/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingGoogleCloudStorage
implements GoogleCloudStorage {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardingGoogleCloudStorage.class);
    private final GoogleCloudStorage delegate;
    private final String delegateClassName;

    public ForwardingGoogleCloudStorage(GoogleCloudStorage delegate) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (Object)"delegate must not be null.");
        this.delegate = delegate;
        this.delegateClassName = delegate.getClass().getSimpleName();
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        LOG.debug("{}.getOptions()", (Object)this.delegateClassName);
        return this.delegate.getOptions();
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        LOG.debug("{}.create({})", (Object)this.delegateClassName, (Object)resourceId);
        return this.delegate.create(resourceId);
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        LOG.debug("{}.create({}, {})", new Object[]{this.delegateClassName, resourceId, options});
        return this.delegate.create(resourceId, options);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        LOG.debug("{}.createEmptyObject({})", (Object)this.delegateClassName, (Object)resourceId);
        this.delegate.createEmptyObject(resourceId);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        LOG.debug("{}.createEmptyObject({}, {})", new Object[]{this.delegateClassName, resourceId, options});
        this.delegate.createEmptyObject(resourceId, options);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        LOG.debug("{}.createEmptyObjects({})", (Object)this.delegateClassName, resourceIds);
        this.delegate.createEmptyObjects(resourceIds);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        LOG.debug("{}.createEmptyObjects({}, {})", new Object[]{this.delegateClassName, resourceIds, options});
        this.delegate.createEmptyObjects(resourceIds, options);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId) throws IOException {
        LOG.debug("{}.open({})", (Object)this.delegateClassName, (Object)resourceId);
        return this.delegate.open(resourceId);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        LOG.debug("{}.open({}, {})", new Object[]{this.delegateClassName, resourceId, readOptions});
        return this.delegate.open(resourceId, readOptions);
    }

    @Override
    public void create(String bucketName) throws IOException {
        LOG.debug("{}.create({})", (Object)this.delegateClassName, (Object)bucketName);
        this.delegate.create(bucketName);
    }

    @Override
    public void create(String bucketName, CreateBucketOptions options) throws IOException {
        LOG.debug("{}.create({}, {})", new Object[]{this.delegateClassName, bucketName, options});
        this.delegate.create(bucketName, options);
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        LOG.debug("{}.deleteBuckets({})", (Object)this.delegateClassName, bucketNames);
        this.delegate.deleteBuckets(bucketNames);
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        LOG.debug("{}.deleteObjects({})", (Object)this.delegateClassName, fullObjectNames);
        this.delegate.deleteObjects(fullObjectNames);
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        LOG.debug("{}.copy({}, {}, {}, {})", new Object[]{this.delegateClassName, srcBucketName, srcObjectNames, dstBucketName, dstObjectNames});
        this.delegate.copy(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames);
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        LOG.debug("{}.listBucketNames()", (Object)this.delegateClassName);
        return this.delegate.listBucketNames();
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        LOG.debug("{}.listBucketInfo()", (Object)this.delegateClassName);
        return this.delegate.listBucketInfo();
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        LOG.debug("{}.listObjectNames({}, {}, {})", new Object[]{this.delegateClassName, bucketName, objectNamePrefix, delimiter});
        return this.delegate.listObjectNames(bucketName, objectNamePrefix, delimiter);
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        LOG.debug("{}.listObjectNames({}, {}, {}, {})", new Object[]{this.delegateClassName, bucketName, objectNamePrefix, delimiter, maxResults});
        return this.delegate.listObjectNames(bucketName, objectNamePrefix, delimiter, maxResults);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        LOG.debug("{}.listObjectInfo({}, {}, {})", new Object[]{this.delegateClassName, bucketName, objectNamePrefix, delimiter});
        return this.delegate.listObjectInfo(bucketName, objectNamePrefix, delimiter);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        LOG.debug("{}.listObjectInfo({}, {}, {}, {})", new Object[]{this.delegateClassName, bucketName, objectNamePrefix, delimiter, maxResults});
        return this.delegate.listObjectInfo(bucketName, objectNamePrefix, delimiter, maxResults);
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        LOG.debug("{}.getItemInfo({})", (Object)this.delegateClassName, (Object)resourceId);
        return this.delegate.getItemInfo(resourceId);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        LOG.debug("{}.getItemInfos({})", (Object)this.delegateClassName, resourceIds);
        return this.delegate.getItemInfos(resourceIds);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        LOG.debug("{}.updateItems({})", (Object)this.delegateClassName, itemInfoList);
        return this.delegate.updateItems(itemInfoList);
    }

    @Override
    public void close() {
        LOG.debug("{}.close()", (Object)this.delegateClassName);
        this.delegate.close();
    }

    @Override
    public void waitForBucketEmpty(String bucketName) throws IOException {
        LOG.debug("{}.waitForBucketEmpty({})", (Object)this.delegateClassName, (Object)bucketName);
        this.delegate.waitForBucketEmpty(bucketName);
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        LOG.debug("{}.compose({}, {}, {}, {})", new Object[]{this.delegateClassName, bucketName, sources, destination, contentType});
        this.delegate.compose(bucketName, sources, destination, contentType);
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        LOG.debug("{}.composeObjects({}, {}, {})", new Object[]{this.delegateClassName, sources, destination, options});
        return this.delegate.composeObjects(sources, destination, options);
    }

    protected GoogleCloudStorage getDelegate() {
        return this.delegate;
    }
}

