/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.DirectoryListCache;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;

public class GoogleCloudStorageFileSystemOptions {
    private final PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions;
    private final boolean performanceCacheEnabled;
    private final GoogleCloudStorageOptions cloudStorageOptions;
    private final boolean metadataCacheEnabled;
    private final DirectoryListCache.Type cacheType;
    private final String cacheBasePath;
    private final TimestampUpdatePredicate shouldIncludeInTimestampUpdatesPredicate;
    private final long cacheMaxEntryAgeMillis;
    private final long cacheMaxInfoAgeMillis;
    private final PathCodec pathCodec;
    private final boolean enableBucketDelete;

    public static Builder newBuilder() {
        return new Builder();
    }

    public GoogleCloudStorageFileSystemOptions(PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions, boolean performanceCacheEnabled, GoogleCloudStorageOptions cloudStorageOptions, boolean metadataCacheEnabled, DirectoryListCache.Type cacheType, String cacheBasePath, TimestampUpdatePredicate shouldIncludeInTimestampUpdatesPredicate, long cacheMaxEntryAgeMillis, long cacheMaxInfoAgeMillis, PathCodec pathCodec, boolean enableBucketDelete) {
        this.performanceCacheOptions = performanceCacheOptions;
        this.performanceCacheEnabled = performanceCacheEnabled;
        this.cloudStorageOptions = cloudStorageOptions;
        this.metadataCacheEnabled = metadataCacheEnabled;
        this.cacheType = cacheType;
        this.cacheBasePath = cacheBasePath;
        this.shouldIncludeInTimestampUpdatesPredicate = shouldIncludeInTimestampUpdatesPredicate;
        this.cacheMaxEntryAgeMillis = cacheMaxEntryAgeMillis;
        this.cacheMaxInfoAgeMillis = cacheMaxInfoAgeMillis;
        this.pathCodec = pathCodec;
        this.enableBucketDelete = enableBucketDelete;
    }

    public PerformanceCachingGoogleCloudStorageOptions getPerformanceCacheOptions() {
        return this.performanceCacheOptions;
    }

    public boolean isPerformanceCacheEnabled() {
        return this.performanceCacheEnabled;
    }

    public GoogleCloudStorageOptions getCloudStorageOptions() {
        return this.cloudStorageOptions;
    }

    public boolean isMetadataCacheEnabled() {
        return this.metadataCacheEnabled;
    }

    public DirectoryListCache.Type getCacheType() {
        return this.cacheType;
    }

    public String getCacheBasePath() {
        return this.cacheBasePath;
    }

    public TimestampUpdatePredicate getShouldIncludeInTimestampUpdatesPredicate() {
        return this.shouldIncludeInTimestampUpdatesPredicate;
    }

    public long getCacheMaxEntryAgeMillis() {
        return this.cacheMaxEntryAgeMillis;
    }

    public long getCacheMaxInfoAgeMillis() {
        return this.cacheMaxInfoAgeMillis;
    }

    public PathCodec getPathCodec() {
        return this.pathCodec;
    }

    public boolean enableBucketDelete() {
        return this.enableBucketDelete;
    }

    public void throwIfNotValid() {
        Preconditions.checkArgument((this.shouldIncludeInTimestampUpdatesPredicate != null ? 1 : 0) != 0, (Object)"Predicate for ignored directory updates should not be null. Consider Predicates.alwasyTrue");
        this.cloudStorageOptions.throwIfNotValid();
    }

    public static class Builder {
        private boolean performanceCacheEnabled = false;
        private PerformanceCachingGoogleCloudStorageOptions.Builder performanceCacheOptionsBuilder = PerformanceCachingGoogleCloudStorageOptions.newBuilder();
        private PerformanceCachingGoogleCloudStorageOptions immutablePerformanceCacheOptions = null;
        protected boolean metadataCacheEnabled = true;
        protected DirectoryListCache.Type cacheType = DirectoryListCache.Type.IN_MEMORY;
        protected String cacheBasePath = null;
        protected TimestampUpdatePredicate shouldIncludeInTimestampUpdatesPredicate = new TimestampUpdatePredicate(){

            @Override
            public boolean shouldUpdateTimestamp(URI item) {
                return true;
            }
        };
        protected long cacheMaxEntryAgeMillis = 14400000L;
        protected long cacheMaxInfoAgeMillis = 10000L;
        private GoogleCloudStorageOptions.Builder cloudStorageOptionsBuilder = new GoogleCloudStorageOptions.Builder();
        private GoogleCloudStorageOptions immutableCloudStorageOptions = null;
        private PathCodec pathCodec = GoogleCloudStorageFileSystem.LEGACY_PATH_CODEC;
        private boolean enableBucketDelete = false;

        public Builder setIsPerformanceCacheEnabled(boolean performanceCacheEnabled) {
            this.performanceCacheEnabled = performanceCacheEnabled;
            return this;
        }

        public PerformanceCachingGoogleCloudStorageOptions.Builder getPerformanceCachingOptionsBuilder() {
            return this.performanceCacheOptionsBuilder;
        }

        public Builder setPerformanceCachingOptionsBuilder(PerformanceCachingGoogleCloudStorageOptions.Builder performanceCacheOptionsBuilder) {
            this.performanceCacheOptionsBuilder = performanceCacheOptionsBuilder;
            this.immutablePerformanceCacheOptions = null;
            return this;
        }

        public Builder setImmutablePerformanceCachingOptions(PerformanceCachingGoogleCloudStorageOptions immutablePerformanceCacheOptions) {
            this.immutablePerformanceCacheOptions = immutablePerformanceCacheOptions;
            this.performanceCacheOptionsBuilder = PerformanceCachingGoogleCloudStorageOptions.newBuilder();
            return this;
        }

        public GoogleCloudStorageOptions.Builder getCloudStorageOptionsBuilder() {
            return this.cloudStorageOptionsBuilder;
        }

        public Builder setCloudStorageOptionsBuilder(GoogleCloudStorageOptions.Builder cloudStorageOptionsBuilder) {
            this.cloudStorageOptionsBuilder = cloudStorageOptionsBuilder;
            this.immutableCloudStorageOptions = null;
            return this;
        }

        public Builder setImmutableCloudStorageOptions(GoogleCloudStorageOptions immutableCloudStorageOptions) {
            this.immutableCloudStorageOptions = immutableCloudStorageOptions;
            this.cloudStorageOptionsBuilder = new GoogleCloudStorageOptions.Builder();
            return this;
        }

        public Builder setIsMetadataCacheEnabled(boolean isMetadataCacheEnabled) {
            this.metadataCacheEnabled = isMetadataCacheEnabled;
            return this;
        }

        public Builder setCacheType(DirectoryListCache.Type cacheType) {
            this.cacheType = cacheType;
            return this;
        }

        public Builder setCacheBasePath(String cacheBasePath) {
            this.cacheBasePath = cacheBasePath;
            return this;
        }

        public Builder setShouldIncludeInTimestampUpdatesPredicate(final Predicate<String> shouldIncludeInTimestampUpdatesPredicate) {
            this.shouldIncludeInTimestampUpdatesPredicate = new TimestampUpdatePredicate(){

                @Override
                public boolean shouldUpdateTimestamp(URI item) {
                    return shouldIncludeInTimestampUpdatesPredicate.apply((Object)item.getPath());
                }
            };
            return this;
        }

        public Builder setShouldIncludeInTimestampUpdatesPredicate(TimestampUpdatePredicate shouldIncludeInTimestampUpdatesPredicate) {
            this.shouldIncludeInTimestampUpdatesPredicate = shouldIncludeInTimestampUpdatesPredicate;
            return this;
        }

        public Builder setCacheMaxEntryAgeMillis(long cacheMaxEntryAgeMillis) {
            this.cacheMaxEntryAgeMillis = cacheMaxEntryAgeMillis;
            return this;
        }

        public Builder setCacheMaxInfoAgeMillis(long cacheMaxInfoAgeMillis) {
            this.cacheMaxInfoAgeMillis = cacheMaxInfoAgeMillis;
            return this;
        }

        public Builder setPathCodec(PathCodec pathCodec) {
            this.pathCodec = pathCodec;
            return this;
        }

        public Builder setEnableBucketDelete(boolean enableBucketDelete) {
            this.enableBucketDelete = enableBucketDelete;
            return this;
        }

        public GoogleCloudStorageFileSystemOptions build() {
            return new GoogleCloudStorageFileSystemOptions(this.immutablePerformanceCacheOptions != null ? this.immutablePerformanceCacheOptions : this.performanceCacheOptionsBuilder.build(), this.performanceCacheEnabled, this.immutableCloudStorageOptions != null ? this.immutableCloudStorageOptions : this.cloudStorageOptionsBuilder.build(), this.metadataCacheEnabled, this.cacheType, this.cacheBasePath, this.shouldIncludeInTimestampUpdatesPredicate, this.cacheMaxEntryAgeMillis, this.cacheMaxInfoAgeMillis, this.pathCodec, this.enableBucketDelete);
        }
    }

    public static interface TimestampUpdatePredicate {
        public boolean shouldUpdateTimestamp(URI var1);
    }
}

