/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class GoogleCloudStorageOptions {
    public static final long MAX_LIST_ITEMS_PER_CALL_DEFAULT = 1024L;
    public static final boolean AUTO_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final boolean INFER_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final long MAX_REQUESTS_PER_BATCH_DEFAULT = 1000L;
    public static final boolean CREATE_EMPTY_MARKER_OBJECT_DEFAULT = false;
    public static final int MAX_WAIT_MILLIS_FOR_EMPTY_OBJECT_CREATION = 3000;
    private final boolean autoRepairImplicitDirectoriesEnabled;
    private final boolean inferImplicitDirectoriesEnabled;
    private final String projectId;
    private final String appName;
    private final HttpTransportFactory.HttpTransportType transportType;
    private final String proxyAddress;
    private final AsyncWriteChannelOptions writeChannelOptions;
    private final long maxListItemsPerCall;
    private final long maxRequestsPerBatch;
    private final boolean createMarkerFile;
    private final int maxWaitMillisForEmptyObjectCreation;

    public static Builder newBuilder() {
        return new Builder();
    }

    protected GoogleCloudStorageOptions(Builder builder) {
        this.autoRepairImplicitDirectoriesEnabled = builder.autoRepairImplicitDirectoriesEnabled;
        this.inferImplicitDirectoriesEnabled = builder.inferImplicitDirectoriesEnabled;
        this.projectId = builder.projectId;
        this.appName = builder.appName;
        this.writeChannelOptions = builder.getWriteChannelOptionsBuilder().build();
        this.maxListItemsPerCall = builder.maxListItemsPerCall;
        this.maxRequestsPerBatch = builder.maxRequestsPerBatch;
        this.createMarkerFile = builder.createMarkerObjects;
        this.transportType = builder.transportType;
        this.proxyAddress = builder.proxyAddress;
        this.maxWaitMillisForEmptyObjectCreation = builder.maxWaitMillisForEmptyObjectCreation;
    }

    public GoogleCloudStorageOptions(boolean autoRepairImplicitDirectoriesEnabled, boolean inferImplicitDirectoriesEnabled, String projectId, String appName, long maxListItemsPerCall, long maxRequestsPerBatch, boolean createMarkerFile, HttpTransportFactory.HttpTransportType transportType, String proxyAddress, AsyncWriteChannelOptions writeChannelOptions) {
        this(new Builder().setProjectId(projectId).setAppName(appName).setWriteChannelOptionsBuilder(new AsyncWriteChannelOptions.Builder().setUploadBufferSize(writeChannelOptions.getUploadBufferSize()).setDirectUploadEnabled(writeChannelOptions.isDirectUploadEnabled())).setAutoRepairImplicitDirectoriesEnabled(autoRepairImplicitDirectoriesEnabled).setInferImplicitDirectoriesEnabled(inferImplicitDirectoriesEnabled).setMaxListItemsPerCall(maxListItemsPerCall).setMaxRequestsPerBatch(maxRequestsPerBatch).setTransportType(transportType).setCreateMarkerObjects(createMarkerFile).setProxyAddress(proxyAddress));
    }

    public boolean isAutoRepairImplicitDirectoriesEnabled() {
        return this.autoRepairImplicitDirectoriesEnabled;
    }

    public boolean isInferImplicitDirectoriesEnabled() {
        return this.inferImplicitDirectoriesEnabled;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getAppName() {
        return this.appName;
    }

    public HttpTransportFactory.HttpTransportType getTransportType() {
        return this.transportType;
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public long getMaxListItemsPerCall() {
        return this.maxListItemsPerCall;
    }

    public AsyncWriteChannelOptions getWriteChannelOptions() {
        return this.writeChannelOptions;
    }

    public long getMaxRequestsPerBatch() {
        return this.maxRequestsPerBatch;
    }

    public boolean isMarkerFileCreationEnabled() {
        return this.createMarkerFile;
    }

    public int getMaxWaitMillisForEmptyObjectCreation() {
        return this.maxWaitMillisForEmptyObjectCreation;
    }

    public void throwIfNotValid() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.projectId) ? 1 : 0) != 0, (Object)"projectId must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.appName) ? 1 : 0) != 0, (Object)"appName must not be null or empty");
    }

    public static class Builder {
        private boolean autoRepairImplicitDirectoriesEnabled = true;
        private boolean inferImplicitDirectoriesEnabled = true;
        private String projectId = null;
        private String appName = null;
        private HttpTransportFactory.HttpTransportType transportType = HttpTransportFactory.DEFAULT_TRANSPORT_TYPE;
        private String proxyAddress = null;
        private long maxListItemsPerCall = 1024L;
        private boolean createMarkerObjects = false;
        private int maxWaitMillisForEmptyObjectCreation = 3000;
        private long maxRequestsPerBatch = 1000L;
        private AsyncWriteChannelOptions.Builder writeChannelOptionsBuilder = new AsyncWriteChannelOptions.Builder();

        public Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
            this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
            return this;
        }

        public Builder setInferImplicitDirectoriesEnabled(boolean inferImplicitDirectoriesEnabled) {
            this.inferImplicitDirectoriesEnabled = inferImplicitDirectoriesEnabled;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder setMaxListItemsPerCall(long maxListItemsPerCall) {
            this.maxListItemsPerCall = maxListItemsPerCall;
            return this;
        }

        public Builder setMaxRequestsPerBatch(long maxRequestsPerBatch) {
            this.maxRequestsPerBatch = maxRequestsPerBatch;
            return this;
        }

        public Builder setCreateMarkerObjects(boolean createMarkerObjects) {
            this.createMarkerObjects = createMarkerObjects;
            return this;
        }

        public Builder setTransportType(HttpTransportFactory.HttpTransportType transportType) {
            this.transportType = transportType;
            return this;
        }

        public Builder setProxyAddress(String proxyAddress) {
            this.proxyAddress = proxyAddress;
            return this;
        }

        public Builder setWriteChannelOptionsBuilder(AsyncWriteChannelOptions.Builder builder) {
            this.writeChannelOptionsBuilder = builder;
            return this;
        }

        public AsyncWriteChannelOptions.Builder getWriteChannelOptionsBuilder() {
            return this.writeChannelOptionsBuilder;
        }

        public Builder setMaxWaitMillisForEmptyObjectCreation(int maxWaitMillisForEmptyObjectCreation) {
            this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
            return this;
        }

        public GoogleCloudStorageOptions build() {
            return new GoogleCloudStorageOptions(this);
        }
    }
}

