/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

public class PerformanceCachingGoogleCloudStorageOptions {
    public static final long MAX_ENTRY_AGE_MILLIS_DEFAULT = 3000L;
    public static final boolean LIST_CACHING_ENABLED = true;
    private final long maxEntryAgeMillis;
    private final boolean inferImplicitDirectoriesEnabled;
    private final boolean listCachingEnabled;

    private PerformanceCachingGoogleCloudStorageOptions(Builder builder) {
        this.maxEntryAgeMillis = builder.maxEntryAgeMillis;
        this.inferImplicitDirectoriesEnabled = builder.inferImplicitDirectoriesEnabled;
        this.listCachingEnabled = builder.listCachingEnabled;
    }

    public long getMaxEntryAgeMillis() {
        return this.maxEntryAgeMillis;
    }

    public boolean isInferImplicitDirectoriesEnabled() {
        return this.inferImplicitDirectoriesEnabled;
    }

    public boolean isListCachingEnabled() {
        return this.listCachingEnabled;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private long maxEntryAgeMillis = 3000L;
        private boolean inferImplicitDirectoriesEnabled = true;
        private boolean listCachingEnabled = true;

        public Builder setMaxEntryAgeMillis(long maxEntryAgeMillis) {
            this.maxEntryAgeMillis = maxEntryAgeMillis;
            return this;
        }

        public Builder setInferImplicitDirectoriesEnabled(boolean inferImplicitDirectoriesEnabled) {
            this.inferImplicitDirectoriesEnabled = inferImplicitDirectoriesEnabled;
            return this;
        }

        public Builder setListCachingEnabled(boolean listCachingEnabled) {
            this.listCachingEnabled = listCachingEnabled;
            return this;
        }

        public PerformanceCachingGoogleCloudStorageOptions build() {
            return new PerformanceCachingGoogleCloudStorageOptions(this);
        }
    }
}

