/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UriEncodingPathCodec
implements PathCodec {
    public static final Logger LOG = LoggerFactory.getLogger(UriEncodingPathCodec.class);

    UriEncodingPathCodec() {
    }

    @Override
    public StorageResourceId validatePathAndGetId(URI path, boolean allowEmptyObjectName) {
        LOG.debug("validatePathAndGetId('{}', {})", (Object)path, (Object)allowEmptyObjectName);
        Preconditions.checkNotNull((Object)path);
        if (!"gs".equals(path.getScheme())) {
            throw new IllegalArgumentException("Google Cloud Storage path supports only 'gs' scheme, instead got '" + path.getScheme() + "' from '" + path + "'.");
        }
        if (path.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
            return StorageResourceId.ROOT;
        }
        String bucketName = path.getAuthority();
        String objectName = path.getPath();
        bucketName = GoogleCloudStorageFileSystem.validateBucketName(bucketName);
        if (Strings.isNullOrEmpty((String)(objectName = GoogleCloudStorageFileSystem.validateObjectName(objectName, allowEmptyObjectName)))) {
            return new StorageResourceId(bucketName);
        }
        return new StorageResourceId(bucketName, objectName);
    }

    @Override
    public URI getPath(String bucketName, String objectName, boolean allowEmptyObjectName) {
        URI pathUri;
        if (allowEmptyObjectName && bucketName == null && objectName == null) {
            return GoogleCloudStorageFileSystem.GCS_ROOT;
        }
        bucketName = GoogleCloudStorageFileSystem.validateBucketName(bucketName);
        objectName = GoogleCloudStorageFileSystem.validateObjectName(objectName, allowEmptyObjectName);
        String path = "/" + objectName;
        String authority = bucketName;
        try {
            pathUri = new URI("gs", authority, path, null, null);
        }
        catch (URISyntaxException e) {
            String msg = String.format("Invalid bucket name (%s) or object name (%s)", bucketName, objectName);
            LOG.error(msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        return pathUri;
    }
}

