/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.Clock;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEntry {
    private static final Logger LOG = LoggerFactory.getLogger(CacheEntry.class);
    private static Clock clock = Clock.SYSTEM;
    private final StorageResourceId resourceId;
    private final long creationTimeMillis;
    private GoogleCloudStorageItemInfo itemInfo;
    private long itemInfoUpdateTimeMillis;

    public CacheEntry(StorageResourceId resourceId) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"CacheEntry requires non-null resourceId.");
        Preconditions.checkArgument((!resourceId.isRoot() ? 1 : 0) != 0, (Object)"CacheEntry cannot take a resourceId corresponding to 'root'.");
        this.resourceId = resourceId;
        this.creationTimeMillis = clock.currentTimeMillis();
        this.itemInfo = null;
        this.itemInfoUpdateTimeMillis = 0L;
    }

    public CacheEntry(StorageResourceId resourceId, long creationTimeMillis) {
        Preconditions.checkArgument((resourceId != null ? 1 : 0) != 0, (Object)"CacheEntry requires non-null resourceId.");
        Preconditions.checkArgument((!resourceId.isRoot() ? 1 : 0) != 0, (Object)"CacheEntry cannot take a resourceId corresponding to 'root'.");
        this.resourceId = resourceId;
        this.creationTimeMillis = creationTimeMillis;
        this.itemInfo = null;
        this.itemInfoUpdateTimeMillis = 0L;
    }

    public CacheEntry(GoogleCloudStorageItemInfo itemInfo) {
        CacheEntry.validateItemInfo(itemInfo);
        this.resourceId = itemInfo.getResourceId();
        this.creationTimeMillis = clock.currentTimeMillis();
        this.itemInfo = itemInfo;
        this.itemInfoUpdateTimeMillis = this.creationTimeMillis;
    }

    private static void validateItemInfo(GoogleCloudStorageItemInfo itemInfo) {
        Preconditions.checkArgument((itemInfo != null ? 1 : 0) != 0, (Object)"CacheEntry requires non-null itemInfo.");
        Preconditions.checkArgument((!itemInfo.isRoot() ? 1 : 0) != 0, (Object)"CacheEntry cannot take an itemInfo corresponding to 'root'.");
        Preconditions.checkArgument((boolean)itemInfo.exists(), (Object)"CacheEntry cannot take an itemInfo for which exists() == false.");
    }

    @VisibleForTesting
    public static void setClock(Clock clock) {
        CacheEntry.clock = clock;
    }

    public StorageResourceId getResourceId() {
        return this.resourceId;
    }

    public long getCreationTimeMillis() {
        return this.creationTimeMillis;
    }

    public synchronized long getItemInfoUpdateTimeMillis() {
        return this.itemInfoUpdateTimeMillis;
    }

    public synchronized GoogleCloudStorageItemInfo getItemInfo() {
        return this.itemInfo;
    }

    public synchronized void clearItemInfo() {
        this.itemInfo = null;
        this.itemInfoUpdateTimeMillis = 0L;
    }

    public synchronized GoogleCloudStorageItemInfo setItemInfo(GoogleCloudStorageItemInfo newItemInfo) {
        CacheEntry.validateItemInfo(newItemInfo);
        Preconditions.checkArgument((boolean)newItemInfo.getResourceId().equals(this.resourceId), (String)"newItemInfo's resourceId (%s) doesn't match existing resourceId (%s)!", (Object)newItemInfo.getResourceId(), (Object)this.resourceId);
        if (this.itemInfo != null) {
            LOG.debug("Replacing existing itemInfo '{}' with newItemInfo '{}'", (Object)this.itemInfo, (Object)newItemInfo);
        } else {
            LOG.debug("Setting itemInfo for first time for cache entry: '{}'", (Object)newItemInfo);
        }
        GoogleCloudStorageItemInfo oldInfo = this.itemInfo;
        this.itemInfo = newItemInfo;
        this.itemInfoUpdateTimeMillis = clock.currentTimeMillis();
        return oldInfo;
    }
}

