/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.Strings;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.PrefixMappedItemCache;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class PerformanceCachingGoogleCloudStorage
extends ForwardingGoogleCloudStorage {
    private final PrefixMappedItemCache cache;
    private final boolean inferImplicitDirectoriesEnabled;
    private final boolean listCachingEnabled;

    public PerformanceCachingGoogleCloudStorage(GoogleCloudStorage delegate, PerformanceCachingGoogleCloudStorageOptions options) {
        super(delegate);
        this.inferImplicitDirectoriesEnabled = options.isInferImplicitDirectoriesEnabled();
        this.listCachingEnabled = options.isListCachingEnabled();
        PrefixMappedItemCache.Config config = new PrefixMappedItemCache.Config();
        config.setMaxEntryAgeMillis(options.getMaxEntryAgeMillis());
        this.cache = new PrefixMappedItemCache(config);
    }

    @VisibleForTesting
    PerformanceCachingGoogleCloudStorage(GoogleCloudStorage delegate, PerformanceCachingGoogleCloudStorageOptions options, PrefixMappedItemCache cache) {
        super(delegate);
        this.inferImplicitDirectoriesEnabled = options.isInferImplicitDirectoriesEnabled();
        this.listCachingEnabled = options.isListCachingEnabled();
        this.cache = cache;
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        super.deleteBuckets(bucketNames);
        for (String bucket : bucketNames) {
            this.cache.invalidateBucket(bucket);
        }
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        super.deleteObjects(fullObjectNames);
        for (StorageResourceId id : fullObjectNames) {
            this.cache.removeItem(id);
        }
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        List<GoogleCloudStorageItemInfo> result = super.listBucketInfo();
        for (GoogleCloudStorageItemInfo item : result) {
            this.cache.putItem(item);
        }
        return result;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        return this.listObjectInfo(bucketName, objectNamePrefix, delimiter, -1L);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        List<GoogleCloudStorageItemInfo> result;
        if (this.listCachingEnabled) {
            result = this.cache.getList(bucketName, objectNamePrefix);
            if (result == null) {
                result = super.listObjectInfo(bucketName, objectNamePrefix, null);
                this.cache.putList(bucketName, objectNamePrefix, result);
            }
            if ("/".equals(delimiter)) {
                this.filter(result, bucketName, objectNamePrefix, delimiter);
            }
        } else {
            result = super.listObjectInfo(bucketName, objectNamePrefix, null);
            this.cache.putList(bucketName, objectNamePrefix, result);
        }
        return result;
    }

    private void filter(List<GoogleCloudStorageItemInfo> items, String bucketName, @Nullable String prefix, @Nullable String delimiter) {
        String string = prefix = prefix == null ? "" : prefix;
        if (Strings.isNullOrEmpty((String)delimiter)) {
            return;
        }
        HashSet<String> dirs = new HashSet<String>();
        Iterator<GoogleCloudStorageItemInfo> itr = items.iterator();
        while (itr.hasNext()) {
            String objectName = itr.next().getObjectName();
            if (!objectName.startsWith(prefix)) {
                itr.remove();
                continue;
            }
            int firstIndex = objectName.indexOf(delimiter, prefix.length());
            if (firstIndex == -1) continue;
            int lastIndex = objectName.lastIndexOf(delimiter);
            if (firstIndex != lastIndex) {
                itr.remove();
                dirs.add(objectName.substring(0, firstIndex + 1));
                continue;
            }
            if (lastIndex == objectName.length() - 1) continue;
            itr.remove();
            dirs.add(objectName.substring(0, firstIndex + 1));
        }
        if (this.inferImplicitDirectoriesEnabled) {
            for (String dir : dirs) {
                items.add(GoogleCloudStorageImpl.createItemInfoForInferredDirectory(new StorageResourceId(bucketName, dir)));
            }
        }
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        GoogleCloudStorageItemInfo item = this.cache.getItem(resourceId);
        if (item == null) {
            item = super.getItemInfo(resourceId);
            this.cache.putItem(item);
        }
        return item;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        ArrayList<GoogleCloudStorageItemInfo> result = new ArrayList<GoogleCloudStorageItemInfo>(resourceIds.size());
        ArrayList<StorageResourceId> request = new ArrayList<StorageResourceId>(resourceIds.size());
        for (StorageResourceId resourceId : resourceIds) {
            GoogleCloudStorageItemInfo item = this.cache.getItem(resourceId);
            if (item == null) {
                request.add(resourceId);
            }
            result.add(item);
        }
        if (!request.isEmpty()) {
            List<GoogleCloudStorageItemInfo> response = super.getItemInfos(request);
            Iterator<GoogleCloudStorageItemInfo> responseIterator = response.iterator();
            for (int i = 0; i < result.size() && responseIterator.hasNext(); ++i) {
                if (result.get(i) != null) continue;
                GoogleCloudStorageItemInfo item = responseIterator.next();
                this.cache.putItem(item);
                result.set(i, item);
            }
        }
        return result;
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        List<GoogleCloudStorageItemInfo> result = super.updateItems(itemInfoList);
        for (GoogleCloudStorageItemInfo item : result) {
            this.cache.putItem(item);
        }
        return result;
    }

    @Override
    public void close() {
        super.close();
        this.cache.invalidateAll();
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        GoogleCloudStorageItemInfo item = super.composeObjects(sources, destination, options);
        this.cache.putItem(item);
        return item;
    }
}

