

package com.google.cloud.hadoop.gcsio;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PerformanceCachingGoogleCloudStorageOptions extends PerformanceCachingGoogleCloudStorageOptions {

  private final long maxEntryAgeMillis;

  private final boolean listCachingEnabled;

  private final long dirMetadataPrefetchLimit;

  private AutoValue_PerformanceCachingGoogleCloudStorageOptions(
      long maxEntryAgeMillis,
      boolean listCachingEnabled,
      long dirMetadataPrefetchLimit) {
    this.maxEntryAgeMillis = maxEntryAgeMillis;
    this.listCachingEnabled = listCachingEnabled;
    this.dirMetadataPrefetchLimit = dirMetadataPrefetchLimit;
  }

  @Override
  public long getMaxEntryAgeMillis() {
    return maxEntryAgeMillis;
  }

  @Override
  public boolean isListCachingEnabled() {
    return listCachingEnabled;
  }

  @Override
  public long getDirMetadataPrefetchLimit() {
    return dirMetadataPrefetchLimit;
  }

  @Override
  public String toString() {
    return "PerformanceCachingGoogleCloudStorageOptions{"
         + "maxEntryAgeMillis=" + maxEntryAgeMillis + ", "
         + "listCachingEnabled=" + listCachingEnabled + ", "
         + "dirMetadataPrefetchLimit=" + dirMetadataPrefetchLimit
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PerformanceCachingGoogleCloudStorageOptions) {
      PerformanceCachingGoogleCloudStorageOptions that = (PerformanceCachingGoogleCloudStorageOptions) o;
      return (this.maxEntryAgeMillis == that.getMaxEntryAgeMillis())
           && (this.listCachingEnabled == that.isListCachingEnabled())
           && (this.dirMetadataPrefetchLimit == that.getDirMetadataPrefetchLimit());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (int) ((maxEntryAgeMillis >>> 32) ^ maxEntryAgeMillis);
    h$ *= 1000003;
    h$ ^= listCachingEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((dirMetadataPrefetchLimit >>> 32) ^ dirMetadataPrefetchLimit);
    return h$;
  }

  @Override
  public PerformanceCachingGoogleCloudStorageOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends PerformanceCachingGoogleCloudStorageOptions.Builder {
    private Long maxEntryAgeMillis;
    private Boolean listCachingEnabled;
    private Long dirMetadataPrefetchLimit;
    Builder() {
    }
    private Builder(PerformanceCachingGoogleCloudStorageOptions source) {
      this.maxEntryAgeMillis = source.getMaxEntryAgeMillis();
      this.listCachingEnabled = source.isListCachingEnabled();
      this.dirMetadataPrefetchLimit = source.getDirMetadataPrefetchLimit();
    }
    @Override
    public PerformanceCachingGoogleCloudStorageOptions.Builder setMaxEntryAgeMillis(long maxEntryAgeMillis) {
      this.maxEntryAgeMillis = maxEntryAgeMillis;
      return this;
    }
    @Override
    public PerformanceCachingGoogleCloudStorageOptions.Builder setListCachingEnabled(boolean listCachingEnabled) {
      this.listCachingEnabled = listCachingEnabled;
      return this;
    }
    @Override
    public PerformanceCachingGoogleCloudStorageOptions.Builder setDirMetadataPrefetchLimit(long dirMetadataPrefetchLimit) {
      this.dirMetadataPrefetchLimit = dirMetadataPrefetchLimit;
      return this;
    }
    @Override
    PerformanceCachingGoogleCloudStorageOptions autoBuild() {
      String missing = "";
      if (this.maxEntryAgeMillis == null) {
        missing += " maxEntryAgeMillis";
      }
      if (this.listCachingEnabled == null) {
        missing += " listCachingEnabled";
      }
      if (this.dirMetadataPrefetchLimit == null) {
        missing += " dirMetadataPrefetchLimit";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PerformanceCachingGoogleCloudStorageOptions(
          this.maxEntryAgeMillis,
          this.listCachingEnabled,
          this.dirMetadataPrefetchLimit);
    }
  }

}
