/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.gcsio.testing.InMemoryObjectReadChannel;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class InMemoryObjectEntry {
    private byte[] completedContents = null;
    private ByteArrayOutputStream writeStream;
    private WritableByteChannel writeChannel;
    private GoogleCloudStorageItemInfo info;

    public InMemoryObjectEntry(String bucketName, String objectName, long createTimeMillis, String contentType, Map<String, byte[]> metadata) {
        this.writeStream = new ByteArrayOutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void close() throws IOException {
                InMemoryObjectEntry inMemoryObjectEntry = InMemoryObjectEntry.this;
                synchronized (inMemoryObjectEntry) {
                    InMemoryObjectEntry.access$102(InMemoryObjectEntry.this, this.toByteArray());
                    HashCode md5 = Hashing.md5().hashBytes(InMemoryObjectEntry.this.completedContents);
                    HashCode crc32c = Hashing.crc32c().hashBytes(InMemoryObjectEntry.this.completedContents);
                    InMemoryObjectEntry.this.writeStream = null;
                    InMemoryObjectEntry.this.writeChannel = null;
                    InMemoryObjectEntry.this.info = new GoogleCloudStorageItemInfo(InMemoryObjectEntry.this.info.getResourceId(), InMemoryObjectEntry.this.info.getCreationTime(), InMemoryObjectEntry.this.completedContents.length, null, null, InMemoryObjectEntry.this.info.getContentType(), InMemoryObjectEntry.this.info.getContentEncoding(), InMemoryObjectEntry.this.info.getMetadata(), 1L, 1L, new VerificationAttributes(md5.asBytes(), Ints.toByteArray((int)crc32c.asInt())));
                }
            }
        };
        WritableByteChannel delegateWriteChannel = Channels.newChannel(this.writeStream);
        this.writeChannel = new WritableByteChannelImpl(delegateWriteChannel);
        this.info = new GoogleCloudStorageItemInfo(new StorageResourceId(bucketName, objectName), createTimeMillis, 0L, null, null, contentType, null, (Map<String, byte[]>)ImmutableMap.copyOf(metadata), 0L, 0L);
    }

    private InMemoryObjectEntry() {
    }

    private synchronized boolean isCompleted() {
        return this.completedContents != null;
    }

    public synchronized String getObjectName() {
        return this.info.getObjectName();
    }

    public synchronized String getBucketName() {
        return this.info.getBucketName();
    }

    public synchronized InMemoryObjectEntry getShallowCopy(String bucketName, String objectName) throws IOException {
        if (!this.isCompleted()) {
            throw new IOException("Cannot getShallowCopy() before the writeChannel has been closed!");
        }
        InMemoryObjectEntry copy = new InMemoryObjectEntry();
        copy.completedContents = this.completedContents;
        copy.writeStream = this.writeStream;
        copy.writeChannel = this.writeChannel;
        Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        copy.info = new GoogleCloudStorageItemInfo(new StorageResourceId(bucketName, objectName), System.currentTimeMillis(), this.info.getSize(), null, null, this.info.getContentType(), this.info.getContentEncoding(), this.info.getMetadata(), this.info.getContentGeneration(), this.info.getMetaGeneration());
        return copy;
    }

    public synchronized WritableByteChannel getWriteChannel() throws IOException {
        if (this.isCompleted()) {
            throw new IOException("Cannot getWriteChannel() once it has already been closed!");
        }
        return this.writeChannel;
    }

    public synchronized SeekableByteChannel getReadChannel() throws IOException {
        return this.getReadChannel(GoogleCloudStorageReadOptions.DEFAULT);
    }

    public synchronized SeekableByteChannel getReadChannel(final GoogleCloudStorageReadOptions readOptions) throws IOException {
        if (!this.isCompleted()) {
            throw new IOException(String.format("Cannot getReadChannel() before writes have been committed! Object = %s", this.getObjectName()));
        }
        return new InMemoryObjectReadChannel(this.completedContents, readOptions){

            @Override
            @Nullable
            protected GoogleCloudStorageItemInfo getInitialMetadata() {
                return readOptions.getFastFailOnNotFound() ? InMemoryObjectEntry.this.getInfo() : super.getInitialMetadata();
            }
        };
    }

    public synchronized GoogleCloudStorageItemInfo getInfo() {
        if (!this.isCompleted()) {
            return GoogleCloudStorageItemInfo.createNotFound(this.info.getResourceId());
        }
        return this.info;
    }

    public synchronized void patchMetadata(Map<String, byte[]> newMetadata) throws IOException {
        if (!this.isCompleted()) {
            throw new IOException(String.format("Cannot patchMetadata() before writes have been committed! Object = %s", this.getObjectName()));
        }
        HashMap mergedMetadata = Maps.newHashMap(this.info.getMetadata());
        for (Map.Entry<String, byte[]> entry : newMetadata.entrySet()) {
            if (entry.getValue() == null && mergedMetadata.containsKey(entry.getKey())) {
                mergedMetadata.remove(entry.getKey());
                continue;
            }
            if (entry.getValue() == null) continue;
            mergedMetadata.put(entry.getKey(), entry.getValue());
        }
        this.info = new GoogleCloudStorageItemInfo(this.info.getResourceId(), this.info.getCreationTime(), this.completedContents.length, null, null, this.info.getContentType(), this.info.getContentEncoding(), mergedMetadata, this.info.getContentGeneration(), this.info.getMetaGeneration() + 1L, this.info.getVerificationAttributes());
    }

    static /* synthetic */ byte[] access$102(InMemoryObjectEntry x0, byte[] x1) {
        x0.completedContents = x1;
        return x1;
    }

    private class WritableByteChannelImpl
    implements WritableByteChannel,
    GoogleCloudStorageItemInfo.Provider {
        private final WritableByteChannel delegateWriteChannel;

        public WritableByteChannelImpl(WritableByteChannel delegateWriteChannel) {
            this.delegateWriteChannel = delegateWriteChannel;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return this.delegateWriteChannel.write(src);
        }

        @Override
        public void close() throws IOException {
            this.delegateWriteChannel.close();
        }

        @Override
        public boolean isOpen() {
            return this.delegateWriteChannel.isOpen();
        }

        @Override
        public GoogleCloudStorageItemInfo getItemInfo() {
            if (!this.isOpen()) {
                return InMemoryObjectEntry.this.info;
            }
            return null;
        }
    }
}

