/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.NanoClock;
import com.google.api.client.util.Sleeper;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageExceptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.flogger.GoogleLogger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GoogleCloudStorageReadChannel
implements SeekableByteChannel {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    @VisibleForTesting
    static final int SKIP_BUFFER_SIZE = 8192;
    private static final String GZIP_ENCODING = "gzip";
    private final Storage gcs;
    private final String bucketName;
    private final String objectName;
    private final Object resourceIdString;
    @VisibleForTesting
    ReadableByteChannel contentChannel;
    private boolean channelIsOpen = true;
    protected long currentPosition = 0L;
    protected long contentChannelPosition = -1L;
    private long size = -1L;
    private long contentChannelEnd = -1L;
    @VisibleForTesting
    boolean randomAccess;
    private int maxRetries = 10;
    private final ApiErrorExtractor errorExtractor;
    private final ClientRequestHelper<StorageObject> clientRequestHelper;
    private final GoogleCloudStorageReadOptions readOptions;
    private Sleeper sleeper = Sleeper.DEFAULT;
    private NanoClock clock = NanoClock.SYSTEM;
    private Supplier<BackOff> readBackOff = Suppliers.memoize(this::createBackOff);
    private byte[] skipBuffer = null;
    private boolean gzipEncoded = false;
    private byte[] footerContent;
    private Long generation = null;
    private boolean metadataInitialized = false;
    @Deprecated
    public static final int DEFAULT_BACKOFF_INITIAL_INTERVAL_MILLIS = 200;
    @Deprecated
    public static final double DEFAULT_BACKOFF_RANDOMIZATION_FACTOR = 0.5;
    @Deprecated
    public static final double DEFAULT_BACKOFF_MULTIPLIER = 1.5;
    @Deprecated
    public static final int DEFAULT_BACKOFF_MAX_INTERVAL_MILLIS = 10000;
    @Deprecated
    public static final int DEFAULT_BACKOFF_MAX_ELAPSED_TIME_MILLIS = 120000;

    public GoogleCloudStorageReadChannel(Storage gcs, String bucketName, String objectName, ApiErrorExtractor errorExtractor, ClientRequestHelper<StorageObject> requestHelper) throws IOException {
        this(gcs, bucketName, objectName, errorExtractor, requestHelper, GoogleCloudStorageReadOptions.DEFAULT);
    }

    public GoogleCloudStorageReadChannel(Storage gcs, String bucketName, String objectName, ApiErrorExtractor errorExtractor, ClientRequestHelper<StorageObject> requestHelper, @Nonnull GoogleCloudStorageReadOptions readOptions) throws IOException {
        this.gcs = gcs;
        this.clientRequestHelper = requestHelper;
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.errorExtractor = errorExtractor;
        this.readOptions = readOptions;
        this.resourceIdString = GoogleCloudStorageReadChannel.lazyToString((Supplier<String>)((Supplier)() -> StorageResourceId.createReadableString(bucketName, objectName)));
        GoogleCloudStorageItemInfo info = this.getInitialMetadata();
        if (info != null) {
            String generationString = String.valueOf(info.getContentGeneration());
            this.initMetadata(info.getContentEncoding(), info.getSize(), generationString);
        }
    }

    protected GoogleCloudStorageReadChannel(@Nonnull GoogleCloudStorageReadOptions readOptions) throws IOException {
        this(null, null, null, null, null, readOptions);
    }

    @VisibleForTesting
    void setSleeper(Sleeper sleeper) {
        Preconditions.checkArgument((sleeper != null ? 1 : 0) != 0, (Object)"sleeper must not be null!");
        this.sleeper = sleeper;
    }

    @VisibleForTesting
    void setNanoClock(NanoClock clock) {
        Preconditions.checkArgument((clock != null ? 1 : 0) != 0, (Object)"clock must not be null!");
        this.clock = clock;
    }

    void setReadBackOff(BackOff backOff) {
        this.readBackOff = Suppliers.ofInstance((Object)Preconditions.checkNotNull((Object)backOff, (Object)"backOff could not be null"));
    }

    @VisibleForTesting
    BackOff getReadBackOff() {
        return (BackOff)this.readBackOff.get();
    }

    @VisibleForTesting
    ExponentialBackOff createBackOff() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(this.readOptions.getBackoffInitialIntervalMillis()).setRandomizationFactor(this.readOptions.getBackoffRandomizationFactor()).setMultiplier(this.readOptions.getBackoffMultiplier()).setMaxIntervalMillis(this.readOptions.getBackoffMaxIntervalMillis()).setMaxElapsedTimeMillis(this.readOptions.getBackoffMaxElapsedTimeMillis()).setNanoClock(this.clock).build();
    }

    @Nullable
    protected GoogleCloudStorageItemInfo getInitialMetadata() {
        return null;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        boolean isEndOfStream;
        this.throwIfNotOpen();
        if (buffer.remaining() == 0) {
            return 0;
        }
        ((GoogleLogger.Api)logger.atFine()).log("Reading %s bytes at %s position from '%s'", (Object)buffer.remaining(), (Object)this.currentPosition, this.resourceIdString);
        if (this.currentPosition == this.size) {
            return -1;
        }
        int totalBytesRead = 0;
        int retriesAttempted = 0;
        do {
            int remainingBeforeRead = buffer.remaining();
            this.performLazySeek(remainingBeforeRead);
            Preconditions.checkState((this.contentChannelPosition == this.currentPosition ? 1 : 0) != 0, (String)"contentChannelPosition (%s) should be equal to currentPosition (%s) after lazy seek", (long)this.contentChannelPosition, (long)this.currentPosition);
            try {
                int numBytesRead = this.contentChannel.read(buffer);
                this.checkIOPrecondition(numBytesRead != 0, "Read 0 bytes without blocking");
                if (numBytesRead < 0) {
                    if (this.gzipEncoded) {
                        this.size = this.currentPosition;
                        this.contentChannelEnd = this.currentPosition;
                    }
                    this.checkIOPrecondition(this.currentPosition == this.contentChannelEnd || this.currentPosition == this.size, String.format("Received end of stream result before all the file data has been received; totalBytesRead: %d, currentPosition: %d, contentChannelEnd %d, size: %d, object: '%s'", totalBytesRead, this.currentPosition, this.contentChannelEnd, this.size, this.resourceIdString));
                    if (this.contentChannelEnd == this.size || this.currentPosition != this.contentChannelEnd) break;
                    this.closeContentChannel();
                }
                if (numBytesRead > 0) {
                    totalBytesRead += numBytesRead;
                    this.currentPosition += (long)numBytesRead;
                    this.contentChannelPosition += (long)numBytesRead;
                    Preconditions.checkState((this.contentChannelPosition == this.currentPosition ? 1 : 0) != 0, (String)"contentChannelPosition (%s) should be equal to currentPosition (%s) after successful read", (long)this.contentChannelPosition, (long)this.currentPosition);
                }
                if (retriesAttempted != 0) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Success after %s retries on reading '%s'", retriesAttempted, this.resourceIdString);
                }
                retriesAttempted = 0;
            }
            catch (IOException ioe) {
                ((GoogleLogger.Api)logger.atFine()).log("Closing contentChannel after %s exception for '%s'.", (Object)ioe.getMessage(), this.resourceIdString);
                this.closeContentChannel();
                if (buffer.remaining() != remainingBeforeRead) {
                    int partialRead = remainingBeforeRead - buffer.remaining();
                    ((GoogleLogger.Api)logger.atInfo()).log("Despite exception, had partial read of %s bytes from '%s'; resetting retry count.", partialRead, this.resourceIdString);
                    retriesAttempted = 0;
                    totalBytesRead += partialRead;
                    this.currentPosition += (long)partialRead;
                }
                if (retriesAttempted == this.maxRetries) {
                    ((GoogleLogger.Api)logger.atSevere()).log("Throwing exception after reaching max read retries (%s) for '%s'.", this.maxRetries, this.resourceIdString);
                    throw ioe;
                }
                if (retriesAttempted == 0) {
                    ((BackOff)this.readBackOff.get()).reset();
                }
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)ioe)).log("Failed read retry #%s/%s for '%s'. Sleeping...", (Object)(++retriesAttempted), (Object)this.maxRetries, this.resourceIdString);
                try {
                    boolean backOffSuccessful = BackOffUtils.next((Sleeper)this.sleeper, (BackOff)((BackOff)this.readBackOff.get()));
                    if (!backOffSuccessful) {
                        ((GoogleLogger.Api)logger.atSevere()).log("BackOff returned false; maximum total elapsed time exhausted. Giving up after %s/%s retries for '%s'", (Object)retriesAttempted, (Object)this.maxRetries, this.resourceIdString);
                        throw ioe;
                    }
                }
                catch (InterruptedException ie) {
                    ((GoogleLogger.Api)logger.atSevere()).log("Interrupted while sleeping before retry. Giving up after %s/%s retries for '%s'", (Object)retriesAttempted, (Object)this.maxRetries, this.resourceIdString);
                    ioe.addSuppressed(ie);
                    throw ioe;
                }
                ((GoogleLogger.Api)logger.atInfo()).log("Done sleeping before retry #%s/%s for '%s'", (Object)retriesAttempted, (Object)this.maxRetries, this.resourceIdString);
            }
            catch (RuntimeException r) {
                this.closeContentChannel();
                throw r;
            }
        } while (buffer.remaining() > 0 && this.currentPosition < this.size);
        boolean bl = isEndOfStream = totalBytesRead == 0;
        if (isEndOfStream) {
            this.checkIOPrecondition(this.currentPosition == this.size, String.format("Failed to read any data before all the file data has been received; currentPosition: %d, size: %d, object '%s'", this.currentPosition, this.size, this.resourceIdString));
            return -1;
        }
        return totalBytesRead;
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new UnsupportedOperationException("Cannot mutate read-only channel");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException("Cannot mutate read-only channel");
    }

    @Override
    public boolean isOpen() {
        return this.channelIsOpen;
    }

    protected void closeContentChannel() {
        if (this.contentChannel != null) {
            ((GoogleLogger.Api)logger.atFine()).log("Closing internal contentChannel for '%s'", this.resourceIdString);
            try {
                this.contentChannel.close();
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause((Throwable)e)).log("Got an exception on contentChannel.close() for '%s'; ignoring it.", this.resourceIdString);
            }
            finally {
                this.contentChannel = null;
                this.resetContentChannel();
            }
        }
    }

    private void resetContentChannel() {
        Preconditions.checkState((this.contentChannel == null ? 1 : 0) != 0, (String)"contentChannel should be null for '%s'", (Object)this.resourceIdString);
        this.contentChannelPosition = -1L;
        this.contentChannelEnd = -1L;
    }

    @Override
    public void close() throws IOException {
        if (!this.channelIsOpen) {
            ((GoogleLogger.Api)logger.atFine()).log("Ignoring close: channel for '%s' is not open.", this.resourceIdString);
            return;
        }
        ((GoogleLogger.Api)logger.atFine()).log("Closing channel for '%s'", this.resourceIdString);
        this.channelIsOpen = false;
        this.closeContentChannel();
    }

    @Override
    public long position() throws IOException {
        this.throwIfNotOpen();
        return this.currentPosition;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.throwIfNotOpen();
        if (newPosition == this.currentPosition) {
            return this;
        }
        this.validatePosition(newPosition);
        ((GoogleLogger.Api)logger.atFine()).log("Seek from %s to %s position for '%s'", (Object)this.currentPosition, (Object)newPosition, this.resourceIdString);
        this.currentPosition = newPosition;
        return this;
    }

    private boolean isRandomAccessPattern(long oldPosition) {
        if (!this.shouldDetectRandomAccess()) {
            return false;
        }
        if (this.currentPosition < oldPosition) {
            ((GoogleLogger.Api)logger.atFine()).log("Detected backward read from %s to %s position, switching to random IO for '%s'", (Object)oldPosition, (Object)this.currentPosition, this.resourceIdString);
            return true;
        }
        if (oldPosition >= 0L && oldPosition + this.readOptions.getInplaceSeekLimit() < this.currentPosition) {
            ((GoogleLogger.Api)logger.atFine()).log("Detected forward read from %s to %s position over %s threshold, switching to random IO for '%s'", (Object)oldPosition, (Object)this.currentPosition, (Object)this.readOptions.getInplaceSeekLimit(), this.resourceIdString);
            return true;
        }
        return false;
    }

    private boolean shouldDetectRandomAccess() {
        return !this.gzipEncoded && !this.randomAccess && this.readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.AUTO;
    }

    private void setRandomAccess() {
        this.randomAccess = true;
        this.checkEncodingAndAccess();
    }

    private void skipInPlace(long seekDistance) {
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[8192];
        }
        while (seekDistance > 0L && this.contentChannel != null) {
            try {
                int bufferSize = Math.toIntExact(Math.min((long)this.skipBuffer.length, seekDistance));
                int bytesRead = this.contentChannel.read(ByteBuffer.wrap(this.skipBuffer, 0, bufferSize));
                if (bytesRead < 0) {
                    ((GoogleLogger.Api)logger.atInfo()).log("Somehow read %s bytes trying to skip %s bytes to seek to position %s, size: %s", (Object)bytesRead, (Object)seekDistance, (Object)this.currentPosition, (Object)this.size);
                    this.closeContentChannel();
                    continue;
                }
                seekDistance -= (long)bytesRead;
                this.contentChannelPosition += (long)bytesRead;
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause((Throwable)e)).log("Got an IO exception on contentChannel.read(), a lazy-seek will be pending for '%s'", this.resourceIdString);
                this.closeContentChannel();
            }
        }
        Preconditions.checkState((this.contentChannel == null || this.contentChannelPosition == this.currentPosition ? 1 : 0) != 0, (String)"contentChannelPosition (%s) should be equal to currentPosition (%s) after successful in-place skip", (long)this.contentChannelPosition, (long)this.currentPosition);
    }

    @Override
    public long size() throws IOException {
        this.throwIfNotOpen();
        return this.size;
    }

    protected void setSize(long size) {
        this.size = size;
    }

    private void checkEncodingAndAccess() {
        Preconditions.checkState((!this.gzipEncoded || !this.randomAccess ? 1 : 0) != 0, (String)"gzipEncoded and randomAccess should not be true at the same time for '%s'", (Object)this.resourceIdString);
    }

    protected void validatePosition(long position) throws IOException {
        if (position < 0L) {
            throw new EOFException(String.format("Invalid seek offset: position value (%d) must be >= 0 for '%s'", position, this.resourceIdString));
        }
        if (this.size >= 0L && position >= this.size) {
            throw new EOFException(String.format("Invalid seek offset: position value (%d) must be between 0 and %d for '%s'", position, this.size, this.resourceIdString));
        }
    }

    @VisibleForTesting
    void performLazySeek(long bytesToRead) throws IOException {
        this.throwIfNotOpen();
        if (this.currentPosition == this.contentChannelPosition && this.contentChannel != null) {
            return;
        }
        ((GoogleLogger.Api)logger.atFine()).log("Performing lazySeek from %s to %s position with %s bytesToRead for '%s'", (Object)this.contentChannelPosition, (Object)this.currentPosition, (Object)bytesToRead, this.resourceIdString);
        long oldPosition = this.contentChannelPosition;
        long seekDistance = this.currentPosition - this.contentChannelPosition;
        if (this.contentChannel != null && seekDistance > 0L && (this.gzipEncoded || seekDistance <= this.readOptions.getInplaceSeekLimit()) && this.currentPosition < this.contentChannelEnd) {
            ((GoogleLogger.Api)logger.atFine()).log("Seeking forward %s bytes (inplaceSeekLimit: %s) in-place to position %s for '%s'", (Object)seekDistance, (Object)this.readOptions.getInplaceSeekLimit(), (Object)this.currentPosition, this.resourceIdString);
            this.skipInPlace(seekDistance);
        } else {
            this.closeContentChannel();
        }
        if (this.contentChannel == null) {
            if (this.isRandomAccessPattern(oldPosition)) {
                this.setRandomAccess();
            }
            this.openContentChannel(bytesToRead);
        }
    }

    private void openContentChannel(long bytesToRead) throws IOException {
        Preconditions.checkState((this.contentChannel == null ? 1 : 0) != 0, (Object)"contentChannel should be null, before opening new");
        InputStream objectContentStream = this.footerContent != null && this.currentPosition >= this.size - (long)this.footerContent.length ? this.openFooterStream() : this.openStream(bytesToRead);
        this.contentChannel = Channels.newChannel(objectContentStream);
        Preconditions.checkState((this.contentChannelPosition == this.currentPosition ? 1 : 0) != 0, (String)"contentChannelPosition (%s) should be equal to currentPosition (%s) for '%s'", (Object)this.contentChannelPosition, (Object)this.currentPosition, (Object)this.resourceIdString);
    }

    @VisibleForTesting
    protected void initMetadata(HttpHeaders headers) throws IOException {
        Preconditions.checkState((!this.metadataInitialized ? 1 : 0) != 0, (String)"can not initialize metadata, it already initialized for '%s'", (Object)this.resourceIdString);
        String range = headers.getContentRange();
        long sizeFromMetadata = range != null ? Long.parseLong(range.substring(range.lastIndexOf(47) + 1)) : headers.getContentLength();
        String generation = headers.getFirstHeaderStringValue("x-goog-generation");
        this.initMetadata(headers.getContentEncoding(), sizeFromMetadata, generation);
    }

    @VisibleForTesting
    protected void initMetadata(@Nullable String encoding, long sizeFromMetadata, @Nullable String generation) throws IOException {
        Preconditions.checkState((!this.metadataInitialized ? 1 : 0) != 0, (String)"can not initialize metadata, it already initialized for '%s'", (Object)this.resourceIdString);
        this.gzipEncoded = Strings.nullToEmpty((String)encoding).contains(GZIP_ENCODING);
        this.size = this.gzipEncoded ? Long.MAX_VALUE : sizeFromMetadata;
        this.randomAccess = !this.gzipEncoded && this.readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.RANDOM;
        this.checkEncodingAndAccess();
        this.initGeneration(generation);
        this.metadataInitialized = true;
        ((GoogleLogger.Api)logger.atFine()).log("Initialized metadata (gzipEncoded=%s, size=%s, randomAccess=%s, generation=%s) for '%s'", (Object)this.gzipEncoded, (Object)this.size, (Object)this.randomAccess, (Object)generation, this.resourceIdString);
    }

    private void initGeneration(@Nullable String generationString) throws IOException {
        if (this.readOptions.getGenerationReadConsistency().equals((Object)GoogleCloudStorageReadOptions.GenerationReadConsistency.LATEST)) {
            this.generation = null;
        } else {
            if (generationString == null) {
                throw new IOException(String.format("Generation Read Consistency is '%s', but failed to retrieve generation for '%s'.", new Object[]{this.readOptions.getGenerationReadConsistency(), this.resourceIdString}));
            }
            this.generation = Long.parseLong(generationString);
        }
    }

    private void cacheFooter(HttpResponse response) throws IOException {
        Preconditions.checkState((this.size > 0L ? 1 : 0) != 0, (String)"size should be greater than 0 for '%s'", (Object)this.resourceIdString);
        int footerSize = Math.toIntExact(response.getHeaders().getContentLength());
        this.footerContent = new byte[footerSize];
        try (InputStream footerStream = response.getContent();){
            int totalBytesRead = 0;
            int bytesRead = 0;
            while ((bytesRead = footerStream.read(this.footerContent, totalBytesRead += bytesRead, footerSize - totalBytesRead)) >= 0 && totalBytesRead <= footerSize) {
            }
            Preconditions.checkState((footerStream.read() < 0 ? 1 : 0) != 0, (String)"footerStream should be empty after reading %s bytes from %s bytes for '%s'", (Object)totalBytesRead, (Object)footerSize, (Object)this.resourceIdString);
            Preconditions.checkState((totalBytesRead == footerSize ? 1 : 0) != 0, (String)"totalBytesRead (%s) should equal footerSize (%s) for '%s'", (Object)totalBytesRead, (Object)footerSize, (Object)this.resourceIdString);
        }
        catch (IOException e) {
            this.footerContent = null;
            throw e;
        }
        ((GoogleLogger.Api)logger.atFine()).log("Prefetched %s bytes footer for '%s'", this.footerContent.length, this.resourceIdString);
    }

    private InputStream openFooterStream() {
        this.contentChannelPosition = this.currentPosition;
        int offset = Math.toIntExact(this.currentPosition - (this.size - (long)this.footerContent.length));
        int length = this.footerContent.length - offset;
        ((GoogleLogger.Api)logger.atFine()).log("Opened stream (prefetched footer) from %s position for '%s'", this.currentPosition, this.resourceIdString);
        return new ByteArrayInputStream(this.footerContent, offset, length);
    }

    protected InputStream openStream(long bytesToRead) throws IOException {
        HttpResponse response;
        String rangeHeader;
        Preconditions.checkArgument((bytesToRead > 0L ? 1 : 0) != 0, (String)"bytesToRead should be greater than 0, but was %s", (long)bytesToRead);
        Preconditions.checkState((this.contentChannel == null && this.contentChannelEnd < 0L ? 1 : 0) != 0, (String)"contentChannel and contentChannelEnd should be not initialized yet for '%s'", (Object)this.resourceIdString);
        if (this.size == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (!this.metadataInitialized) {
            this.contentChannelPosition = this.getContentChannelPositionForFirstRead(bytesToRead);
            rangeHeader = "bytes=" + this.contentChannelPosition + "-";
            if (this.readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.RANDOM) {
                long maxBytesToRead = Math.max((long)this.readOptions.getMinRangeRequestSize(), bytesToRead);
                rangeHeader = rangeHeader + (this.contentChannelPosition + maxBytesToRead - 1L);
            }
        } else if (this.gzipEncoded) {
            rangeHeader = null;
            this.contentChannelPosition = 0L;
            this.contentChannelEnd = this.size;
        } else {
            this.contentChannelPosition = this.readOptions.getFadvise() != GoogleCloudStorageReadOptions.Fadvise.SEQUENTIAL && this.isFooterRead() ? Math.max(0L, this.size - (long)this.readOptions.getMinRangeRequestSize()) : this.currentPosition;
            long rangeSize = this.size - this.contentChannelPosition;
            if (this.randomAccess) {
                long randomRangeSize = Math.max(bytesToRead, (long)this.readOptions.getMinRangeRequestSize());
                rangeSize = Math.min(randomRangeSize, rangeSize);
            }
            this.contentChannelEnd = this.contentChannelPosition + rangeSize;
            if (this.footerContent != null) {
                this.contentChannelEnd = Math.min(this.contentChannelEnd, this.size - (long)this.footerContent.length);
            }
            Preconditions.checkState((this.currentPosition < this.contentChannelEnd ? 1 : 0) != 0, (String)"currentPosition (%s) should be less than contentChannelEnd (%s) for '%s'", (Object)this.currentPosition, (Object)this.contentChannelEnd, (Object)this.resourceIdString);
            Preconditions.checkState((this.contentChannelPosition <= this.currentPosition ? 1 : 0) != 0, (String)"contentChannelPosition (%s) should be less or equal to currentPosition (%s) for '%s'", (Object)this.contentChannelPosition, (Object)this.currentPosition, (Object)this.resourceIdString);
            rangeHeader = "bytes=" + this.contentChannelPosition + "-";
            if (this.randomAccess || this.contentChannelEnd != this.size) {
                rangeHeader = rangeHeader + (this.contentChannelEnd - 1L);
            }
        }
        Preconditions.checkState((!this.metadataInitialized || this.contentChannelEnd > 0L ? 1 : 0) != 0, (String)"contentChannelEnd should be initialized already for '%s'", (Object)this.resourceIdString);
        Storage.Objects.Get getObject = this.createDataRequest(rangeHeader);
        try {
            response = getObject.executeMedia();
        }
        catch (IOException e) {
            if (!this.metadataInitialized && this.errorExtractor.rangeNotSatisfiable(e) && this.currentPosition == 0L) {
                ((GoogleLogger.Api)logger.atInfo()).log("Got 'range not satisfiable' for reading '%s' at position 0; assuming empty.", this.resourceIdString);
                this.size = 0L;
                return new ByteArrayInputStream(new byte[0]);
            }
            response = this.handleExecuteMediaException(e, getObject, this.shouldRetryWithLiveVersion());
        }
        if (!this.metadataInitialized) {
            this.initMetadata(response.getHeaders());
            Preconditions.checkState((boolean)this.metadataInitialized, (String)"metadata should be initialized already for '%s'", (Object)this.resourceIdString);
            if (this.size == 0L) {
                this.resetContentChannel();
                return new ByteArrayInputStream(new byte[0]);
            }
            if (this.gzipEncoded) {
                if (this.currentPosition == 0L) {
                    this.contentChannelEnd = this.size;
                } else {
                    this.resetContentChannel();
                    return this.openStream(bytesToRead);
                }
            }
        }
        if (this.contentChannelEnd < 0L) {
            String contentRange = response.getHeaders().getContentRange();
            if (contentRange != null) {
                String contentEnd = contentRange.substring(contentRange.lastIndexOf(45) + 1, contentRange.lastIndexOf(47));
                this.contentChannelEnd = Long.parseLong(contentEnd) + 1L;
            } else {
                this.contentChannelEnd = response.getHeaders().getContentLength();
            }
        }
        Preconditions.checkState((this.contentChannelEnd > 0L ? 1 : 0) != 0, (String)"contentChannelEnd should be initialized already for '%s'", (Object)this.resourceIdString);
        if (!this.gzipEncoded && this.readOptions.getFadvise() != GoogleCloudStorageReadOptions.Fadvise.SEQUENTIAL && this.contentChannelEnd == this.size && this.contentChannelEnd - this.contentChannelPosition <= (long)this.readOptions.getMinRangeRequestSize()) {
            for (int retriesCount = 0; retriesCount < this.maxRetries; ++retriesCount) {
                try {
                    this.cacheFooter(response);
                    if (retriesCount == 0) break;
                    ((GoogleLogger.Api)logger.atInfo()).log("Successfully cached footer after %s retries for '%s'", retriesCount, this.resourceIdString);
                    break;
                }
                catch (IOException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atInfo()).withCause((Throwable)e)).log("Failed to prefetch footer (retry #%s/%s) for '%s'", (Object)(retriesCount + 1), (Object)this.maxRetries, this.resourceIdString);
                    if (retriesCount == 0) {
                        ((BackOff)this.readBackOff.get()).reset();
                    }
                    if (retriesCount == this.maxRetries) {
                        this.resetContentChannel();
                        throw e;
                    }
                    try {
                        response = getObject.executeMedia();
                    }
                    catch (IOException e1) {
                        response = this.handleExecuteMediaException(e1, getObject, this.shouldRetryWithLiveVersion());
                    }
                    continue;
                }
            }
            Preconditions.checkState((this.footerContent != null ? 1 : 0) != 0, (String)"footerContent should not be null after successful footer prefetch for '%s'", (Object)this.resourceIdString);
            this.resetContentChannel();
            return this.openFooterStream();
        }
        try {
            InputStream contentStream = response.getContent();
            if (this.readOptions.getBufferSize() > 0) {
                int bufferSize = this.readOptions.getBufferSize();
                bufferSize = Math.toIntExact(Math.min((long)bufferSize, this.contentChannelEnd - this.contentChannelPosition));
                ((GoogleLogger.Api)logger.atFine()).log("Opened stream from %d position with %s range, %d bytesToRead and %d bytes buffer for '%s'", (Object)this.currentPosition, (Object)rangeHeader, (Object)bytesToRead, (Object)bufferSize, this.resourceIdString);
                contentStream = new BufferedInputStream(contentStream, bufferSize);
            } else {
                ((GoogleLogger.Api)logger.atFine()).log("Opened stream from %d position with %s range and %d bytesToRead for '%s'", (Object)this.currentPosition, (Object)rangeHeader, (Object)bytesToRead, this.resourceIdString);
            }
            if (this.contentChannelPosition < this.currentPosition) {
                long bytesToSkip = this.currentPosition - this.contentChannelPosition;
                ((GoogleLogger.Api)logger.atFine()).log("Skipping %d bytes from %d position to %d position for '%s'", (Object)bytesToSkip, (Object)this.contentChannelPosition, (Object)this.currentPosition, this.resourceIdString);
                while (bytesToSkip > 0L) {
                    long skippedBytes = contentStream.skip(bytesToSkip);
                    ((GoogleLogger.Api)logger.atFine()).log("Skipped %d bytes from %d position for '%s'", (Object)skippedBytes, (Object)this.contentChannelPosition, this.resourceIdString);
                    bytesToSkip -= skippedBytes;
                    this.contentChannelPosition += skippedBytes;
                }
            }
            Preconditions.checkState((this.contentChannelPosition == this.currentPosition ? 1 : 0) != 0, (String)"contentChannelPosition (%s) should be equal to currentPosition (%s) for '%s'", (Object)this.contentChannelPosition, (Object)this.currentPosition, (Object)this.resourceIdString);
            return contentStream;
        }
        catch (IOException e) {
            try {
                response.disconnect();
            }
            catch (IOException closeException) {
                e.addSuppressed(closeException);
            }
            throw e;
        }
    }

    private boolean isFooterRead() {
        return this.size - this.currentPosition <= (long)this.readOptions.getMinRangeRequestSize();
    }

    private long getContentChannelPositionForFirstRead(long bytesToRead) {
        if (this.readOptions.getFadvise() == GoogleCloudStorageReadOptions.Fadvise.SEQUENTIAL || bytesToRead >= (long)this.readOptions.getMinRangeRequestSize()) {
            return this.currentPosition;
        }
        if (bytesToRead <= (long)(this.readOptions.getMinRangeRequestSize() / 2)) {
            return Math.max(0L, this.currentPosition - (long)(this.readOptions.getMinRangeRequestSize() / 2));
        }
        return Math.max(0L, this.currentPosition - ((long)this.readOptions.getMinRangeRequestSize() - bytesToRead));
    }

    private boolean shouldRetryWithLiveVersion() {
        return this.generation != null && this.readOptions.getGenerationReadConsistency().equals((Object)GoogleCloudStorageReadOptions.GenerationReadConsistency.BEST_EFFORT);
    }

    private HttpResponse handleExecuteMediaException(IOException e, Storage.Objects.Get getObject, boolean retryWithLiveVersion) throws IOException {
        if (this.errorExtractor.itemNotFound(e)) {
            if (retryWithLiveVersion) {
                this.generation = null;
                this.footerContent = null;
                getObject.setGeneration(null);
                try {
                    return getObject.executeMedia();
                }
                catch (IOException e1) {
                    return this.handleExecuteMediaException(e1, getObject, false);
                }
            }
            throw GoogleCloudStorageExceptions.getFileNotFoundException(this.bucketName, this.objectName);
        }
        String msg = String.format("Error reading '%s' at position %d", this.resourceIdString, this.currentPosition);
        if (this.errorExtractor.rangeNotSatisfiable(e)) {
            throw (EOFException)new EOFException(msg).initCause(e);
        }
        throw new IOException(msg, e);
    }

    private Storage.Objects.Get createDataRequest(String rangeHeader) throws IOException {
        Storage.Objects.Get getObject = this.createRequest();
        getObject.setGeneration(this.generation);
        HttpHeaders requestHeaders = this.clientRequestHelper.getRequestHeaders((AbstractGoogleClientRequest)getObject);
        requestHeaders.setAcceptEncoding(GZIP_ENCODING);
        requestHeaders.setRange(rangeHeader);
        return getObject;
    }

    protected Storage.Objects.Get createRequest() throws IOException {
        return this.gcs.objects().get(this.bucketName, this.objectName);
    }

    private void throwIfNotOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void checkIOPrecondition(boolean precondition, String errorMessage) throws IOException {
        if (!precondition) {
            throw new IOException(errorMessage);
        }
    }

    private static Object lazyToString(final Supplier<String> stringSupplier) {
        return new Object(){
            private final Supplier<String> toString;
            {
                this.toString = Suppliers.memoize((Supplier)stringSupplier);
            }

            public String toString() {
                return (String)this.toString.get();
            }
        };
    }
}

