/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.AutoValue_GoogleCloudStorageOptions;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;

@AutoValue
public abstract class GoogleCloudStorageOptions {
    public static final boolean AUTO_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final boolean INFER_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final boolean CREATE_EMPTY_MARKER_OBJECT_DEFAULT = false;
    public static final int MAX_WAIT_MILLIS_FOR_EMPTY_OBJECT_CREATION = 3000;
    public static final long MAX_LIST_ITEMS_PER_CALL_DEFAULT = 1024L;
    public static final long MAX_REQUESTS_PER_BATCH_DEFAULT = 30L;
    public static final int MAX_HTTP_REQUEST_RETRIES = 10;
    public static final int HTTP_REQUEST_CONNECT_TIMEOUT = 20000;
    public static final int HTTP_REQUEST_READ_TIMEOUT = 20000;
    public static final boolean COPY_WITH_REWRITE_DEFAULT = false;
    public static final AsyncWriteChannelOptions ASYNC_WRITE_CHANNEL_OPTIONS_DEFAULT = AsyncWriteChannelOptions.newBuilder().build();
    public static final RequesterPaysOptions REQUESTER_PAYS_OPTIONS_DEFAULT = RequesterPaysOptions.DEFAULT;

    public static Builder newBuilder() {
        return new AutoValue_GoogleCloudStorageOptions.Builder().setAutoRepairImplicitDirectoriesEnabled(true).setInferImplicitDirectoriesEnabled(true).setCreateMarkerObjects(false).setMaxWaitMillisForEmptyObjectCreation(3000).setMaxListItemsPerCall(1024L).setMaxRequestsPerBatch(30L).setMaxHttpRequestRetries(10).setHttpRequestConnectTimeout(20000).setHttpRequestReadTimeout(20000).setTransportType(HttpTransportFactory.DEFAULT_TRANSPORT_TYPE).setCopyWithRewriteEnabled(false).setWriteChannelOptions(ASYNC_WRITE_CHANNEL_OPTIONS_DEFAULT).setRequesterPaysOptions(REQUESTER_PAYS_OPTIONS_DEFAULT);
    }

    @Nullable
    public abstract String getProjectId();

    @Nullable
    public abstract String getAppName();

    public abstract boolean isAutoRepairImplicitDirectoriesEnabled();

    public abstract boolean isInferImplicitDirectoriesEnabled();

    public abstract boolean isMarkerFileCreationEnabled();

    public abstract int getMaxWaitMillisForEmptyObjectCreation();

    public abstract long getMaxListItemsPerCall();

    public abstract long getMaxRequestsPerBatch();

    public abstract int getMaxHttpRequestRetries();

    public abstract int getHttpRequestConnectTimeout();

    public abstract int getHttpRequestReadTimeout();

    public abstract HttpTransportFactory.HttpTransportType getTransportType();

    @Nullable
    public abstract String getProxyAddress();

    public abstract boolean isCopyWithRewriteEnabled();

    public abstract AsyncWriteChannelOptions getWriteChannelOptions();

    public abstract RequesterPaysOptions getRequesterPaysOptions();

    public abstract Builder toBuilder();

    public void throwIfNotValid() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getAppName()) ? 1 : 0) != 0, (Object)"appName must not be null or empty");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @Deprecated
        private AsyncWriteChannelOptions.Builder writeChannelOptionsBuilder;

        public abstract Builder setProjectId(String var1);

        public abstract Builder setAppName(String var1);

        public abstract Builder setAutoRepairImplicitDirectoriesEnabled(boolean var1);

        public abstract Builder setInferImplicitDirectoriesEnabled(boolean var1);

        public abstract Builder setMarkerFileCreationEnabled(boolean var1);

        @Deprecated
        public Builder setCreateMarkerObjects(boolean createMarkerObjects) {
            return this.setMarkerFileCreationEnabled(createMarkerObjects);
        }

        public abstract Builder setMaxWaitMillisForEmptyObjectCreation(int var1);

        public abstract Builder setMaxListItemsPerCall(long var1);

        public abstract Builder setMaxRequestsPerBatch(long var1);

        public abstract Builder setMaxHttpRequestRetries(int var1);

        public abstract Builder setHttpRequestConnectTimeout(int var1);

        public abstract Builder setHttpRequestReadTimeout(int var1);

        public abstract Builder setTransportType(HttpTransportFactory.HttpTransportType var1);

        public abstract Builder setProxyAddress(String var1);

        public abstract Builder setCopyWithRewriteEnabled(boolean var1);

        public abstract Builder setWriteChannelOptions(AsyncWriteChannelOptions var1);

        @Deprecated
        public Builder setWriteChannelOptionsBuilder(AsyncWriteChannelOptions.Builder builder) {
            this.writeChannelOptionsBuilder = builder;
            return this;
        }

        @Deprecated
        public AsyncWriteChannelOptions.Builder getWriteChannelOptionsBuilder() {
            return this.writeChannelOptionsBuilder == null ? (this.writeChannelOptionsBuilder = AsyncWriteChannelOptions.newBuilder()) : this.writeChannelOptionsBuilder;
        }

        public abstract Builder setRequesterPaysOptions(RequesterPaysOptions var1);

        abstract GoogleCloudStorageOptions autoBuild();

        public GoogleCloudStorageOptions build() {
            if (this.writeChannelOptionsBuilder != null) {
                this.setWriteChannelOptions(this.writeChannelOptionsBuilder.build());
            }
            return this.autoBuild();
        }
    }
}

