/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.testing;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InMemoryObjectReadChannel
extends GoogleCloudStorageReadChannel {
    private final byte[] channelContent;

    public InMemoryObjectReadChannel(byte[] channelContent) throws IOException {
        this(channelContent, GoogleCloudStorageReadOptions.DEFAULT);
    }

    public InMemoryObjectReadChannel(byte[] channelContent, GoogleCloudStorageReadOptions readOptions) throws IOException {
        super(readOptions);
        this.channelContent = (byte[])Preconditions.checkNotNull((Object)channelContent, (Object)"channelContents could not be null");
        this.setSize(channelContent.length);
    }

    @Override
    protected void initEncodingAndSize() {
    }

    @Override
    protected InputStream openStream(long bytesToRead) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.channelContent);
        ((InputStream)inputStream).skip(this.currentPosition);
        return inputStream;
    }
}

