/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class GoogleCloudStorageExceptions {
    public static FileNotFoundException getFileNotFoundException(String bucketName, String objectName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)bucketName) ? 1 : 0) != 0, (Object)"bucketName must not be null or empty");
        if (objectName == null) {
            objectName = "";
        }
        return new FileNotFoundException(String.format("Item not found: %s/%s. If you enabled STRICT generation consistency, it is possible that the live version is still available but the intended generation is deleted.", bucketName, objectName));
    }

    public static IOException createCompositeException(Collection<IOException> innerExceptions) {
        Preconditions.checkArgument((innerExceptions != null ? 1 : 0) != 0, (Object)"innerExceptions must not be null");
        Preconditions.checkArgument((!innerExceptions.isEmpty() ? 1 : 0) != 0, (Object)"innerExceptions must contain at least one element");
        Iterator<IOException> innerExceptionIterator = innerExceptions.iterator();
        if (innerExceptions.size() == 1) {
            return innerExceptionIterator.next();
        }
        IOException combined = new IOException("Multiple IOExceptions.");
        while (innerExceptionIterator.hasNext()) {
            combined.addSuppressed(innerExceptionIterator.next());
        }
        return combined;
    }

    public static IOException wrapException(IOException e, String message, String bucketName, String objectName) {
        String name = "bucket: " + bucketName;
        if (!Strings.isNullOrEmpty((String)objectName)) {
            name = name + ", object: " + objectName;
        }
        String fullMessage = String.format("%s: %s", message, name);
        return new IOException(fullMessage, e);
    }
}

