

package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageOptions extends GoogleCloudStorageOptions {

  private final String projectId;

  private final String appName;

  private final boolean autoRepairImplicitDirectoriesEnabled;

  private final boolean inferImplicitDirectoriesEnabled;

  private final boolean markerFileCreationEnabled;

  private final int maxWaitMillisForEmptyObjectCreation;

  private final long maxListItemsPerCall;

  private final long maxRequestsPerBatch;

  private final int batchThreads;

  private final long copyMaxRequestsPerBatch;

  private final int copyBatchThreads;

  private final int maxHttpRequestRetries;

  private final int httpRequestConnectTimeout;

  private final int httpRequestReadTimeout;

  private final HttpTransportFactory.HttpTransportType transportType;

  private final String proxyAddress;

  private final boolean copyWithRewriteEnabled;

  private final AsyncWriteChannelOptions writeChannelOptions;

  private final RequesterPaysOptions requesterPaysOptions;

  private AutoValue_GoogleCloudStorageOptions(
      @Nullable String projectId,
      @Nullable String appName,
      boolean autoRepairImplicitDirectoriesEnabled,
      boolean inferImplicitDirectoriesEnabled,
      boolean markerFileCreationEnabled,
      int maxWaitMillisForEmptyObjectCreation,
      long maxListItemsPerCall,
      long maxRequestsPerBatch,
      int batchThreads,
      long copyMaxRequestsPerBatch,
      int copyBatchThreads,
      int maxHttpRequestRetries,
      int httpRequestConnectTimeout,
      int httpRequestReadTimeout,
      HttpTransportFactory.HttpTransportType transportType,
      @Nullable String proxyAddress,
      boolean copyWithRewriteEnabled,
      AsyncWriteChannelOptions writeChannelOptions,
      RequesterPaysOptions requesterPaysOptions) {
    this.projectId = projectId;
    this.appName = appName;
    this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
    this.inferImplicitDirectoriesEnabled = inferImplicitDirectoriesEnabled;
    this.markerFileCreationEnabled = markerFileCreationEnabled;
    this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
    this.maxListItemsPerCall = maxListItemsPerCall;
    this.maxRequestsPerBatch = maxRequestsPerBatch;
    this.batchThreads = batchThreads;
    this.copyMaxRequestsPerBatch = copyMaxRequestsPerBatch;
    this.copyBatchThreads = copyBatchThreads;
    this.maxHttpRequestRetries = maxHttpRequestRetries;
    this.httpRequestConnectTimeout = httpRequestConnectTimeout;
    this.httpRequestReadTimeout = httpRequestReadTimeout;
    this.transportType = transportType;
    this.proxyAddress = proxyAddress;
    this.copyWithRewriteEnabled = copyWithRewriteEnabled;
    this.writeChannelOptions = writeChannelOptions;
    this.requesterPaysOptions = requesterPaysOptions;
  }

  @Nullable
  @Override
  public String getProjectId() {
    return projectId;
  }

  @Nullable
  @Override
  public String getAppName() {
    return appName;
  }

  @Override
  public boolean isAutoRepairImplicitDirectoriesEnabled() {
    return autoRepairImplicitDirectoriesEnabled;
  }

  @Override
  public boolean isInferImplicitDirectoriesEnabled() {
    return inferImplicitDirectoriesEnabled;
  }

  @Override
  public boolean isMarkerFileCreationEnabled() {
    return markerFileCreationEnabled;
  }

  @Override
  public int getMaxWaitMillisForEmptyObjectCreation() {
    return maxWaitMillisForEmptyObjectCreation;
  }

  @Override
  public long getMaxListItemsPerCall() {
    return maxListItemsPerCall;
  }

  @Override
  public long getMaxRequestsPerBatch() {
    return maxRequestsPerBatch;
  }

  @Override
  public int getBatchThreads() {
    return batchThreads;
  }

  @Override
  public long getCopyMaxRequestsPerBatch() {
    return copyMaxRequestsPerBatch;
  }

  @Override
  public int getCopyBatchThreads() {
    return copyBatchThreads;
  }

  @Override
  public int getMaxHttpRequestRetries() {
    return maxHttpRequestRetries;
  }

  @Override
  public int getHttpRequestConnectTimeout() {
    return httpRequestConnectTimeout;
  }

  @Override
  public int getHttpRequestReadTimeout() {
    return httpRequestReadTimeout;
  }

  @Override
  public HttpTransportFactory.HttpTransportType getTransportType() {
    return transportType;
  }

  @Nullable
  @Override
  public String getProxyAddress() {
    return proxyAddress;
  }

  @Override
  public boolean isCopyWithRewriteEnabled() {
    return copyWithRewriteEnabled;
  }

  @Override
  public AsyncWriteChannelOptions getWriteChannelOptions() {
    return writeChannelOptions;
  }

  @Override
  public RequesterPaysOptions getRequesterPaysOptions() {
    return requesterPaysOptions;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageOptions{"
         + "projectId=" + projectId + ", "
         + "appName=" + appName + ", "
         + "autoRepairImplicitDirectoriesEnabled=" + autoRepairImplicitDirectoriesEnabled + ", "
         + "inferImplicitDirectoriesEnabled=" + inferImplicitDirectoriesEnabled + ", "
         + "markerFileCreationEnabled=" + markerFileCreationEnabled + ", "
         + "maxWaitMillisForEmptyObjectCreation=" + maxWaitMillisForEmptyObjectCreation + ", "
         + "maxListItemsPerCall=" + maxListItemsPerCall + ", "
         + "maxRequestsPerBatch=" + maxRequestsPerBatch + ", "
         + "batchThreads=" + batchThreads + ", "
         + "copyMaxRequestsPerBatch=" + copyMaxRequestsPerBatch + ", "
         + "copyBatchThreads=" + copyBatchThreads + ", "
         + "maxHttpRequestRetries=" + maxHttpRequestRetries + ", "
         + "httpRequestConnectTimeout=" + httpRequestConnectTimeout + ", "
         + "httpRequestReadTimeout=" + httpRequestReadTimeout + ", "
         + "transportType=" + transportType + ", "
         + "proxyAddress=" + proxyAddress + ", "
         + "copyWithRewriteEnabled=" + copyWithRewriteEnabled + ", "
         + "writeChannelOptions=" + writeChannelOptions + ", "
         + "requesterPaysOptions=" + requesterPaysOptions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageOptions) {
      GoogleCloudStorageOptions that = (GoogleCloudStorageOptions) o;
      return ((this.projectId == null) ? (that.getProjectId() == null) : this.projectId.equals(that.getProjectId()))
           && ((this.appName == null) ? (that.getAppName() == null) : this.appName.equals(that.getAppName()))
           && (this.autoRepairImplicitDirectoriesEnabled == that.isAutoRepairImplicitDirectoriesEnabled())
           && (this.inferImplicitDirectoriesEnabled == that.isInferImplicitDirectoriesEnabled())
           && (this.markerFileCreationEnabled == that.isMarkerFileCreationEnabled())
           && (this.maxWaitMillisForEmptyObjectCreation == that.getMaxWaitMillisForEmptyObjectCreation())
           && (this.maxListItemsPerCall == that.getMaxListItemsPerCall())
           && (this.maxRequestsPerBatch == that.getMaxRequestsPerBatch())
           && (this.batchThreads == that.getBatchThreads())
           && (this.copyMaxRequestsPerBatch == that.getCopyMaxRequestsPerBatch())
           && (this.copyBatchThreads == that.getCopyBatchThreads())
           && (this.maxHttpRequestRetries == that.getMaxHttpRequestRetries())
           && (this.httpRequestConnectTimeout == that.getHttpRequestConnectTimeout())
           && (this.httpRequestReadTimeout == that.getHttpRequestReadTimeout())
           && (this.transportType.equals(that.getTransportType()))
           && ((this.proxyAddress == null) ? (that.getProxyAddress() == null) : this.proxyAddress.equals(that.getProxyAddress()))
           && (this.copyWithRewriteEnabled == that.isCopyWithRewriteEnabled())
           && (this.writeChannelOptions.equals(that.getWriteChannelOptions()))
           && (this.requesterPaysOptions.equals(that.getRequesterPaysOptions()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (projectId == null) ? 0 : projectId.hashCode();
    h$ *= 1000003;
    h$ ^= (appName == null) ? 0 : appName.hashCode();
    h$ *= 1000003;
    h$ ^= autoRepairImplicitDirectoriesEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= inferImplicitDirectoriesEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= markerFileCreationEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= maxWaitMillisForEmptyObjectCreation;
    h$ *= 1000003;
    h$ ^= (int) ((maxListItemsPerCall >>> 32) ^ maxListItemsPerCall);
    h$ *= 1000003;
    h$ ^= (int) ((maxRequestsPerBatch >>> 32) ^ maxRequestsPerBatch);
    h$ *= 1000003;
    h$ ^= batchThreads;
    h$ *= 1000003;
    h$ ^= (int) ((copyMaxRequestsPerBatch >>> 32) ^ copyMaxRequestsPerBatch);
    h$ *= 1000003;
    h$ ^= copyBatchThreads;
    h$ *= 1000003;
    h$ ^= maxHttpRequestRetries;
    h$ *= 1000003;
    h$ ^= httpRequestConnectTimeout;
    h$ *= 1000003;
    h$ ^= httpRequestReadTimeout;
    h$ *= 1000003;
    h$ ^= transportType.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyAddress == null) ? 0 : proxyAddress.hashCode();
    h$ *= 1000003;
    h$ ^= copyWithRewriteEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= writeChannelOptions.hashCode();
    h$ *= 1000003;
    h$ ^= requesterPaysOptions.hashCode();
    return h$;
  }

  @Override
  public GoogleCloudStorageOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageOptions.Builder {
    private String projectId;
    private String appName;
    private Boolean autoRepairImplicitDirectoriesEnabled;
    private Boolean inferImplicitDirectoriesEnabled;
    private Boolean markerFileCreationEnabled;
    private Integer maxWaitMillisForEmptyObjectCreation;
    private Long maxListItemsPerCall;
    private Long maxRequestsPerBatch;
    private Integer batchThreads;
    private Long copyMaxRequestsPerBatch;
    private Integer copyBatchThreads;
    private Integer maxHttpRequestRetries;
    private Integer httpRequestConnectTimeout;
    private Integer httpRequestReadTimeout;
    private HttpTransportFactory.HttpTransportType transportType;
    private String proxyAddress;
    private Boolean copyWithRewriteEnabled;
    private AsyncWriteChannelOptions writeChannelOptions;
    private RequesterPaysOptions requesterPaysOptions;
    Builder() {
    }
    private Builder(GoogleCloudStorageOptions source) {
      this.projectId = source.getProjectId();
      this.appName = source.getAppName();
      this.autoRepairImplicitDirectoriesEnabled = source.isAutoRepairImplicitDirectoriesEnabled();
      this.inferImplicitDirectoriesEnabled = source.isInferImplicitDirectoriesEnabled();
      this.markerFileCreationEnabled = source.isMarkerFileCreationEnabled();
      this.maxWaitMillisForEmptyObjectCreation = source.getMaxWaitMillisForEmptyObjectCreation();
      this.maxListItemsPerCall = source.getMaxListItemsPerCall();
      this.maxRequestsPerBatch = source.getMaxRequestsPerBatch();
      this.batchThreads = source.getBatchThreads();
      this.copyMaxRequestsPerBatch = source.getCopyMaxRequestsPerBatch();
      this.copyBatchThreads = source.getCopyBatchThreads();
      this.maxHttpRequestRetries = source.getMaxHttpRequestRetries();
      this.httpRequestConnectTimeout = source.getHttpRequestConnectTimeout();
      this.httpRequestReadTimeout = source.getHttpRequestReadTimeout();
      this.transportType = source.getTransportType();
      this.proxyAddress = source.getProxyAddress();
      this.copyWithRewriteEnabled = source.isCopyWithRewriteEnabled();
      this.writeChannelOptions = source.getWriteChannelOptions();
      this.requesterPaysOptions = source.getRequesterPaysOptions();
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProjectId(String projectId) {
      this.projectId = projectId;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAppName(String appName) {
      this.appName = appName;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
      this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setInferImplicitDirectoriesEnabled(boolean inferImplicitDirectoriesEnabled) {
      this.inferImplicitDirectoriesEnabled = inferImplicitDirectoriesEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMarkerFileCreationEnabled(boolean markerFileCreationEnabled) {
      this.markerFileCreationEnabled = markerFileCreationEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxWaitMillisForEmptyObjectCreation(int maxWaitMillisForEmptyObjectCreation) {
      this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxListItemsPerCall(long maxListItemsPerCall) {
      this.maxListItemsPerCall = maxListItemsPerCall;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxRequestsPerBatch(long maxRequestsPerBatch) {
      this.maxRequestsPerBatch = maxRequestsPerBatch;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setBatchThreads(int batchThreads) {
      this.batchThreads = batchThreads;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setCopyMaxRequestsPerBatch(long copyMaxRequestsPerBatch) {
      this.copyMaxRequestsPerBatch = copyMaxRequestsPerBatch;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setCopyBatchThreads(int copyBatchThreads) {
      this.copyBatchThreads = copyBatchThreads;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxHttpRequestRetries(int maxHttpRequestRetries) {
      this.maxHttpRequestRetries = maxHttpRequestRetries;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestConnectTimeout(int httpRequestConnectTimeout) {
      this.httpRequestConnectTimeout = httpRequestConnectTimeout;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestReadTimeout(int httpRequestReadTimeout) {
      this.httpRequestReadTimeout = httpRequestReadTimeout;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTransportType(HttpTransportFactory.HttpTransportType transportType) {
      if (transportType == null) {
        throw new NullPointerException("Null transportType");
      }
      this.transportType = transportType;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyAddress(String proxyAddress) {
      this.proxyAddress = proxyAddress;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setCopyWithRewriteEnabled(boolean copyWithRewriteEnabled) {
      this.copyWithRewriteEnabled = copyWithRewriteEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setWriteChannelOptions(AsyncWriteChannelOptions writeChannelOptions) {
      if (writeChannelOptions == null) {
        throw new NullPointerException("Null writeChannelOptions");
      }
      this.writeChannelOptions = writeChannelOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setRequesterPaysOptions(RequesterPaysOptions requesterPaysOptions) {
      if (requesterPaysOptions == null) {
        throw new NullPointerException("Null requesterPaysOptions");
      }
      this.requesterPaysOptions = requesterPaysOptions;
      return this;
    }
    @Override
    GoogleCloudStorageOptions autoBuild() {
      String missing = "";
      if (this.autoRepairImplicitDirectoriesEnabled == null) {
        missing += " autoRepairImplicitDirectoriesEnabled";
      }
      if (this.inferImplicitDirectoriesEnabled == null) {
        missing += " inferImplicitDirectoriesEnabled";
      }
      if (this.markerFileCreationEnabled == null) {
        missing += " markerFileCreationEnabled";
      }
      if (this.maxWaitMillisForEmptyObjectCreation == null) {
        missing += " maxWaitMillisForEmptyObjectCreation";
      }
      if (this.maxListItemsPerCall == null) {
        missing += " maxListItemsPerCall";
      }
      if (this.maxRequestsPerBatch == null) {
        missing += " maxRequestsPerBatch";
      }
      if (this.batchThreads == null) {
        missing += " batchThreads";
      }
      if (this.copyMaxRequestsPerBatch == null) {
        missing += " copyMaxRequestsPerBatch";
      }
      if (this.copyBatchThreads == null) {
        missing += " copyBatchThreads";
      }
      if (this.maxHttpRequestRetries == null) {
        missing += " maxHttpRequestRetries";
      }
      if (this.httpRequestConnectTimeout == null) {
        missing += " httpRequestConnectTimeout";
      }
      if (this.httpRequestReadTimeout == null) {
        missing += " httpRequestReadTimeout";
      }
      if (this.transportType == null) {
        missing += " transportType";
      }
      if (this.copyWithRewriteEnabled == null) {
        missing += " copyWithRewriteEnabled";
      }
      if (this.writeChannelOptions == null) {
        missing += " writeChannelOptions";
      }
      if (this.requesterPaysOptions == null) {
        missing += " requesterPaysOptions";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageOptions(
          this.projectId,
          this.appName,
          this.autoRepairImplicitDirectoriesEnabled,
          this.inferImplicitDirectoriesEnabled,
          this.markerFileCreationEnabled,
          this.maxWaitMillisForEmptyObjectCreation,
          this.maxListItemsPerCall,
          this.maxRequestsPerBatch,
          this.batchThreads,
          this.copyMaxRequestsPerBatch,
          this.copyBatchThreads,
          this.maxHttpRequestRetries,
          this.httpRequestConnectTimeout,
          this.httpRequestReadTimeout,
          this.transportType,
          this.proxyAddress,
          this.copyWithRewriteEnabled,
          this.writeChannelOptions,
          this.requesterPaysOptions);
    }
  }

}
