/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import javax.annotation.Nullable;

final class AutoValue_GoogleCloudStorageOptions
extends GoogleCloudStorageOptions {
    private final String projectId;
    private final String appName;
    private final boolean autoRepairImplicitDirectoriesEnabled;
    private final boolean inferImplicitDirectoriesEnabled;
    private final boolean markerFileCreationEnabled;
    private final int maxWaitMillisForEmptyObjectCreation;
    private final long maxListItemsPerCall;
    private final long maxRequestsPerBatch;
    private final int batchThreads;
    private final long copyMaxRequestsPerBatch;
    private final int copyBatchThreads;
    private final int maxHttpRequestRetries;
    private final int httpRequestConnectTimeout;
    private final int httpRequestReadTimeout;
    private final HttpTransportFactory.HttpTransportType transportType;
    private final String proxyAddress;
    private final boolean copyWithRewriteEnabled;
    private final long maxBytesRewrittenPerCall;
    private final GoogleCloudStorageReadOptions readChannelOptions;
    private final AsyncWriteChannelOptions writeChannelOptions;
    private final RequesterPaysOptions requesterPaysOptions;

    private AutoValue_GoogleCloudStorageOptions(@Nullable String projectId, @Nullable String appName, boolean autoRepairImplicitDirectoriesEnabled, boolean inferImplicitDirectoriesEnabled, boolean markerFileCreationEnabled, int maxWaitMillisForEmptyObjectCreation, long maxListItemsPerCall, long maxRequestsPerBatch, int batchThreads, long copyMaxRequestsPerBatch, int copyBatchThreads, int maxHttpRequestRetries, int httpRequestConnectTimeout, int httpRequestReadTimeout, HttpTransportFactory.HttpTransportType transportType, @Nullable String proxyAddress, boolean copyWithRewriteEnabled, long maxBytesRewrittenPerCall, GoogleCloudStorageReadOptions readChannelOptions, AsyncWriteChannelOptions writeChannelOptions, RequesterPaysOptions requesterPaysOptions) {
        this.projectId = projectId;
        this.appName = appName;
        this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
        this.inferImplicitDirectoriesEnabled = inferImplicitDirectoriesEnabled;
        this.markerFileCreationEnabled = markerFileCreationEnabled;
        this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
        this.maxListItemsPerCall = maxListItemsPerCall;
        this.maxRequestsPerBatch = maxRequestsPerBatch;
        this.batchThreads = batchThreads;
        this.copyMaxRequestsPerBatch = copyMaxRequestsPerBatch;
        this.copyBatchThreads = copyBatchThreads;
        this.maxHttpRequestRetries = maxHttpRequestRetries;
        this.httpRequestConnectTimeout = httpRequestConnectTimeout;
        this.httpRequestReadTimeout = httpRequestReadTimeout;
        this.transportType = transportType;
        this.proxyAddress = proxyAddress;
        this.copyWithRewriteEnabled = copyWithRewriteEnabled;
        this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
        this.readChannelOptions = readChannelOptions;
        this.writeChannelOptions = writeChannelOptions;
        this.requesterPaysOptions = requesterPaysOptions;
    }

    @Override
    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    public String getAppName() {
        return this.appName;
    }

    @Override
    public boolean isAutoRepairImplicitDirectoriesEnabled() {
        return this.autoRepairImplicitDirectoriesEnabled;
    }

    @Override
    public boolean isInferImplicitDirectoriesEnabled() {
        return this.inferImplicitDirectoriesEnabled;
    }

    @Override
    public boolean isMarkerFileCreationEnabled() {
        return this.markerFileCreationEnabled;
    }

    @Override
    public int getMaxWaitMillisForEmptyObjectCreation() {
        return this.maxWaitMillisForEmptyObjectCreation;
    }

    @Override
    public long getMaxListItemsPerCall() {
        return this.maxListItemsPerCall;
    }

    @Override
    public long getMaxRequestsPerBatch() {
        return this.maxRequestsPerBatch;
    }

    @Override
    public int getBatchThreads() {
        return this.batchThreads;
    }

    @Override
    public long getCopyMaxRequestsPerBatch() {
        return this.copyMaxRequestsPerBatch;
    }

    @Override
    public int getCopyBatchThreads() {
        return this.copyBatchThreads;
    }

    @Override
    public int getMaxHttpRequestRetries() {
        return this.maxHttpRequestRetries;
    }

    @Override
    public int getHttpRequestConnectTimeout() {
        return this.httpRequestConnectTimeout;
    }

    @Override
    public int getHttpRequestReadTimeout() {
        return this.httpRequestReadTimeout;
    }

    @Override
    public HttpTransportFactory.HttpTransportType getTransportType() {
        return this.transportType;
    }

    @Override
    @Nullable
    public String getProxyAddress() {
        return this.proxyAddress;
    }

    @Override
    public boolean isCopyWithRewriteEnabled() {
        return this.copyWithRewriteEnabled;
    }

    @Override
    public long getMaxBytesRewrittenPerCall() {
        return this.maxBytesRewrittenPerCall;
    }

    @Override
    public GoogleCloudStorageReadOptions getReadChannelOptions() {
        return this.readChannelOptions;
    }

    @Override
    public AsyncWriteChannelOptions getWriteChannelOptions() {
        return this.writeChannelOptions;
    }

    @Override
    public RequesterPaysOptions getRequesterPaysOptions() {
        return this.requesterPaysOptions;
    }

    public String toString() {
        return "GoogleCloudStorageOptions{projectId=" + this.projectId + ", appName=" + this.appName + ", autoRepairImplicitDirectoriesEnabled=" + this.autoRepairImplicitDirectoriesEnabled + ", inferImplicitDirectoriesEnabled=" + this.inferImplicitDirectoriesEnabled + ", markerFileCreationEnabled=" + this.markerFileCreationEnabled + ", maxWaitMillisForEmptyObjectCreation=" + this.maxWaitMillisForEmptyObjectCreation + ", maxListItemsPerCall=" + this.maxListItemsPerCall + ", maxRequestsPerBatch=" + this.maxRequestsPerBatch + ", batchThreads=" + this.batchThreads + ", copyMaxRequestsPerBatch=" + this.copyMaxRequestsPerBatch + ", copyBatchThreads=" + this.copyBatchThreads + ", maxHttpRequestRetries=" + this.maxHttpRequestRetries + ", httpRequestConnectTimeout=" + this.httpRequestConnectTimeout + ", httpRequestReadTimeout=" + this.httpRequestReadTimeout + ", transportType=" + this.transportType + ", proxyAddress=" + this.proxyAddress + ", copyWithRewriteEnabled=" + this.copyWithRewriteEnabled + ", maxBytesRewrittenPerCall=" + this.maxBytesRewrittenPerCall + ", readChannelOptions=" + this.readChannelOptions + ", writeChannelOptions=" + this.writeChannelOptions + ", requesterPaysOptions=" + this.requesterPaysOptions + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GoogleCloudStorageOptions) {
            GoogleCloudStorageOptions that = (GoogleCloudStorageOptions)o;
            return (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && (this.appName == null ? that.getAppName() == null : this.appName.equals(that.getAppName())) && this.autoRepairImplicitDirectoriesEnabled == that.isAutoRepairImplicitDirectoriesEnabled() && this.inferImplicitDirectoriesEnabled == that.isInferImplicitDirectoriesEnabled() && this.markerFileCreationEnabled == that.isMarkerFileCreationEnabled() && this.maxWaitMillisForEmptyObjectCreation == that.getMaxWaitMillisForEmptyObjectCreation() && this.maxListItemsPerCall == that.getMaxListItemsPerCall() && this.maxRequestsPerBatch == that.getMaxRequestsPerBatch() && this.batchThreads == that.getBatchThreads() && this.copyMaxRequestsPerBatch == that.getCopyMaxRequestsPerBatch() && this.copyBatchThreads == that.getCopyBatchThreads() && this.maxHttpRequestRetries == that.getMaxHttpRequestRetries() && this.httpRequestConnectTimeout == that.getHttpRequestConnectTimeout() && this.httpRequestReadTimeout == that.getHttpRequestReadTimeout() && this.transportType.equals((Object)that.getTransportType()) && (this.proxyAddress == null ? that.getProxyAddress() == null : this.proxyAddress.equals(that.getProxyAddress())) && this.copyWithRewriteEnabled == that.isCopyWithRewriteEnabled() && this.maxBytesRewrittenPerCall == that.getMaxBytesRewrittenPerCall() && this.readChannelOptions.equals(that.getReadChannelOptions()) && this.writeChannelOptions.equals(that.getWriteChannelOptions()) && this.requesterPaysOptions.equals(that.getRequesterPaysOptions());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h$ *= 1000003;
        h$ ^= this.appName == null ? 0 : this.appName.hashCode();
        h$ *= 1000003;
        h$ ^= this.autoRepairImplicitDirectoriesEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.inferImplicitDirectoriesEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.markerFileCreationEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.maxWaitMillisForEmptyObjectCreation;
        h$ *= 1000003;
        h$ ^= (int)(this.maxListItemsPerCall >>> 32 ^ this.maxListItemsPerCall);
        h$ *= 1000003;
        h$ ^= (int)(this.maxRequestsPerBatch >>> 32 ^ this.maxRequestsPerBatch);
        h$ *= 1000003;
        h$ ^= this.batchThreads;
        h$ *= 1000003;
        h$ ^= (int)(this.copyMaxRequestsPerBatch >>> 32 ^ this.copyMaxRequestsPerBatch);
        h$ *= 1000003;
        h$ ^= this.copyBatchThreads;
        h$ *= 1000003;
        h$ ^= this.maxHttpRequestRetries;
        h$ *= 1000003;
        h$ ^= this.httpRequestConnectTimeout;
        h$ *= 1000003;
        h$ ^= this.httpRequestReadTimeout;
        h$ *= 1000003;
        h$ ^= this.transportType.hashCode();
        h$ *= 1000003;
        h$ ^= this.proxyAddress == null ? 0 : this.proxyAddress.hashCode();
        h$ *= 1000003;
        h$ ^= this.copyWithRewriteEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.maxBytesRewrittenPerCall >>> 32 ^ this.maxBytesRewrittenPerCall);
        h$ *= 1000003;
        h$ ^= this.readChannelOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeChannelOptions.hashCode();
        h$ *= 1000003;
        return h$ ^= this.requesterPaysOptions.hashCode();
    }

    @Override
    public GoogleCloudStorageOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends GoogleCloudStorageOptions.Builder {
        private String projectId;
        private String appName;
        private Boolean autoRepairImplicitDirectoriesEnabled;
        private Boolean inferImplicitDirectoriesEnabled;
        private Boolean markerFileCreationEnabled;
        private Integer maxWaitMillisForEmptyObjectCreation;
        private Long maxListItemsPerCall;
        private Long maxRequestsPerBatch;
        private Integer batchThreads;
        private Long copyMaxRequestsPerBatch;
        private Integer copyBatchThreads;
        private Integer maxHttpRequestRetries;
        private Integer httpRequestConnectTimeout;
        private Integer httpRequestReadTimeout;
        private HttpTransportFactory.HttpTransportType transportType;
        private String proxyAddress;
        private Boolean copyWithRewriteEnabled;
        private Long maxBytesRewrittenPerCall;
        private GoogleCloudStorageReadOptions readChannelOptions;
        private AsyncWriteChannelOptions writeChannelOptions;
        private RequesterPaysOptions requesterPaysOptions;

        Builder() {
        }

        private Builder(GoogleCloudStorageOptions source) {
            this.projectId = source.getProjectId();
            this.appName = source.getAppName();
            this.autoRepairImplicitDirectoriesEnabled = source.isAutoRepairImplicitDirectoriesEnabled();
            this.inferImplicitDirectoriesEnabled = source.isInferImplicitDirectoriesEnabled();
            this.markerFileCreationEnabled = source.isMarkerFileCreationEnabled();
            this.maxWaitMillisForEmptyObjectCreation = source.getMaxWaitMillisForEmptyObjectCreation();
            this.maxListItemsPerCall = source.getMaxListItemsPerCall();
            this.maxRequestsPerBatch = source.getMaxRequestsPerBatch();
            this.batchThreads = source.getBatchThreads();
            this.copyMaxRequestsPerBatch = source.getCopyMaxRequestsPerBatch();
            this.copyBatchThreads = source.getCopyBatchThreads();
            this.maxHttpRequestRetries = source.getMaxHttpRequestRetries();
            this.httpRequestConnectTimeout = source.getHttpRequestConnectTimeout();
            this.httpRequestReadTimeout = source.getHttpRequestReadTimeout();
            this.transportType = source.getTransportType();
            this.proxyAddress = source.getProxyAddress();
            this.copyWithRewriteEnabled = source.isCopyWithRewriteEnabled();
            this.maxBytesRewrittenPerCall = source.getMaxBytesRewrittenPerCall();
            this.readChannelOptions = source.getReadChannelOptions();
            this.writeChannelOptions = source.getWriteChannelOptions();
            this.requesterPaysOptions = source.getRequesterPaysOptions();
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setAppName(String appName) {
            this.appName = appName;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
            this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setInferImplicitDirectoriesEnabled(boolean inferImplicitDirectoriesEnabled) {
            this.inferImplicitDirectoriesEnabled = inferImplicitDirectoriesEnabled;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMarkerFileCreationEnabled(boolean markerFileCreationEnabled) {
            this.markerFileCreationEnabled = markerFileCreationEnabled;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxWaitMillisForEmptyObjectCreation(int maxWaitMillisForEmptyObjectCreation) {
            this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxListItemsPerCall(long maxListItemsPerCall) {
            this.maxListItemsPerCall = maxListItemsPerCall;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxRequestsPerBatch(long maxRequestsPerBatch) {
            this.maxRequestsPerBatch = maxRequestsPerBatch;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setBatchThreads(int batchThreads) {
            this.batchThreads = batchThreads;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setCopyMaxRequestsPerBatch(long copyMaxRequestsPerBatch) {
            this.copyMaxRequestsPerBatch = copyMaxRequestsPerBatch;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setCopyBatchThreads(int copyBatchThreads) {
            this.copyBatchThreads = copyBatchThreads;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxHttpRequestRetries(int maxHttpRequestRetries) {
            this.maxHttpRequestRetries = maxHttpRequestRetries;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHttpRequestConnectTimeout(int httpRequestConnectTimeout) {
            this.httpRequestConnectTimeout = httpRequestConnectTimeout;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setHttpRequestReadTimeout(int httpRequestReadTimeout) {
            this.httpRequestReadTimeout = httpRequestReadTimeout;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setTransportType(HttpTransportFactory.HttpTransportType transportType) {
            if (transportType == null) {
                throw new NullPointerException("Null transportType");
            }
            this.transportType = transportType;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setProxyAddress(String proxyAddress) {
            this.proxyAddress = proxyAddress;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setCopyWithRewriteEnabled(boolean copyWithRewriteEnabled) {
            this.copyWithRewriteEnabled = copyWithRewriteEnabled;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setMaxBytesRewrittenPerCall(long maxBytesRewrittenPerCall) {
            this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setReadChannelOptions(GoogleCloudStorageReadOptions readChannelOptions) {
            if (readChannelOptions == null) {
                throw new NullPointerException("Null readChannelOptions");
            }
            this.readChannelOptions = readChannelOptions;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setWriteChannelOptions(AsyncWriteChannelOptions writeChannelOptions) {
            if (writeChannelOptions == null) {
                throw new NullPointerException("Null writeChannelOptions");
            }
            this.writeChannelOptions = writeChannelOptions;
            return this;
        }

        @Override
        public GoogleCloudStorageOptions.Builder setRequesterPaysOptions(RequesterPaysOptions requesterPaysOptions) {
            if (requesterPaysOptions == null) {
                throw new NullPointerException("Null requesterPaysOptions");
            }
            this.requesterPaysOptions = requesterPaysOptions;
            return this;
        }

        @Override
        GoogleCloudStorageOptions autoBuild() {
            String missing = "";
            if (this.autoRepairImplicitDirectoriesEnabled == null) {
                missing = missing + " autoRepairImplicitDirectoriesEnabled";
            }
            if (this.inferImplicitDirectoriesEnabled == null) {
                missing = missing + " inferImplicitDirectoriesEnabled";
            }
            if (this.markerFileCreationEnabled == null) {
                missing = missing + " markerFileCreationEnabled";
            }
            if (this.maxWaitMillisForEmptyObjectCreation == null) {
                missing = missing + " maxWaitMillisForEmptyObjectCreation";
            }
            if (this.maxListItemsPerCall == null) {
                missing = missing + " maxListItemsPerCall";
            }
            if (this.maxRequestsPerBatch == null) {
                missing = missing + " maxRequestsPerBatch";
            }
            if (this.batchThreads == null) {
                missing = missing + " batchThreads";
            }
            if (this.copyMaxRequestsPerBatch == null) {
                missing = missing + " copyMaxRequestsPerBatch";
            }
            if (this.copyBatchThreads == null) {
                missing = missing + " copyBatchThreads";
            }
            if (this.maxHttpRequestRetries == null) {
                missing = missing + " maxHttpRequestRetries";
            }
            if (this.httpRequestConnectTimeout == null) {
                missing = missing + " httpRequestConnectTimeout";
            }
            if (this.httpRequestReadTimeout == null) {
                missing = missing + " httpRequestReadTimeout";
            }
            if (this.transportType == null) {
                missing = missing + " transportType";
            }
            if (this.copyWithRewriteEnabled == null) {
                missing = missing + " copyWithRewriteEnabled";
            }
            if (this.maxBytesRewrittenPerCall == null) {
                missing = missing + " maxBytesRewrittenPerCall";
            }
            if (this.readChannelOptions == null) {
                missing = missing + " readChannelOptions";
            }
            if (this.writeChannelOptions == null) {
                missing = missing + " writeChannelOptions";
            }
            if (this.requesterPaysOptions == null) {
                missing = missing + " requesterPaysOptions";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GoogleCloudStorageOptions(this.projectId, this.appName, this.autoRepairImplicitDirectoriesEnabled, this.inferImplicitDirectoriesEnabled, this.markerFileCreationEnabled, this.maxWaitMillisForEmptyObjectCreation, this.maxListItemsPerCall, this.maxRequestsPerBatch, this.batchThreads, this.copyMaxRequestsPerBatch, this.copyBatchThreads, this.maxHttpRequestRetries, this.httpRequestConnectTimeout, this.httpRequestReadTimeout, this.transportType, this.proxyAddress, this.copyWithRewriteEnabled, this.maxBytesRewrittenPerCall, this.readChannelOptions, this.writeChannelOptions, this.requesterPaysOptions);
        }
    }
}

