/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public class ForwardingGoogleCloudStorage
implements GoogleCloudStorage {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final GoogleCloudStorage delegate;
    private final String delegateClassName;

    public ForwardingGoogleCloudStorage(GoogleCloudStorage delegate) {
        Preconditions.checkArgument((delegate != null ? 1 : 0) != 0, (Object)"delegate must not be null.");
        this.delegate = delegate;
        this.delegateClassName = delegate.getClass().getSimpleName();
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        ((GoogleLogger.Api)logger.atFine()).log("%s.getOptions()", (Object)this.delegateClassName);
        return this.delegate.getOptions();
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.create(%s)", (Object)this.delegateClassName, (Object)resourceId);
        return this.delegate.create(resourceId);
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.create(%s, %s)", (Object)this.delegateClassName, (Object)resourceId, (Object)options);
        return this.delegate.create(resourceId, options);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.createEmptyObject(%s)", (Object)this.delegateClassName, (Object)resourceId);
        this.delegate.createEmptyObject(resourceId);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.createEmptyObject(%s, %s)", (Object)this.delegateClassName, (Object)resourceId, (Object)options);
        this.delegate.createEmptyObject(resourceId, options);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.createEmptyObjects(%s)", (Object)this.delegateClassName, resourceIds);
        this.delegate.createEmptyObjects(resourceIds);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.createEmptyObjects(%s, %s)", (Object)this.delegateClassName, resourceIds, (Object)options);
        this.delegate.createEmptyObjects(resourceIds, options);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.open(%s)", (Object)this.delegateClassName, (Object)resourceId);
        return this.delegate.open(resourceId);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.open(%s, %s)", (Object)this.delegateClassName, (Object)resourceId, (Object)readOptions);
        return this.delegate.open(resourceId, readOptions);
    }

    @Override
    public void create(String bucketName) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.create(%s)", (Object)this.delegateClassName, (Object)bucketName);
        this.delegate.create(bucketName);
    }

    @Override
    public void create(String bucketName, CreateBucketOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.create(%s, %s)", (Object)this.delegateClassName, (Object)bucketName, (Object)options);
        this.delegate.create(bucketName, options);
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.deleteBuckets(%s)", (Object)this.delegateClassName, bucketNames);
        this.delegate.deleteBuckets(bucketNames);
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.deleteObjects(%s)", (Object)this.delegateClassName, fullObjectNames);
        this.delegate.deleteObjects(fullObjectNames);
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.copy(%s, %s, %s, %s)", (Object)this.delegateClassName, (Object)srcBucketName, srcObjectNames, (Object)dstBucketName, dstObjectNames);
        this.delegate.copy(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames);
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.listBucketNames()", (Object)this.delegateClassName);
        return this.delegate.listBucketNames();
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.listBucketInfo()", (Object)this.delegateClassName);
        return this.delegate.listBucketInfo();
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.listObjectNames(%s, %s, %s)", (Object)this.delegateClassName, (Object)bucketName, (Object)objectNamePrefix, (Object)delimiter);
        return this.delegate.listObjectNames(bucketName, objectNamePrefix, delimiter);
    }

    @Override
    public List<String> listObjectNames(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.listObjectNames(%s, %s, %s, %s)", (Object)this.delegateClassName, (Object)bucketName, (Object)objectNamePrefix, (Object)delimiter, (Object)maxResults);
        return this.delegate.listObjectNames(bucketName, objectNamePrefix, delimiter, maxResults);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.listObjectInfo(%s, %s, %s)", (Object)this.delegateClassName, (Object)bucketName, (Object)objectNamePrefix, (Object)delimiter);
        return this.delegate.listObjectInfo(bucketName, objectNamePrefix, delimiter);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, String delimiter, long maxResults) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.listObjectInfo(%s, %s, %s, %s)", (Object)this.delegateClassName, (Object)bucketName, (Object)objectNamePrefix, (Object)delimiter, (Object)maxResults);
        return this.delegate.listObjectInfo(bucketName, objectNamePrefix, delimiter, maxResults);
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.getItemInfo(%s)", (Object)this.delegateClassName, (Object)resourceId);
        return this.delegate.getItemInfo(resourceId);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.getItemInfos(%s)", (Object)this.delegateClassName, resourceIds);
        return this.delegate.getItemInfos(resourceIds);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.updateItems(%s)", (Object)this.delegateClassName, itemInfoList);
        return this.delegate.updateItems(itemInfoList);
    }

    @Override
    public void close() {
        ((GoogleLogger.Api)logger.atFine()).log("%s.close()", (Object)this.delegateClassName);
        this.delegate.close();
    }

    @Override
    public void waitForBucketEmpty(String bucketName) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.waitForBucketEmpty(%s)", (Object)this.delegateClassName, (Object)bucketName);
        this.delegate.waitForBucketEmpty(bucketName);
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.compose(%s, %s, %s, %s)", (Object)this.delegateClassName, (Object)bucketName, sources, (Object)destination, (Object)contentType);
        this.delegate.compose(bucketName, sources, destination, contentType);
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("%s.composeObjects(%s, %s, %s)", (Object)this.delegateClassName, sources, (Object)destination, (Object)options);
        return this.delegate.composeObjects(sources, destination, options);
    }

    protected GoogleCloudStorage getDelegate() {
        return this.delegate;
    }
}

