

package com.google.cloud.hadoop.gcsio;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageReadOptions extends GoogleCloudStorageReadOptions {

  private final int backoffInitialIntervalMillis;

  private final double backoffRandomizationFactor;

  private final double backoffMultiplier;

  private final int backoffMaxIntervalMillis;

  private final int backoffMaxElapsedTimeMillis;

  private final boolean fastFailOnNotFound;

  private final boolean supportGzipEncoding;

  private final int bufferSize;

  private final long inplaceSeekLimit;

  private final GoogleCloudStorageReadOptions.Fadvise fadvise;

  private final int minRangeRequestSize;

  private final GoogleCloudStorageReadOptions.GenerationReadConsistency generationReadConsistency;

  private AutoValue_GoogleCloudStorageReadOptions(
      int backoffInitialIntervalMillis,
      double backoffRandomizationFactor,
      double backoffMultiplier,
      int backoffMaxIntervalMillis,
      int backoffMaxElapsedTimeMillis,
      boolean fastFailOnNotFound,
      boolean supportGzipEncoding,
      int bufferSize,
      long inplaceSeekLimit,
      GoogleCloudStorageReadOptions.Fadvise fadvise,
      int minRangeRequestSize,
      GoogleCloudStorageReadOptions.GenerationReadConsistency generationReadConsistency) {
    this.backoffInitialIntervalMillis = backoffInitialIntervalMillis;
    this.backoffRandomizationFactor = backoffRandomizationFactor;
    this.backoffMultiplier = backoffMultiplier;
    this.backoffMaxIntervalMillis = backoffMaxIntervalMillis;
    this.backoffMaxElapsedTimeMillis = backoffMaxElapsedTimeMillis;
    this.fastFailOnNotFound = fastFailOnNotFound;
    this.supportGzipEncoding = supportGzipEncoding;
    this.bufferSize = bufferSize;
    this.inplaceSeekLimit = inplaceSeekLimit;
    this.fadvise = fadvise;
    this.minRangeRequestSize = minRangeRequestSize;
    this.generationReadConsistency = generationReadConsistency;
  }

  @Override
  public int getBackoffInitialIntervalMillis() {
    return backoffInitialIntervalMillis;
  }

  @Override
  public double getBackoffRandomizationFactor() {
    return backoffRandomizationFactor;
  }

  @Override
  public double getBackoffMultiplier() {
    return backoffMultiplier;
  }

  @Override
  public int getBackoffMaxIntervalMillis() {
    return backoffMaxIntervalMillis;
  }

  @Override
  public int getBackoffMaxElapsedTimeMillis() {
    return backoffMaxElapsedTimeMillis;
  }

  @Override
  public boolean getFastFailOnNotFound() {
    return fastFailOnNotFound;
  }

  @Override
  public boolean getSupportGzipEncoding() {
    return supportGzipEncoding;
  }

  @Override
  public int getBufferSize() {
    return bufferSize;
  }

  @Override
  public long getInplaceSeekLimit() {
    return inplaceSeekLimit;
  }

  @Override
  public GoogleCloudStorageReadOptions.Fadvise getFadvise() {
    return fadvise;
  }

  @Override
  public int getMinRangeRequestSize() {
    return minRangeRequestSize;
  }

  @Override
  public GoogleCloudStorageReadOptions.GenerationReadConsistency getGenerationReadConsistency() {
    return generationReadConsistency;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageReadOptions{"
         + "backoffInitialIntervalMillis=" + backoffInitialIntervalMillis + ", "
         + "backoffRandomizationFactor=" + backoffRandomizationFactor + ", "
         + "backoffMultiplier=" + backoffMultiplier + ", "
         + "backoffMaxIntervalMillis=" + backoffMaxIntervalMillis + ", "
         + "backoffMaxElapsedTimeMillis=" + backoffMaxElapsedTimeMillis + ", "
         + "fastFailOnNotFound=" + fastFailOnNotFound + ", "
         + "supportGzipEncoding=" + supportGzipEncoding + ", "
         + "bufferSize=" + bufferSize + ", "
         + "inplaceSeekLimit=" + inplaceSeekLimit + ", "
         + "fadvise=" + fadvise + ", "
         + "minRangeRequestSize=" + minRangeRequestSize + ", "
         + "generationReadConsistency=" + generationReadConsistency
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageReadOptions) {
      GoogleCloudStorageReadOptions that = (GoogleCloudStorageReadOptions) o;
      return this.backoffInitialIntervalMillis == that.getBackoffInitialIntervalMillis()
          && Double.doubleToLongBits(this.backoffRandomizationFactor) == Double.doubleToLongBits(that.getBackoffRandomizationFactor())
          && Double.doubleToLongBits(this.backoffMultiplier) == Double.doubleToLongBits(that.getBackoffMultiplier())
          && this.backoffMaxIntervalMillis == that.getBackoffMaxIntervalMillis()
          && this.backoffMaxElapsedTimeMillis == that.getBackoffMaxElapsedTimeMillis()
          && this.fastFailOnNotFound == that.getFastFailOnNotFound()
          && this.supportGzipEncoding == that.getSupportGzipEncoding()
          && this.bufferSize == that.getBufferSize()
          && this.inplaceSeekLimit == that.getInplaceSeekLimit()
          && this.fadvise.equals(that.getFadvise())
          && this.minRangeRequestSize == that.getMinRangeRequestSize()
          && this.generationReadConsistency.equals(that.getGenerationReadConsistency());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= backoffInitialIntervalMillis;
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(backoffRandomizationFactor) >>> 32) ^ Double.doubleToLongBits(backoffRandomizationFactor));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(backoffMultiplier) >>> 32) ^ Double.doubleToLongBits(backoffMultiplier));
    h$ *= 1000003;
    h$ ^= backoffMaxIntervalMillis;
    h$ *= 1000003;
    h$ ^= backoffMaxElapsedTimeMillis;
    h$ *= 1000003;
    h$ ^= fastFailOnNotFound ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= supportGzipEncoding ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= bufferSize;
    h$ *= 1000003;
    h$ ^= (int) ((inplaceSeekLimit >>> 32) ^ inplaceSeekLimit);
    h$ *= 1000003;
    h$ ^= fadvise.hashCode();
    h$ *= 1000003;
    h$ ^= minRangeRequestSize;
    h$ *= 1000003;
    h$ ^= generationReadConsistency.hashCode();
    return h$;
  }

  @Override
  public GoogleCloudStorageReadOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageReadOptions.Builder {
    private Integer backoffInitialIntervalMillis;
    private Double backoffRandomizationFactor;
    private Double backoffMultiplier;
    private Integer backoffMaxIntervalMillis;
    private Integer backoffMaxElapsedTimeMillis;
    private Boolean fastFailOnNotFound;
    private Boolean supportGzipEncoding;
    private Integer bufferSize;
    private Long inplaceSeekLimit;
    private GoogleCloudStorageReadOptions.Fadvise fadvise;
    private Integer minRangeRequestSize;
    private GoogleCloudStorageReadOptions.GenerationReadConsistency generationReadConsistency;
    Builder() {
    }
    private Builder(GoogleCloudStorageReadOptions source) {
      this.backoffInitialIntervalMillis = source.getBackoffInitialIntervalMillis();
      this.backoffRandomizationFactor = source.getBackoffRandomizationFactor();
      this.backoffMultiplier = source.getBackoffMultiplier();
      this.backoffMaxIntervalMillis = source.getBackoffMaxIntervalMillis();
      this.backoffMaxElapsedTimeMillis = source.getBackoffMaxElapsedTimeMillis();
      this.fastFailOnNotFound = source.getFastFailOnNotFound();
      this.supportGzipEncoding = source.getSupportGzipEncoding();
      this.bufferSize = source.getBufferSize();
      this.inplaceSeekLimit = source.getInplaceSeekLimit();
      this.fadvise = source.getFadvise();
      this.minRangeRequestSize = source.getMinRangeRequestSize();
      this.generationReadConsistency = source.getGenerationReadConsistency();
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffInitialIntervalMillis(int backoffInitialIntervalMillis) {
      this.backoffInitialIntervalMillis = backoffInitialIntervalMillis;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffRandomizationFactor(double backoffRandomizationFactor) {
      this.backoffRandomizationFactor = backoffRandomizationFactor;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffMultiplier(double backoffMultiplier) {
      this.backoffMultiplier = backoffMultiplier;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffMaxIntervalMillis(int backoffMaxIntervalMillis) {
      this.backoffMaxIntervalMillis = backoffMaxIntervalMillis;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffMaxElapsedTimeMillis(int backoffMaxElapsedTimeMillis) {
      this.backoffMaxElapsedTimeMillis = backoffMaxElapsedTimeMillis;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setFastFailOnNotFound(boolean fastFailOnNotFound) {
      this.fastFailOnNotFound = fastFailOnNotFound;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setSupportGzipEncoding(boolean supportGzipEncoding) {
      this.supportGzipEncoding = supportGzipEncoding;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBufferSize(int bufferSize) {
      this.bufferSize = bufferSize;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setInplaceSeekLimit(long inplaceSeekLimit) {
      this.inplaceSeekLimit = inplaceSeekLimit;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setFadvise(GoogleCloudStorageReadOptions.Fadvise fadvise) {
      if (fadvise == null) {
        throw new NullPointerException("Null fadvise");
      }
      this.fadvise = fadvise;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setMinRangeRequestSize(int minRangeRequestSize) {
      this.minRangeRequestSize = minRangeRequestSize;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGenerationReadConsistency(GoogleCloudStorageReadOptions.GenerationReadConsistency generationReadConsistency) {
      if (generationReadConsistency == null) {
        throw new NullPointerException("Null generationReadConsistency");
      }
      this.generationReadConsistency = generationReadConsistency;
      return this;
    }
    @Override
    GoogleCloudStorageReadOptions autoBuild() {
      String missing = "";
      if (this.backoffInitialIntervalMillis == null) {
        missing += " backoffInitialIntervalMillis";
      }
      if (this.backoffRandomizationFactor == null) {
        missing += " backoffRandomizationFactor";
      }
      if (this.backoffMultiplier == null) {
        missing += " backoffMultiplier";
      }
      if (this.backoffMaxIntervalMillis == null) {
        missing += " backoffMaxIntervalMillis";
      }
      if (this.backoffMaxElapsedTimeMillis == null) {
        missing += " backoffMaxElapsedTimeMillis";
      }
      if (this.fastFailOnNotFound == null) {
        missing += " fastFailOnNotFound";
      }
      if (this.supportGzipEncoding == null) {
        missing += " supportGzipEncoding";
      }
      if (this.bufferSize == null) {
        missing += " bufferSize";
      }
      if (this.inplaceSeekLimit == null) {
        missing += " inplaceSeekLimit";
      }
      if (this.fadvise == null) {
        missing += " fadvise";
      }
      if (this.minRangeRequestSize == null) {
        missing += " minRangeRequestSize";
      }
      if (this.generationReadConsistency == null) {
        missing += " generationReadConsistency";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageReadOptions(
          this.backoffInitialIntervalMillis,
          this.backoffRandomizationFactor,
          this.backoffMultiplier,
          this.backoffMaxIntervalMillis,
          this.backoffMaxElapsedTimeMillis,
          this.fastFailOnNotFound,
          this.supportGzipEncoding,
          this.bufferSize,
          this.inplaceSeekLimit,
          this.fadvise,
          this.minRangeRequestSize,
          this.generationReadConsistency);
    }
  }

}
