

package com.google.cloud.hadoop.gcsio.testing;

import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GcsItemInfoTestBuilder extends GcsItemInfoTestBuilder {

  private final StorageResourceId storageResourceId;

  private final long creationTime;

  private final long modificationTime;

  private final long size;

  private final String location;

  private final String storageClass;

  private final String contentType;

  private final String contentEncoding;

  private final ImmutableMap<String, byte[]> metadata;

  private final long contentGeneration;

  private final long metaGeneration;

  private final VerificationAttributes verificationAttributes;

  private AutoValue_GcsItemInfoTestBuilder(
      StorageResourceId storageResourceId,
      long creationTime,
      long modificationTime,
      long size,
      @Nullable String location,
      @Nullable String storageClass,
      @Nullable String contentType,
      @Nullable String contentEncoding,
      ImmutableMap<String, byte[]> metadata,
      long contentGeneration,
      long metaGeneration,
      VerificationAttributes verificationAttributes) {
    this.storageResourceId = storageResourceId;
    this.creationTime = creationTime;
    this.modificationTime = modificationTime;
    this.size = size;
    this.location = location;
    this.storageClass = storageClass;
    this.contentType = contentType;
    this.contentEncoding = contentEncoding;
    this.metadata = metadata;
    this.contentGeneration = contentGeneration;
    this.metaGeneration = metaGeneration;
    this.verificationAttributes = verificationAttributes;
  }

  @Override
  public StorageResourceId getStorageResourceId() {
    return storageResourceId;
  }

  @Override
  public long getCreationTime() {
    return creationTime;
  }

  @Override
  public long getModificationTime() {
    return modificationTime;
  }

  @Override
  public long getSize() {
    return size;
  }

  @Nullable
  @Override
  public String getLocation() {
    return location;
  }

  @Nullable
  @Override
  public String getStorageClass() {
    return storageClass;
  }

  @Nullable
  @Override
  public String getContentType() {
    return contentType;
  }

  @Nullable
  @Override
  public String getContentEncoding() {
    return contentEncoding;
  }

  @Override
  public ImmutableMap<String, byte[]> getMetadata() {
    return metadata;
  }

  @Override
  public long getContentGeneration() {
    return contentGeneration;
  }

  @Override
  public long getMetaGeneration() {
    return metaGeneration;
  }

  @Override
  public VerificationAttributes getVerificationAttributes() {
    return verificationAttributes;
  }

  @Override
  public String toString() {
    return "GcsItemInfoTestBuilder{"
         + "storageResourceId=" + storageResourceId + ", "
         + "creationTime=" + creationTime + ", "
         + "modificationTime=" + modificationTime + ", "
         + "size=" + size + ", "
         + "location=" + location + ", "
         + "storageClass=" + storageClass + ", "
         + "contentType=" + contentType + ", "
         + "contentEncoding=" + contentEncoding + ", "
         + "metadata=" + metadata + ", "
         + "contentGeneration=" + contentGeneration + ", "
         + "metaGeneration=" + metaGeneration + ", "
         + "verificationAttributes=" + verificationAttributes
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GcsItemInfoTestBuilder) {
      GcsItemInfoTestBuilder that = (GcsItemInfoTestBuilder) o;
      return this.storageResourceId.equals(that.getStorageResourceId())
          && this.creationTime == that.getCreationTime()
          && this.modificationTime == that.getModificationTime()
          && this.size == that.getSize()
          && (this.location == null ? that.getLocation() == null : this.location.equals(that.getLocation()))
          && (this.storageClass == null ? that.getStorageClass() == null : this.storageClass.equals(that.getStorageClass()))
          && (this.contentType == null ? that.getContentType() == null : this.contentType.equals(that.getContentType()))
          && (this.contentEncoding == null ? that.getContentEncoding() == null : this.contentEncoding.equals(that.getContentEncoding()))
          && this.metadata.equals(that.getMetadata())
          && this.contentGeneration == that.getContentGeneration()
          && this.metaGeneration == that.getMetaGeneration()
          && this.verificationAttributes.equals(that.getVerificationAttributes());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= storageResourceId.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((creationTime >>> 32) ^ creationTime);
    h$ *= 1000003;
    h$ ^= (int) ((modificationTime >>> 32) ^ modificationTime);
    h$ *= 1000003;
    h$ ^= (int) ((size >>> 32) ^ size);
    h$ *= 1000003;
    h$ ^= (location == null) ? 0 : location.hashCode();
    h$ *= 1000003;
    h$ ^= (storageClass == null) ? 0 : storageClass.hashCode();
    h$ *= 1000003;
    h$ ^= (contentType == null) ? 0 : contentType.hashCode();
    h$ *= 1000003;
    h$ ^= (contentEncoding == null) ? 0 : contentEncoding.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((contentGeneration >>> 32) ^ contentGeneration);
    h$ *= 1000003;
    h$ ^= (int) ((metaGeneration >>> 32) ^ metaGeneration);
    h$ *= 1000003;
    h$ ^= verificationAttributes.hashCode();
    return h$;
  }

  static final class Builder extends GcsItemInfoTestBuilder.Builder {
    private StorageResourceId storageResourceId;
    private Long creationTime;
    private Long modificationTime;
    private Long size;
    private String location;
    private String storageClass;
    private String contentType;
    private String contentEncoding;
    private ImmutableMap<String, byte[]> metadata;
    private Long contentGeneration;
    private Long metaGeneration;
    private VerificationAttributes verificationAttributes;
    Builder() {
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setStorageResourceId(StorageResourceId storageResourceId) {
      if (storageResourceId == null) {
        throw new NullPointerException("Null storageResourceId");
      }
      this.storageResourceId = storageResourceId;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setCreationTime(long creationTime) {
      this.creationTime = creationTime;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setModificationTime(long modificationTime) {
      this.modificationTime = modificationTime;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setSize(long size) {
      this.size = size;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setLocation(String location) {
      this.location = location;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setStorageClass(String storageClass) {
      this.storageClass = storageClass;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setContentType(String contentType) {
      this.contentType = contentType;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setContentEncoding(String contentEncoding) {
      this.contentEncoding = contentEncoding;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setMetadata(Map<String, byte[]> metadata) {
      this.metadata = ImmutableMap.copyOf(metadata);
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setContentGeneration(long contentGeneration) {
      this.contentGeneration = contentGeneration;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setMetaGeneration(long metaGeneration) {
      this.metaGeneration = metaGeneration;
      return this;
    }
    @Override
    public GcsItemInfoTestBuilder.Builder setVerificationAttributes(VerificationAttributes verificationAttributes) {
      if (verificationAttributes == null) {
        throw new NullPointerException("Null verificationAttributes");
      }
      this.verificationAttributes = verificationAttributes;
      return this;
    }
    @Override
    GcsItemInfoTestBuilder autoBuild() {
      String missing = "";
      if (this.storageResourceId == null) {
        missing += " storageResourceId";
      }
      if (this.creationTime == null) {
        missing += " creationTime";
      }
      if (this.modificationTime == null) {
        missing += " modificationTime";
      }
      if (this.size == null) {
        missing += " size";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.contentGeneration == null) {
        missing += " contentGeneration";
      }
      if (this.metaGeneration == null) {
        missing += " metaGeneration";
      }
      if (this.verificationAttributes == null) {
        missing += " verificationAttributes";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GcsItemInfoTestBuilder(
          this.storageResourceId,
          this.creationTime,
          this.modificationTime,
          this.size,
          this.location,
          this.storageClass,
          this.contentType,
          this.contentEncoding,
          this.metadata,
          this.contentGeneration,
          this.metaGeneration,
          this.verificationAttributes);
    }
  }

}
