/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.cooplock;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.cooplock.AutoValue_CooperativeLockingOptions;
import com.google.common.base.Preconditions;
import java.time.Duration;

@AutoValue
public abstract class CooperativeLockingOptions {
    public static final long LOCK_EXPIRATION_TIMEOUT_MS_DEFAULT = Duration.ofMinutes(2L).toMillis();
    public static final int MAX_CONCURRENT_OPERATIONS_DEFAULT = 20;
    public static final CooperativeLockingOptions DEFAULT = CooperativeLockingOptions.builder().build();
    private static final long MIN_LOCK_EXPIRATION_TIMEOUT_MS = Duration.ofSeconds(30L).toMillis();

    public static Builder builder() {
        return new AutoValue_CooperativeLockingOptions.Builder().setLockExpirationTimeoutMilli(LOCK_EXPIRATION_TIMEOUT_MS_DEFAULT).setMaxConcurrentOperations(20);
    }

    public abstract long getLockExpirationTimeoutMilli();

    public abstract int getMaxConcurrentOperations();

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setLockExpirationTimeoutMilli(long var1);

        public abstract Builder setMaxConcurrentOperations(int var1);

        abstract CooperativeLockingOptions autoBuild();

        public CooperativeLockingOptions build() {
            CooperativeLockingOptions options = this.autoBuild();
            Preconditions.checkArgument((options.getLockExpirationTimeoutMilli() >= MIN_LOCK_EXPIRATION_TIMEOUT_MS ? 1 : 0) != 0, (String)"lockExpirationTimeoutMs should be greater or equal to %s ms, but was %s", (long)MIN_LOCK_EXPIRATION_TIMEOUT_MS, (long)options.getLockExpirationTimeoutMilli());
            Preconditions.checkArgument((options.getMaxConcurrentOperations() > 0 ? 1 : 0) != 0, (String)"maxConcurrentOperations should be greater than 0, but was %s", (int)options.getMaxConcurrentOperations());
            return options;
        }
    }
}

