/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.BaseAbstractGoogleAsyncWriteChannel;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.google.storage.v1.ChecksummedData;
import com.google.google.storage.v1.InsertObjectRequest;
import com.google.google.storage.v1.InsertObjectSpec;
import com.google.google.storage.v1.ObjectChecksums;
import com.google.google.storage.v1.QueryWriteStatusRequest;
import com.google.google.storage.v1.QueryWriteStatusResponse;
import com.google.google.storage.v1.ServiceConstants;
import com.google.google.storage.v1.StartResumableWriteRequest;
import com.google.google.storage.v1.StartResumableWriteResponse;
import com.google.google.storage.v1.StorageGrpc;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.util.Timestamps;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public final class GoogleCloudStorageGrpcWriteChannel
extends BaseAbstractGoogleAsyncWriteChannel<com.google.google.storage.v1.Object>
implements GoogleCloudStorageItemInfo.Provider {
    static final int GCS_MINIMUM_CHUNK_SIZE = 262144;
    private static final Duration START_RESUMABLE_WRITE_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration QUERY_WRITE_STATUS_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration WRITE_STREAM_TIMEOUT = Duration.ofMinutes(10L);
    private static final int UPLOAD_RETRIES = 5;
    private static int NUMBER_OF_REQUESTS_TO_RETAIN = 5;
    private static final ImmutableSet<Status.Code> TRANSIENT_ERRORS = ImmutableSet.of((Object)Status.Code.DEADLINE_EXCEEDED, (Object)Status.Code.RESOURCE_EXHAUSTED, (Object)Status.Code.INTERNAL, (Object)Status.Code.UNAVAILABLE);
    private final StorageGrpc.StorageStub stub;
    private final StorageResourceId resourceId;
    private final ObjectWriteConditions writeConditions;
    private final Optional<String> requesterPaysProject;
    private final ImmutableMap<String, String> metadata;
    private final boolean checksumsEnabled;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    GoogleCloudStorageGrpcWriteChannel(ExecutorService threadPool, StorageGrpc.StorageStub stub, StorageResourceId resourceId, AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, Optional<String> requesterPaysProject, Map<String, String> metadata, String contentType) {
        super(threadPool, options);
        this.stub = stub;
        this.resourceId = resourceId;
        this.writeConditions = writeConditions;
        this.requesterPaysProject = requesterPaysProject;
        this.metadata = ImmutableMap.copyOf(metadata);
        this.contentType = contentType;
        this.checksumsEnabled = options.isGrpcChecksumsEnabled();
    }

    protected String getResourceString() {
        return this.resourceId.toString();
    }

    public void setDirectUploadEnabled(boolean enableDirectUpload) {
    }

    public void setUploadChunkSize(int chunkSize) {
        Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (Object)"Upload chunk size must be greater than 0.");
    }

    public void handleResponse(com.google.google.storage.v1.Object response) {
        Preconditions.checkArgument((!response.getBucket().isEmpty() ? 1 : 0) != 0, (String)"Got response from service with empty/missing bucketName: %s", (Object)response);
        Map<String, byte[]> metadata = response.getMetadataMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> BaseEncoding.base64().decode((CharSequence)entry.getValue())));
        byte[] md5Hash = response.getMd5Hash().length() > 0 ? BaseEncoding.base64().decode((CharSequence)response.getMd5Hash()) : null;
        byte[] crc32c = response.hasCrc32C() ? ByteBuffer.allocate(4).putInt(response.getCrc32C().getValue()).array() : null;
        this.completedItemInfo = new GoogleCloudStorageItemInfo(new StorageResourceId(response.getBucket(), response.getName()), Timestamps.toMillis((Timestamp)response.getTimeCreated()), Timestamps.toMillis((Timestamp)response.getUpdated()), response.getSize(), null, null, response.getContentType(), response.getContentEncoding(), metadata, response.getGeneration(), response.getMetageneration(), new VerificationAttributes(md5Hash, crc32c));
    }

    public void startUpload(InputStream pipeSource) {
        try {
            this.uploadOperation = this.threadPool.submit(new UploadOperation(pipeSource));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failed to start upload for '%s'", this.resourceId), e);
        }
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.completedItemInfo;
    }

    private class UploadOperation
    implements Callable<com.google.google.storage.v1.Object> {
        private final BufferedInputStream pipeSource;
        private final int MAX_BYTES_PER_MESSAGE = ServiceConstants.Values.MAX_WRITE_CHUNK_BYTES.getNumber();
        private Hasher objectHasher;
        private String uploadId;
        private int retriesAttempted = 0;
        private TreeMap<Long, ByteString> dataChunkMap = new TreeMap();

        UploadOperation(InputStream pipeSource) {
            this.pipeSource = new BufferedInputStream(pipeSource, this.MAX_BYTES_PER_MESSAGE);
            if (GoogleCloudStorageGrpcWriteChannel.this.checksumsEnabled) {
                this.objectHasher = Hashing.crc32c().newHasher();
            }
        }

        @Override
        public com.google.google.storage.v1.Object call() throws IOException {
            try (BufferedInputStream ignore = this.pipeSource;){
                com.google.google.storage.v1.Object object = this.doResumableUpload();
                return object;
            }
        }

        private com.google.google.storage.v1.Object doResumableUpload() throws IOException {
            while (this.retriesAttempted++ < 5) {
                this.uploadId = this.startResumableUpload();
                long writeOffset = this.retriesAttempted > 1 ? this.getCommittedWriteSize(this.uploadId) : 0L;
                InsertChunkResponseObserver responseObserver = new InsertChunkResponseObserver(this.uploadId, writeOffset);
                StreamObserver<InsertObjectRequest> requestStreamObserver = ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(WRITE_STREAM_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).insertObject((StreamObserver<com.google.google.storage.v1.Object>)responseObserver);
                try {
                    responseObserver.ready.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(String.format("Streaming RPC failed to become ready for resumable upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.getResourceString()), e);
                }
                boolean objectFinalized = false;
                while (!objectFinalized) {
                    InsertObjectRequest insertRequest;
                    if (this.dataChunkMap.size() > 0 && this.dataChunkMap.lastKey() >= writeOffset) {
                        insertRequest = this.buildRequestFromBufferedDataChunk(this.dataChunkMap, writeOffset);
                        writeOffset += (long)insertRequest.getChecksummedData().getContent().size();
                    } else {
                        ByteString data = ByteString.readFrom((InputStream)ByteStreams.limit((InputStream)this.pipeSource, (long)this.MAX_BYTES_PER_MESSAGE));
                        this.dataChunkMap.put(writeOffset, data);
                        if (this.dataChunkMap.size() >= NUMBER_OF_REQUESTS_TO_RETAIN) {
                            this.dataChunkMap.remove(this.dataChunkMap.firstKey());
                        }
                        insertRequest = this.buildInsertRequest(writeOffset, data, false);
                        writeOffset += (long)data.size();
                    }
                    requestStreamObserver.onNext((Object)insertRequest);
                    objectFinalized = insertRequest.getFinishWrite();
                    if (responseObserver.hasTransientError() || responseObserver.hasNonTransientError()) {
                        requestStreamObserver.onError(responseObserver.hasTransientError() ? responseObserver.transientError : responseObserver.nonTransientError);
                        break;
                    }
                    if (!objectFinalized) continue;
                    requestStreamObserver.onCompleted();
                }
                try {
                    responseObserver.done.await();
                    if (responseObserver.hasTransientError()) {
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(String.format("Resumable upload failed for '%s'", GoogleCloudStorageGrpcWriteChannel.this.getResourceString()), e);
                }
                return responseObserver.getResponseOrThrow();
            }
            throw new IOException(String.format("Too many retry attempts. Resumable upload failed for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId));
        }

        private InsertObjectRequest buildInsertRequest(long writeOffset, ByteString dataChunk, boolean resumeFromFailedInsert) {
            InsertObjectRequest.Builder requestBuilder = InsertObjectRequest.newBuilder().setUploadId(this.uploadId).setWriteOffset(writeOffset);
            if (dataChunk.size() > 0) {
                ChecksummedData.Builder requestDataBuilder = ChecksummedData.newBuilder().setContent(dataChunk);
                if (GoogleCloudStorageGrpcWriteChannel.this.checksumsEnabled) {
                    if (!resumeFromFailedInsert) {
                        this.updateObjectHash(dataChunk);
                    }
                    requestDataBuilder.setCrc32C(UInt32Value.newBuilder().setValue(this.getChunkHash(dataChunk)));
                }
                requestBuilder.setChecksummedData(requestDataBuilder);
            }
            if (dataChunk.size() < this.MAX_BYTES_PER_MESSAGE) {
                requestBuilder.setFinishWrite(true);
                if (GoogleCloudStorageGrpcWriteChannel.this.checksumsEnabled) {
                    requestBuilder.setObjectChecksums(ObjectChecksums.newBuilder().setCrc32C(UInt32Value.newBuilder().setValue(this.objectHasher.hash().asInt())));
                }
            }
            return requestBuilder.build();
        }

        private int getChunkHash(ByteString dataChunk) {
            Hasher chunkHasher = Hashing.crc32c().newHasher();
            for (ByteBuffer buffer : dataChunk.asReadOnlyByteBufferList()) {
                chunkHasher.putBytes(buffer);
            }
            return chunkHasher.hash().asInt();
        }

        private void updateObjectHash(ByteString dataChunk) {
            for (ByteBuffer buffer : dataChunk.asReadOnlyByteBufferList()) {
                this.objectHasher.putBytes(buffer);
            }
        }

        private InsertObjectRequest buildRequestFromBufferedDataChunk(TreeMap<Long, ByteString> dataChunkMap, long writeOffset) throws IOException {
            InsertObjectRequest request = null;
            if (dataChunkMap.size() > 0 && dataChunkMap.firstKey() <= writeOffset) {
                for (Map.Entry<Long, ByteString> entry : dataChunkMap.entrySet()) {
                    if (entry.getKey() + (long)entry.getValue().size() <= writeOffset) continue;
                    Long writeOffsetToResume = entry.getKey();
                    ByteString chunkData = entry.getValue();
                    request = this.buildInsertRequest(writeOffsetToResume, chunkData, true);
                    break;
                }
            }
            if (request == null) {
                throw new IOException(String.format("Didn't have enough data buffered for attempt to resume upload for uploadID %s: last committed offset=%s, earliest buffered offset=%s. Upload must be restarted from the beginning.", this.uploadId, writeOffset, dataChunkMap.firstKey()));
            }
            return request;
        }

        private void runWithRetries(Runnable block, SimpleResponseObserver responseObserver) throws IOException {
            for (int attemptedRetries = 0; attemptedRetries < 5; ++attemptedRetries) {
                block.run();
                if (responseObserver.hasError()) continue;
                return;
            }
            throw new IOException(String.format("Failed to start resumable upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), responseObserver.getError());
        }

        private String startResumableUpload() throws IOException {
            InsertObjectSpec.Builder insertObjectSpecBuilder = InsertObjectSpec.newBuilder().setResource(com.google.google.storage.v1.Object.newBuilder().setBucket(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getBucketName()).setName(GoogleCloudStorageGrpcWriteChannel.this.resourceId.getObjectName()).setContentType(GoogleCloudStorageGrpcWriteChannel.this.contentType).putAllMetadata((Map<String, String>)GoogleCloudStorageGrpcWriteChannel.this.metadata).build());
            if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasContentGenerationMatch()) {
                insertObjectSpecBuilder.setIfGenerationMatch(Int64Value.newBuilder().setValue(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getContentGenerationMatch()));
            }
            if (GoogleCloudStorageGrpcWriteChannel.this.writeConditions.hasMetaGenerationMatch()) {
                insertObjectSpecBuilder.setIfMetagenerationMatch(Int64Value.newBuilder().setValue(GoogleCloudStorageGrpcWriteChannel.this.writeConditions.getMetaGenerationMatch()));
            }
            if (GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject.isPresent()) {
                insertObjectSpecBuilder.setUserProject((String)GoogleCloudStorageGrpcWriteChannel.this.requesterPaysProject.get());
            }
            StartResumableWriteRequest request = StartResumableWriteRequest.newBuilder().setInsertObjectSpec(insertObjectSpecBuilder).build();
            SimpleResponseObserver<StartResumableWriteResponse> responseObserver = new SimpleResponseObserver<StartResumableWriteResponse>();
            ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(START_RESUMABLE_WRITE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).startResumableWrite(request, responseObserver);
            try {
                responseObserver.done.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(String.format("Failed to start resumable upload for '%s'", GoogleCloudStorageGrpcWriteChannel.this.getResourceString()), e);
            }
            return responseObserver.getResponse().getUploadId();
        }

        private long getCommittedWriteSize(String uploadId) throws IOException {
            QueryWriteStatusRequest request = QueryWriteStatusRequest.newBuilder().setUploadId(uploadId).build();
            SimpleResponseObserver<QueryWriteStatusResponse> responseObserver = new SimpleResponseObserver<QueryWriteStatusResponse>();
            ((StorageGrpc.StorageStub)GoogleCloudStorageGrpcWriteChannel.this.stub.withDeadlineAfter(QUERY_WRITE_STATUS_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS)).queryWriteStatus(request, responseObserver);
            try {
                responseObserver.done.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(String.format("Failed to get committed write size for '%s'", GoogleCloudStorageGrpcWriteChannel.this.getResourceString()), e);
            }
            return responseObserver.getResponse().getCommittedSize();
        }

        private class SimpleResponseObserver<T>
        implements StreamObserver<T> {
            private T response;
            private Throwable error;
            final CountDownLatch done = new CountDownLatch(1);

            private SimpleResponseObserver() {
            }

            public T getResponse() {
                return (T)Preconditions.checkNotNull(this.response, (String)"Response not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasError() {
                return this.error != null || this.response == null;
            }

            public Throwable getError() {
                return (Throwable)Preconditions.checkNotNull((Object)this.error, (String)"Error not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            public void onNext(T response) {
                this.response = response;
            }

            public void onError(Throwable t) {
                this.error = new IOException(String.format("Caught exception for '%s'", GoogleCloudStorageGrpcWriteChannel.this.resourceId), t);
                this.done.countDown();
            }

            public void onCompleted() {
                this.done.countDown();
            }
        }

        private class InsertChunkResponseObserver
        implements ClientResponseObserver<InsertObjectRequest, com.google.google.storage.v1.Object> {
            private final long writeOffset;
            private final String uploadId;
            private com.google.google.storage.v1.Object response;
            public Throwable transientError = null;
            public Throwable nonTransientError = null;
            final CountDownLatch done = new CountDownLatch(1);
            final CountDownLatch ready = new CountDownLatch(1);

            InsertChunkResponseObserver(String uploadId, long writeOffset) {
                this.uploadId = uploadId;
                this.writeOffset = writeOffset;
            }

            public com.google.google.storage.v1.Object getResponseOrThrow() throws IOException {
                if (this.hasNonTransientError()) {
                    throw new IOException(String.format("Resumable upload failed for '%s'", GoogleCloudStorageGrpcWriteChannel.this.getResourceString()), this.nonTransientError);
                }
                return (com.google.google.storage.v1.Object)Preconditions.checkNotNull((Object)this.response, (String)"Response not present for '%s'", (Object)GoogleCloudStorageGrpcWriteChannel.this.resourceId);
            }

            boolean hasTransientError() {
                return this.transientError != null;
            }

            boolean hasNonTransientError() {
                return this.response == null && this.nonTransientError != null;
            }

            public void onNext(com.google.google.storage.v1.Object response) {
                this.response = response;
            }

            public void onError(Throwable t) {
                String statusDesc;
                Status s = Status.fromThrowable((Throwable)t);
                String string = statusDesc = s == null ? "" : s.getDescription();
                if (t.getClass() == StatusException.class || t.getClass() == StatusRuntimeException.class) {
                    Status.Code code;
                    Status.Code code2 = code = t.getClass() == StatusException.class ? ((StatusException)t).getStatus().getCode() : ((StatusRuntimeException)t).getStatus().getCode();
                    if (TRANSIENT_ERRORS.contains((Object)code)) {
                        this.transientError = t;
                    }
                }
                if (this.transientError == null) {
                    this.nonTransientError = new IOException(String.format("Caught exception for '%s', while uploading to uploadId %s at writeOffset %d. Status: %s", GoogleCloudStorageGrpcWriteChannel.this.resourceId, this.uploadId, this.writeOffset, statusDesc), t);
                }
                this.done.countDown();
            }

            public void onCompleted() {
                this.done.countDown();
            }

            public void beforeStart(ClientCallStreamObserver<InsertObjectRequest> clientCallStreamObserver) {
                clientCallStreamObserver.setOnReadyHandler(() -> this.ready.countDown());
            }
        }
    }
}

