package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.authorization.AuthorizationHandler;
import com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageOptions extends GoogleCloudStorageOptions {

  private final boolean grpcEnabled;

  private final String grpcServerAddress;

  private final boolean trafficDirectorEnabled;

  private final boolean directPathPreferred;

  private final String storageRootUrl;

  private final String storageServicePath;

  private final String projectId;

  private final String appName;

  private final boolean autoRepairImplicitDirectoriesEnabled;

  private final int maxWaitMillisForEmptyObjectCreation;

  private final long maxListItemsPerCall;

  private final long maxRequestsPerBatch;

  private final int batchThreads;

  private final int maxHttpRequestRetries;

  private final int httpRequestConnectTimeout;

  private final int httpRequestReadTimeout;

  private final HttpTransportFactory.HttpTransportType transportType;

  private final String proxyAddress;

  private final RedactedString proxyUsername;

  private final RedactedString proxyPassword;

  private final boolean copyWithRewriteEnabled;

  private final long maxBytesRewrittenPerCall;

  private final GoogleCloudStorageReadOptions readChannelOptions;

  private final AsyncWriteChannelOptions writeChannelOptions;

  private final RequesterPaysOptions requesterPaysOptions;

  private final CooperativeLockingOptions cooperativeLockingOptions;

  private final ImmutableMap<String, String> httpRequestHeaders;

  private final String encryptionAlgorithm;

  private final RedactedString encryptionKey;

  private final RedactedString encryptionKeyHash;

  private final long grpcMessageTimeoutCheckInterval;

  private final GoogleCloudStorageOptions.MetricsSink metricsSink;

  private final boolean traceLogEnabled;

  private final Class<? extends AuthorizationHandler> authorizationHandlerImplClass;

  private final Map<String, String> authorizationHandlerProperties;

  private AutoValue_GoogleCloudStorageOptions(
      boolean grpcEnabled,
      String grpcServerAddress,
      boolean trafficDirectorEnabled,
      boolean directPathPreferred,
      String storageRootUrl,
      String storageServicePath,
      @Nullable String projectId,
      @Nullable String appName,
      boolean autoRepairImplicitDirectoriesEnabled,
      int maxWaitMillisForEmptyObjectCreation,
      long maxListItemsPerCall,
      long maxRequestsPerBatch,
      int batchThreads,
      int maxHttpRequestRetries,
      int httpRequestConnectTimeout,
      int httpRequestReadTimeout,
      HttpTransportFactory.HttpTransportType transportType,
      @Nullable String proxyAddress,
      @Nullable RedactedString proxyUsername,
      @Nullable RedactedString proxyPassword,
      boolean copyWithRewriteEnabled,
      long maxBytesRewrittenPerCall,
      GoogleCloudStorageReadOptions readChannelOptions,
      AsyncWriteChannelOptions writeChannelOptions,
      RequesterPaysOptions requesterPaysOptions,
      CooperativeLockingOptions cooperativeLockingOptions,
      ImmutableMap<String, String> httpRequestHeaders,
      @Nullable String encryptionAlgorithm,
      @Nullable RedactedString encryptionKey,
      @Nullable RedactedString encryptionKeyHash,
      long grpcMessageTimeoutCheckInterval,
      GoogleCloudStorageOptions.MetricsSink metricsSink,
      boolean traceLogEnabled,
      @Nullable Class<? extends AuthorizationHandler> authorizationHandlerImplClass,
      Map<String, String> authorizationHandlerProperties) {
    this.grpcEnabled = grpcEnabled;
    this.grpcServerAddress = grpcServerAddress;
    this.trafficDirectorEnabled = trafficDirectorEnabled;
    this.directPathPreferred = directPathPreferred;
    this.storageRootUrl = storageRootUrl;
    this.storageServicePath = storageServicePath;
    this.projectId = projectId;
    this.appName = appName;
    this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
    this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
    this.maxListItemsPerCall = maxListItemsPerCall;
    this.maxRequestsPerBatch = maxRequestsPerBatch;
    this.batchThreads = batchThreads;
    this.maxHttpRequestRetries = maxHttpRequestRetries;
    this.httpRequestConnectTimeout = httpRequestConnectTimeout;
    this.httpRequestReadTimeout = httpRequestReadTimeout;
    this.transportType = transportType;
    this.proxyAddress = proxyAddress;
    this.proxyUsername = proxyUsername;
    this.proxyPassword = proxyPassword;
    this.copyWithRewriteEnabled = copyWithRewriteEnabled;
    this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
    this.readChannelOptions = readChannelOptions;
    this.writeChannelOptions = writeChannelOptions;
    this.requesterPaysOptions = requesterPaysOptions;
    this.cooperativeLockingOptions = cooperativeLockingOptions;
    this.httpRequestHeaders = httpRequestHeaders;
    this.encryptionAlgorithm = encryptionAlgorithm;
    this.encryptionKey = encryptionKey;
    this.encryptionKeyHash = encryptionKeyHash;
    this.grpcMessageTimeoutCheckInterval = grpcMessageTimeoutCheckInterval;
    this.metricsSink = metricsSink;
    this.traceLogEnabled = traceLogEnabled;
    this.authorizationHandlerImplClass = authorizationHandlerImplClass;
    this.authorizationHandlerProperties = authorizationHandlerProperties;
  }

  @Override
  public boolean isGrpcEnabled() {
    return grpcEnabled;
  }

  @Override
  public String getGrpcServerAddress() {
    return grpcServerAddress;
  }

  @Override
  public boolean isTrafficDirectorEnabled() {
    return trafficDirectorEnabled;
  }

  @Override
  public boolean isDirectPathPreferred() {
    return directPathPreferred;
  }

  @Override
  public String getStorageRootUrl() {
    return storageRootUrl;
  }

  @Override
  public String getStorageServicePath() {
    return storageServicePath;
  }

  @Nullable
  @Override
  public String getProjectId() {
    return projectId;
  }

  @Nullable
  @Override
  public String getAppName() {
    return appName;
  }

  @Override
  public boolean isAutoRepairImplicitDirectoriesEnabled() {
    return autoRepairImplicitDirectoriesEnabled;
  }

  @Override
  public int getMaxWaitMillisForEmptyObjectCreation() {
    return maxWaitMillisForEmptyObjectCreation;
  }

  @Override
  public long getMaxListItemsPerCall() {
    return maxListItemsPerCall;
  }

  @Override
  public long getMaxRequestsPerBatch() {
    return maxRequestsPerBatch;
  }

  @Override
  public int getBatchThreads() {
    return batchThreads;
  }

  @Override
  public int getMaxHttpRequestRetries() {
    return maxHttpRequestRetries;
  }

  @Override
  public int getHttpRequestConnectTimeout() {
    return httpRequestConnectTimeout;
  }

  @Override
  public int getHttpRequestReadTimeout() {
    return httpRequestReadTimeout;
  }

  @Override
  public HttpTransportFactory.HttpTransportType getTransportType() {
    return transportType;
  }

  @Nullable
  @Override
  public String getProxyAddress() {
    return proxyAddress;
  }

  @Nullable
  @Override
  public RedactedString getProxyUsername() {
    return proxyUsername;
  }

  @Nullable
  @Override
  public RedactedString getProxyPassword() {
    return proxyPassword;
  }

  @Override
  public boolean isCopyWithRewriteEnabled() {
    return copyWithRewriteEnabled;
  }

  @Override
  public long getMaxBytesRewrittenPerCall() {
    return maxBytesRewrittenPerCall;
  }

  @Override
  public GoogleCloudStorageReadOptions getReadChannelOptions() {
    return readChannelOptions;
  }

  @Override
  public AsyncWriteChannelOptions getWriteChannelOptions() {
    return writeChannelOptions;
  }

  @Override
  public RequesterPaysOptions getRequesterPaysOptions() {
    return requesterPaysOptions;
  }

  @Override
  public CooperativeLockingOptions getCooperativeLockingOptions() {
    return cooperativeLockingOptions;
  }

  @Override
  public ImmutableMap<String, String> getHttpRequestHeaders() {
    return httpRequestHeaders;
  }

  @Nullable
  @Override
  public String getEncryptionAlgorithm() {
    return encryptionAlgorithm;
  }

  @Nullable
  @Override
  public RedactedString getEncryptionKey() {
    return encryptionKey;
  }

  @Nullable
  @Override
  public RedactedString getEncryptionKeyHash() {
    return encryptionKeyHash;
  }

  @Override
  public long getGrpcMessageTimeoutCheckInterval() {
    return grpcMessageTimeoutCheckInterval;
  }

  @Override
  public GoogleCloudStorageOptions.MetricsSink getMetricsSink() {
    return metricsSink;
  }

  @Override
  public boolean isTraceLogEnabled() {
    return traceLogEnabled;
  }

  @Nullable
  @Override
  public Class<? extends AuthorizationHandler> getAuthorizationHandlerImplClass() {
    return authorizationHandlerImplClass;
  }

  @Override
  public Map<String, String> getAuthorizationHandlerProperties() {
    return authorizationHandlerProperties;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageOptions{"
        + "grpcEnabled=" + grpcEnabled + ", "
        + "grpcServerAddress=" + grpcServerAddress + ", "
        + "trafficDirectorEnabled=" + trafficDirectorEnabled + ", "
        + "directPathPreferred=" + directPathPreferred + ", "
        + "storageRootUrl=" + storageRootUrl + ", "
        + "storageServicePath=" + storageServicePath + ", "
        + "projectId=" + projectId + ", "
        + "appName=" + appName + ", "
        + "autoRepairImplicitDirectoriesEnabled=" + autoRepairImplicitDirectoriesEnabled + ", "
        + "maxWaitMillisForEmptyObjectCreation=" + maxWaitMillisForEmptyObjectCreation + ", "
        + "maxListItemsPerCall=" + maxListItemsPerCall + ", "
        + "maxRequestsPerBatch=" + maxRequestsPerBatch + ", "
        + "batchThreads=" + batchThreads + ", "
        + "maxHttpRequestRetries=" + maxHttpRequestRetries + ", "
        + "httpRequestConnectTimeout=" + httpRequestConnectTimeout + ", "
        + "httpRequestReadTimeout=" + httpRequestReadTimeout + ", "
        + "transportType=" + transportType + ", "
        + "proxyAddress=" + proxyAddress + ", "
        + "proxyUsername=" + proxyUsername + ", "
        + "proxyPassword=" + proxyPassword + ", "
        + "copyWithRewriteEnabled=" + copyWithRewriteEnabled + ", "
        + "maxBytesRewrittenPerCall=" + maxBytesRewrittenPerCall + ", "
        + "readChannelOptions=" + readChannelOptions + ", "
        + "writeChannelOptions=" + writeChannelOptions + ", "
        + "requesterPaysOptions=" + requesterPaysOptions + ", "
        + "cooperativeLockingOptions=" + cooperativeLockingOptions + ", "
        + "httpRequestHeaders=" + httpRequestHeaders + ", "
        + "encryptionAlgorithm=" + encryptionAlgorithm + ", "
        + "encryptionKey=" + encryptionKey + ", "
        + "encryptionKeyHash=" + encryptionKeyHash + ", "
        + "grpcMessageTimeoutCheckInterval=" + grpcMessageTimeoutCheckInterval + ", "
        + "metricsSink=" + metricsSink + ", "
        + "traceLogEnabled=" + traceLogEnabled + ", "
        + "authorizationHandlerImplClass=" + authorizationHandlerImplClass + ", "
        + "authorizationHandlerProperties=" + authorizationHandlerProperties
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageOptions) {
      GoogleCloudStorageOptions that = (GoogleCloudStorageOptions) o;
      return this.grpcEnabled == that.isGrpcEnabled()
          && this.grpcServerAddress.equals(that.getGrpcServerAddress())
          && this.trafficDirectorEnabled == that.isTrafficDirectorEnabled()
          && this.directPathPreferred == that.isDirectPathPreferred()
          && this.storageRootUrl.equals(that.getStorageRootUrl())
          && this.storageServicePath.equals(that.getStorageServicePath())
          && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId()))
          && (this.appName == null ? that.getAppName() == null : this.appName.equals(that.getAppName()))
          && this.autoRepairImplicitDirectoriesEnabled == that.isAutoRepairImplicitDirectoriesEnabled()
          && this.maxWaitMillisForEmptyObjectCreation == that.getMaxWaitMillisForEmptyObjectCreation()
          && this.maxListItemsPerCall == that.getMaxListItemsPerCall()
          && this.maxRequestsPerBatch == that.getMaxRequestsPerBatch()
          && this.batchThreads == that.getBatchThreads()
          && this.maxHttpRequestRetries == that.getMaxHttpRequestRetries()
          && this.httpRequestConnectTimeout == that.getHttpRequestConnectTimeout()
          && this.httpRequestReadTimeout == that.getHttpRequestReadTimeout()
          && this.transportType.equals(that.getTransportType())
          && (this.proxyAddress == null ? that.getProxyAddress() == null : this.proxyAddress.equals(that.getProxyAddress()))
          && (this.proxyUsername == null ? that.getProxyUsername() == null : this.proxyUsername.equals(that.getProxyUsername()))
          && (this.proxyPassword == null ? that.getProxyPassword() == null : this.proxyPassword.equals(that.getProxyPassword()))
          && this.copyWithRewriteEnabled == that.isCopyWithRewriteEnabled()
          && this.maxBytesRewrittenPerCall == that.getMaxBytesRewrittenPerCall()
          && this.readChannelOptions.equals(that.getReadChannelOptions())
          && this.writeChannelOptions.equals(that.getWriteChannelOptions())
          && this.requesterPaysOptions.equals(that.getRequesterPaysOptions())
          && this.cooperativeLockingOptions.equals(that.getCooperativeLockingOptions())
          && this.httpRequestHeaders.equals(that.getHttpRequestHeaders())
          && (this.encryptionAlgorithm == null ? that.getEncryptionAlgorithm() == null : this.encryptionAlgorithm.equals(that.getEncryptionAlgorithm()))
          && (this.encryptionKey == null ? that.getEncryptionKey() == null : this.encryptionKey.equals(that.getEncryptionKey()))
          && (this.encryptionKeyHash == null ? that.getEncryptionKeyHash() == null : this.encryptionKeyHash.equals(that.getEncryptionKeyHash()))
          && this.grpcMessageTimeoutCheckInterval == that.getGrpcMessageTimeoutCheckInterval()
          && this.metricsSink.equals(that.getMetricsSink())
          && this.traceLogEnabled == that.isTraceLogEnabled()
          && (this.authorizationHandlerImplClass == null ? that.getAuthorizationHandlerImplClass() == null : this.authorizationHandlerImplClass.equals(that.getAuthorizationHandlerImplClass()))
          && this.authorizationHandlerProperties.equals(that.getAuthorizationHandlerProperties());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= grpcEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= grpcServerAddress.hashCode();
    h$ *= 1000003;
    h$ ^= trafficDirectorEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= directPathPreferred ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= storageRootUrl.hashCode();
    h$ *= 1000003;
    h$ ^= storageServicePath.hashCode();
    h$ *= 1000003;
    h$ ^= (projectId == null) ? 0 : projectId.hashCode();
    h$ *= 1000003;
    h$ ^= (appName == null) ? 0 : appName.hashCode();
    h$ *= 1000003;
    h$ ^= autoRepairImplicitDirectoriesEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= maxWaitMillisForEmptyObjectCreation;
    h$ *= 1000003;
    h$ ^= (int) ((maxListItemsPerCall >>> 32) ^ maxListItemsPerCall);
    h$ *= 1000003;
    h$ ^= (int) ((maxRequestsPerBatch >>> 32) ^ maxRequestsPerBatch);
    h$ *= 1000003;
    h$ ^= batchThreads;
    h$ *= 1000003;
    h$ ^= maxHttpRequestRetries;
    h$ *= 1000003;
    h$ ^= httpRequestConnectTimeout;
    h$ *= 1000003;
    h$ ^= httpRequestReadTimeout;
    h$ *= 1000003;
    h$ ^= transportType.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyAddress == null) ? 0 : proxyAddress.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyUsername == null) ? 0 : proxyUsername.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyPassword == null) ? 0 : proxyPassword.hashCode();
    h$ *= 1000003;
    h$ ^= copyWithRewriteEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((maxBytesRewrittenPerCall >>> 32) ^ maxBytesRewrittenPerCall);
    h$ *= 1000003;
    h$ ^= readChannelOptions.hashCode();
    h$ *= 1000003;
    h$ ^= writeChannelOptions.hashCode();
    h$ *= 1000003;
    h$ ^= requesterPaysOptions.hashCode();
    h$ *= 1000003;
    h$ ^= cooperativeLockingOptions.hashCode();
    h$ *= 1000003;
    h$ ^= httpRequestHeaders.hashCode();
    h$ *= 1000003;
    h$ ^= (encryptionAlgorithm == null) ? 0 : encryptionAlgorithm.hashCode();
    h$ *= 1000003;
    h$ ^= (encryptionKey == null) ? 0 : encryptionKey.hashCode();
    h$ *= 1000003;
    h$ ^= (encryptionKeyHash == null) ? 0 : encryptionKeyHash.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((grpcMessageTimeoutCheckInterval >>> 32) ^ grpcMessageTimeoutCheckInterval);
    h$ *= 1000003;
    h$ ^= metricsSink.hashCode();
    h$ *= 1000003;
    h$ ^= traceLogEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (authorizationHandlerImplClass == null) ? 0 : authorizationHandlerImplClass.hashCode();
    h$ *= 1000003;
    h$ ^= authorizationHandlerProperties.hashCode();
    return h$;
  }

  @Override
  public GoogleCloudStorageOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageOptions.Builder {
    private Boolean grpcEnabled;
    private String grpcServerAddress;
    private Boolean trafficDirectorEnabled;
    private Boolean directPathPreferred;
    private String storageRootUrl;
    private String storageServicePath;
    private String projectId;
    private String appName;
    private Boolean autoRepairImplicitDirectoriesEnabled;
    private Integer maxWaitMillisForEmptyObjectCreation;
    private Long maxListItemsPerCall;
    private Long maxRequestsPerBatch;
    private Integer batchThreads;
    private Integer maxHttpRequestRetries;
    private Integer httpRequestConnectTimeout;
    private Integer httpRequestReadTimeout;
    private HttpTransportFactory.HttpTransportType transportType;
    private String proxyAddress;
    private RedactedString proxyUsername;
    private RedactedString proxyPassword;
    private Boolean copyWithRewriteEnabled;
    private Long maxBytesRewrittenPerCall;
    private GoogleCloudStorageReadOptions readChannelOptions;
    private AsyncWriteChannelOptions writeChannelOptions;
    private RequesterPaysOptions requesterPaysOptions;
    private CooperativeLockingOptions cooperativeLockingOptions;
    private ImmutableMap<String, String> httpRequestHeaders;
    private String encryptionAlgorithm;
    private RedactedString encryptionKey;
    private RedactedString encryptionKeyHash;
    private Long grpcMessageTimeoutCheckInterval;
    private GoogleCloudStorageOptions.MetricsSink metricsSink;
    private Boolean traceLogEnabled;
    private Class<? extends AuthorizationHandler> authorizationHandlerImplClass;
    private Map<String, String> authorizationHandlerProperties;
    Builder() {
    }
    private Builder(GoogleCloudStorageOptions source) {
      this.grpcEnabled = source.isGrpcEnabled();
      this.grpcServerAddress = source.getGrpcServerAddress();
      this.trafficDirectorEnabled = source.isTrafficDirectorEnabled();
      this.directPathPreferred = source.isDirectPathPreferred();
      this.storageRootUrl = source.getStorageRootUrl();
      this.storageServicePath = source.getStorageServicePath();
      this.projectId = source.getProjectId();
      this.appName = source.getAppName();
      this.autoRepairImplicitDirectoriesEnabled = source.isAutoRepairImplicitDirectoriesEnabled();
      this.maxWaitMillisForEmptyObjectCreation = source.getMaxWaitMillisForEmptyObjectCreation();
      this.maxListItemsPerCall = source.getMaxListItemsPerCall();
      this.maxRequestsPerBatch = source.getMaxRequestsPerBatch();
      this.batchThreads = source.getBatchThreads();
      this.maxHttpRequestRetries = source.getMaxHttpRequestRetries();
      this.httpRequestConnectTimeout = source.getHttpRequestConnectTimeout();
      this.httpRequestReadTimeout = source.getHttpRequestReadTimeout();
      this.transportType = source.getTransportType();
      this.proxyAddress = source.getProxyAddress();
      this.proxyUsername = source.getProxyUsername();
      this.proxyPassword = source.getProxyPassword();
      this.copyWithRewriteEnabled = source.isCopyWithRewriteEnabled();
      this.maxBytesRewrittenPerCall = source.getMaxBytesRewrittenPerCall();
      this.readChannelOptions = source.getReadChannelOptions();
      this.writeChannelOptions = source.getWriteChannelOptions();
      this.requesterPaysOptions = source.getRequesterPaysOptions();
      this.cooperativeLockingOptions = source.getCooperativeLockingOptions();
      this.httpRequestHeaders = source.getHttpRequestHeaders();
      this.encryptionAlgorithm = source.getEncryptionAlgorithm();
      this.encryptionKey = source.getEncryptionKey();
      this.encryptionKeyHash = source.getEncryptionKeyHash();
      this.grpcMessageTimeoutCheckInterval = source.getGrpcMessageTimeoutCheckInterval();
      this.metricsSink = source.getMetricsSink();
      this.traceLogEnabled = source.isTraceLogEnabled();
      this.authorizationHandlerImplClass = source.getAuthorizationHandlerImplClass();
      this.authorizationHandlerProperties = source.getAuthorizationHandlerProperties();
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcEnabled(boolean grpcEnabled) {
      this.grpcEnabled = grpcEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcServerAddress(String grpcServerAddress) {
      if (grpcServerAddress == null) {
        throw new NullPointerException("Null grpcServerAddress");
      }
      this.grpcServerAddress = grpcServerAddress;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTrafficDirectorEnabled(boolean trafficDirectorEnabled) {
      this.trafficDirectorEnabled = trafficDirectorEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setDirectPathPreferred(boolean directPathPreferred) {
      this.directPathPreferred = directPathPreferred;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setStorageRootUrl(String storageRootUrl) {
      if (storageRootUrl == null) {
        throw new NullPointerException("Null storageRootUrl");
      }
      this.storageRootUrl = storageRootUrl;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setStorageServicePath(String storageServicePath) {
      if (storageServicePath == null) {
        throw new NullPointerException("Null storageServicePath");
      }
      this.storageServicePath = storageServicePath;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProjectId(String projectId) {
      this.projectId = projectId;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAppName(String appName) {
      this.appName = appName;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
      this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxWaitMillisForEmptyObjectCreation(int maxWaitMillisForEmptyObjectCreation) {
      this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxListItemsPerCall(long maxListItemsPerCall) {
      this.maxListItemsPerCall = maxListItemsPerCall;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxRequestsPerBatch(long maxRequestsPerBatch) {
      this.maxRequestsPerBatch = maxRequestsPerBatch;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setBatchThreads(int batchThreads) {
      this.batchThreads = batchThreads;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxHttpRequestRetries(int maxHttpRequestRetries) {
      this.maxHttpRequestRetries = maxHttpRequestRetries;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestConnectTimeout(int httpRequestConnectTimeout) {
      this.httpRequestConnectTimeout = httpRequestConnectTimeout;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestReadTimeout(int httpRequestReadTimeout) {
      this.httpRequestReadTimeout = httpRequestReadTimeout;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTransportType(HttpTransportFactory.HttpTransportType transportType) {
      if (transportType == null) {
        throw new NullPointerException("Null transportType");
      }
      this.transportType = transportType;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyAddress(String proxyAddress) {
      this.proxyAddress = proxyAddress;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyUsername(RedactedString proxyUsername) {
      this.proxyUsername = proxyUsername;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyPassword(RedactedString proxyPassword) {
      this.proxyPassword = proxyPassword;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setCopyWithRewriteEnabled(boolean copyWithRewriteEnabled) {
      this.copyWithRewriteEnabled = copyWithRewriteEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxBytesRewrittenPerCall(long maxBytesRewrittenPerCall) {
      this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setReadChannelOptions(GoogleCloudStorageReadOptions readChannelOptions) {
      if (readChannelOptions == null) {
        throw new NullPointerException("Null readChannelOptions");
      }
      this.readChannelOptions = readChannelOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setWriteChannelOptions(AsyncWriteChannelOptions writeChannelOptions) {
      if (writeChannelOptions == null) {
        throw new NullPointerException("Null writeChannelOptions");
      }
      this.writeChannelOptions = writeChannelOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setRequesterPaysOptions(RequesterPaysOptions requesterPaysOptions) {
      if (requesterPaysOptions == null) {
        throw new NullPointerException("Null requesterPaysOptions");
      }
      this.requesterPaysOptions = requesterPaysOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setCooperativeLockingOptions(CooperativeLockingOptions cooperativeLockingOptions) {
      if (cooperativeLockingOptions == null) {
        throw new NullPointerException("Null cooperativeLockingOptions");
      }
      this.cooperativeLockingOptions = cooperativeLockingOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestHeaders(Map<String, String> httpRequestHeaders) {
      this.httpRequestHeaders = ImmutableMap.copyOf(httpRequestHeaders);
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setEncryptionAlgorithm(String encryptionAlgorithm) {
      this.encryptionAlgorithm = encryptionAlgorithm;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setEncryptionKey(RedactedString encryptionKey) {
      this.encryptionKey = encryptionKey;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setEncryptionKeyHash(RedactedString encryptionKeyHash) {
      this.encryptionKeyHash = encryptionKeyHash;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcMessageTimeoutCheckInterval(long grpcMessageTimeoutCheckInterval) {
      this.grpcMessageTimeoutCheckInterval = grpcMessageTimeoutCheckInterval;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMetricsSink(GoogleCloudStorageOptions.MetricsSink metricsSink) {
      if (metricsSink == null) {
        throw new NullPointerException("Null metricsSink");
      }
      this.metricsSink = metricsSink;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTraceLogEnabled(Boolean traceLogEnabled) {
      if (traceLogEnabled == null) {
        throw new NullPointerException("Null traceLogEnabled");
      }
      this.traceLogEnabled = traceLogEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAuthorizationHandlerImplClass(Class<? extends AuthorizationHandler> authorizationHandlerImplClass) {
      this.authorizationHandlerImplClass = authorizationHandlerImplClass;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAuthorizationHandlerProperties(Map<String, String> authorizationHandlerProperties) {
      if (authorizationHandlerProperties == null) {
        throw new NullPointerException("Null authorizationHandlerProperties");
      }
      this.authorizationHandlerProperties = authorizationHandlerProperties;
      return this;
    }
    @Override
    GoogleCloudStorageOptions autoBuild() {
      if (this.grpcEnabled == null
          || this.grpcServerAddress == null
          || this.trafficDirectorEnabled == null
          || this.directPathPreferred == null
          || this.storageRootUrl == null
          || this.storageServicePath == null
          || this.autoRepairImplicitDirectoriesEnabled == null
          || this.maxWaitMillisForEmptyObjectCreation == null
          || this.maxListItemsPerCall == null
          || this.maxRequestsPerBatch == null
          || this.batchThreads == null
          || this.maxHttpRequestRetries == null
          || this.httpRequestConnectTimeout == null
          || this.httpRequestReadTimeout == null
          || this.transportType == null
          || this.copyWithRewriteEnabled == null
          || this.maxBytesRewrittenPerCall == null
          || this.readChannelOptions == null
          || this.writeChannelOptions == null
          || this.requesterPaysOptions == null
          || this.cooperativeLockingOptions == null
          || this.httpRequestHeaders == null
          || this.grpcMessageTimeoutCheckInterval == null
          || this.metricsSink == null
          || this.traceLogEnabled == null
          || this.authorizationHandlerProperties == null) {
        StringBuilder missing = new StringBuilder();
        if (this.grpcEnabled == null) {
          missing.append(" grpcEnabled");
        }
        if (this.grpcServerAddress == null) {
          missing.append(" grpcServerAddress");
        }
        if (this.trafficDirectorEnabled == null) {
          missing.append(" trafficDirectorEnabled");
        }
        if (this.directPathPreferred == null) {
          missing.append(" directPathPreferred");
        }
        if (this.storageRootUrl == null) {
          missing.append(" storageRootUrl");
        }
        if (this.storageServicePath == null) {
          missing.append(" storageServicePath");
        }
        if (this.autoRepairImplicitDirectoriesEnabled == null) {
          missing.append(" autoRepairImplicitDirectoriesEnabled");
        }
        if (this.maxWaitMillisForEmptyObjectCreation == null) {
          missing.append(" maxWaitMillisForEmptyObjectCreation");
        }
        if (this.maxListItemsPerCall == null) {
          missing.append(" maxListItemsPerCall");
        }
        if (this.maxRequestsPerBatch == null) {
          missing.append(" maxRequestsPerBatch");
        }
        if (this.batchThreads == null) {
          missing.append(" batchThreads");
        }
        if (this.maxHttpRequestRetries == null) {
          missing.append(" maxHttpRequestRetries");
        }
        if (this.httpRequestConnectTimeout == null) {
          missing.append(" httpRequestConnectTimeout");
        }
        if (this.httpRequestReadTimeout == null) {
          missing.append(" httpRequestReadTimeout");
        }
        if (this.transportType == null) {
          missing.append(" transportType");
        }
        if (this.copyWithRewriteEnabled == null) {
          missing.append(" copyWithRewriteEnabled");
        }
        if (this.maxBytesRewrittenPerCall == null) {
          missing.append(" maxBytesRewrittenPerCall");
        }
        if (this.readChannelOptions == null) {
          missing.append(" readChannelOptions");
        }
        if (this.writeChannelOptions == null) {
          missing.append(" writeChannelOptions");
        }
        if (this.requesterPaysOptions == null) {
          missing.append(" requesterPaysOptions");
        }
        if (this.cooperativeLockingOptions == null) {
          missing.append(" cooperativeLockingOptions");
        }
        if (this.httpRequestHeaders == null) {
          missing.append(" httpRequestHeaders");
        }
        if (this.grpcMessageTimeoutCheckInterval == null) {
          missing.append(" grpcMessageTimeoutCheckInterval");
        }
        if (this.metricsSink == null) {
          missing.append(" metricsSink");
        }
        if (this.traceLogEnabled == null) {
          missing.append(" traceLogEnabled");
        }
        if (this.authorizationHandlerProperties == null) {
          missing.append(" authorizationHandlerProperties");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageOptions(
          this.grpcEnabled,
          this.grpcServerAddress,
          this.trafficDirectorEnabled,
          this.directPathPreferred,
          this.storageRootUrl,
          this.storageServicePath,
          this.projectId,
          this.appName,
          this.autoRepairImplicitDirectoriesEnabled,
          this.maxWaitMillisForEmptyObjectCreation,
          this.maxListItemsPerCall,
          this.maxRequestsPerBatch,
          this.batchThreads,
          this.maxHttpRequestRetries,
          this.httpRequestConnectTimeout,
          this.httpRequestReadTimeout,
          this.transportType,
          this.proxyAddress,
          this.proxyUsername,
          this.proxyPassword,
          this.copyWithRewriteEnabled,
          this.maxBytesRewrittenPerCall,
          this.readChannelOptions,
          this.writeChannelOptions,
          this.requesterPaysOptions,
          this.cooperativeLockingOptions,
          this.httpRequestHeaders,
          this.encryptionAlgorithm,
          this.encryptionKey,
          this.encryptionKeyHash,
          this.grpcMessageTimeoutCheckInterval,
          this.metricsSink,
          this.traceLogEnabled,
          this.authorizationHandlerImplClass,
          this.authorizationHandlerProperties);
    }
  }

}
