/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.function.Function;

@VisibleForTesting
public class GcsJavaClientImpl
implements GoogleCloudStorage {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private GoogleCloudStorageImpl gcsClientDelegate;
    private GoogleCloudStorageOptions storageOptions;
    private Credential credential;

    private GcsJavaClientImpl(GcsJavaClientImplBuilder builder) throws IOException {
        this.storageOptions = (GoogleCloudStorageOptions)Preconditions.checkNotNull((Object)builder.storageOptions, (Object)"options must not be null");
        this.credential = (Credential)Preconditions.checkNotNull((Object)builder.credential, (Object)"credentials must not be null");
        if (builder.httpRequestInitializer != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Overriding httpRequestInitializer. ALERT: Should not be hit in production");
            this.gcsClientDelegate = new GoogleCloudStorageImpl(this.storageOptions, builder.httpRequestInitializer);
        } else if (builder.storage != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Overriding storage. ALERT: Should not be hit in production");
            this.gcsClientDelegate = new GoogleCloudStorageImpl(this.storageOptions, builder.storage);
        } else {
            this.gcsClientDelegate = new GoogleCloudStorageImpl(this.storageOptions, this.credential);
        }
    }

    @Override
    public GoogleCloudStorageOptions getOptions() {
        return this.gcsClientDelegate.getOptions();
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        return this.gcsClientDelegate.create(resourceId, options);
    }

    @Override
    public void createBucket(String bucketName, CreateBucketOptions options) throws IOException {
        this.gcsClientDelegate.createBucket(bucketName, options);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId) throws IOException {
        this.gcsClientDelegate.createEmptyObject(resourceId);
    }

    @Override
    public void createEmptyObject(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        this.gcsClientDelegate.createEmptyObject(resourceId, options);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds) throws IOException {
        this.gcsClientDelegate.createEmptyObjects(resourceIds);
    }

    @Override
    public void createEmptyObjects(List<StorageResourceId> resourceIds, CreateObjectOptions options) throws IOException {
        this.gcsClientDelegate.createEmptyObjects(resourceIds, options);
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return this.gcsClientDelegate.open(resourceId, readOptions);
    }

    @Override
    public void deleteBuckets(List<String> bucketNames) throws IOException {
        this.gcsClientDelegate.deleteBuckets(bucketNames);
    }

    @Override
    public void deleteObjects(List<StorageResourceId> fullObjectNames) throws IOException {
        this.gcsClientDelegate.deleteObjects(fullObjectNames);
    }

    @Override
    public void copy(String srcBucketName, List<String> srcObjectNames, String dstBucketName, List<String> dstObjectNames) throws IOException {
        this.gcsClientDelegate.copy(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames);
    }

    @Override
    public List<String> listBucketNames() throws IOException {
        return this.gcsClientDelegate.listBucketNames();
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listBucketInfo() throws IOException {
        return this.gcsClientDelegate.listBucketInfo();
    }

    @Override
    public List<GoogleCloudStorageItemInfo> listObjectInfo(String bucketName, String objectNamePrefix, ListObjectOptions listOptions) throws IOException {
        return this.gcsClientDelegate.listObjectInfo(bucketName, objectNamePrefix, listOptions);
    }

    @Override
    public GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> listObjectInfoPage(String bucketName, String objectNamePrefix, ListObjectOptions listOptions, String pageToken) throws IOException {
        return this.gcsClientDelegate.listObjectInfoPage(bucketName, objectNamePrefix, listOptions, pageToken);
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo(StorageResourceId resourceId) throws IOException {
        return this.gcsClientDelegate.getItemInfo(resourceId);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> getItemInfos(List<StorageResourceId> resourceIds) throws IOException {
        return this.gcsClientDelegate.getItemInfos(resourceIds);
    }

    @Override
    public List<GoogleCloudStorageItemInfo> updateItems(List<UpdatableItemInfo> itemInfoList) throws IOException {
        return this.gcsClientDelegate.updateItems(itemInfoList);
    }

    @Override
    public void compose(String bucketName, List<String> sources, String destination, String contentType) throws IOException {
        this.gcsClientDelegate.compose(bucketName, sources, destination, contentType);
    }

    @Override
    public GoogleCloudStorageItemInfo composeObjects(List<StorageResourceId> sources, StorageResourceId destination, CreateObjectOptions options) throws IOException {
        return this.gcsClientDelegate.composeObjects(sources, destination, options);
    }

    @Override
    public void close() {
        this.gcsClientDelegate.close();
    }

    public static class GcsJavaClientImplBuilder {
        private Credential credential;
        private Storage storage;
        private HttpRequestInitializer httpRequestInitializer;
        private GoogleCloudStorageOptions storageOptions;
        private Function<List<AccessBoundary>, String> downscopedAccessTokenFn;

        public GcsJavaClientImplBuilder(GoogleCloudStorageOptions storageOptions, Credential credential, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) {
            this.storageOptions = storageOptions;
            this.credential = credential;
            this.downscopedAccessTokenFn = downscopedAccessTokenFn;
        }

        @VisibleForTesting
        public GcsJavaClientImplBuilder withApairyClientStorage(Storage storage) {
            Preconditions.checkNotNull((Object)storage, (Object)"storage must not be null");
            this.storage = storage;
            return this;
        }

        @VisibleForTesting
        public GcsJavaClientImplBuilder withHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            Preconditions.checkNotNull((Object)httpRequestInitializer, (Object)"storage must not be null");
            this.httpRequestInitializer = httpRequestInitializer;
            return this;
        }

        public GcsJavaClientImpl build() throws IOException {
            return new GcsJavaClientImpl(this);
        }
    }
}

