/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.auto.value.AutoBuilder;
import com.google.cloud.NoCredentials;
import com.google.cloud.hadoop.gcsio.AutoBuilder_GoogleCloudStorageClientImpl_Builder;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcTracingInterceptor;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientWriteChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.cloud.storage.BlobWriteSessionConfig;
import com.google.cloud.storage.BlobWriteSessionConfigs;
import com.google.cloud.storage.ParallelCompositeUploadBlobWriteSessionConfig;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.ClientInterceptor;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@VisibleForTesting
public class GoogleCloudStorageClientImpl
extends ForwardingGoogleCloudStorage {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final GoogleCloudStorageOptions storageOptions;
    private final Storage storage;
    private static final ErrorTypeExtractor errorExtractor = GrpcErrorTypeExtractor.INSTANCE;
    private ExecutorService backgroundTasksThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("gcsio-storage-client-write-channel-pool-%d").setDaemon(true).build());

    GoogleCloudStorageClientImpl(GoogleCloudStorageOptions options, @Nullable Storage clientLibraryStorage, @Nullable Credentials credentials, @Nullable Credential credential, @Nullable com.google.api.services.storage.Storage apiaryClientStorage, @Nullable HttpRequestInitializer httpRequestInitializer, @Nullable ImmutableList<ClientInterceptor> gRPCInterceptors, @Nullable Function<List<AccessBoundary>, String> downscopedAccessTokenFn, @Nullable ExecutorService pCUExecutorService) throws IOException {
        super(GoogleCloudStorageClientImpl.getDelegate(httpRequestInitializer, apiaryClientStorage, options, credentials, credential, downscopedAccessTokenFn));
        this.storageOptions = options;
        this.storage = clientLibraryStorage == null ? GoogleCloudStorageClientImpl.createStorage(credentials, options, gRPCInterceptors, pCUExecutorService) : clientLibraryStorage;
    }

    @Override
    public WritableByteChannel create(StorageResourceId resourceId, CreateObjectOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("create(%s)", (Object)resourceId);
        Preconditions.checkArgument((boolean)resourceId.isStorageObject(), (String)"Expected full StorageObject id, got %s", (Object)resourceId);
        StorageResourceId resourceIdWithGeneration = resourceId;
        if (!resourceId.hasGenerationId()) {
            resourceIdWithGeneration = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), this.getWriteGeneration(resourceId, options.isOverwriteExisting()));
        }
        GoogleCloudStorageClientWriteChannel channel = new GoogleCloudStorageClientWriteChannel(this.storage, this.storageOptions, resourceIdWithGeneration, options, this.backgroundTasksThreadPool);
        channel.initialize();
        return channel;
    }

    @Override
    public SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("open(%s, %s)", (Object)resourceId, (Object)readOptions);
        return this.open(resourceId, null, readOptions);
    }

    private SeekableByteChannel open(StorageResourceId resourceId, GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return new GoogleCloudStorageClientReadChannel(this.storage, itemInfo == null ? this.getItemInfo(resourceId) : itemInfo, readOptions, errorExtractor, this.storageOptions);
    }

    @Override
    public void close() {
        try {
            try {
                this.storage.close();
            }
            catch (Exception e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Error occurred while closing the storage client");
            }
            try {
                super.close();
            }
            finally {
                this.backgroundTasksThreadPool.shutdown();
            }
        }
        finally {
            this.backgroundTasksThreadPool = null;
        }
    }

    private long getWriteGeneration(StorageResourceId resourceId, boolean overwrite) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("getWriteGeneration(%s, %s)", (Object)resourceId, overwrite);
        GoogleCloudStorageItemInfo info = this.getItemInfo(resourceId);
        if (!info.exists()) {
            return 0L;
        }
        if (info.exists() && overwrite) {
            long generation = info.getContentGeneration();
            Preconditions.checkState((generation != 0L ? 1 : 0) != 0, (Object)"Generation should not be 0 for an existing item");
            return generation;
        }
        throw new FileAlreadyExistsException(String.format("Object %s already exists.", resourceId));
    }

    private static GoogleCloudStorage getDelegate(HttpRequestInitializer httpRequestInitializer, com.google.api.services.storage.Storage storage, GoogleCloudStorageOptions storageOptions, Credentials credentials, Credential credential, Function<List<AccessBoundary>, String> downscopedAccessTokenFn) throws IOException {
        if (httpRequestInitializer != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Overriding httpRequestInitializer. ALERT: Use this only for testing");
            return new GoogleCloudStorageImpl(storageOptions, httpRequestInitializer, downscopedAccessTokenFn);
        }
        if (storage != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Overriding storage. ALERT: Use this only for testing");
            return new GoogleCloudStorageImpl(storageOptions, storage, credentials, downscopedAccessTokenFn);
        }
        return new GoogleCloudStorageImpl(storageOptions, credential);
    }

    private static Storage createStorage(Credentials credentials, GoogleCloudStorageOptions storageOptions, List<ClientInterceptor> interceptors, ExecutorService pCUExecutorService) throws IOException {
        return (Storage)StorageOptions.grpc().setAttemptDirectPath(storageOptions.isDirectPathPreferred()).setHeaderProvider(() -> storageOptions.getHttpRequestHeaders()).setGrpcInterceptorProvider(() -> {
            ArrayList<GoogleCloudStorageClientGrpcTracingInterceptor> list = new ArrayList<GoogleCloudStorageClientGrpcTracingInterceptor>();
            if (interceptors != null && !interceptors.isEmpty()) {
                list.addAll(interceptors.stream().filter(x -> x != null).collect(Collectors.toList()));
            }
            if (storageOptions.isTraceLogEnabled()) {
                list.add(new GoogleCloudStorageClientGrpcTracingInterceptor());
            }
            return ImmutableList.copyOf(list);
        }).setCredentials((Credentials)(credentials != null ? credentials : NoCredentials.getInstance())).setBlobWriteSessionConfig(GoogleCloudStorageClientImpl.getSessionConfig(storageOptions.getWriteChannelOptions(), pCUExecutorService)).build().getService();
    }

    private static BlobWriteSessionConfig getSessionConfig(AsyncWriteChannelOptions writeOptions, ExecutorService pCUExecutorService) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("Upload strategy in use: %s", (Object)writeOptions.getUploadType());
        switch (writeOptions.getUploadType()) {
            case CHUNK_UPLOAD: {
                return BlobWriteSessionConfigs.getDefault().withChunkSize(writeOptions.getUploadChunkSize());
            }
            case WRITE_TO_DISK_THEN_UPLOAD: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    return BlobWriteSessionConfigs.bufferToTempDirThenUpload();
                }
                return BlobWriteSessionConfigs.bufferToDiskThenUpload((Collection)((Collection)writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet())));
            }
            case JOURNALING: {
                if (writeOptions.getTemporaryPaths() == null || writeOptions.getTemporaryPaths().isEmpty()) {
                    throw new IllegalArgumentException("Upload using `Journaling` requires the property:fs.gs.write.temporary.dirs to be set.");
                }
                return BlobWriteSessionConfigs.journaling((Collection)((Collection)writeOptions.getTemporaryPaths().stream().map(x -> Paths.get(x, new String[0])).collect(ImmutableSet.toImmutableSet())));
            }
            case PARALLEL_COMPOSITE_UPLOAD: {
                return BlobWriteSessionConfigs.parallelCompositeUpload().withBufferAllocationStrategy(ParallelCompositeUploadBlobWriteSessionConfig.BufferAllocationStrategy.fixedPool((int)writeOptions.getPCUBufferCount(), (int)writeOptions.getPCUBufferCapacity())).withPartCleanupStrategy(GoogleCloudStorageClientImpl.getPartCleanupStrategy(writeOptions.getPartFileCleanupType())).withExecutorSupplier(GoogleCloudStorageClientImpl.getPCUExecutorSupplier(pCUExecutorService)).withPartNamingStrategy(GoogleCloudStorageClientImpl.getPartNamingStrategy(writeOptions.getPartFileNamePrefix()));
            }
        }
        throw new IllegalArgumentException(String.format("Upload type:%s is not supported.", writeOptions.getUploadType()));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy getPartCleanupStrategy(AsyncWriteChannelOptions.PartFileCleanupType cleanupType) {
        switch (cleanupType) {
            case NEVER: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.never();
            }
            case ON_SUCCESS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.onlyOnSuccess();
            }
            case ALWAYS: {
                return ParallelCompositeUploadBlobWriteSessionConfig.PartCleanupStrategy.always();
            }
        }
        throw new IllegalArgumentException(String.format("Cleanup type:%s is not handled.", cleanupType));
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy getPartNamingStrategy(String partFilePrefix) {
        if (Strings.isNullOrEmpty((String)partFilePrefix)) {
            return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.noPrefix();
        }
        return ParallelCompositeUploadBlobWriteSessionConfig.PartNamingStrategy.prefix((String)partFilePrefix);
    }

    private static ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier getPCUExecutorSupplier(ExecutorService pCUExecutorService) {
        return pCUExecutorService == null ? ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.cachedPool() : ParallelCompositeUploadBlobWriteSessionConfig.ExecutorSupplier.useExecutor((Executor)pCUExecutorService);
    }

    public static Builder builder() {
        return new AutoBuilder_GoogleCloudStorageClientImpl_Builder();
    }

    @AutoBuilder(ofClass=GoogleCloudStorageClientImpl.class)
    public static abstract class Builder {
        public abstract Builder setOptions(GoogleCloudStorageOptions var1);

        public abstract Builder setCredentials(@Nullable Credentials var1);

        public abstract Builder setCredential(@Nullable Credential var1);

        public abstract Builder setApiaryClientStorage(@Nullable com.google.api.services.storage.Storage var1);

        @VisibleForTesting
        public abstract Builder setHttpRequestInitializer(@Nullable HttpRequestInitializer var1);

        public abstract Builder setDownscopedAccessTokenFn(@Nullable Function<List<AccessBoundary>, String> var1);

        public abstract Builder setGRPCInterceptors(@Nullable ImmutableList<ClientInterceptor> var1);

        @VisibleForTesting
        public abstract Builder setClientLibraryStorage(@Nullable Storage var1);

        @VisibleForTesting
        public abstract Builder setPCUExecutorService(@Nullable ExecutorService var1);

        public abstract GoogleCloudStorageClientImpl build() throws IOException;
    }
}

