package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.authorization.AuthorizationHandler;
import com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageOptions extends GoogleCloudStorageOptions {

  private final boolean grpcEnabled;

  private final boolean hnBucketRenameEnabled;

  private final String grpcServerAddress;

  private final boolean trafficDirectorEnabled;

  private final boolean directPathPreferred;

  private final String storageRootUrl;

  private final String storageServicePath;

  private final boolean grpcWriteEnabled;

  @Nullable
  private final String projectId;

  @Nullable
  private final String appName;

  private final boolean autoRepairImplicitDirectoriesEnabled;

  private final int maxWaitMillisForEmptyObjectCreation;

  private final long maxListItemsPerCall;

  private final long maxRequestsPerBatch;

  private final int batchThreads;

  private final int maxHttpRequestRetries;

  private final int httpRequestConnectTimeout;

  private final int httpRequestReadTimeout;

  private final HttpTransportFactory.HttpTransportType transportType;

  @Nullable
  private final String proxyAddress;

  @Nullable
  private final RedactedString proxyUsername;

  @Nullable
  private final RedactedString proxyPassword;

  private final boolean copyWithRewriteEnabled;

  private final long maxBytesRewrittenPerCall;

  private final GoogleCloudStorageReadOptions readChannelOptions;

  private final AsyncWriteChannelOptions writeChannelOptions;

  private final RequesterPaysOptions requesterPaysOptions;

  private final CooperativeLockingOptions cooperativeLockingOptions;

  private final ImmutableMap<String, String> httpRequestHeaders;

  @Nullable
  private final String encryptionAlgorithm;

  @Nullable
  private final RedactedString encryptionKey;

  @Nullable
  private final RedactedString encryptionKeyHash;

  private final long grpcMessageTimeoutCheckInterval;

  private final GoogleCloudStorageOptions.MetricsSink metricsSink;

  private final boolean traceLogEnabled;

  private final boolean operationTraceLogEnabled;

  private final long traceLogTimeThreshold;

  private final ImmutableSet<String> traceLogExcludeProperties;

  @Nullable
  private final Class<? extends AuthorizationHandler> authorizationHandlerImplClass;

  private final Map<String, String> authorizationHandlerProperties;

  private AutoValue_GoogleCloudStorageOptions(
      boolean grpcEnabled,
      boolean hnBucketRenameEnabled,
      String grpcServerAddress,
      boolean trafficDirectorEnabled,
      boolean directPathPreferred,
      String storageRootUrl,
      String storageServicePath,
      boolean grpcWriteEnabled,
      @Nullable String projectId,
      @Nullable String appName,
      boolean autoRepairImplicitDirectoriesEnabled,
      int maxWaitMillisForEmptyObjectCreation,
      long maxListItemsPerCall,
      long maxRequestsPerBatch,
      int batchThreads,
      int maxHttpRequestRetries,
      int httpRequestConnectTimeout,
      int httpRequestReadTimeout,
      HttpTransportFactory.HttpTransportType transportType,
      @Nullable String proxyAddress,
      @Nullable RedactedString proxyUsername,
      @Nullable RedactedString proxyPassword,
      boolean copyWithRewriteEnabled,
      long maxBytesRewrittenPerCall,
      GoogleCloudStorageReadOptions readChannelOptions,
      AsyncWriteChannelOptions writeChannelOptions,
      RequesterPaysOptions requesterPaysOptions,
      CooperativeLockingOptions cooperativeLockingOptions,
      ImmutableMap<String, String> httpRequestHeaders,
      @Nullable String encryptionAlgorithm,
      @Nullable RedactedString encryptionKey,
      @Nullable RedactedString encryptionKeyHash,
      long grpcMessageTimeoutCheckInterval,
      GoogleCloudStorageOptions.MetricsSink metricsSink,
      boolean traceLogEnabled,
      boolean operationTraceLogEnabled,
      long traceLogTimeThreshold,
      ImmutableSet<String> traceLogExcludeProperties,
      @Nullable Class<? extends AuthorizationHandler> authorizationHandlerImplClass,
      Map<String, String> authorizationHandlerProperties) {
    this.grpcEnabled = grpcEnabled;
    this.hnBucketRenameEnabled = hnBucketRenameEnabled;
    this.grpcServerAddress = grpcServerAddress;
    this.trafficDirectorEnabled = trafficDirectorEnabled;
    this.directPathPreferred = directPathPreferred;
    this.storageRootUrl = storageRootUrl;
    this.storageServicePath = storageServicePath;
    this.grpcWriteEnabled = grpcWriteEnabled;
    this.projectId = projectId;
    this.appName = appName;
    this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
    this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
    this.maxListItemsPerCall = maxListItemsPerCall;
    this.maxRequestsPerBatch = maxRequestsPerBatch;
    this.batchThreads = batchThreads;
    this.maxHttpRequestRetries = maxHttpRequestRetries;
    this.httpRequestConnectTimeout = httpRequestConnectTimeout;
    this.httpRequestReadTimeout = httpRequestReadTimeout;
    this.transportType = transportType;
    this.proxyAddress = proxyAddress;
    this.proxyUsername = proxyUsername;
    this.proxyPassword = proxyPassword;
    this.copyWithRewriteEnabled = copyWithRewriteEnabled;
    this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
    this.readChannelOptions = readChannelOptions;
    this.writeChannelOptions = writeChannelOptions;
    this.requesterPaysOptions = requesterPaysOptions;
    this.cooperativeLockingOptions = cooperativeLockingOptions;
    this.httpRequestHeaders = httpRequestHeaders;
    this.encryptionAlgorithm = encryptionAlgorithm;
    this.encryptionKey = encryptionKey;
    this.encryptionKeyHash = encryptionKeyHash;
    this.grpcMessageTimeoutCheckInterval = grpcMessageTimeoutCheckInterval;
    this.metricsSink = metricsSink;
    this.traceLogEnabled = traceLogEnabled;
    this.operationTraceLogEnabled = operationTraceLogEnabled;
    this.traceLogTimeThreshold = traceLogTimeThreshold;
    this.traceLogExcludeProperties = traceLogExcludeProperties;
    this.authorizationHandlerImplClass = authorizationHandlerImplClass;
    this.authorizationHandlerProperties = authorizationHandlerProperties;
  }

  @Override
  public boolean isGrpcEnabled() {
    return grpcEnabled;
  }

  @Override
  public boolean isHnBucketRenameEnabled() {
    return hnBucketRenameEnabled;
  }

  @Override
  public String getGrpcServerAddress() {
    return grpcServerAddress;
  }

  @Override
  public boolean isTrafficDirectorEnabled() {
    return trafficDirectorEnabled;
  }

  @Override
  public boolean isDirectPathPreferred() {
    return directPathPreferred;
  }

  @Override
  public String getStorageRootUrl() {
    return storageRootUrl;
  }

  @Override
  public String getStorageServicePath() {
    return storageServicePath;
  }

  @Override
  public boolean isGrpcWriteEnabled() {
    return grpcWriteEnabled;
  }

  @Nullable
  @Override
  public String getProjectId() {
    return projectId;
  }

  @Nullable
  @Override
  public String getAppName() {
    return appName;
  }

  @Override
  public boolean isAutoRepairImplicitDirectoriesEnabled() {
    return autoRepairImplicitDirectoriesEnabled;
  }

  @Override
  public int getMaxWaitMillisForEmptyObjectCreation() {
    return maxWaitMillisForEmptyObjectCreation;
  }

  @Override
  public long getMaxListItemsPerCall() {
    return maxListItemsPerCall;
  }

  @Override
  public long getMaxRequestsPerBatch() {
    return maxRequestsPerBatch;
  }

  @Override
  public int getBatchThreads() {
    return batchThreads;
  }

  @Override
  public int getMaxHttpRequestRetries() {
    return maxHttpRequestRetries;
  }

  @Override
  public int getHttpRequestConnectTimeout() {
    return httpRequestConnectTimeout;
  }

  @Override
  public int getHttpRequestReadTimeout() {
    return httpRequestReadTimeout;
  }

  @Override
  public HttpTransportFactory.HttpTransportType getTransportType() {
    return transportType;
  }

  @Nullable
  @Override
  public String getProxyAddress() {
    return proxyAddress;
  }

  @Nullable
  @Override
  public RedactedString getProxyUsername() {
    return proxyUsername;
  }

  @Nullable
  @Override
  public RedactedString getProxyPassword() {
    return proxyPassword;
  }

  @Override
  public boolean isCopyWithRewriteEnabled() {
    return copyWithRewriteEnabled;
  }

  @Override
  public long getMaxBytesRewrittenPerCall() {
    return maxBytesRewrittenPerCall;
  }

  @Override
  public GoogleCloudStorageReadOptions getReadChannelOptions() {
    return readChannelOptions;
  }

  @Override
  public AsyncWriteChannelOptions getWriteChannelOptions() {
    return writeChannelOptions;
  }

  @Override
  public RequesterPaysOptions getRequesterPaysOptions() {
    return requesterPaysOptions;
  }

  @Override
  public CooperativeLockingOptions getCooperativeLockingOptions() {
    return cooperativeLockingOptions;
  }

  @Override
  public ImmutableMap<String, String> getHttpRequestHeaders() {
    return httpRequestHeaders;
  }

  @Nullable
  @Override
  public String getEncryptionAlgorithm() {
    return encryptionAlgorithm;
  }

  @Nullable
  @Override
  public RedactedString getEncryptionKey() {
    return encryptionKey;
  }

  @Nullable
  @Override
  public RedactedString getEncryptionKeyHash() {
    return encryptionKeyHash;
  }

  @Override
  public long getGrpcMessageTimeoutCheckInterval() {
    return grpcMessageTimeoutCheckInterval;
  }

  @Override
  public GoogleCloudStorageOptions.MetricsSink getMetricsSink() {
    return metricsSink;
  }

  @Override
  public boolean isTraceLogEnabled() {
    return traceLogEnabled;
  }

  @Override
  public boolean isOperationTraceLogEnabled() {
    return operationTraceLogEnabled;
  }

  @Override
  public long getTraceLogTimeThreshold() {
    return traceLogTimeThreshold;
  }

  @Override
  public ImmutableSet<String> getTraceLogExcludeProperties() {
    return traceLogExcludeProperties;
  }

  @Nullable
  @Override
  public Class<? extends AuthorizationHandler> getAuthorizationHandlerImplClass() {
    return authorizationHandlerImplClass;
  }

  @Override
  public Map<String, String> getAuthorizationHandlerProperties() {
    return authorizationHandlerProperties;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageOptions{"
        + "grpcEnabled=" + grpcEnabled + ", "
        + "hnBucketRenameEnabled=" + hnBucketRenameEnabled + ", "
        + "grpcServerAddress=" + grpcServerAddress + ", "
        + "trafficDirectorEnabled=" + trafficDirectorEnabled + ", "
        + "directPathPreferred=" + directPathPreferred + ", "
        + "storageRootUrl=" + storageRootUrl + ", "
        + "storageServicePath=" + storageServicePath + ", "
        + "grpcWriteEnabled=" + grpcWriteEnabled + ", "
        + "projectId=" + projectId + ", "
        + "appName=" + appName + ", "
        + "autoRepairImplicitDirectoriesEnabled=" + autoRepairImplicitDirectoriesEnabled + ", "
        + "maxWaitMillisForEmptyObjectCreation=" + maxWaitMillisForEmptyObjectCreation + ", "
        + "maxListItemsPerCall=" + maxListItemsPerCall + ", "
        + "maxRequestsPerBatch=" + maxRequestsPerBatch + ", "
        + "batchThreads=" + batchThreads + ", "
        + "maxHttpRequestRetries=" + maxHttpRequestRetries + ", "
        + "httpRequestConnectTimeout=" + httpRequestConnectTimeout + ", "
        + "httpRequestReadTimeout=" + httpRequestReadTimeout + ", "
        + "transportType=" + transportType + ", "
        + "proxyAddress=" + proxyAddress + ", "
        + "proxyUsername=" + proxyUsername + ", "
        + "proxyPassword=" + proxyPassword + ", "
        + "copyWithRewriteEnabled=" + copyWithRewriteEnabled + ", "
        + "maxBytesRewrittenPerCall=" + maxBytesRewrittenPerCall + ", "
        + "readChannelOptions=" + readChannelOptions + ", "
        + "writeChannelOptions=" + writeChannelOptions + ", "
        + "requesterPaysOptions=" + requesterPaysOptions + ", "
        + "cooperativeLockingOptions=" + cooperativeLockingOptions + ", "
        + "httpRequestHeaders=" + httpRequestHeaders + ", "
        + "encryptionAlgorithm=" + encryptionAlgorithm + ", "
        + "encryptionKey=" + encryptionKey + ", "
        + "encryptionKeyHash=" + encryptionKeyHash + ", "
        + "grpcMessageTimeoutCheckInterval=" + grpcMessageTimeoutCheckInterval + ", "
        + "metricsSink=" + metricsSink + ", "
        + "traceLogEnabled=" + traceLogEnabled + ", "
        + "operationTraceLogEnabled=" + operationTraceLogEnabled + ", "
        + "traceLogTimeThreshold=" + traceLogTimeThreshold + ", "
        + "traceLogExcludeProperties=" + traceLogExcludeProperties + ", "
        + "authorizationHandlerImplClass=" + authorizationHandlerImplClass + ", "
        + "authorizationHandlerProperties=" + authorizationHandlerProperties
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageOptions) {
      GoogleCloudStorageOptions that = (GoogleCloudStorageOptions) o;
      return this.grpcEnabled == that.isGrpcEnabled()
          && this.hnBucketRenameEnabled == that.isHnBucketRenameEnabled()
          && this.grpcServerAddress.equals(that.getGrpcServerAddress())
          && this.trafficDirectorEnabled == that.isTrafficDirectorEnabled()
          && this.directPathPreferred == that.isDirectPathPreferred()
          && this.storageRootUrl.equals(that.getStorageRootUrl())
          && this.storageServicePath.equals(that.getStorageServicePath())
          && this.grpcWriteEnabled == that.isGrpcWriteEnabled()
          && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId()))
          && (this.appName == null ? that.getAppName() == null : this.appName.equals(that.getAppName()))
          && this.autoRepairImplicitDirectoriesEnabled == that.isAutoRepairImplicitDirectoriesEnabled()
          && this.maxWaitMillisForEmptyObjectCreation == that.getMaxWaitMillisForEmptyObjectCreation()
          && this.maxListItemsPerCall == that.getMaxListItemsPerCall()
          && this.maxRequestsPerBatch == that.getMaxRequestsPerBatch()
          && this.batchThreads == that.getBatchThreads()
          && this.maxHttpRequestRetries == that.getMaxHttpRequestRetries()
          && this.httpRequestConnectTimeout == that.getHttpRequestConnectTimeout()
          && this.httpRequestReadTimeout == that.getHttpRequestReadTimeout()
          && this.transportType.equals(that.getTransportType())
          && (this.proxyAddress == null ? that.getProxyAddress() == null : this.proxyAddress.equals(that.getProxyAddress()))
          && (this.proxyUsername == null ? that.getProxyUsername() == null : this.proxyUsername.equals(that.getProxyUsername()))
          && (this.proxyPassword == null ? that.getProxyPassword() == null : this.proxyPassword.equals(that.getProxyPassword()))
          && this.copyWithRewriteEnabled == that.isCopyWithRewriteEnabled()
          && this.maxBytesRewrittenPerCall == that.getMaxBytesRewrittenPerCall()
          && this.readChannelOptions.equals(that.getReadChannelOptions())
          && this.writeChannelOptions.equals(that.getWriteChannelOptions())
          && this.requesterPaysOptions.equals(that.getRequesterPaysOptions())
          && this.cooperativeLockingOptions.equals(that.getCooperativeLockingOptions())
          && this.httpRequestHeaders.equals(that.getHttpRequestHeaders())
          && (this.encryptionAlgorithm == null ? that.getEncryptionAlgorithm() == null : this.encryptionAlgorithm.equals(that.getEncryptionAlgorithm()))
          && (this.encryptionKey == null ? that.getEncryptionKey() == null : this.encryptionKey.equals(that.getEncryptionKey()))
          && (this.encryptionKeyHash == null ? that.getEncryptionKeyHash() == null : this.encryptionKeyHash.equals(that.getEncryptionKeyHash()))
          && this.grpcMessageTimeoutCheckInterval == that.getGrpcMessageTimeoutCheckInterval()
          && this.metricsSink.equals(that.getMetricsSink())
          && this.traceLogEnabled == that.isTraceLogEnabled()
          && this.operationTraceLogEnabled == that.isOperationTraceLogEnabled()
          && this.traceLogTimeThreshold == that.getTraceLogTimeThreshold()
          && this.traceLogExcludeProperties.equals(that.getTraceLogExcludeProperties())
          && (this.authorizationHandlerImplClass == null ? that.getAuthorizationHandlerImplClass() == null : this.authorizationHandlerImplClass.equals(that.getAuthorizationHandlerImplClass()))
          && this.authorizationHandlerProperties.equals(that.getAuthorizationHandlerProperties());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= grpcEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= hnBucketRenameEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= grpcServerAddress.hashCode();
    h$ *= 1000003;
    h$ ^= trafficDirectorEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= directPathPreferred ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= storageRootUrl.hashCode();
    h$ *= 1000003;
    h$ ^= storageServicePath.hashCode();
    h$ *= 1000003;
    h$ ^= grpcWriteEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (projectId == null) ? 0 : projectId.hashCode();
    h$ *= 1000003;
    h$ ^= (appName == null) ? 0 : appName.hashCode();
    h$ *= 1000003;
    h$ ^= autoRepairImplicitDirectoriesEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= maxWaitMillisForEmptyObjectCreation;
    h$ *= 1000003;
    h$ ^= (int) ((maxListItemsPerCall >>> 32) ^ maxListItemsPerCall);
    h$ *= 1000003;
    h$ ^= (int) ((maxRequestsPerBatch >>> 32) ^ maxRequestsPerBatch);
    h$ *= 1000003;
    h$ ^= batchThreads;
    h$ *= 1000003;
    h$ ^= maxHttpRequestRetries;
    h$ *= 1000003;
    h$ ^= httpRequestConnectTimeout;
    h$ *= 1000003;
    h$ ^= httpRequestReadTimeout;
    h$ *= 1000003;
    h$ ^= transportType.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyAddress == null) ? 0 : proxyAddress.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyUsername == null) ? 0 : proxyUsername.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyPassword == null) ? 0 : proxyPassword.hashCode();
    h$ *= 1000003;
    h$ ^= copyWithRewriteEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((maxBytesRewrittenPerCall >>> 32) ^ maxBytesRewrittenPerCall);
    h$ *= 1000003;
    h$ ^= readChannelOptions.hashCode();
    h$ *= 1000003;
    h$ ^= writeChannelOptions.hashCode();
    h$ *= 1000003;
    h$ ^= requesterPaysOptions.hashCode();
    h$ *= 1000003;
    h$ ^= cooperativeLockingOptions.hashCode();
    h$ *= 1000003;
    h$ ^= httpRequestHeaders.hashCode();
    h$ *= 1000003;
    h$ ^= (encryptionAlgorithm == null) ? 0 : encryptionAlgorithm.hashCode();
    h$ *= 1000003;
    h$ ^= (encryptionKey == null) ? 0 : encryptionKey.hashCode();
    h$ *= 1000003;
    h$ ^= (encryptionKeyHash == null) ? 0 : encryptionKeyHash.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((grpcMessageTimeoutCheckInterval >>> 32) ^ grpcMessageTimeoutCheckInterval);
    h$ *= 1000003;
    h$ ^= metricsSink.hashCode();
    h$ *= 1000003;
    h$ ^= traceLogEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= operationTraceLogEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((traceLogTimeThreshold >>> 32) ^ traceLogTimeThreshold);
    h$ *= 1000003;
    h$ ^= traceLogExcludeProperties.hashCode();
    h$ *= 1000003;
    h$ ^= (authorizationHandlerImplClass == null) ? 0 : authorizationHandlerImplClass.hashCode();
    h$ *= 1000003;
    h$ ^= authorizationHandlerProperties.hashCode();
    return h$;
  }

  @Override
  public GoogleCloudStorageOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageOptions.Builder {
    private boolean grpcEnabled;
    private boolean hnBucketRenameEnabled;
    private String grpcServerAddress;
    private boolean trafficDirectorEnabled;
    private boolean directPathPreferred;
    private String storageRootUrl;
    private String storageServicePath;
    private boolean grpcWriteEnabled;
    private String projectId;
    private String appName;
    private boolean autoRepairImplicitDirectoriesEnabled;
    private int maxWaitMillisForEmptyObjectCreation;
    private long maxListItemsPerCall;
    private long maxRequestsPerBatch;
    private int batchThreads;
    private int maxHttpRequestRetries;
    private int httpRequestConnectTimeout;
    private int httpRequestReadTimeout;
    private HttpTransportFactory.HttpTransportType transportType;
    private String proxyAddress;
    private RedactedString proxyUsername;
    private RedactedString proxyPassword;
    private boolean copyWithRewriteEnabled;
    private long maxBytesRewrittenPerCall;
    private GoogleCloudStorageReadOptions readChannelOptions;
    private AsyncWriteChannelOptions writeChannelOptions;
    private RequesterPaysOptions requesterPaysOptions;
    private CooperativeLockingOptions cooperativeLockingOptions;
    private ImmutableMap<String, String> httpRequestHeaders;
    private String encryptionAlgorithm;
    private RedactedString encryptionKey;
    private RedactedString encryptionKeyHash;
    private long grpcMessageTimeoutCheckInterval;
    private GoogleCloudStorageOptions.MetricsSink metricsSink;
    private boolean traceLogEnabled;
    private boolean operationTraceLogEnabled;
    private long traceLogTimeThreshold;
    private ImmutableSet<String> traceLogExcludeProperties;
    private Class<? extends AuthorizationHandler> authorizationHandlerImplClass;
    private Map<String, String> authorizationHandlerProperties;
    private int set$0;
    Builder() {
    }
    private Builder(GoogleCloudStorageOptions source) {
      this.grpcEnabled = source.isGrpcEnabled();
      this.hnBucketRenameEnabled = source.isHnBucketRenameEnabled();
      this.grpcServerAddress = source.getGrpcServerAddress();
      this.trafficDirectorEnabled = source.isTrafficDirectorEnabled();
      this.directPathPreferred = source.isDirectPathPreferred();
      this.storageRootUrl = source.getStorageRootUrl();
      this.storageServicePath = source.getStorageServicePath();
      this.grpcWriteEnabled = source.isGrpcWriteEnabled();
      this.projectId = source.getProjectId();
      this.appName = source.getAppName();
      this.autoRepairImplicitDirectoriesEnabled = source.isAutoRepairImplicitDirectoriesEnabled();
      this.maxWaitMillisForEmptyObjectCreation = source.getMaxWaitMillisForEmptyObjectCreation();
      this.maxListItemsPerCall = source.getMaxListItemsPerCall();
      this.maxRequestsPerBatch = source.getMaxRequestsPerBatch();
      this.batchThreads = source.getBatchThreads();
      this.maxHttpRequestRetries = source.getMaxHttpRequestRetries();
      this.httpRequestConnectTimeout = source.getHttpRequestConnectTimeout();
      this.httpRequestReadTimeout = source.getHttpRequestReadTimeout();
      this.transportType = source.getTransportType();
      this.proxyAddress = source.getProxyAddress();
      this.proxyUsername = source.getProxyUsername();
      this.proxyPassword = source.getProxyPassword();
      this.copyWithRewriteEnabled = source.isCopyWithRewriteEnabled();
      this.maxBytesRewrittenPerCall = source.getMaxBytesRewrittenPerCall();
      this.readChannelOptions = source.getReadChannelOptions();
      this.writeChannelOptions = source.getWriteChannelOptions();
      this.requesterPaysOptions = source.getRequesterPaysOptions();
      this.cooperativeLockingOptions = source.getCooperativeLockingOptions();
      this.httpRequestHeaders = source.getHttpRequestHeaders();
      this.encryptionAlgorithm = source.getEncryptionAlgorithm();
      this.encryptionKey = source.getEncryptionKey();
      this.encryptionKeyHash = source.getEncryptionKeyHash();
      this.grpcMessageTimeoutCheckInterval = source.getGrpcMessageTimeoutCheckInterval();
      this.metricsSink = source.getMetricsSink();
      this.traceLogEnabled = source.isTraceLogEnabled();
      this.operationTraceLogEnabled = source.isOperationTraceLogEnabled();
      this.traceLogTimeThreshold = source.getTraceLogTimeThreshold();
      this.traceLogExcludeProperties = source.getTraceLogExcludeProperties();
      this.authorizationHandlerImplClass = source.getAuthorizationHandlerImplClass();
      this.authorizationHandlerProperties = source.getAuthorizationHandlerProperties();
      set$0 = 0x7_ffff;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcEnabled(boolean grpcEnabled) {
      this.grpcEnabled = grpcEnabled;
      set$0 |= 1;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHnBucketRenameEnabled(boolean hnBucketRenameEnabled) {
      this.hnBucketRenameEnabled = hnBucketRenameEnabled;
      set$0 |= 2;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcServerAddress(String grpcServerAddress) {
      if (grpcServerAddress == null) {
        throw new NullPointerException("Null grpcServerAddress");
      }
      this.grpcServerAddress = grpcServerAddress;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTrafficDirectorEnabled(boolean trafficDirectorEnabled) {
      this.trafficDirectorEnabled = trafficDirectorEnabled;
      set$0 |= 4;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setDirectPathPreferred(boolean directPathPreferred) {
      this.directPathPreferred = directPathPreferred;
      set$0 |= 8;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setStorageRootUrl(String storageRootUrl) {
      if (storageRootUrl == null) {
        throw new NullPointerException("Null storageRootUrl");
      }
      this.storageRootUrl = storageRootUrl;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setStorageServicePath(String storageServicePath) {
      if (storageServicePath == null) {
        throw new NullPointerException("Null storageServicePath");
      }
      this.storageServicePath = storageServicePath;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcWriteEnabled(boolean grpcWriteEnabled) {
      this.grpcWriteEnabled = grpcWriteEnabled;
      set$0 |= 0x10;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProjectId(String projectId) {
      this.projectId = projectId;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAppName(String appName) {
      this.appName = appName;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
      this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
      set$0 |= 0x20;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxWaitMillisForEmptyObjectCreation(int maxWaitMillisForEmptyObjectCreation) {
      this.maxWaitMillisForEmptyObjectCreation = maxWaitMillisForEmptyObjectCreation;
      set$0 |= 0x40;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxListItemsPerCall(long maxListItemsPerCall) {
      this.maxListItemsPerCall = maxListItemsPerCall;
      set$0 |= 0x80;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxRequestsPerBatch(long maxRequestsPerBatch) {
      this.maxRequestsPerBatch = maxRequestsPerBatch;
      set$0 |= 0x100;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setBatchThreads(int batchThreads) {
      this.batchThreads = batchThreads;
      set$0 |= 0x200;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxHttpRequestRetries(int maxHttpRequestRetries) {
      this.maxHttpRequestRetries = maxHttpRequestRetries;
      set$0 |= 0x400;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestConnectTimeout(int httpRequestConnectTimeout) {
      this.httpRequestConnectTimeout = httpRequestConnectTimeout;
      set$0 |= 0x800;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestReadTimeout(int httpRequestReadTimeout) {
      this.httpRequestReadTimeout = httpRequestReadTimeout;
      set$0 |= 0x1000;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTransportType(HttpTransportFactory.HttpTransportType transportType) {
      if (transportType == null) {
        throw new NullPointerException("Null transportType");
      }
      this.transportType = transportType;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyAddress(String proxyAddress) {
      this.proxyAddress = proxyAddress;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyUsername(RedactedString proxyUsername) {
      this.proxyUsername = proxyUsername;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyPassword(RedactedString proxyPassword) {
      this.proxyPassword = proxyPassword;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setCopyWithRewriteEnabled(boolean copyWithRewriteEnabled) {
      this.copyWithRewriteEnabled = copyWithRewriteEnabled;
      set$0 |= 0x2000;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxBytesRewrittenPerCall(long maxBytesRewrittenPerCall) {
      this.maxBytesRewrittenPerCall = maxBytesRewrittenPerCall;
      set$0 |= 0x4000;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setReadChannelOptions(GoogleCloudStorageReadOptions readChannelOptions) {
      if (readChannelOptions == null) {
        throw new NullPointerException("Null readChannelOptions");
      }
      this.readChannelOptions = readChannelOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setWriteChannelOptions(AsyncWriteChannelOptions writeChannelOptions) {
      if (writeChannelOptions == null) {
        throw new NullPointerException("Null writeChannelOptions");
      }
      this.writeChannelOptions = writeChannelOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setRequesterPaysOptions(RequesterPaysOptions requesterPaysOptions) {
      if (requesterPaysOptions == null) {
        throw new NullPointerException("Null requesterPaysOptions");
      }
      this.requesterPaysOptions = requesterPaysOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setCooperativeLockingOptions(CooperativeLockingOptions cooperativeLockingOptions) {
      if (cooperativeLockingOptions == null) {
        throw new NullPointerException("Null cooperativeLockingOptions");
      }
      this.cooperativeLockingOptions = cooperativeLockingOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestHeaders(Map<String, String> httpRequestHeaders) {
      this.httpRequestHeaders = ImmutableMap.copyOf(httpRequestHeaders);
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setEncryptionAlgorithm(String encryptionAlgorithm) {
      this.encryptionAlgorithm = encryptionAlgorithm;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setEncryptionKey(RedactedString encryptionKey) {
      this.encryptionKey = encryptionKey;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setEncryptionKeyHash(RedactedString encryptionKeyHash) {
      this.encryptionKeyHash = encryptionKeyHash;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcMessageTimeoutCheckInterval(long grpcMessageTimeoutCheckInterval) {
      this.grpcMessageTimeoutCheckInterval = grpcMessageTimeoutCheckInterval;
      set$0 |= 0x8000;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMetricsSink(GoogleCloudStorageOptions.MetricsSink metricsSink) {
      if (metricsSink == null) {
        throw new NullPointerException("Null metricsSink");
      }
      this.metricsSink = metricsSink;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTraceLogEnabled(Boolean traceLogEnabled) {
      if (traceLogEnabled == null) {
        throw new NullPointerException("Null traceLogEnabled");
      }
      this.traceLogEnabled = traceLogEnabled;
      set$0 |= 0x1_0000;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setOperationTraceLogEnabled(Boolean operationTraceLogEnabled) {
      if (operationTraceLogEnabled == null) {
        throw new NullPointerException("Null operationTraceLogEnabled");
      }
      this.operationTraceLogEnabled = operationTraceLogEnabled;
      set$0 |= 0x2_0000;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTraceLogTimeThreshold(long traceLogTimeThreshold) {
      this.traceLogTimeThreshold = traceLogTimeThreshold;
      set$0 |= 0x4_0000;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTraceLogExcludeProperties(ImmutableSet<String> traceLogExcludeProperties) {
      if (traceLogExcludeProperties == null) {
        throw new NullPointerException("Null traceLogExcludeProperties");
      }
      this.traceLogExcludeProperties = traceLogExcludeProperties;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAuthorizationHandlerImplClass(Class<? extends AuthorizationHandler> authorizationHandlerImplClass) {
      this.authorizationHandlerImplClass = authorizationHandlerImplClass;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAuthorizationHandlerProperties(Map<String, String> authorizationHandlerProperties) {
      if (authorizationHandlerProperties == null) {
        throw new NullPointerException("Null authorizationHandlerProperties");
      }
      this.authorizationHandlerProperties = authorizationHandlerProperties;
      return this;
    }
    @Override
    GoogleCloudStorageOptions autoBuild() {
      if (set$0 != 0x7_ffff
          || this.grpcServerAddress == null
          || this.storageRootUrl == null
          || this.storageServicePath == null
          || this.transportType == null
          || this.readChannelOptions == null
          || this.writeChannelOptions == null
          || this.requesterPaysOptions == null
          || this.cooperativeLockingOptions == null
          || this.httpRequestHeaders == null
          || this.metricsSink == null
          || this.traceLogExcludeProperties == null
          || this.authorizationHandlerProperties == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" grpcEnabled");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" hnBucketRenameEnabled");
        }
        if (this.grpcServerAddress == null) {
          missing.append(" grpcServerAddress");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" trafficDirectorEnabled");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" directPathPreferred");
        }
        if (this.storageRootUrl == null) {
          missing.append(" storageRootUrl");
        }
        if (this.storageServicePath == null) {
          missing.append(" storageServicePath");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" grpcWriteEnabled");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" autoRepairImplicitDirectoriesEnabled");
        }
        if ((set$0 & 0x40) == 0) {
          missing.append(" maxWaitMillisForEmptyObjectCreation");
        }
        if ((set$0 & 0x80) == 0) {
          missing.append(" maxListItemsPerCall");
        }
        if ((set$0 & 0x100) == 0) {
          missing.append(" maxRequestsPerBatch");
        }
        if ((set$0 & 0x200) == 0) {
          missing.append(" batchThreads");
        }
        if ((set$0 & 0x400) == 0) {
          missing.append(" maxHttpRequestRetries");
        }
        if ((set$0 & 0x800) == 0) {
          missing.append(" httpRequestConnectTimeout");
        }
        if ((set$0 & 0x1000) == 0) {
          missing.append(" httpRequestReadTimeout");
        }
        if (this.transportType == null) {
          missing.append(" transportType");
        }
        if ((set$0 & 0x2000) == 0) {
          missing.append(" copyWithRewriteEnabled");
        }
        if ((set$0 & 0x4000) == 0) {
          missing.append(" maxBytesRewrittenPerCall");
        }
        if (this.readChannelOptions == null) {
          missing.append(" readChannelOptions");
        }
        if (this.writeChannelOptions == null) {
          missing.append(" writeChannelOptions");
        }
        if (this.requesterPaysOptions == null) {
          missing.append(" requesterPaysOptions");
        }
        if (this.cooperativeLockingOptions == null) {
          missing.append(" cooperativeLockingOptions");
        }
        if (this.httpRequestHeaders == null) {
          missing.append(" httpRequestHeaders");
        }
        if ((set$0 & 0x8000) == 0) {
          missing.append(" grpcMessageTimeoutCheckInterval");
        }
        if (this.metricsSink == null) {
          missing.append(" metricsSink");
        }
        if ((set$0 & 0x1_0000) == 0) {
          missing.append(" traceLogEnabled");
        }
        if ((set$0 & 0x2_0000) == 0) {
          missing.append(" operationTraceLogEnabled");
        }
        if ((set$0 & 0x4_0000) == 0) {
          missing.append(" traceLogTimeThreshold");
        }
        if (this.traceLogExcludeProperties == null) {
          missing.append(" traceLogExcludeProperties");
        }
        if (this.authorizationHandlerProperties == null) {
          missing.append(" authorizationHandlerProperties");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageOptions(
          this.grpcEnabled,
          this.hnBucketRenameEnabled,
          this.grpcServerAddress,
          this.trafficDirectorEnabled,
          this.directPathPreferred,
          this.storageRootUrl,
          this.storageServicePath,
          this.grpcWriteEnabled,
          this.projectId,
          this.appName,
          this.autoRepairImplicitDirectoriesEnabled,
          this.maxWaitMillisForEmptyObjectCreation,
          this.maxListItemsPerCall,
          this.maxRequestsPerBatch,
          this.batchThreads,
          this.maxHttpRequestRetries,
          this.httpRequestConnectTimeout,
          this.httpRequestReadTimeout,
          this.transportType,
          this.proxyAddress,
          this.proxyUsername,
          this.proxyPassword,
          this.copyWithRewriteEnabled,
          this.maxBytesRewrittenPerCall,
          this.readChannelOptions,
          this.writeChannelOptions,
          this.requesterPaysOptions,
          this.cooperativeLockingOptions,
          this.httpRequestHeaders,
          this.encryptionAlgorithm,
          this.encryptionKey,
          this.encryptionKeyHash,
          this.grpcMessageTimeoutCheckInterval,
          this.metricsSink,
          this.traceLogEnabled,
          this.operationTraceLogEnabled,
          this.traceLogTimeThreshold,
          this.traceLogExcludeProperties,
          this.authorizationHandlerImplClass,
          this.authorizationHandlerProperties);
    }
  }

}
