/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@VisibleForTesting
public enum GrpcStreamType {
    START_RESUMABLE_WRITE("StartResumableWrite"),
    WRITE_OBJECT("WriteObject"),
    READ_OBJECT("ReadObject"),
    OTHER("Other");

    public final String name;
    private static final Map<String, GrpcStreamType> names;

    private GrpcStreamType(String name) {
        this.name = name;
    }

    public static GrpcStreamType getTypeFromName(String name) {
        return names.getOrDefault(name.toUpperCase(), OTHER);
    }

    static {
        names = Arrays.stream(GrpcStreamType.values()).collect(Collectors.toMap(x -> x.name.toUpperCase(), x -> x));
    }
}

