/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.RestorableState;
import com.google.cloud.WriteChannel;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationType;
import com.google.cloud.hadoop.gcsio.cooplock.CoopLockRecordsDao;
import com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.gcsio.cooplock.DeleteOperation;
import com.google.cloud.hadoop.gcsio.cooplock.RenameOperation;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CoopLockIntegrationTest {
    private static final Gson GSON = CoopLockRecordsDao.createGson();
    private static final String OPERATION_FILENAME_PATTERN_FORMAT = "[0-9]{8}T[0-9]{6}\\.[0-9]{3}Z_%s_[a-z0-9\\-]+";
    private static final Duration COOP_LOCK_TIMEOUT = Duration.ofSeconds(30L);
    private static GoogleCloudStorageOptions gcsOptions;
    private static RetryHttpInitializer httpRequestInitializer;
    private static GoogleCloudStorageFileSystemIntegrationHelper gcsfsIHelper;

    @BeforeClass
    public static void before() throws Throwable {
        Credential credential = (Credential)Preconditions.checkNotNull((Object)GoogleCloudStorageTestHelper.getCredential(), (Object)"credential must not be null");
        gcsOptions = GoogleCloudStorageTestHelper.getStandardOptionBuilder().build();
        httpRequestInitializer = new RetryHttpInitializer(credential, gcsOptions.toRetryHttpInitializerOptions());
        GoogleCloudStorageFileSystem gcsfs = new GoogleCloudStorageFileSystem(credential, GoogleCloudStorageFileSystemOptions.builder().setBucketDeleteEnabled(true).setCloudStorageOptions(gcsOptions).build());
        gcsfsIHelper = new GoogleCloudStorageFileSystemIntegrationHelper(gcsfs);
        gcsfsIHelper.beforeAllTests();
    }

    @AfterClass
    public static void afterClass() throws Throwable {
        gcsfsIHelper.afterAllTests();
        GoogleCloudStorageFileSystem gcsfs = CoopLockIntegrationTest.gcsfsIHelper.gcsfs;
        Truth.assertThat((Boolean)gcsfs.exists(new URI("gs://" + CoopLockIntegrationTest.gcsfsIHelper.sharedBucketName1))).isFalse();
        Truth.assertThat((Boolean)gcsfs.exists(new URI("gs://" + CoopLockIntegrationTest.gcsfsIHelper.sharedBucketName2))).isFalse();
    }

    @Test
    public void moveDirectory() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockIntegrationTest.newGcsFsOptions();
        TrackingHttpRequestInitializer trackingRequestInitializer = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestInitializer);
        GoogleCloudStorageFileSystem gcsFs = CoopLockIntegrationTest.newGcsFs(gcsFsOptions, trackingRequestInitializer);
        String bucketName = gcsfsIHelper.createUniqueBucket("coop-rename");
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String dirName = "rename_" + UUID.randomUUID();
        String fileName = "file";
        URI srcDirUri = bucketUri.resolve(dirName + "_src/");
        URI dstDirUri = bucketUri.resolve(dirName + "_dst/");
        gcsfsIHelper.writeTextFile(bucketName, srcDirUri.resolve(fileName).getPath(), "file_content");
        gcsFs.rename(srcDirUri, dstDirUri);
        Truth.assertThat(trackingRequestInitializer.getAllRequestStrings()).containsAtLeast((Object)TrackingHttpRequestInitializer.uploadRequestString(bucketName, "_lock/all.lock", 1), (Object)TrackingHttpRequestInitializer.updateMetadataRequestString(bucketName, "_lock/all.lock", 1), new Object[]{TrackingHttpRequestInitializer.deleteMatchMetaGenerationRequestString(bucketName, "_lock/all.lock", 2)});
        Truth.assertThat((Boolean)gcsFs.exists(srcDirUri)).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(srcDirUri.resolve(fileName))).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(dstDirUri)).isTrue();
        Truth.assertThat((Boolean)gcsFs.exists(dstDirUri.resolve(fileName))).isTrue();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(2);
        String fileNamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.RENAME);
        URI lockFileUri = CoopLockIntegrationTest.matchFile(lockFiles, fileNamePattern + "\\.lock").get();
        URI logFileUri = CoopLockIntegrationTest.matchFile(lockFiles, fileNamePattern + "\\.log").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((RenameOperation)GSON.fromJson(lockContent, RenameOperation.class)).setLockExpiration(null)).isEqualTo((Object)new RenameOperation().setLockExpiration(null).setSrcResource(srcDirUri.toString()).setDstResource(dstDirUri.toString()).setCopySucceeded(true));
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)String.format("{\"src\":\"%s\",\"dst\":\"%s\"}\n", srcDirUri.resolve(fileName), dstDirUri.resolve(fileName)));
    }

    @Test
    public void deleteDirectory() throws Exception {
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockIntegrationTest.newGcsFsOptions();
        TrackingHttpRequestInitializer trackingRequestInitializer = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestInitializer);
        GoogleCloudStorageFileSystem gcsFs = CoopLockIntegrationTest.newGcsFs(gcsFsOptions, trackingRequestInitializer);
        String bucketName = gcsfsIHelper.createUniqueBucket("coop-delete");
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        gcsfsIHelper.writeTextFile(bucketName, dirUri.resolve(fileName).getPath(), "file_content");
        gcsFs.delete(dirUri, true);
        Truth.assertThat(trackingRequestInitializer.getAllRequestStrings()).containsAtLeast((Object)TrackingHttpRequestInitializer.uploadRequestString(bucketName, "_lock/all.lock", 1), (Object)TrackingHttpRequestInitializer.updateMetadataRequestString(bucketName, "_lock/all.lock", 1), new Object[]{TrackingHttpRequestInitializer.deleteMatchMetaGenerationRequestString(bucketName, "_lock/all.lock", 2)});
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(dirUri.resolve(fileName))).isFalse();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(2);
        String fileNamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.DELETE);
        URI lockFileUri = CoopLockIntegrationTest.matchFile(lockFiles, fileNamePattern + "\\.lock").get();
        URI logFileUri = CoopLockIntegrationTest.matchFile(lockFiles, fileNamePattern + "\\.log").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((DeleteOperation)GSON.fromJson(lockContent, DeleteOperation.class)).setLockExpiration(null)).isEqualTo((Object)new DeleteOperation().setLockExpiration(null).setResource(dirUri.toString()));
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)(dirUri.resolve(fileName) + "\n" + dirUri + "\n"));
    }

    @Test
    public void directoryDelete_lockRenewed() throws Exception {
        String bucketName = gcsfsIHelper.createUniqueBucket("coop-delete-lock-renewed");
        URI bucketUri = new URI("gs://" + bucketName + "/");
        String fileName = "file";
        URI dirUri = bucketUri.resolve("delete_" + UUID.randomUUID() + "/");
        URI fileUri = dirUri.resolve(fileName);
        gcsfsIHelper.writeTextFile(bucketName, fileUri.getPath(), "file_content");
        CooperativeLockingOptions coopLockOptions = CooperativeLockingOptions.builder().setLockExpirationTimeoutMilli(COOP_LOCK_TIMEOUT.toMillis()).build();
        GoogleCloudStorageFileSystemOptions gcsFsOptions = CoopLockIntegrationTest.newGcsFsOptions(gcsOptions.toBuilder().setCooperativeLockingOptions(coopLockOptions).build());
        Duration lockRenewalDelay = COOP_LOCK_TIMEOUT.dividedBy(2L);
        Duration lockRenewalTimeout = COOP_LOCK_TIMEOUT.dividedBy(4L);
        String encodedFilePath = URLEncoder.encode(fileUri.getPath().substring(1), StandardCharsets.UTF_8.name());
        HttpRequestInitializer sleepingRequestInitializer = CoopLockIntegrationTest.interceptingRequestInitializer(r -> {
            String reqUrl = "/b/" + bucketName + "/o/" + encodedFilePath;
            if ("DELETE".equals(r.getRequestMethod()) && r.getUrl().toString().contains(reqUrl)) {
                Uninterruptibles.sleepUninterruptibly((Duration)lockRenewalDelay.plus(lockRenewalTimeout));
            }
        });
        GoogleCloudStorageFileSystem sleepingGcsFs = CoopLockIntegrationTest.newGcsFs(gcsFsOptions, sleepingRequestInitializer);
        Instant operationStart = Instant.now();
        sleepingGcsFs.delete(dirUri, true);
        GoogleCloudStorageFileSystem gcsFs = CoopLockIntegrationTest.newGcsFs(gcsFsOptions, (HttpRequestInitializer)httpRequestInitializer);
        Truth.assertThat((Boolean)gcsFs.exists(dirUri)).isFalse();
        Truth.assertThat((Boolean)gcsFs.exists(fileUri)).isFalse();
        List<URI> lockFiles = gcsFs.listFileInfo(bucketUri.resolve("_lock/")).stream().map(FileInfo::getPath).collect(Collectors.toList());
        Truth.assertThat(lockFiles).hasSize(2);
        String filenamePattern = String.format(OPERATION_FILENAME_PATTERN_FORMAT, CoopLockOperationType.DELETE);
        URI lockFileUri = CoopLockIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.lock").get();
        URI logFileUri = CoopLockIntegrationTest.matchFile(lockFiles, filenamePattern + "\\.log").get();
        String lockContent = gcsfsIHelper.readTextFile(bucketName, lockFileUri.getPath());
        Truth.assertThat((Object)((DeleteOperation)GSON.fromJson(lockContent, DeleteOperation.class)).setLockExpiration(null)).isEqualTo((Object)new DeleteOperation().setLockExpiration(null).setResource(dirUri.toString()));
        Truth.assertThat((String)gcsfsIHelper.readTextFile(bucketName, logFileUri.getPath())).isEqualTo((Object)(fileUri + "\n" + dirUri + "\n"));
        Instant expectedRenewedLockExpiration = operationStart.plus(COOP_LOCK_TIMEOUT).plus(lockRenewalDelay);
        Instant renewedLockExpiration = ((DeleteOperation)GSON.fromJson(lockContent, DeleteOperation.class)).getLockExpiration();
        Truth.assertThat((Comparable)renewedLockExpiration).isGreaterThan((Comparable)expectedRenewedLockExpiration);
        Truth.assertThat((Comparable)renewedLockExpiration).isLessThan((Comparable)expectedRenewedLockExpiration.plus(lockRenewalTimeout));
    }

    private static Optional<URI> matchFile(List<URI> files, String pattern) {
        return files.stream().filter(f -> f.toString().matches("^gs://.*/" + pattern + "$")).findAny();
    }

    private static GoogleCloudStorageFileSystemOptions newGcsFsOptions() {
        return CoopLockIntegrationTest.newGcsFsOptions(gcsOptions);
    }

    private static GoogleCloudStorageFileSystemOptions newGcsFsOptions(GoogleCloudStorageOptions gcsOptions) {
        return GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(gcsOptions).setCooperativeLockingEnabled(true).build();
    }

    private static GoogleCloudStorageFileSystem newGcsFs(GoogleCloudStorageFileSystemOptions gcsfsOptions, HttpRequestInitializer requestInitializer) throws IOException {
        return new GoogleCloudStorageFileSystem(o -> new GoogleCloudStorageImpl(o, requestInitializer), gcsfsOptions);
    }

    private static HttpRequestInitializer interceptingRequestInitializer(Consumer<HttpRequest> interceptFn) {
        return request -> {
            httpRequestInitializer.initialize(request);
            HttpExecuteInterceptor executeInterceptor = (HttpExecuteInterceptor)Preconditions.checkNotNull((Object)request.getInterceptor());
            request.setInterceptor(interceptedRequest -> {
                executeInterceptor.intercept(interceptedRequest);
                interceptFn.accept(interceptedRequest);
            });
        };
    }

    public static class FakeWriteChannel
    implements WriteChannel {
        private boolean open = true;
        private final boolean throwExceptionOnWrite;

        public FakeWriteChannel() {
            this.throwExceptionOnWrite = false;
        }

        public FakeWriteChannel(boolean throwExceptionOnWrite) {
            this.throwExceptionOnWrite = throwExceptionOnWrite;
        }

        public void setChunkSize(int i) {
        }

        public RestorableState<WriteChannel> capture() {
            return null;
        }

        public int write(ByteBuffer src) throws IOException {
            if (this.throwExceptionOnWrite) {
                throw new IOException("Intentionally triggered");
            }
            int bytesWritten = 0;
            int capacity = src.capacity();
            if (src.limit() - src.position() <= capacity / 2) {
                bytesWritten = src.limit();
                src.position(src.limit());
            } else {
                bytesWritten = capacity / 2;
                src.position(src.position() + capacity / 2);
            }
            return bytesWritten;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void close() throws IOException {
            this.open = false;
        }
    }
}

