/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.cloud.hadoop.gcsio.AssertingLogHandler;
import com.google.cloud.hadoop.gcsio.EventLoggingHttpRequestInitializer;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EventLoggingHttpRequestInitializerTest {
    private static final String REQUEST_URL = "http://google.com";
    private static final Logger LOGGER = Logger.getLogger(EventLoggingHttpRequestInitializer.class.getName());
    private EventLoggingHttpRequestInitializer requestInitializer;
    private AssertingLogHandler assertingHandler;

    @Before
    public void setUp() throws IOException {
        this.assertingHandler = new AssertingLogHandler();
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(this.assertingHandler);
        LOGGER.setLevel(Level.INFO);
        this.requestInitializer = new EventLoggingHttpRequestInitializer();
    }

    @After
    public void verifyAndRemoveAssertingHandler() {
        LOGGER.removeHandler(this.assertingHandler);
    }

    @Test
    public void testTracingDetailsSetOnSuccess() throws IOException {
        int expectedStatusCode = 201;
        HttpRequest httpRequest = EventLoggingHttpRequestInitializerTest.getHttpRequestWithResponse(MockHttpTransportHelper.emptyResponse((int)expectedStatusCode));
        this.requestInitializer.initialize(httpRequest);
        HttpResponse res = httpRequest.execute();
        Truth.assertThat((Object)res).isNotNull();
        Truth.assertThat((Integer)res.getStatusCode()).isEqualTo((Object)expectedStatusCode);
        this.assertingHandler.assertLogCount(1);
        Map<String, Object> logRecord = this.assertingHandler.getLogRecordAtIndex(0);
        EventLoggingHttpRequestInitializerTest.verifyFields(logRecord, expectedStatusCode);
        Truth.assertThat((Object)logRecord.get("request_start_time_utc")).isNotNull();
        Truth.assertThat((Object)logRecord.get("request_finish_time_utc")).isNotNull();
        Truth.assertThat((Object)logRecord.get("unexpected_error")).isNull();
    }

    @Test
    public void testTracingHeadersSuccess() throws IOException {
        int expectedStatusCode = 201;
        MockLowLevelHttpResponse httpResponse = MockHttpTransportHelper.emptyResponse((int)expectedStatusCode).addHeader("custom-response-header", "responseValue");
        HttpRequest httpRequest = EventLoggingHttpRequestInitializerTest.getHttpRequestWithResponse(httpResponse).setHeaders(new HttpHeaders().set("custom-request-header", (Object)"requestValue"));
        this.requestInitializer.initialize(httpRequest);
        HttpResponse res = httpRequest.execute();
        Truth.assertThat((Object)res).isNotNull();
        Truth.assertThat((Integer)res.getStatusCode()).isEqualTo((Object)expectedStatusCode);
        this.assertingHandler.assertLogCount(1);
        Map<String, Object> logRecord = this.assertingHandler.getLogRecordAtIndex(0);
        EventLoggingHttpRequestInitializerTest.verifyFields(logRecord, expectedStatusCode);
        Object requestHeadersObj = logRecord.get("request_headers");
        Truth.assertThat((Object)requestHeadersObj).isInstanceOf(Map.class);
        Map requestHeadersMap = (Map)requestHeadersObj;
        Truth.assertThat(requestHeadersMap.get("custom-request-header")).isNotNull();
        Object responseHeadersObj = logRecord.get("response_headers");
        Truth.assertThat((Object)responseHeadersObj).isInstanceOf(Map.class);
        Map responseHeadersMap = (Map)responseHeadersObj;
        Truth.assertThat(responseHeadersMap.get("custom-response-header")).isNotNull();
    }

    @Test
    public void testTracingHeadersFiltered() throws IOException {
        int expectedStatusCode = 201;
        MockLowLevelHttpResponse httpResponse = MockHttpTransportHelper.emptyResponse((int)expectedStatusCode).addHeader("Set-Cookie", "cookieName=cookieValue");
        HttpRequest httpRequest = EventLoggingHttpRequestInitializerTest.getHttpRequestWithResponse(httpResponse).setHeaders(new HttpHeaders().set("Authorization", (Object)"Bearer TOKEN").set("Cookie", (Object)"cookieName=cookieValue").set("Proxy-Authorization", (Object)"Basic user/pass"));
        this.requestInitializer.initialize(httpRequest);
        HttpResponse res = httpRequest.execute();
        Truth.assertThat((Object)res).isNotNull();
        Truth.assertThat((Integer)res.getStatusCode()).isEqualTo((Object)expectedStatusCode);
        this.assertingHandler.assertLogCount(1);
        Map<String, Object> logRecord = this.assertingHandler.getLogRecordAtIndex(0);
        EventLoggingHttpRequestInitializerTest.verifyFields(logRecord, expectedStatusCode);
        Object requestHeadersObj = logRecord.get("request_headers");
        Truth.assertThat((Object)requestHeadersObj).isInstanceOf(Map.class);
        Map requestHeadersMap = (Map)requestHeadersObj;
        Truth.assertThat(requestHeadersMap.get("authorization")).isNull();
        Truth.assertThat(requestHeadersMap.get("cookie")).isNull();
        Truth.assertThat(requestHeadersMap.get("proxy-authorization")).isNull();
        Object responseHeadersObj = logRecord.get("response_headers");
        Truth.assertThat((Object)responseHeadersObj).isInstanceOf(Map.class);
        Map responseHeadersMap = (Map)responseHeadersObj;
        Truth.assertThat(responseHeadersMap.get("set-cookie")).isNull();
    }

    @Test
    public void testIOExceptionNoCallback() throws IOException {
        HttpRequest httpRequest = EventLoggingHttpRequestInitializerTest.getHttpRequestWithResponse(new IOException("test IOException"));
        this.requestInitializer.initialize(httpRequest);
        Assert.assertThrows(IOException.class, () -> httpRequest.execute());
        this.assertingHandler.assertLogCount(0);
    }

    @Test
    public void testZombieRequestDoesNotCrash() throws IOException {
        HttpResponse httpResponse = EventLoggingHttpRequestInitializerTest.getHttpRequestWithResponse(MockHttpTransportHelper.emptyResponse((int)200)).execute();
        this.requestInitializer.logAndRemoveRequestFromTracking(httpResponse);
        this.assertingHandler.assertLogCount(1);
        Map<String, Object> logRecord = this.assertingHandler.getLogRecordAtIndex(0);
        EventLoggingHttpRequestInitializerTest.verifyFields(logRecord, 200);
        Truth.assertThat((Object)logRecord.get("unexpected_error")).isEqualTo((Object)"Unknown request. This is unexpected.");
    }

    @Test
    public void testTracingTimeBasedFiltering() throws IOException {
        EventLoggingHttpRequestInitializer initializer = new EventLoggingHttpRequestInitializer(1000L, ImmutableSet.of());
        HttpRequest httpRequest = EventLoggingHttpRequestInitializerTest.getHttpRequestWithResponse(MockHttpTransportHelper.emptyResponse((int)201));
        initializer.initialize(httpRequest);
        HttpResponse res = httpRequest.execute();
        Truth.assertThat((Object)res).isNotNull();
        this.assertingHandler.assertLogCount(0);
    }

    @Test
    public void testTracingPropertyFiltering() throws IOException {
        int expectedStatusCode = 201;
        EventLoggingHttpRequestInitializer initializer = new EventLoggingHttpRequestInitializer(0L, ImmutableSet.of((Object)"request_start_time_utc"));
        HttpRequest httpRequest = EventLoggingHttpRequestInitializerTest.getHttpRequestWithResponse(MockHttpTransportHelper.emptyResponse((int)expectedStatusCode));
        initializer.initialize(httpRequest);
        HttpResponse res = httpRequest.execute();
        Truth.assertThat((Object)res).isNotNull();
        Truth.assertThat((Integer)res.getStatusCode()).isEqualTo((Object)expectedStatusCode);
        this.assertingHandler.assertLogCount(1);
        Map<String, Object> logRecord = this.assertingHandler.getLogRecordAtIndex(0);
        Truth.assertThat((Object)logRecord.get("request_start_time_utc")).isNull();
        Truth.assertThat((Object)logRecord.get("request_finish_time_utc")).isNotNull();
        Truth.assertThat((Object)logRecord.get("unexpected_error")).isNull();
    }

    private static void verifyFields(Map<String, Object> logRecord, int expectedStatusCode) {
        Truth.assertThat((Object)logRecord.get("response_time")).isNotNull();
        Truth.assertThat((Object)logRecord.get("response_headers")).isNotNull();
        Truth.assertThat((Object)logRecord.get("request_headers")).isNotNull();
        Truth.assertThat((Object)logRecord.get("request_method")).isNotNull();
        Truth.assertThat((Object)logRecord.get("request_url")).isEqualTo((Object)REQUEST_URL);
        Truth.assertThat((Object)logRecord.get("response_status_code")).isEqualTo((Object)expectedStatusCode);
    }

    private static HttpRequest getHttpRequestWithResponse(Object response) throws IOException {
        return MockHttpTransportHelper.mockTransport((Object[])new Object[]{response}).createRequestFactory().buildGetRequest(new GenericUrl(REQUEST_URL));
    }
}

