/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.ForwardingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class ForwardingGoogleCloudStorageTest {
    private static final String TEST_STRING = "test";
    private static final List<String> TEST_STRINGS = Lists.newArrayList((Object[])new String[]{"test"});
    private static final StorageResourceId TEST_STORAGE_RESOURCE_ID = new StorageResourceId("test");
    private static final List<StorageResourceId> TEST_STORAGE_RESOURCE_IDS = Lists.newArrayList((Object[])new StorageResourceId[]{TEST_STORAGE_RESOURCE_ID});
    private static final UpdatableItemInfo TEST_ITEM_INFO = new UpdatableItemInfo(TEST_STORAGE_RESOURCE_ID, null);
    private static final List<UpdatableItemInfo> TEST_ITEM_INFOS = Lists.newArrayList((Object[])new UpdatableItemInfo[]{TEST_ITEM_INFO});
    private static final CreateObjectOptions TEST_OBJECT_OPTIONS = CreateObjectOptions.DEFAULT_NO_OVERWRITE;
    private static final CreateBucketOptions TEST_BUCKET_OPTIONS = CreateBucketOptions.builder().setLocation("test").setStorageClass("test").build();
    private static final GoogleCloudStorageReadOptions TEST_READ_OPTIONS = GoogleCloudStorageReadOptions.DEFAULT;
    private ForwardingGoogleCloudStorage gcs;
    @Mock
    private GoogleCloudStorage mockGcsDelegate;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.gcs = new ForwardingGoogleCloudStorage(this.mockGcsDelegate);
    }

    @After
    public void tearDown() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockGcsDelegate});
    }

    @Test
    public void testGetOptions() {
        this.gcs.getOptions();
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).getOptions();
    }

    @Test
    public void testCreateWithResource() throws IOException {
        this.gcs.create(TEST_STORAGE_RESOURCE_ID);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).create((StorageResourceId)ArgumentMatchers.eq((Object)TEST_STORAGE_RESOURCE_ID), (CreateObjectOptions)ArgumentMatchers.eq((Object)CreateObjectOptions.DEFAULT_OVERWRITE));
    }

    @Test
    public void testCreateWithResourceAndOptions() throws IOException {
        this.gcs.create(TEST_STORAGE_RESOURCE_ID, TEST_OBJECT_OPTIONS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).create((StorageResourceId)ArgumentMatchers.eq((Object)TEST_STORAGE_RESOURCE_ID), (CreateObjectOptions)ArgumentMatchers.eq((Object)TEST_OBJECT_OPTIONS));
    }

    @Test
    public void testCreateEmptyObject() throws IOException {
        this.gcs.createEmptyObject(TEST_STORAGE_RESOURCE_ID);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).createEmptyObject((StorageResourceId)ArgumentMatchers.eq((Object)TEST_STORAGE_RESOURCE_ID));
    }

    @Test
    public void testCreateEmptyObjectWithOptions() throws IOException {
        this.gcs.createEmptyObject(TEST_STORAGE_RESOURCE_ID, TEST_OBJECT_OPTIONS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).createEmptyObject((StorageResourceId)ArgumentMatchers.eq((Object)TEST_STORAGE_RESOURCE_ID), (CreateObjectOptions)ArgumentMatchers.eq((Object)TEST_OBJECT_OPTIONS));
    }

    @Test
    public void testCreateEmptyObjects() throws IOException {
        this.gcs.createEmptyObjects(TEST_STORAGE_RESOURCE_IDS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).createEmptyObjects((List)ArgumentMatchers.eq(TEST_STORAGE_RESOURCE_IDS));
    }

    @Test
    public void testCreateEmptyObjectsWithOptions() throws IOException {
        this.gcs.createEmptyObjects(TEST_STORAGE_RESOURCE_IDS, TEST_OBJECT_OPTIONS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).createEmptyObjects((List)ArgumentMatchers.eq(TEST_STORAGE_RESOURCE_IDS), (CreateObjectOptions)ArgumentMatchers.eq((Object)TEST_OBJECT_OPTIONS));
    }

    @Test
    public void testOpen() throws IOException {
        this.gcs.open(TEST_STORAGE_RESOURCE_ID);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).open((StorageResourceId)ArgumentMatchers.eq((Object)TEST_STORAGE_RESOURCE_ID), (GoogleCloudStorageReadOptions)ArgumentMatchers.eq((Object)GoogleCloudStorageReadOptions.DEFAULT));
    }

    @Test
    public void testOpenWithReadOptions() throws IOException {
        this.gcs.open(TEST_STORAGE_RESOURCE_ID, TEST_READ_OPTIONS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).open((StorageResourceId)ArgumentMatchers.eq((Object)TEST_STORAGE_RESOURCE_ID), (GoogleCloudStorageReadOptions)ArgumentMatchers.eq((Object)TEST_READ_OPTIONS));
    }

    @Test
    public void testCreateWithBucket() throws IOException {
        this.gcs.createBucket(TEST_STRING);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).createBucket((String)ArgumentMatchers.eq((Object)TEST_STRING), (CreateBucketOptions)ArgumentMatchers.eq((Object)CreateBucketOptions.DEFAULT));
    }

    @Test
    public void testCreateWithBucketAndOptions() throws IOException {
        this.gcs.createBucket(TEST_STRING, TEST_BUCKET_OPTIONS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).createBucket((String)ArgumentMatchers.eq((Object)TEST_STRING), (CreateBucketOptions)ArgumentMatchers.eq((Object)TEST_BUCKET_OPTIONS));
    }

    @Test
    public void testDeleteBuckets() throws IOException {
        this.gcs.deleteBuckets(TEST_STRINGS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).deleteBuckets((List)ArgumentMatchers.eq(TEST_STRINGS));
    }

    @Test
    public void testDeleteObjects() throws IOException {
        this.gcs.deleteObjects(TEST_STORAGE_RESOURCE_IDS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).deleteObjects((List)ArgumentMatchers.eq(TEST_STORAGE_RESOURCE_IDS));
    }

    @Test
    public void testCopy() throws IOException {
        this.gcs.copy(TEST_STRING, TEST_STRINGS, TEST_STRING, TEST_STRINGS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).copy((String)ArgumentMatchers.eq((Object)TEST_STRING), (List)ArgumentMatchers.eq(TEST_STRINGS), (String)ArgumentMatchers.eq((Object)TEST_STRING), (List)ArgumentMatchers.eq(TEST_STRINGS));
    }

    @Test
    public void testListBucketNames() throws IOException {
        this.gcs.listBucketNames();
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).listBucketNames();
    }

    @Test
    public void testListBucketInfo() throws IOException {
        this.gcs.listBucketInfo();
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).listBucketInfo();
    }

    @Test
    public void testListObjectInfo() throws IOException {
        this.gcs.listObjectInfo(TEST_STRING, TEST_STRING);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).listObjectInfo((String)ArgumentMatchers.eq((Object)TEST_STRING), (String)ArgumentMatchers.eq((Object)TEST_STRING), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT));
    }

    @Test
    public void testListObjectInfoWithMax() throws IOException {
        this.gcs.listObjectInfo(TEST_STRING, TEST_STRING, ListObjectOptions.DEFAULT);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).listObjectInfo((String)ArgumentMatchers.eq((Object)TEST_STRING), (String)ArgumentMatchers.eq((Object)TEST_STRING), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT));
    }

    @Test
    public void testListObjectInfoPage() throws IOException {
        this.gcs.listObjectInfoPage(TEST_STRING, TEST_STRING, TEST_STRING);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).listObjectInfoPage((String)ArgumentMatchers.eq((Object)TEST_STRING), (String)ArgumentMatchers.eq((Object)TEST_STRING), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT), (String)ArgumentMatchers.eq((Object)TEST_STRING));
    }

    @Test
    public void testListObjectInfoPageWithMax() throws IOException {
        this.gcs.listObjectInfoPage(TEST_STRING, TEST_STRING, ListObjectOptions.DEFAULT, TEST_STRING);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).listObjectInfoPage((String)ArgumentMatchers.eq((Object)TEST_STRING), (String)ArgumentMatchers.eq((Object)TEST_STRING), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT), (String)ArgumentMatchers.eq((Object)TEST_STRING));
    }

    @Test
    public void testGetItemInfo() throws IOException {
        this.gcs.getItemInfo(TEST_STORAGE_RESOURCE_ID);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).getItemInfo((StorageResourceId)ArgumentMatchers.eq((Object)TEST_STORAGE_RESOURCE_ID));
    }

    @Test
    public void testGetItemInfos() throws IOException {
        this.gcs.getItemInfos(TEST_STORAGE_RESOURCE_IDS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).getItemInfos((List)ArgumentMatchers.eq(TEST_STORAGE_RESOURCE_IDS));
    }

    @Test
    public void testUpdateItems() throws IOException {
        this.gcs.updateItems(TEST_ITEM_INFOS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).updateItems((List)ArgumentMatchers.eq(TEST_ITEM_INFOS));
    }

    @Test
    public void testClose() {
        this.gcs.close();
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).close();
    }

    @Test
    public void testCompose() throws IOException {
        this.gcs.compose(TEST_STRING, TEST_STRINGS, TEST_STRING, TEST_STRING);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).compose((String)ArgumentMatchers.eq((Object)TEST_STRING), (List)ArgumentMatchers.eq(TEST_STRINGS), (String)ArgumentMatchers.eq((Object)TEST_STRING), (String)ArgumentMatchers.eq((Object)TEST_STRING));
    }

    @Test
    public void testComposeObjects() throws IOException {
        this.gcs.composeObjects(TEST_STORAGE_RESOURCE_IDS, TEST_STORAGE_RESOURCE_ID, TEST_OBJECT_OPTIONS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.mockGcsDelegate)).composeObjects((List)ArgumentMatchers.eq(TEST_STORAGE_RESOURCE_IDS), (StorageResourceId)ArgumentMatchers.eq((Object)TEST_STORAGE_RESOURCE_ID), (CreateObjectOptions)ArgumentMatchers.eq((Object)TEST_OBJECT_OPTIONS));
    }

    @Test
    public void testGetDelegate() {
        GoogleCloudStorage delegate = this.gcs.getDelegate();
        Truth.assertThat((Object)delegate).isEqualTo((Object)this.mockGcsDelegate);
    }

    @Test
    public void delegate_throwsExceptionWhenNull() {
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new ForwardingGoogleCloudStorage(null));
        Truth.assertThat((Throwable)exception).hasMessageThat().startsWith("delegate must not be null");
    }
}

