/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.ReadChannel;
import com.google.cloud.hadoop.gcsio.FakeReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientReadChannel;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.ErrorTypeExtractor;
import com.google.cloud.hadoop.util.GrpcErrorTypeExtractor;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageClientReadChannelTest {
    private static final String V1_BUCKET_NAME = "bucket-name";
    private static final String OBJECT_NAME = "object-name";
    private static final int CHUNK_SIZE = 1024;
    private static final int OBJECT_SIZE = 0x100000;
    private static final int IN_PLACE_SEEK_LIMIT = 5;
    private static final StorageResourceId RESOURCE_ID = new StorageResourceId("bucket-name", "object-name");
    private static final ByteString CONTENT = GoogleCloudStorageTestHelper.createTestData(0x100000);
    private static final GoogleCloudStorageReadOptions DEFAULT_READ_OPTION = GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.RANDOM).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).setMinRangeRequestSize(1024).build();
    private static final GoogleCloudStorageItemInfo DEFAULT_ITEM_INFO = GoogleCloudStorageItemInfo.createObject((StorageResourceId)RESOURCE_ID, (long)10L, (long)15L, (long)0x100000L, (String)"text/plain", (String)"text", null, (long)1L, (long)2L, null);
    private ReadChannel fakeReadChannel;
    private Storage mockedStorage = (Storage)Mockito.mock(Storage.class);
    private GoogleCloudStorageClientReadChannel readChannel;

    @Before
    public void setUp() throws IOException {
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT));
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        this.readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, DEFAULT_READ_OPTION);
    }

    @Test
    public void inValidSeekPositions() {
        int seekPosition = -1;
        Assert.assertThrows(EOFException.class, () -> this.readChannel.position((long)seekPosition));
        Assert.assertThrows(EOFException.class, () -> this.readChannel.position(0x100000L));
    }

    @Test
    public void readThrowsClosedChannel() throws IOException {
        this.readChannel.close();
        Assert.assertThrows(ClosedChannelException.class, () -> this.readChannel.read(ByteBuffer.allocate(1)));
    }

    @Test
    public void closingClosedChannel() throws IOException {
        this.readChannel.read(ByteBuffer.allocate(1));
        this.readChannel.close();
        this.readChannel.close();
        this.readChannel.close();
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void readSingleChunkSuccess() throws IOException {
        int readBytes = 100;
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT));
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        this.readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, DEFAULT_READ_OPTION);
        int startPosition = 0;
        this.readChannel.position((long)startPosition);
        Truth.assertThat((Long)this.readChannel.position()).isEqualTo((Object)startPosition);
        ByteBuffer buffer = ByteBuffer.allocate(readBytes);
        this.readChannel.read(buffer);
        this.verifyContent(buffer, startPosition, readBytes);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).limit(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).read((ByteBuffer)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void readMultipleChunkSuccessSequential() throws IOException {
        int chunksToRead = 2;
        int chunkSize = 1024;
        int readBytes = chunksToRead * chunkSize;
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT));
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        GoogleCloudStorageClientReadChannel readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.SEQUENTIAL).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).setMinRangeRequestSize(chunkSize).build());
        int startPosition = 0;
        readChannel.position((long)startPosition);
        Truth.assertThat((Long)readChannel.position()).isEqualTo((Object)startPosition);
        ByteBuffer buffer = ByteBuffer.allocate(readBytes);
        readChannel.read(buffer);
        this.verifyContent(buffer, startPosition, readBytes);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).limit(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)chunksToRead))).read((ByteBuffer)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void readFullObject() throws IOException {
        int chunkSize = 1024;
        long startPosition = 0L;
        this.readChannel.position(startPosition);
        Truth.assertThat((Long)this.readChannel.position()).isEqualTo((Object)startPosition);
        ByteBuffer buffer = ByteBuffer.allocate(chunkSize);
        for (int totalBytesRead = 0; totalBytesRead < 0x100000; totalBytesRead += buffer.limit()) {
            this.readChannel.position((long)totalBytesRead);
            Truth.assertThat((Long)this.readChannel.position()).isEqualTo((Object)totalBytesRead);
            buffer.clear();
            this.readChannel.read(buffer);
            this.verifyContent(buffer, totalBytesRead, chunkSize);
        }
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)(0x100000 / chunkSize)))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)(0x100000 / chunkSize)))).limit(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)(0x100000 / chunkSize)))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)(0x100000 / chunkSize)))).close();
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)(0x100000 / chunkSize * 2 - 1)))).read((ByteBuffer)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void fadviseAuto_onForwardRead_switchesToRandom() throws IOException {
        int chunkSize = 1024;
        int seekPosition = 2048;
        GoogleCloudStorageClientReadChannel readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).setMinRangeRequestSize(chunkSize).build());
        ByteBuffer buffer = ByteBuffer.allocate(chunkSize);
        readChannel.read(buffer);
        Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isFalse();
        this.verifyContent(buffer, 0, chunkSize);
        buffer.clear();
        readChannel.position((long)seekPosition);
        readChannel.read(buffer);
        Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isTrue();
        this.verifyContent(buffer, seekPosition, chunkSize);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).limit(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).close();
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void fadviseAuto_onBackwardRead_switchesToRandom() throws IOException {
        int chunkSize = 1024;
        int seekPosition = 2048;
        GoogleCloudStorageClientReadChannel readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, GoogleCloudStorageReadOptions.builder().setFadvise(GoogleCloudStorageReadOptions.Fadvise.AUTO).setGrpcChecksumsEnabled(true).setInplaceSeekLimit(5L).setMinRangeRequestSize(chunkSize).build());
        ByteBuffer buffer = ByteBuffer.allocate(chunkSize);
        readChannel.position((long)seekPosition);
        readChannel.read(buffer);
        Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isFalse();
        this.verifyContent(buffer, seekPosition, chunkSize);
        buffer.clear();
        readChannel.position(0L);
        readChannel.read(buffer);
        Truth.assertThat((Boolean)readChannel.randomAccessStatus()).isTrue();
        this.verifyContent(buffer, 0, chunkSize);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).limit(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).close();
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void footerPrefetch_reused() throws IOException {
        int chunkSize;
        int footerSize = chunkSize = 1024;
        int startPosition = 0x100000 - (new Random().nextInt(footerSize - 1) + 1);
        this.readChannel.position((long)startPosition);
        Truth.assertThat((Long)this.readChannel.position()).isEqualTo((Object)startPosition);
        int bytesToRead = 1;
        ByteBuffer buffer = ByteBuffer.allocate(bytesToRead);
        this.readChannel.read(buffer);
        this.verifyContent(buffer, startPosition, bytesToRead);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).limit(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).read((ByteBuffer)ArgumentMatchers.any());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).close();
        startPosition = 0x100000 - new Random().nextInt(footerSize);
        this.readChannel.position((long)startPosition);
        buffer.clear();
        this.readChannel.read(buffer);
        this.verifyContent(buffer, startPosition, bytesToRead);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void read_whenBufferIsEmpty() throws IOException {
        ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[0]);
        this.readChannel.read(emptyBuffer);
        Truth.assertThat((Integer)this.readChannel.read(emptyBuffer)).isEqualTo((Object)0);
    }

    @Test
    public void read_whenPositionIsEqualToSize() throws IOException {
        this.readChannel = this.getJavaStorageChannel(GoogleCloudStorageItemInfo.createObject((StorageResourceId)RESOURCE_ID, (long)10L, (long)15L, (long)0L, (String)"text/plain", (String)"text", null, (long)1L, (long)2L, null), GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setSupportGzipEncoding(false).build());
        ByteBuffer readBuffer = ByteBuffer.wrap(new byte[1]);
        Truth.assertThat((Long)this.readChannel.position()).isEqualTo((Object)this.readChannel.size());
        Truth.assertThat((Integer)this.readChannel.read(readBuffer)).isEqualTo((Object)-1);
    }

    @Test
    public void gzipEncodedObject_throwWhileChannelCreation() {
        Assert.assertThrows(IOException.class, () -> this.getJavaStorageChannel(GoogleCloudStorageItemInfo.createObject((StorageResourceId)RESOURCE_ID, (long)10L, (long)15L, (long)0L, (String)"text/plain", (String)"gzip", null, (long)1L, (long)2L, null), GoogleCloudStorageReadOptions.DEFAULT.toBuilder().setSupportGzipEncoding(false).build()));
    }

    @Test
    public void verifyInPlaceSeek() throws IOException {
        int startPosition = 0;
        int bytesToRead = 100;
        this.readChannel.position((long)startPosition);
        Truth.assertThat((Long)this.readChannel.position()).isEqualTo((Object)startPosition);
        ByteBuffer buffer = ByteBuffer.allocate(bytesToRead);
        this.readChannel.read(buffer);
        this.verifyContent(buffer, startPosition, bytesToRead);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).limit(ArgumentMatchers.anyLong());
        buffer.clear();
        int seekPosition = startPosition + bytesToRead + 5;
        this.readChannel.position((long)seekPosition);
        this.readChannel.read(buffer);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)3))).read((ByteBuffer)ArgumentMatchers.any());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)0))).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void readThrowException() throws IOException {
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT, (List<FakeReadChannel.REQUEST_TYPE>)ImmutableList.of((Object)((Object)FakeReadChannel.REQUEST_TYPE.READ_EXCEPTION))));
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        this.readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, DEFAULT_READ_OPTION);
        int startPosition = 0;
        this.readChannel.position((long)startPosition);
        Assert.assertThrows(IOException.class, () -> this.readChannel.read(ByteBuffer.allocate(1)));
    }

    @Test
    public void closeThrowsException() throws IOException {
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT){

            @Override
            public void close() {
                throw new RuntimeException("Runtime exception while closing content Channel");
            }
        });
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        this.readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, DEFAULT_READ_OPTION);
        this.readChannel.read(ByteBuffer.allocate(1024));
        this.readChannel.close();
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).limit(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).read((ByteBuffer)ArgumentMatchers.any());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void partialReadThrows() throws IOException {
        int readBytes = 10;
        int partialByteRead = readBytes / 2;
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT, (List<FakeReadChannel.REQUEST_TYPE>)ImmutableList.of((Object)((Object)FakeReadChannel.REQUEST_TYPE.PARTIAL_READ))));
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        this.readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, DEFAULT_READ_OPTION);
        ByteBuffer buffer = ByteBuffer.allocate(readBytes);
        Assert.assertThrows(IOException.class, () -> this.readChannel.read(buffer));
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).limit(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).read((ByteBuffer)ArgumentMatchers.any());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).close();
        Truth.assertThat((Integer)buffer.position()).isEqualTo((Object)partialByteRead);
        Truth.assertThat((Long)this.readChannel.position()).isEqualTo((Object)partialByteRead);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void readThrowsEventuallyPass() throws IOException {
        int readBytes = 10;
        int partialByteRead = readBytes / 2;
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT, (List<FakeReadChannel.REQUEST_TYPE>)ImmutableList.of((Object)((Object)FakeReadChannel.REQUEST_TYPE.PARTIAL_READ), (Object)((Object)FakeReadChannel.REQUEST_TYPE.READ_CHUNK))));
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        this.readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, DEFAULT_READ_OPTION);
        ByteBuffer buffer = ByteBuffer.allocate(readBytes);
        Assert.assertThrows(IOException.class, () -> this.readChannel.read(buffer));
        Truth.assertThat((Integer)buffer.position()).isEqualTo((Object)partialByteRead);
        Truth.assertThat((Long)this.readChannel.position()).isEqualTo((Object)partialByteRead);
        this.readChannel.read(buffer);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).limit(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).read((ByteBuffer)ArgumentMatchers.any());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).close();
        Truth.assertThat((Integer)buffer.position()).isEqualTo((Object)readBytes);
        this.verifyContent(buffer, 0, readBytes);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void contentChannelCreationException() throws IOException {
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT){

            @Override
            public void seek(long seek) throws IOException {
                throw new IOException("Intentionally triggered while setting position for content channel");
            }
        });
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        this.readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, DEFAULT_READ_OPTION);
        Assert.assertThrows(IOException.class, () -> this.readChannel.read(ByteBuffer.allocate(1)));
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT){

            @Override
            public ReadChannel limit(long seek) {
                throw new RuntimeException("Intentionally triggered while setting position for content channel");
            }
        });
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        this.readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, DEFAULT_READ_OPTION);
        Assert.assertThrows(IOException.class, () -> this.readChannel.read(ByteBuffer.allocate(1)));
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).seek(ArgumentMatchers.anyLong());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)1))).limit(ArgumentMatchers.anyLong());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.fakeReadChannel});
    }

    @Test
    public void requestRangeOverlapWithCachedFooter() throws IOException {
        int chunkSize;
        int footerSize = chunkSize = 1024;
        int startPosition = 0x100000 - footerSize;
        this.fakeReadChannel = (ReadChannel)Mockito.spy((Object)new FakeReadChannel(CONTENT));
        Mockito.when((Object)this.mockedStorage.reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)this.fakeReadChannel);
        this.readChannel = this.getJavaStorageChannel(DEFAULT_ITEM_INFO, DEFAULT_READ_OPTION);
        this.readChannel.position((long)startPosition);
        Truth.assertThat((Long)this.readChannel.position()).isEqualTo((Object)startPosition);
        ByteBuffer buffer = ByteBuffer.allocate(chunkSize);
        this.readChannel.read(buffer);
        this.verifyContent(buffer, startPosition, chunkSize);
        buffer.clear();
        this.readChannel.position((long)(--startPosition));
        this.readChannel.read(buffer);
        this.verifyContent(buffer, startPosition, chunkSize);
        ArgumentCaptor seekValue = ArgumentCaptor.forClass(Long.class);
        ArgumentCaptor limitValue = ArgumentCaptor.forClass(Long.class);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).seek(((Long)seekValue.capture()).longValue());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).limit(((Long)limitValue.capture()).longValue());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).setChunkSize(0);
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)3))).read((ByteBuffer)ArgumentMatchers.any());
        ((ReadChannel)Mockito.verify((Object)this.fakeReadChannel, (VerificationMode)Mockito.times((int)2))).close();
        Truth.assertThat((Long)((Long)seekValue.getAllValues().get(0))).isEqualTo((Object)(0x100000 - footerSize));
        Truth.assertThat((Long)((Long)limitValue.getAllValues().get(0))).isEqualTo((Object)0x100000);
        Truth.assertThat((Long)((Long)seekValue.getAllValues().get(1))).isEqualTo((Object)startPosition);
        Truth.assertThat((Long)((Long)limitValue.getAllValues().get(1))).isEqualTo((Object)(startPosition + 1));
    }

    private void verifyContent(ByteBuffer buffer, int startPosition, int length) {
        Truth.assertThat((Integer)buffer.position()).isEqualTo((Object)length);
        GoogleCloudStorageTestHelper.assertByteArrayEquals(buffer.array(), CONTENT.substring(startPosition, startPosition + length).toByteArray());
    }

    private GoogleCloudStorageClientReadChannel getJavaStorageChannel(GoogleCloudStorageItemInfo itemInfo, GoogleCloudStorageReadOptions readOptions) throws IOException {
        GoogleCloudStorageItemInfo objectInfo = itemInfo;
        if (itemInfo == null) {
            objectInfo = DEFAULT_ITEM_INFO;
        }
        return new GoogleCloudStorageClientReadChannel(this.mockedStorage, objectInfo, readOptions, (ErrorTypeExtractor)GrpcErrorTypeExtractor.INSTANCE, GoogleCloudStorageOptions.DEFAULT.toBuilder().build());
    }
}

