/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public class GoogleCloudStorageFileSystemIntegrationHelper
extends GoogleCloudStorageIntegrationHelper {
    public final GoogleCloudStorageFileSystem gcsfs;

    public static GoogleCloudStorageFileSystem createGcsFs(String projectId) throws IOException {
        GoogleCloudStorageOptions gcsOptions = GoogleCloudStorageOptions.builder().setAppName("GHFS/test").setProjectId(projectId).setCopyWithRewriteEnabled(true).build();
        return new GoogleCloudStorageFileSystem(GoogleCloudStorageTestHelper.getCredential(), GoogleCloudStorageFileSystemOptions.builder().setBucketDeleteEnabled(true).setCloudStorageOptions(gcsOptions).build());
    }

    public static GoogleCloudStorageFileSystemIntegrationHelper create() throws IOException {
        String projectId = (String)Preconditions.checkNotNull((Object)TestConfiguration.getInstance().getProjectId(), (Object)"projectId can not be null");
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemIntegrationHelper.createGcsFs(projectId);
        return new GoogleCloudStorageFileSystemIntegrationHelper(gcsFs);
    }

    @Override
    protected WritableByteChannel create(URI path, CreateFileOptions options) throws IOException {
        return this.gcsfs.create(path, options);
    }

    public GoogleCloudStorageFileSystemIntegrationHelper(GoogleCloudStorageFileSystem gcsfs) {
        super(gcsfs.getGcs());
        this.gcsfs = (GoogleCloudStorageFileSystem)Preconditions.checkNotNull((Object)gcsfs);
    }

    @Override
    protected SeekableByteChannel open(String bucketName, String objectName) throws IOException {
        URI path = this.getPath(bucketName, objectName);
        return this.gcsfs.open(path);
    }

    @Override
    protected SeekableByteChannel open(URI path) throws IOException {
        return this.gcsfs.open(path);
    }

    @Override
    protected SeekableByteChannel open(String bucketName, String objectName, GoogleCloudStorageReadOptions readOptions) throws IOException {
        URI path = this.getPath(bucketName, objectName);
        return this.open(path, readOptions);
    }

    @Override
    protected SeekableByteChannel open(URI path, GoogleCloudStorageReadOptions readOptions) throws IOException {
        return this.gcsfs.open(path, readOptions);
    }

    @Override
    protected void mkdir(String bucketName, String objectName) throws IOException {
        URI path = this.getPath(bucketName, objectName);
        this.gcsfs.mkdir(path);
    }

    @Override
    protected void mkdir(String bucketName) throws IOException {
        URI path = this.getPath(bucketName, null);
        this.gcsfs.mkdir(path);
    }

    @Override
    protected void delete(String bucketName) throws IOException {
        URI path = this.getPath(bucketName, null);
        this.gcsfs.delete(path, false);
    }

    @Override
    protected void delete(String bucketName, String objectName) throws IOException {
        URI path = this.getPath(bucketName, objectName);
        this.gcsfs.delete(path, false);
    }

    protected boolean delete(URI path, boolean recursive) throws IOException {
        this.gcsfs.delete(path, recursive);
        return true;
    }

    @Override
    protected void clearBucket(String bucketName) throws IOException {
        URI path = this.getPath(bucketName, null);
        for (FileInfo fileInfo : this.gcsfs.listFileInfo(path)) {
            this.gcsfs.delete(fileInfo.getPath(), true);
        }
    }

    protected boolean rename(URI src, URI dst) throws IOException {
        this.gcsfs.rename(src, dst);
        return true;
    }

    protected boolean mkdirs(URI path) throws IOException {
        this.gcsfs.mkdirs(path);
        return true;
    }

    protected boolean compose(List<URI> sources, URI destination, String contentType) throws IOException {
        this.gcsfs.compose(sources, destination, contentType);
        return true;
    }

    protected boolean exists(URI path) throws IOException {
        return this.gcsfs.exists(path);
    }

    protected boolean isDirectory(URI path) throws IOException {
        return this.gcsfs.getFileInfo(path).isDirectory();
    }

    public URI getPath(String bucketName, String objectName) {
        return UriPaths.fromStringPathComponents((String)bucketName, (String)objectName, (boolean)true);
    }

    public String getItemName(URI src) {
        return this.gcsfs.getItemName(src);
    }
}

