/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemNewIntegrationTestBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.CredentialAdapter;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.URI;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageFileSystemJavaStorageNewIntegrationTest
extends GoogleCloudStorageFileSystemNewIntegrationTestBase {
    @BeforeClass
    public static void beforeClass() throws Throwable {
        Credential credential = (Credential)Preconditions.checkNotNull((Object)GoogleCloudStorageTestHelper.getCredential(), (Object)"credential must not be null");
        gcsOptions = GoogleCloudStorageTestHelper.getStandardOptionBuilder().setBatchThreads(0).setCopyWithRewriteEnabled(false).build();
        httpRequestsInitializer = new RetryHttpInitializer(credential, gcsOptions.toRetryHttpInitializerOptions());
        GoogleCloudStorageFileSystem gcsfs = new GoogleCloudStorageFileSystem(credential, GoogleCloudStorageFileSystemOptions.builder().setBucketDeleteEnabled(true).setCloudStorageOptions(gcsOptions).setClientType(GoogleCloudStorageFileSystemOptions.ClientType.STORAGE_CLIENT).build());
        gcsfsIHelper = new GoogleCloudStorageFileSystemIntegrationHelper(gcsfs);
        gcsfsIHelper.beforeAllTests();
    }

    @AfterClass
    public static void afterClass() throws Throwable {
        gcsfsIHelper.afterAllTests();
        GoogleCloudStorageFileSystem gcsfs = GoogleCloudStorageFileSystemJavaStorageNewIntegrationTest.gcsfsIHelper.gcsfs;
        Truth.assertThat((Boolean)gcsfs.exists(new URI("gs://" + GoogleCloudStorageFileSystemJavaStorageNewIntegrationTest.gcsfsIHelper.sharedBucketName1))).isFalse();
        Truth.assertThat((Boolean)gcsfs.exists(new URI("gs://" + GoogleCloudStorageFileSystemJavaStorageNewIntegrationTest.gcsfsIHelper.sharedBucketName2))).isFalse();
    }

    @Override
    protected GoogleCloudStorageFileSystem newGcsFs(GoogleCloudStorageFileSystemOptions gcsfsOptions, TrackingHttpRequestInitializer gcsRequestsTracker) throws IOException {
        return new GoogleCloudStorageFileSystem(options -> GoogleCloudStorageClientImpl.builder().setOptions(options).setCredential(httpRequestsInitializer.getCredential()).setCredentials((Credentials)new CredentialAdapter(httpRequestsInitializer.getCredential())).setHttpRequestInitializer((HttpRequestInitializer)gcsRequestsTracker).build(), gcsfsOptions);
    }
}

