/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.gcsio.CoopLockIntegrationTest;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.ThrowingInputStream;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.gcsio.testing.MockGoogleCloudStorageImplFactory;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.cloud.hadoop.util.testing.MockHttpTransportHelper;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BlobWriteSession;
import com.google.cloud.storage.Storage;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileAlreadyExistsException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class GoogleCloudStorageImplCreateTest {
    private static final String BUCKET_NAME = "foo-bucket";
    private static final String OBJECT_NAME = "bar-object";
    private static final Storage mockedJavaClientStorage = (Storage)Mockito.mock(Storage.class);
    private final BlobWriteSession mockBlobWriteSession = (BlobWriteSession)Mockito.mock(BlobWriteSession.class);
    private final boolean testStorageClientImpl;
    private GoogleCloudStorageOptions gcsOptions;

    private com.google.api.services.storage.Storage createStorage() throws IOException {
        return new Storage.Builder(HttpTransportFactory.createHttpTransport((HttpTransportFactory.HttpTransportType)HttpTransportFactory.HttpTransportType.JAVA_NET), (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)new RetryHttpInitializer(null, "foo-user-agent")).build();
    }

    public GoogleCloudStorageImplCreateTest(boolean tesStorageClientImpl) {
        this.testStorageClientImpl = tesStorageClientImpl;
    }

    @Parameterized.Parameters
    public static Iterable<Boolean> javaClientEnabled() {
        return ImmutableList.of((Object)false, (Object)true);
    }

    @Before
    public void setUp() {
        this.gcsOptions = GoogleCloudStorageOptions.builder().setAppName("gcsio-unit-test").setProjectId("google.com:foo-project").setGrpcEnabled(this.testStorageClientImpl).build();
    }

    @Test
    public void testCreateObjectApiError() throws IOException {
        final Error fakeError = new Error("Fake error");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ThrowingInputStream(null, fakeError))});
        Mockito.when((Object)mockedJavaClientStorage.blobWriteSession((BlobInfo)ArgumentMatchers.any(), (Storage.BlobWriteOption[])ArgumentMatchers.any())).thenReturn((Object)this.mockBlobWriteSession);
        Mockito.when((Object)this.mockBlobWriteSession.open()).thenReturn((Object)new CoopLockIntegrationTest.FakeWriteChannel(){

            @Override
            public void close() {
                throw fakeError;
            }
        });
        GoogleCloudStorage gcs = this.getCloudStorageImpl((HttpTransport)transport, this.gcsOptions);
        WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        Error thrown = (Error)Assert.assertThrows(Error.class, writeChannel::close);
        Truth.assertThat((Throwable)thrown).isEqualTo((Object)fakeError);
    }

    @Test
    public void testCreateObjectOverwriteFile() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTestHelper.newStorageObject(BUCKET_NAME, OBJECT_NAME))});
        GoogleCloudStorage gcs = this.getCloudStorageImpl((HttpTransport)transport, this.gcsOptions);
        WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME), CreateObjectOptions.DEFAULT_OVERWRITE);
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
    }

    @Test
    public void testCreateObjectFileAlreadyPresent() throws IOException {
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonDataResponse((Object)GoogleCloudStorageTestHelper.newStorageObject(BUCKET_NAME, OBJECT_NAME))});
        GoogleCloudStorage gcs = this.getCloudStorageImpl((HttpTransport)transport, this.gcsOptions);
        FileAlreadyExistsException thrown = (FileAlreadyExistsException)Assert.assertThrows(FileAlreadyExistsException.class, () -> gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME), CreateObjectOptions.DEFAULT_NO_OVERWRITE));
        Truth.assertThat((Throwable)thrown).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    public void testCreateObjectApiRuntimeException() throws IOException {
        final RuntimeException fakeException = new RuntimeException("Fake exception");
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.inputStreamResponse((String)"Content-Length", (Object)1, (InputStream)new ThrowingInputStream(null, fakeException))});
        Mockito.when((Object)mockedJavaClientStorage.blobWriteSession((BlobInfo)ArgumentMatchers.any(), (Storage.BlobWriteOption[])ArgumentMatchers.any())).thenReturn((Object)this.mockBlobWriteSession);
        Mockito.when((Object)this.mockBlobWriteSession.open()).thenReturn((Object)new CoopLockIntegrationTest.FakeWriteChannel(){

            @Override
            public void close() {
                throw fakeException;
            }
        });
        GoogleCloudStorage gcs = this.getCloudStorageImpl((HttpTransport)transport, this.gcsOptions);
        WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
        Truth.assertThat((Throwable)thrown).hasCauseThat().isEqualTo((Object)fakeException);
    }

    @Test
    public void testCreateObjectApiInterruptedException() throws Exception {
        final CountDownLatch waitForEverLatch = new CountDownLatch(1);
        final CountDownLatch writeStartedLatch = new CountDownLatch(2);
        final CountDownLatch threadsDoneLatch = new CountDownLatch(2);
        MockHttpTransport transport = MockHttpTransportHelper.mockTransport((Object[])new Object[]{MockHttpTransportHelper.jsonErrorResponse((MockHttpTransportHelper.ErrorResponses)MockHttpTransportHelper.ErrorResponses.NOT_FOUND), MockHttpTransportHelper.arbitraryInputStreamSupplier(() -> {
            try {
                writeStartedLatch.countDown();
                waitForEverLatch.await();
                Assert.fail((String)"Unexpected to get here.");
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                threadsDoneLatch.countDown();
            }
            return null;
        })});
        Mockito.when((Object)mockedJavaClientStorage.blobWriteSession((BlobInfo)ArgumentMatchers.any(), (Storage.BlobWriteOption[])ArgumentMatchers.any())).thenReturn((Object)this.mockBlobWriteSession);
        Mockito.when((Object)this.mockBlobWriteSession.open()).thenReturn((Object)new CoopLockIntegrationTest.FakeWriteChannel(){

            @Override
            public void close() {
                try {
                    writeStartedLatch.countDown();
                    waitForEverLatch.await();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    threadsDoneLatch.countDown();
                }
                Assert.fail((String)"Unexpected to get here.");
            }
        });
        GoogleCloudStorage gcs = this.getCloudStorageImpl((HttpTransport)transport, this.gcsOptions);
        WritableByteChannel writeChannel = gcs.create(new StorageResourceId(BUCKET_NAME, OBJECT_NAME));
        Truth.assertThat((Boolean)writeChannel.isOpen()).isTrue();
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<?> write = executorService.submit(() -> {
            writeStartedLatch.countDown();
            try {
                IOException ioe = (IOException)Assert.assertThrows(IOException.class, writeChannel::close);
                Truth.assertThat((Throwable)ioe).isInstanceOf(ClosedByInterruptException.class);
            }
            finally {
                threadsDoneLatch.countDown();
            }
        });
        Truth.assertWithMessage((String)"Neither thread started.").that(Boolean.valueOf(writeStartedLatch.await(5000L, TimeUnit.MILLISECONDS))).isTrue();
        write.cancel(true);
        Truth.assertWithMessage((String)"Failed to wait for tasks to get interrupted.").that(Boolean.valueOf(threadsDoneLatch.await(5000L, TimeUnit.MILLISECONDS))).isTrue();
    }

    private GoogleCloudStorage getCloudStorageImpl(HttpTransport transport, GoogleCloudStorageOptions options) throws IOException {
        if (options != null) {
            return this.testStorageClientImpl ? MockGoogleCloudStorageImplFactory.mockedGcsClientImpl(options, transport, mockedJavaClientStorage) : MockGoogleCloudStorageImplFactory.mockedGcs(options, transport);
        }
        return this.testStorageClientImpl ? MockGoogleCloudStorageImplFactory.mockedGcsClientImpl(transport, mockedJavaClientStorage) : MockGoogleCloudStorageImplFactory.mockedGcs(transport);
    }
}

