/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class GoogleCloudStorageNewIntegrationTestBase {
    protected static final CreateObjectOptions GZIP_CREATE_OPTIONS = CreateObjectOptions.DEFAULT_NO_OVERWRITE.toBuilder().setContentEncoding("gzip").build();
    private static final ListObjectOptions INCLUDE_PREFIX_LIST_OPTIONS = ListObjectOptions.DEFAULT.toBuilder().setIncludePrefix(true).build();
    protected static GoogleCloudStorageOptions gcsOptions;
    protected static RetryHttpInitializer httpRequestsInitializer;
    protected static GoogleCloudStorageFileSystemIntegrationHelper gcsfsIHelper;
    @Rule
    public TestName name = new TestName();
    protected TrackingHttpRequestInitializer gcsRequestsTracker;
    protected boolean isTracingSupported = false;
    private GoogleCloudStorage gcs;

    @Before
    public void before() {
        this.gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
    }

    @After
    public void after() {
        if (this.gcs != null) {
            this.gcs.close();
            this.gcs = null;
        }
    }

    @Test
    public void listObjectInfo_nonExistentBucket_nullPrefix() throws Exception {
        this.list_nonExistentBucket_nullPrefix((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonExistentBucket_nullPrefix() throws Exception {
        this.list_nonExistentBucket_nullPrefix((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonExistentBucket_nullPrefix(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = "list-neb-np_" + UUID.randomUUID();
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).isEmpty();
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_emptyBucket_nullPrefix() throws Exception {
        this.list_emptyBucket_nullPrefix((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_emptyBucket_nullPrefix() throws Exception {
        this.list_emptyBucket_nullPrefix((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_emptyBucket_nullPrefix(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-eb-np");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).isEmpty();
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_nonEmptyBucket_nullPrefix_object() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_object((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonEmptyBucket_nullPrefix_object() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_object((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonEmptyBucket_nullPrefix_object(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-neb-np-o");
        gcsfsIHelper.createObjects(testBucket, "obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).containsExactly(new Object[]{"obj"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_nonEmptyBucket_nullPrefix_emptyDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_emptyDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonEmptyBucket_nullPrefix_emptyDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_emptyDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonEmptyBucket_nullPrefix_emptyDir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-neb-np-ed_");
        gcsfsIHelper.createObjects(testBucket, "dir/");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).containsExactly(new Object[]{"dir/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_nonEmptyBucket_nullPrefix_subDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_subDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonEmptyBucket_nullPrefix_subDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_subDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonEmptyBucket_nullPrefix_subDir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-neb-np-sd");
        gcsfsIHelper.createObjects(testBucket, "subdir/", "subdir/obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).containsExactly(new Object[]{"subdir/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_nonEmptyBucket_nullPrefix_implicitSubDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_implicitSubDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_nonEmptyBucket_nullPrefix_implicitSubDir() throws Exception {
        this.list_nonEmptyBucket_nullPrefix_implicitSubDir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_nonEmptyBucket_nullPrefix_implicitSubDir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.createUniqueBucket("list-neb-np-isd");
        gcsfsIHelper.createObjects(testBucket, "subdir/obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, null);
        Truth.assertThat(listResult).containsExactly(new Object[]{"subdir/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, null)});
    }

    @Test
    public void listObjectInfo_prefix_doesNotExist() throws Exception {
        this.list_prefix_doesNotExist((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefix_doesNotExist() throws Exception {
        this.list_prefix_doesNotExist((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefix_doesNotExist(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = String.format("list_prefix_doesNotExist_%s/", UUID.randomUUID());
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).isEmpty();
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_prefixObject_empty() throws Exception {
        this.list_prefixObject_empty((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefixObject_empty() throws Exception {
        this.list_prefixObject_empty((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefixObject_empty(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.getTestResource() + "/";
        gcsfsIHelper.createObjects(testBucket, testDir);
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).isEmpty();
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_prefixObject_withObject() throws Exception {
        this.list_prefixObject_withObject((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefixObject_withObject() throws Exception {
        this.list_prefixObject_withObject((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefixObject_withObject(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "obj"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_prefixObject_withSubdir() throws Exception {
        this.list_prefixObject_withSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefixObject_withSubdir() throws Exception {
        this.list_prefixObject_withSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefixObject_withSubdir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "sub/");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "sub/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_prefixObject_withImplicitSubdir() throws Exception {
        this.list_prefixObject_withImplicitSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_prefixObject_withImplicitSubdir() throws Exception {
        this.list_prefixObject_withImplicitSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_prefixObject_withImplicitSubdir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "sub/obj");
        gcsfsIHelper.createObjects(testBucket, testDir);
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "sub/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_implicitPrefix_withObject() throws Exception {
        this.list_implicitPrefix_withObject((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_implicitPrefix_withObject() throws Exception {
        this.list_implicitPrefix_withObject((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_implicitPrefix_withObject(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "obj"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_implicitPrefix_withSubdir() throws Exception {
        this.list_implicitPrefix_withSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_implicitPrefix_withSubdir() throws Exception {
        this.list_implicitPrefix_withSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_implicitPrefix_withSubdir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "sub/");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "sub/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_implicitPrefix_withImplicitSubdir() throws Exception {
        this.list_implicitPrefix_withImplicitSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfo(bucket, prefix)), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    @Test
    public void listObjectInfoPage_implicitPrefix_withImplicitSubdir() throws Exception {
        this.list_implicitPrefix_withImplicitSubdir((gcs, bucket, prefix) -> GoogleCloudStorageNewIntegrationTestBase.getObjectNames(gcs.listObjectInfoPage(bucket, prefix, null).getItems()), (bucket, prefix) -> TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, null));
    }

    private void list_implicitPrefix_withImplicitSubdir(TriFunction<GoogleCloudStorage, String, String, List<String>> listFn, BiFunction<String, String, String> requestFn) throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "sub/obj");
        List<String> listResult = listFn.apply(this.gcs, testBucket, testDir);
        Truth.assertThat(listResult).containsExactly(new Object[]{testDir + "sub/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{requestFn.apply(testBucket, testDir)});
    }

    @Test
    public void listObjectInfo_withLimit_oneGcsRequest() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, ListObjectOptions.DEFAULT.toBuilder().setMaxResults(1L).build());
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir + "f1"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, 2, null)});
    }

    @Test
    public void listObjectInfo_withLimit_multipleGcsRequests() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        int maxResultsPerRequest = 1;
        GoogleCloudStorageOptions options = gcsOptions.toBuilder().setMaxListItemsPerCall((long)maxResultsPerRequest).build();
        this.gcs = new GoogleCloudStorageImpl(options, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3", "f4");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, ListObjectOptions.DEFAULT.toBuilder().setMaxResults(2L).build());
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, null), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_1"), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_2")});
    }

    @Test
    public void listObjectInfo_withoutLimits() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        int maxResultsPerRequest = 1;
        GoogleCloudStorageOptions options = gcsOptions.toBuilder().setMaxListItemsPerCall((long)maxResultsPerRequest).build();
        this.gcs = new GoogleCloudStorageImpl(options, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, null), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_1"), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_2"), TrackingHttpRequestInitializer.listRequestString(testBucket, true, testDir, maxResultsPerRequest, "token_3")});
    }

    @Test
    public void listObjectInfo_includePrefix_emptyBucket() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = gcsfsIHelper.createUniqueBucket("lst-objs_incl-pfx_empty-bckt");
        List listedObjects = this.gcs.listObjectInfo(testBucket, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).isEmpty();
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, null, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_objectInBucket() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = gcsfsIHelper.createUniqueBucket("lst-objs_incl-pfx_obj-in-bckt");
        gcsfsIHelper.createObjects(testBucket, "obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{"obj"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, null, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_implicitDirInBucket() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = gcsfsIHelper.createUniqueBucket(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 10));
        gcsfsIHelper.createObjects(testBucket, "implDir/obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, null, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{"implDir/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, null, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_onlyPrefixObject() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "dir/") + "dir/";
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_object() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir, testDir + "obj"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_subdir() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "dir/");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir, testDir + "dir/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_implicitPrefixObject() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir, testDir + "obj"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_includePrefix_implicitSubdir() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDirWithoutSubdirs(testBucket, "dir/obj");
        List listedObjects = this.gcs.listObjectInfo(testBucket, testDir, INCLUDE_PREFIX_LIST_OPTIONS);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{testDir, testDir + "dir/"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(testBucket, testDir, null)});
    }

    @Test
    public void listObjectInfo_allMetadataFieldsCorrect() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testDirName = this.name.getMethodName() + "/";
        StorageResourceId objectId = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, testDirName + "object");
        CreateObjectOptions createOptions = GZIP_CREATE_OPTIONS.toBuilder().setMetadata((Map)ImmutableMap.of((Object)"test-key", (Object)"val".getBytes(StandardCharsets.UTF_8))).build();
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(objectId, createOptions)));){
            ((OutputStream)os).write((objectId + "-content").getBytes(StandardCharsets.UTF_8));
        }
        List listedObjects = this.gcs.listObjectInfo(objectId.getBucketName(), testDirName);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(listedObjects)).containsExactly(new Object[]{objectId.getObjectName()});
        GoogleCloudStorageNewIntegrationTestBase.assertObjectFields(objectId, (GoogleCloudStorageItemInfo)listedObjects.get(0));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(objectId.getBucketName(), testDirName, null)});
    }

    @Test
    public void getItemInfo_allMetadataFieldsCorrect() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        StorageResourceId objectId = new StorageResourceId(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1, this.name.getMethodName());
        CreateObjectOptions createOptions = GZIP_CREATE_OPTIONS.toBuilder().setMetadata((Map)ImmutableMap.of((Object)"test-key", (Object)"val".getBytes(StandardCharsets.UTF_8))).build();
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(objectId, createOptions)));){
            ((OutputStream)os).write((objectId + "-content").getBytes(StandardCharsets.UTF_8));
        }
        GoogleCloudStorageItemInfo object = this.gcs.getItemInfo(objectId);
        GoogleCloudStorageNewIntegrationTestBase.assertObjectFields(objectId, object);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(objectId.getBucketName(), objectId.getObjectName())});
    }

    @Test
    public void getItemInfo_oneGcsRequest() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1");
        GoogleCloudStorageItemInfo object = this.gcs.getItemInfo(new StorageResourceId(testBucket, testDir + "f1"));
        Truth.assertThat((String)object.getObjectName()).isEqualTo((Object)(testDir + "f1"));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1")});
    }

    @Test
    public void getItemInfos_withoutLimits() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        ImmutableList resourceIdsList = ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2"), (Object)new StorageResourceId(testBucket, testDir + "f3"));
        List objects = this.gcs.getItemInfos((List)resourceIdsList);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(objects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f3")});
    }

    @Test
    public void getItemInfos_withLimit_zeroBatchGcsRequest() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions.toBuilder().setMaxRequestsPerBatch(1L).build(), (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        ImmutableList resourceIdsList = ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2"), (Object)new StorageResourceId(testBucket, testDir + "f3"));
        List objects = this.gcs.getItemInfos((List)resourceIdsList);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(objects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f3")});
    }

    @Test
    public void getItemInfos_withLimit_multipleBatchGcsRequest() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions.toBuilder().setMaxRequestsPerBatch(2L).build(), (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        ImmutableList resourceIdsList = ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2"), (Object)new StorageResourceId(testBucket, testDir + "f3"));
        List objects = this.gcs.getItemInfos((List)resourceIdsList);
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(objects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2"), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f3")});
    }

    @Test
    public void updateItems_withoutLimits() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1");
        StorageResourceId resourceId = new StorageResourceId(testBucket, testDir + "f1");
        ImmutableMap updatedMetadata = ImmutableMap.of((Object)"test-metadata", (Object)"test-value".getBytes(StandardCharsets.UTF_8));
        List updatedObjects = this.gcs.updateItems((List)ImmutableList.of((Object)new UpdatableItemInfo(resourceId, (Map)updatedMetadata)));
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(updatedObjects)).containsExactly(new Object[]{testDir + "f1"});
        Truth.assertThat(((GoogleCloudStorageItemInfo)updatedObjects.get(0)).getMetadata().keySet()).isEqualTo(updatedMetadata.keySet());
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.postRequestString(testBucket, testDir + "f1")});
    }

    @Test
    public void updateItems_withLimits_MultipleBatchGcsRequests() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions.toBuilder().setMaxRequestsPerBatch(2L).build(), (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        ImmutableMap updatedMetadata = ImmutableMap.of((Object)"test-metadata", (Object)"test-value".getBytes(StandardCharsets.UTF_8));
        List updatedObjects = this.gcs.updateItems((List)ImmutableList.of((Object)new UpdatableItemInfo(new StorageResourceId(testBucket, testDir + "f1"), (Map)updatedMetadata), (Object)new UpdatableItemInfo(new StorageResourceId(testBucket, testDir + "f2"), (Map)updatedMetadata), (Object)new UpdatableItemInfo(new StorageResourceId(testBucket, testDir + "f3"), (Map)updatedMetadata)));
        Truth.assertThat(GoogleCloudStorageNewIntegrationTestBase.getObjectNames(updatedObjects)).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
        Truth.assertThat(((GoogleCloudStorageItemInfo)updatedObjects.get(0)).getMetadata().keySet()).isEqualTo(updatedMetadata.keySet());
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.postRequestString(testBucket, testDir + "f1"), TrackingHttpRequestInitializer.postRequestString(testBucket, testDir + "f2"), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.postRequestString(testBucket, testDir + "f3")});
    }

    @Test
    public void copy_withoutLimits_withDisabledCopyWithRewrites() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket1 = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testBucket2 = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName2;
        String testDir = this.createObjectsInTestDir(testBucket1, "f1", "f2", "f3");
        this.gcs.copy(testBucket1, (List)ImmutableList.of((Object)(testDir + "f1"), (Object)(testDir + "f2")), testBucket2, (List)ImmutableList.of((Object)(testDir + "f4"), (Object)(testDir + "f5")));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(testBucket1), TrackingHttpRequestInitializer.getBucketRequestString(testBucket2), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.copyRequestString(testBucket1, testDir + "f1", testBucket2, testDir + "f4", "copyTo"), TrackingHttpRequestInitializer.copyRequestString(testBucket1, testDir + "f2", testBucket2, testDir + "f5", "copyTo")});
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket2, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f4", testDir + "f5"});
    }

    @Test
    public void copy_withoutLimits_withEnabledCopyWithRewrites() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions.toBuilder().setCopyWithRewriteEnabled(true).build(), (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket1 = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testBucket2 = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName2;
        String testDir = this.createObjectsInTestDir(testBucket1, "f1", "f2", "f3");
        this.gcs.copy(testBucket1, (List)ImmutableList.of((Object)(testDir + "f1"), (Object)(testDir + "f2")), testBucket2, (List)ImmutableList.of((Object)(testDir + "f4"), (Object)(testDir + "f5")));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(testBucket1), TrackingHttpRequestInitializer.getBucketRequestString(testBucket2), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.copyRequestString(testBucket1, testDir + "f1", testBucket2, testDir + "f4", "rewriteTo"), TrackingHttpRequestInitializer.copyRequestString(testBucket1, testDir + "f2", testBucket2, testDir + "f5", "rewriteTo")});
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket2, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f4", testDir + "f5"});
    }

    @Test
    public void deleteObjects_withoutLimit() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        this.gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2")));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1", "generation"), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2", "generation"), TrackingHttpRequestInitializer.batchRequestString(), TrackingHttpRequestInitializer.deleteRequestString(testBucket, testDir + "f1", 1L), TrackingHttpRequestInitializer.deleteRequestString(testBucket, testDir + "f2", 2L)});
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f3"});
    }

    @Test
    public void deleteObjects_withLimit_zeroBatchGcsRequest() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions.toBuilder().setMaxRequestsPerBatch(1L).build(), (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2", "f3");
        this.gcs.deleteObjects((List)ImmutableList.of((Object)new StorageResourceId(testBucket, testDir + "f1"), (Object)new StorageResourceId(testBucket, testDir + "f2")));
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f1", "generation"), TrackingHttpRequestInitializer.deleteRequestString(testBucket, testDir + "f1", 1L), TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f2", "generation"), TrackingHttpRequestInitializer.deleteRequestString(testBucket, testDir + "f2", 2L)});
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f3"});
    }

    @Test
    public void composeObject_withoutLimit() throws Exception {
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        String testDir = this.createObjectsInTestDir(testBucket, "f1", "f2");
        this.gcs.compose(testBucket, (List)ImmutableList.of((Object)(testDir + "f1"), (Object)(testDir + "f2")), testDir + "f3", null);
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testDir + "f3"), TrackingHttpRequestInitializer.composeRequestString(testBucket, testDir + "f3", 1)});
        List<String> listedObjects = GoogleCloudStorageNewIntegrationTestBase.getObjectNames(this.gcs.listObjectInfo(testBucket, testDir));
        Truth.assertThat(listedObjects).containsExactly(new Object[]{testDir + "f1", testDir + "f2", testDir + "f3"});
    }

    @Test
    public void create_gzipEncodedFile() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(this.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write("content".getBytes(StandardCharsets.UTF_8));
        }
        if (this.isTracingSupported) {
            Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testFile.getObjectName()), TrackingHttpRequestInitializer.resumableUploadRequestString(testBucket, testFile.getObjectName(), 1, true), TrackingHttpRequestInitializer.resumableUploadChunkRequestString(testBucket, testFile.getObjectName(), 2, 1)});
        }
        Truth.assertThat((String)this.gcs.getItemInfo(testFile).getContentEncoding()).isEqualTo((Object)"gzip");
    }

    @Test
    public void open_gzipEncoded_succeeds_ifContentEncodingSupportEnabled() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write("content".getBytes(StandardCharsets.UTF_8));
        }
        long generationId = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.getItemInfo(testFile).getContentGeneration();
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        byte[] readContent = new byte[7];
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setSupportGzipEncoding(true).build();
        try (SeekableByteChannel channel = this.gcs.open(testFile, readOptions);){
            channel.read(ByteBuffer.wrap(readContent));
        }
        Truth.assertThat((String)new String(readContent, StandardCharsets.UTF_8)).isEqualTo((Object)"content");
        if (this.isTracingSupported) {
            Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testFile.getObjectName()), TrackingHttpRequestInitializer.getMediaRequestString(testBucket, testFile.getObjectName(), generationId)});
        }
    }

    @Test
    public void open_gzipEncoded_succeeds_ifContentEncodingSupportDisabled() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write("content".getBytes(StandardCharsets.UTF_8));
        }
        TrackingHttpRequestInitializer gcsRequestsTracker = new TrackingHttpRequestInitializer((HttpRequestInitializer)httpRequestsInitializer);
        this.gcs = new GoogleCloudStorageImpl(gcsOptions, (HttpRequestInitializer)gcsRequestsTracker);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setSupportGzipEncoding(false).build();
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> this.gcs.open(testFile, readOptions));
        Truth.assertThat((Throwable)e).hasMessageThat().isEqualTo((Object)"Cannot read GZIP encoded files - content encoding support is disabled.");
        Truth.assertThat(gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testFile.getObjectName())});
    }

    @Test
    public void open_gzipEncoded_rangeRead_succeed() throws Exception {
        String testBucket = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.sharedBucketName1;
        StorageResourceId testFile = new StorageResourceId(testBucket, this.getTestResource());
        String data = "content";
        try (GZIPOutputStream os = new GZIPOutputStream(Channels.newOutputStream(GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.create(testFile, GZIP_CREATE_OPTIONS)));){
            ((OutputStream)os).write(data.getBytes(StandardCharsets.UTF_8));
        }
        long generationId = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.getItemInfo(testFile).getContentGeneration();
        this.gcs = this.createGoogleCloudStorage(gcsOptions);
        int startIndex = 2;
        int endIndex = 4;
        byte[] readContent = new byte[endIndex - startIndex];
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setSupportGzipEncoding(true).build();
        try (SeekableByteChannel channel = this.gcs.open(testFile, readOptions);){
            channel.position(startIndex);
            channel.read(ByteBuffer.wrap(readContent));
        }
        Truth.assertThat((String)new String(readContent, StandardCharsets.UTF_8)).isEqualTo((Object)data.substring(startIndex, endIndex));
        if (this.isTracingSupported) {
            Truth.assertThat(this.gcsRequestsTracker.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(testBucket, testFile.getObjectName(), "contentEncoding,generation,size"), TrackingHttpRequestInitializer.getMediaRequestString(testBucket, testFile.getObjectName(), generationId)}).inOrder();
        }
    }

    protected static List<String> getObjectNames(List<GoogleCloudStorageItemInfo> listedObjects) {
        return listedObjects.stream().map(GoogleCloudStorageItemInfo::getObjectName).collect(Collectors.toList());
    }

    private static String createUniqueBucket(String suffix) throws IOException {
        return gcsfsIHelper.createUniqueBucket(suffix + UUID.randomUUID().toString().substring(0, 8));
    }

    private static void assertObjectFields(StorageResourceId expectedObjectId, GoogleCloudStorageItemInfo object) throws IOException {
        GoogleCloudStorageItemInfo expectedObjectItemInfo = GoogleCloudStorageNewIntegrationTestBase.gcsfsIHelper.gcs.getItemInfo(expectedObjectId);
        Truth.assertThat((Object)object).isEqualTo((Object)expectedObjectItemInfo);
        Truth.assertThat((String)object.getLocation()).isNull();
        Truth.assertThat((String)object.getStorageClass()).isNull();
    }

    private String createObjectsInTestDir(String bucketName, String ... objects) throws Exception {
        String testDir = this.getTestResource() + "/";
        String[] objectPaths = (String[])Arrays.stream(objects).map(o -> testDir + o).toArray(String[]::new);
        gcsfsIHelper.createObjectsWithSubdirs(bucketName, objectPaths);
        return testDir;
    }

    private String createObjectsInTestDirWithoutSubdirs(String bucketName, String ... objects) throws Exception {
        String testDir = this.getTestResource() + "/";
        String[] objectPaths = (String[])Arrays.stream(objects).map(o -> testDir + o).toArray(String[]::new);
        gcsfsIHelper.createObjects(bucketName, objectPaths);
        return testDir;
    }

    protected abstract GoogleCloudStorage createGoogleCloudStorage(GoogleCloudStorageOptions var1) throws IOException;

    protected String getTestResource() {
        return this.name.getMethodName() + "_" + UUID.randomUUID();
    }

    @FunctionalInterface
    private static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3) throws IOException;

        default public <V> TriFunction<A, B, C, V> andThen(Function<? super R, ? extends V> after) {
            return (a, b, c) -> ((Function)Preconditions.checkNotNull((Object)after)).apply(this.apply(a, b, c));
        }
    }
}

