/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.util.Clock;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.ListObjectOptions;
import com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.PrefixMappedItemCache;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.gcsio.VerificationAttributes;
import com.google.cloud.hadoop.gcsio.testing.GcsItemInfoTestBuilder;
import com.google.cloud.hadoop.gcsio.testing.InMemoryGoogleCloudStorage;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class PerformanceCachingGoogleCloudStorageTest {
    private static final HashCode EMPTY_OBJECT_MD5 = Hashing.md5().hashBytes(new byte[0]);
    private static final HashCode EMPTY_OBJECT_CRC32C = Hashing.crc32c().hashBytes(new byte[0]);
    private static final ImmutableMap<String, byte[]> TEST_METADATA = ImmutableMap.of((Object)"test_key", (Object)new byte[]{2});
    private static final CreateBucketOptions CREATE_BUCKET_OPTIONS = CreateBucketOptions.builder().setLocation("test_location").setStorageClass("test_storage_class").build();
    private static final CreateObjectOptions CREATE_OBJECT_OPTIONS = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setContentType("test_content_type").setMetadata(TEST_METADATA).build();
    private static final String BUCKET_A = "alpha";
    private static final String BUCKET_B = "alph";
    private static final String PREFIX_A = "bar";
    private static final String PREFIX_AA = "bar/apple";
    private static final String PREFIX_ABA = "bar/berry/foo";
    private static final String PREFIX_B = "baz";
    private static final GoogleCloudStorageItemInfo ITEM_A = PerformanceCachingGoogleCloudStorageTest.createBucketItemInfo("alpha");
    private static final GoogleCloudStorageItemInfo ITEM_B = PerformanceCachingGoogleCloudStorageTest.createBucketItemInfo("alph");
    private static final GoogleCloudStorageItemInfo ITEM_A_A = PerformanceCachingGoogleCloudStorageTest.createObjectItemInfo("alpha", "bar");
    private static final GoogleCloudStorageItemInfo ITEM_A_AA = PerformanceCachingGoogleCloudStorageTest.createObjectItemInfo("alpha", "bar/apple");
    private static final GoogleCloudStorageItemInfo ITEM_A_ABA = PerformanceCachingGoogleCloudStorageTest.createObjectItemInfo("alpha", "bar/berry/foo");
    private static final GoogleCloudStorageItemInfo ITEM_A_B = PerformanceCachingGoogleCloudStorageTest.createObjectItemInfo("alpha", "baz");
    private static final GoogleCloudStorageItemInfo ITEM_B_A = PerformanceCachingGoogleCloudStorageTest.createObjectItemInfo("alph", "bar");
    private static final GoogleCloudStorageItemInfo ITEM_B_B = PerformanceCachingGoogleCloudStorageTest.createObjectItemInfo("alph", "baz");
    private TestClock clock;
    private PerformanceCachingGoogleCloudStorage gcs;
    private PrefixMappedItemCache cache;
    private GoogleCloudStorage gcsDelegate;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.cache = new PrefixMappedItemCache((Ticker)new TestTicker(), Duration.ofMillis(10L));
        this.clock = new TestClock();
        InMemoryGoogleCloudStorage gcsImpl = new InMemoryGoogleCloudStorage(GoogleCloudStorageOptions.DEFAULT, (Clock)this.clock);
        this.gcsDelegate = (GoogleCloudStorage)Mockito.spy((Object)gcsImpl);
        this.gcs = new PerformanceCachingGoogleCloudStorage(this.gcsDelegate, this.cache);
        this.gcsDelegate.createBucket(BUCKET_A, CREATE_BUCKET_OPTIONS);
        this.gcsDelegate.createBucket(BUCKET_B, CREATE_BUCKET_OPTIONS);
        this.gcsDelegate.createEmptyObject(ITEM_A_A.getResourceId(), CREATE_OBJECT_OPTIONS);
        this.gcsDelegate.createEmptyObject(ITEM_A_AA.getResourceId(), CREATE_OBJECT_OPTIONS);
        this.gcsDelegate.createEmptyObject(ITEM_A_ABA.getResourceId(), CREATE_OBJECT_OPTIONS);
        this.gcsDelegate.createEmptyObject(ITEM_A_B.getResourceId(), CREATE_OBJECT_OPTIONS);
        this.gcsDelegate.createEmptyObject(ITEM_B_A.getResourceId(), CREATE_OBJECT_OPTIONS);
        this.gcsDelegate.createEmptyObject(ITEM_B_B.getResourceId(), CREATE_OBJECT_OPTIONS);
    }

    @Test
    public void testDeleteBuckets() throws IOException {
        ArrayList buckets = Lists.newArrayList((Object[])new String[]{BUCKET_A});
        this.cache.putItem(ITEM_A_A);
        this.cache.putItem(ITEM_B_A);
        this.gcs.deleteBuckets((List)buckets);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).deleteBuckets((List)ArgumentMatchers.eq((Object)buckets));
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactly(new Object[]{ITEM_B_A});
    }

    @Test
    public void testDeleteObjects() throws IOException {
        ArrayList ids = Lists.newArrayList((Object[])new StorageResourceId[]{ITEM_A_A.getResourceId(), ITEM_B_A.getResourceId()});
        this.cache.putItem(ITEM_A_A);
        this.cache.putItem(ITEM_B_A);
        this.cache.putItem(ITEM_B_B);
        this.gcs.deleteObjects((List)ids);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).deleteObjects((List)ArgumentMatchers.eq((Object)ids));
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactly(new Object[]{ITEM_B_B});
    }

    @Test
    public void testListBucketInfo() throws IOException {
        ArrayList expected = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A, ITEM_B});
        List result = this.gcs.listBucketInfo();
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).listBucketInfo();
        Truth.assertThat((Iterable)result).containsExactlyElementsIn((Iterable)expected);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expected);
    }

    @Test
    public void testListObjectInfo() throws IOException {
        ArrayList expected = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A_A, ITEM_A_AA, ITEM_A_ABA});
        List result = this.gcs.listObjectInfo(BUCKET_A, PREFIX_A, ListObjectOptions.DEFAULT_FLAT_LIST);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).listObjectInfo((String)ArgumentMatchers.eq((Object)BUCKET_A), (String)ArgumentMatchers.eq((Object)PREFIX_A), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT_FLAT_LIST));
        Truth.assertThat((Iterable)result).containsExactlyElementsIn((Iterable)expected);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expected);
    }

    @Test
    public void testListBucketInfoAndObjectInfo() throws IOException {
        ImmutableList expectedBuckets = ImmutableList.of((Object)ITEM_A, (Object)ITEM_B);
        ImmutableList expectedObjectsInBucketA = ImmutableList.of((Object)ITEM_A_A, (Object)ITEM_A_AA, (Object)ITEM_A_ABA, (Object)ITEM_A_B);
        Iterable expectedAllCachedItems = Iterables.concat((Iterable)expectedBuckets, (Iterable)expectedObjectsInBucketA);
        List objects1 = this.gcs.listObjectInfo(BUCKET_A, null, ListObjectOptions.DEFAULT_FLAT_LIST);
        Truth.assertThat((Iterable)objects1).containsExactlyElementsIn((Iterable)expectedObjectsInBucketA);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expectedObjectsInBucketA);
        List buckets = this.gcs.listBucketInfo();
        Truth.assertThat((Iterable)buckets).containsExactlyElementsIn((Iterable)expectedBuckets);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn(expectedAllCachedItems);
        List objects2 = this.gcs.listObjectInfo(BUCKET_A, null, ListObjectOptions.DEFAULT_FLAT_LIST);
        Truth.assertThat((Iterable)objects2).containsExactlyElementsIn((Iterable)expectedObjectsInBucketA);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn(expectedAllCachedItems);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).listBucketInfo();
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate, (VerificationMode)Mockito.times((int)2))).listObjectInfo((String)ArgumentMatchers.eq((Object)BUCKET_A), (String)ArgumentMatchers.eq(null), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT_FLAT_LIST));
    }

    @Test
    public void testListObjectInfo_delimiter() throws IOException {
        GoogleCloudStorageItemInfo itemAAPrefix = PerformanceCachingGoogleCloudStorageTest.createInferredDirectory(BUCKET_A, "bar/");
        ArrayList expectedResult = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A_A, itemAAPrefix});
        ArrayList expectedCached = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A_A, itemAAPrefix});
        List result = this.gcs.listObjectInfo(BUCKET_A, PREFIX_A, ListObjectOptions.DEFAULT);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).listObjectInfo((String)ArgumentMatchers.eq((Object)BUCKET_A), (String)ArgumentMatchers.eq((Object)PREFIX_A), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT));
        Truth.assertThat((Iterable)result).containsExactlyElementsIn((Iterable)expectedResult);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expectedCached);
    }

    @Test
    public void testListObjectInfo_prefixDir_delimiter() throws IOException {
        String prefixADir = "bar/";
        String prefixABADir = PREFIX_ABA.substring(0, PREFIX_ABA.lastIndexOf(47) + 1);
        GoogleCloudStorageItemInfo itemABAPrefix = PerformanceCachingGoogleCloudStorageTest.createInferredDirectory(BUCKET_A, prefixABADir);
        ArrayList expectedResult = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A_AA, itemABAPrefix});
        ArrayList expectedCached = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A_AA, itemABAPrefix});
        List result = this.gcs.listObjectInfo(BUCKET_A, prefixADir, ListObjectOptions.DEFAULT);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).listObjectInfo((String)ArgumentMatchers.eq((Object)BUCKET_A), (String)ArgumentMatchers.eq((Object)prefixADir), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT));
        Truth.assertThat((Iterable)result).containsExactlyElementsIn((Iterable)expectedResult);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expectedCached);
    }

    @Test
    public void testListObjectInfoAlt() throws IOException {
        ArrayList expected = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_B_A, ITEM_B_B});
        List result = this.gcs.listObjectInfo(BUCKET_B, null, ListObjectOptions.DEFAULT_FLAT_LIST);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).listObjectInfo((String)ArgumentMatchers.eq((Object)BUCKET_B), (String)ArgumentMatchers.eq(null), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT_FLAT_LIST));
        Truth.assertThat((Iterable)result).containsExactlyElementsIn((Iterable)expected);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expected);
    }

    @Test
    public void testListObjectInfoCached() throws IOException {
        ArrayList expected = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A_A, ITEM_A_AA, ITEM_A_ABA, ITEM_A_B});
        this.gcs.listObjectInfo(BUCKET_A, null, ListObjectOptions.DEFAULT_FLAT_LIST);
        List result = this.gcs.listObjectInfo(BUCKET_A, null, ListObjectOptions.DEFAULT_FLAT_LIST);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate, (VerificationMode)Mockito.times((int)2))).listObjectInfo((String)ArgumentMatchers.eq((Object)BUCKET_A), (String)ArgumentMatchers.eq(null), (ListObjectOptions)ArgumentMatchers.eq((Object)ListObjectOptions.DEFAULT_FLAT_LIST));
        Truth.assertThat((Iterable)result).containsExactlyElementsIn((Iterable)expected);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expected);
    }

    @Test
    public void testGetItemInfo() throws IOException {
        this.cache.putItem(ITEM_A_A);
        GoogleCloudStorageItemInfo result = this.gcs.getItemInfo(ITEM_A_A.getResourceId());
        Truth.assertThat((Object)result).isEqualTo((Object)ITEM_A_A);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactly(new Object[]{ITEM_A_A});
    }

    @Test
    public void testGetItemInfoMissing() throws IOException {
        GoogleCloudStorageItemInfo result = this.gcs.getItemInfo(ITEM_A_A.getResourceId());
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).getItemInfo((StorageResourceId)ArgumentMatchers.eq((Object)ITEM_A_A.getResourceId()));
        Truth.assertThat((Object)result).isEqualTo((Object)ITEM_A_A);
        Truth.assertThat((Object)this.cache.getItem(ITEM_A_A.getResourceId())).isEqualTo((Object)ITEM_A_A);
    }

    @Test
    public void testGetItemInfosAllCached() throws IOException {
        ArrayList requestedIds = Lists.newArrayList((Object[])new StorageResourceId[]{ITEM_A_A.getResourceId(), ITEM_A_B.getResourceId()});
        ArrayList expected = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A_A, ITEM_A_B});
        this.cache.putItem(ITEM_A_A);
        this.cache.putItem(ITEM_A_B);
        List result = this.gcs.getItemInfos((List)requestedIds);
        Truth.assertThat((Iterable)result).containsExactlyElementsIn((Iterable)expected).inOrder();
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expected);
    }

    @Test
    public void testGetItemInfosSomeCached() throws IOException {
        ArrayList requestedIds = Lists.newArrayList((Object[])new StorageResourceId[]{ITEM_A_A.getResourceId(), ITEM_A_B.getResourceId(), ITEM_B_A.getResourceId(), ITEM_B_B.getResourceId()});
        ArrayList uncachedIds = Lists.newArrayList((Object[])new StorageResourceId[]{ITEM_A_A.getResourceId(), ITEM_B_A.getResourceId()});
        ArrayList expected = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A_A, ITEM_A_B, ITEM_B_A, ITEM_B_B});
        this.cache.putItem(ITEM_A_B);
        this.cache.putItem(ITEM_B_B);
        List result = this.gcs.getItemInfos((List)requestedIds);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).getItemInfos((List)ArgumentMatchers.eq((Object)uncachedIds));
        Truth.assertThat((Iterable)result).containsExactlyElementsIn((Iterable)expected).inOrder();
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expected);
    }

    @Test
    public void testGetItemInfosNoneCached() throws IOException {
        ArrayList requestedIds = Lists.newArrayList((Object[])new StorageResourceId[]{ITEM_A_A.getResourceId(), ITEM_A_B.getResourceId()});
        ArrayList expected = Lists.newArrayList((Object[])new GoogleCloudStorageItemInfo[]{ITEM_A_A, ITEM_A_B});
        List result = this.gcs.getItemInfos((List)requestedIds);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).getItemInfos((List)ArgumentMatchers.eq((Object)requestedIds));
        Truth.assertThat((Iterable)result).containsExactlyElementsIn((Iterable)expected).inOrder();
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactlyElementsIn((Iterable)expected);
    }

    @Test
    public void testUpdateItems() throws IOException {
        ArrayList updateItems = Lists.newArrayList((Object[])new UpdatableItemInfo[]{new UpdatableItemInfo(ITEM_A_A.getResourceId(), TEST_METADATA)});
        GoogleCloudStorageItemInfo itemAAUpdated = PerformanceCachingGoogleCloudStorageTest.updateObjectItemInfo(ITEM_A_A, ITEM_A_A.getMetaGeneration() + 1L);
        List result = this.gcs.updateItems((List)updateItems);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).updateItems((List)ArgumentMatchers.eq((Object)updateItems));
        Truth.assertThat((Iterable)result).containsExactly(new Object[]{itemAAUpdated});
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactly(new Object[]{itemAAUpdated});
    }

    @Test
    public void testClose() {
        this.cache.putItem(ITEM_A_A);
        this.gcs.close();
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).close();
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).isEmpty();
    }

    @Test
    public void testComposeObjects() throws IOException {
        ArrayList ids = Lists.newArrayList((Object[])new StorageResourceId[]{ITEM_A_A.getResourceId(), ITEM_A_B.getResourceId()});
        GoogleCloudStorageItemInfo result = this.gcs.composeObjects((List)ids, ITEM_A_AA.getResourceId(), CREATE_OBJECT_OPTIONS);
        ((GoogleCloudStorage)Mockito.verify((Object)this.gcsDelegate)).composeObjects((List)ArgumentMatchers.eq((Object)ids), (StorageResourceId)ArgumentMatchers.eq((Object)ITEM_A_AA.getResourceId()), (CreateObjectOptions)ArgumentMatchers.eq((Object)CREATE_OBJECT_OPTIONS));
        Truth.assertThat((Object)result).isEqualTo((Object)ITEM_A_AA);
        Truth.assertThat((Iterable)this.cache.getAllItemsRaw()).containsExactly(new Object[]{ITEM_A_AA});
    }

    public static GoogleCloudStorageItemInfo createBucketItemInfo(String bucketName) {
        return GoogleCloudStorageItemInfo.createBucket((StorageResourceId)new StorageResourceId(bucketName), (long)0L, (long)0L, (String)CREATE_BUCKET_OPTIONS.getLocation(), (String)CREATE_BUCKET_OPTIONS.getStorageClass());
    }

    public static GoogleCloudStorageItemInfo createObjectItemInfo(String bucketName, String objectName) {
        return PerformanceCachingGoogleCloudStorageTest.createObjectItemInfo(bucketName, objectName, CREATE_OBJECT_OPTIONS);
    }

    public static GoogleCloudStorageItemInfo createObjectItemInfo(String bucketName, String objectName, CreateObjectOptions createObjectOptions) {
        return GcsItemInfoTestBuilder.create().setStorageResourceId(new StorageResourceId(bucketName, objectName)).setCreationTime(0L).setModificationTime(0L).setSize(0L).setContentType(createObjectOptions.getContentType()).setContentEncoding(createObjectOptions.getContentEncoding()).setMetadata((Map)createObjectOptions.getMetadata()).setContentGeneration(1L).setMetaGeneration(1L).setVerificationAttributes(new VerificationAttributes(EMPTY_OBJECT_MD5.asBytes(), EMPTY_OBJECT_CRC32C.asBytes())).build();
    }

    public static GoogleCloudStorageItemInfo createInferredDirectory(String bucketName, String objectName) {
        return GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)new StorageResourceId(bucketName, objectName));
    }

    private static GoogleCloudStorageItemInfo updateObjectItemInfo(GoogleCloudStorageItemInfo object, long metaGeneration) {
        return GoogleCloudStorageItemInfo.createObject((StorageResourceId)object.getResourceId(), (long)object.getCreationTime(), (long)object.getModificationTime(), (long)object.getSize(), (String)object.getContentType(), (String)object.getContentEncoding(), (Map)object.getMetadata(), (long)object.getContentGeneration(), (long)metaGeneration, (VerificationAttributes)object.getVerificationAttributes());
    }

    private static class TestClock
    implements Clock {
        private TestClock() {
        }

        public long currentTimeMillis() {
            return 0L;
        }
    }

    private static class TestTicker
    extends Ticker {
        private TestTicker() {
        }

        public long read() {
            return 0L;
        }
    }
}

