/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageIntegrationHelper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;

public class TrackingHttpRequestInitializer
implements HttpRequestInitializer {
    public static final String OBJECT_FIELDS = "bucket,name,timeCreated,updated,generation,metageneration,size,contentType,contentEncoding,md5Hash,crc32c,metadata";
    private static final String GET_REQUEST_FORMAT = "GET:https://storage.googleapis.com/storage/v1/b/%s/o/%s%s";
    private static final String GET_MEDIA_REQUEST_FORMAT = "GET:https://storage.googleapis.com/download/storage/v1/b/%s/o/%s?alt=media";
    private static final String GET_BUCKET_REQUEST_FORMAT = "GET:https://storage.googleapis.com/storage/v1/b/%s";
    private static final String POST_REQUEST_FORMAT = "POST:https://storage.googleapis.com/storage/v1/b/%s/o/%s";
    private static final String POST_COPY_REQUEST_FORMAT = "POST:https://storage.googleapis.com/storage/v1/b/%s/o/%s/%s/b/%s/o/%s";
    private static final String POST_COPY_REQUEST_WITH_METADATA_FORMAT = "POST:https://storage.googleapis.com/storage/v1/b/%s/o/%s/%s/b/%s/o/%s?ifGenerationMatch=%s";
    private static final String UPLOAD_REQUEST_FORMAT = "POST:https://storage.googleapis.com/upload/storage/v1/b/%s/o?ifGenerationMatch=%s&uploadType=multipart:%s";
    private static final String RESUMABLE_UPLOAD_REQUEST_FORMAT = "POST:https://storage.googleapis.com/upload/storage/v1/b/%s/o?ifGenerationMatch=%s&name=%s&uploadType=resumable";
    private static final String RESUMABLE_UPLOAD_CHUNK_REQUEST_FORMAT = "PUT:https://storage.googleapis.com/upload/storage/v1/b/%s/o?%sname=%s&uploadType=resumable&upload_id=upload_%s";
    private static final String UPDATE_METADATA_REQUEST_FORMAT = "POST:https://storage.googleapis.com/storage/v1/b/%s/o/%s?ifMetagenerationMatch=%d";
    private static final String DELETE_BUCKET_REQUEST_FORMAT = "DELETE:https://storage.googleapis.com/storage/v1/b/%s";
    private static final String DELETE_META_REQUEST_FORMAT = "DELETE:https://storage.googleapis.com/storage/v1/b/%s/o/%s?ifMetagenerationMatch=%d";
    private static final String DELETE_REQUEST_FORMAT = "DELETE:https://storage.googleapis.com/storage/v1/b/%s/o/%s?ifGenerationMatch=%s";
    private static final String LIST_BUCKETS_REQUEST_FORMAT = "GET:https://storage.googleapis.com/storage/v1/b?maxResults=5000&project=%s";
    private static final String LIST_REQUEST_FORMAT = "GET:https://storage.googleapis.com/storage/v1/b/%s/o?%sfields=items(%s),prefixes,nextPageToken%s&maxResults=%d%s";
    private static final String LIST_SIMPLE_REQUEST_FORMAT = "GET:https://storage.googleapis.com/storage/v1/b/%s/o?maxResults=%d&prefix=%s";
    private static final String BATCH_REQUEST = "POST:https://storage.googleapis.com/batch/storage/v1";
    private static final String COMPOSE_REQUEST_FORMAT = "POST:https://storage.googleapis.com/storage/v1/b/%s/o/%s/compose";
    private static final String CREATE_BUCKET_REQUEST_FORMAT = "POST:https://storage.googleapis.com/storage/v1/b?project=%s";
    private static final String PAGE_TOKEN_PARAM_PATTERN = "pageToken=[^&]+";
    private static final String REWRITE_TOKEN_PARAM_PATTERN = "rewriteToken=[^&]+";
    private static final String GENERATION_MATCH_TOKEN_PARAM_PATTERN = "ifGenerationMatch=[^&]+";
    private static final String UPLOAD_ID_PARAM_PATTERN = "upload_id=[^&]+";
    private final HttpRequestInitializer delegate;
    private final List<HttpRequest> requests = Collections.synchronizedList(new ArrayList());
    private final boolean replaceRequestParams;

    public TrackingHttpRequestInitializer() {
        this(null);
    }

    public TrackingHttpRequestInitializer(HttpRequestInitializer delegate) {
        this(delegate, true);
    }

    public TrackingHttpRequestInitializer(boolean replaceRequestParams) {
        this(null, replaceRequestParams);
    }

    public TrackingHttpRequestInitializer(HttpRequestInitializer delegate, boolean replaceRequestParams) {
        this.delegate = delegate;
        this.replaceRequestParams = replaceRequestParams;
    }

    public void initialize(HttpRequest request) throws IOException {
        if (this.delegate != null) {
            this.delegate.initialize(request);
        }
        HttpExecuteInterceptor executeInterceptor = request.getInterceptor();
        request.setInterceptor(r -> {
            if (executeInterceptor != null) {
                executeInterceptor.intercept(r);
            }
            this.requests.add(r);
        });
    }

    public ImmutableList<HttpRequest> getAllRequests() {
        return ImmutableList.copyOf(this.requests);
    }

    public ImmutableList<String> getAllRequestStrings() {
        AtomicLong pageTokenId = new AtomicLong();
        AtomicLong rewriteTokenId = new AtomicLong();
        AtomicLong generationMatchId = new AtomicLong();
        AtomicLong resumableUploadId = new AtomicLong();
        return (ImmutableList)this.requests.stream().map(GoogleCloudStorageIntegrationHelper::requestToString).map(r -> this.replacePageTokenWithId((String)r, pageTokenId)).map(r -> this.replaceRewriteTokenWithId((String)r, rewriteTokenId)).map(r -> this.replaceGenerationMatchWithId((String)r, generationMatchId)).map(r -> TrackingHttpRequestInitializer.replaceResumableUploadIdWithId(r, resumableUploadId)).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<String> getAllRequestInvocationIds() {
        return (ImmutableList)this.requests.stream().map(r -> this.getInvocationId(r.getHeaders())).filter(((Predicate<String>)Strings::isNullOrEmpty).negate()).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<String> getAllRawRequestStrings() {
        return (ImmutableList)this.requests.stream().map(GoogleCloudStorageIntegrationHelper::requestToString).collect(ImmutableList.toImmutableList());
    }

    private String getInvocationId(HttpHeaders header) {
        String apiClientHeader = (String)header.get((Object)"x-goog-api-client");
        int beginIndex = apiClientHeader.indexOf("gccl-invocation-id/");
        if (beginIndex >= 0) {
            int endIndex;
            endIndex = (endIndex = Math.max(apiClientHeader.indexOf(" ", beginIndex += "gccl-invocation-id/".length()), apiClientHeader.indexOf(",", beginIndex))) == -1 ? apiClientHeader.length() : endIndex;
            return apiClientHeader.substring(beginIndex, endIndex);
        }
        return null;
    }

    private String replacePageTokenWithId(String request, AtomicLong pageTokenId) {
        return this.replaceRequestParams ? TrackingHttpRequestInitializer.replaceWithId(request, PAGE_TOKEN_PARAM_PATTERN, "pageToken=token_", pageTokenId) : request;
    }

    private String replaceRewriteTokenWithId(String request, AtomicLong rewriteTokenId) {
        return this.replaceRequestParams ? TrackingHttpRequestInitializer.replaceWithId(request, REWRITE_TOKEN_PARAM_PATTERN, "rewriteToken=token_", rewriteTokenId) : request;
    }

    private String replaceGenerationMatchWithId(String request, AtomicLong generationId) {
        String idPrefix = "ifGenerationMatch=generationId_";
        return this.replaceRequestParams ? TrackingHttpRequestInitializer.replaceWithId(request, GENERATION_MATCH_TOKEN_PARAM_PATTERN, idPrefix, generationId) : request;
    }

    private static String replaceResumableUploadIdWithId(String request, AtomicLong uploadId) {
        return TrackingHttpRequestInitializer.replaceWithId(request, UPLOAD_ID_PARAM_PATTERN, "upload_id=upload_", uploadId);
    }

    private static String replaceWithId(String request, String pattern, String idPrefix, AtomicLong id) {
        long nextId = id.get() + 1L;
        String replacedRequest = request.replaceAll(pattern, idPrefix + nextId);
        if (!request.equals(replacedRequest)) {
            id.incrementAndGet();
        }
        return replacedRequest;
    }

    public void reset() {
        this.requests.clear();
    }

    public static String getRequestString(String bucketName, String object) {
        return TrackingHttpRequestInitializer.getRequestString(bucketName, object, OBJECT_FIELDS);
    }

    public static String getRequestString(String bucketName, String object, String fields) {
        String queryParameters = fields == null ? "" : "?fields=" + fields;
        return String.format(GET_REQUEST_FORMAT, bucketName, TrackingHttpRequestInitializer.urlEncode(object), queryParameters);
    }

    public static String getMediaRequestString(String bucketName, String object) {
        return TrackingHttpRequestInitializer.getMediaRequestString(bucketName, object, null);
    }

    public static String getMediaRequestString(String bucketName, String object, Long generationId) {
        return String.format(GET_MEDIA_REQUEST_FORMAT, bucketName, TrackingHttpRequestInitializer.urlEncode(object)) + (generationId == null ? "" : "&generation=" + generationId);
    }

    public static String getBucketRequestString(String bucketName) {
        return String.format(GET_BUCKET_REQUEST_FORMAT, bucketName);
    }

    public static String postRequestString(String bucketName, String object) {
        return String.format(POST_REQUEST_FORMAT, bucketName, TrackingHttpRequestInitializer.urlEncode(object));
    }

    public static String rewriteRequestString(String srcBucket, String srcObject, String dstBucket, String dstObject, Integer maxBytesRewrittenPerCall, Integer rewriteTokenId) {
        String rewriteParams = (maxBytesRewrittenPerCall == null ? "" : "?maxBytesRewrittenPerCall=" + maxBytesRewrittenPerCall) + (rewriteTokenId == null ? "" : "&rewriteToken=token_" + rewriteTokenId);
        return TrackingHttpRequestInitializer.copyRequestString(srcBucket, srcObject, dstBucket, dstObject, "rewriteTo") + rewriteParams;
    }

    public static String copyRequestString(String srcBucket, String srcObject, String dstBucket, String dstObject, String requestType) {
        return String.format(POST_COPY_REQUEST_FORMAT, srcBucket, TrackingHttpRequestInitializer.urlEncode(srcObject), requestType, dstBucket, TrackingHttpRequestInitializer.urlEncode(dstObject));
    }

    public static String copyRequestString(String srcBucket, String srcObject, String dstBucket, String dstObject, String requestType, Integer generationId) {
        return TrackingHttpRequestInitializer.copyRequestString(srcBucket, srcObject, dstBucket, dstObject, requestType, generationId, true);
    }

    public static String copyRequestString(String srcBucket, String srcObject, String dstBucket, String dstObject, String requestType, Integer generationId, boolean replaceGenerationId) {
        String request = String.format(POST_COPY_REQUEST_WITH_METADATA_FORMAT, srcBucket, TrackingHttpRequestInitializer.urlEncode(srcObject), requestType, dstBucket, TrackingHttpRequestInitializer.urlEncode(dstObject), replaceGenerationId ? "generationId_" + generationId : generationId);
        return generationId == null ? request.replaceAll("ifGenerationMatch=[^&]+&", "") : request;
    }

    public static String uploadRequestString(String bucketName, String object, Integer generationId) {
        return TrackingHttpRequestInitializer.uploadRequestString(bucketName, object, generationId, true);
    }

    public static String uploadRequestString(String bucketName, String object, Integer generationId, boolean replaceGenerationId) {
        String request = String.format(UPLOAD_REQUEST_FORMAT, bucketName, replaceGenerationId ? "generationId_" + generationId : generationId, object);
        return generationId == null ? request.replaceAll("ifGenerationMatch=[^&]+&", "") : request;
    }

    public static String resumableUploadRequestString(String bucketName, String object, Integer generationId, boolean replaceGenerationId) {
        String request = String.format(RESUMABLE_UPLOAD_REQUEST_FORMAT, bucketName, replaceGenerationId ? "generationId_" + generationId : generationId, object);
        return generationId == null ? request.replaceAll("ifGenerationMatch=[^&]+&", "") : request;
    }

    public static String resumableUploadChunkRequestString(String bucketName, String object, Integer uploadId) {
        return TrackingHttpRequestInitializer.resumableUploadChunkRequestString(bucketName, object, null, uploadId);
    }

    public static String resumableUploadChunkRequestString(String bucketName, String object, Integer generationId, Integer uploadId) {
        String generationIdParameter = generationId == null ? "" : "ifGenerationMatch=generationId_" + generationId + "&";
        return String.format(RESUMABLE_UPLOAD_CHUNK_REQUEST_FORMAT, bucketName, generationIdParameter, object, uploadId);
    }

    public static String updateMetadataRequestString(String bucketName, String object, int metaGenerationId) {
        return String.format(UPDATE_METADATA_REQUEST_FORMAT, bucketName, TrackingHttpRequestInitializer.urlEncode(object), metaGenerationId);
    }

    public static String deleteBucketRequestString(String bucketName) {
        return String.format(DELETE_BUCKET_REQUEST_FORMAT, bucketName);
    }

    public static String deleteRequestString(String bucketName, String object, long generationId) {
        return TrackingHttpRequestInitializer.deleteRequestString(bucketName, object, generationId, true);
    }

    public static String deleteRequestString(String bucketName, String object, long generationId, boolean replaceGenerationId) {
        return String.format(DELETE_REQUEST_FORMAT, bucketName, TrackingHttpRequestInitializer.urlEncode(object), replaceGenerationId ? "generationId_" + generationId : Long.valueOf(generationId));
    }

    public static String deleteMatchMetaGenerationRequestString(String bucketName, String object, int metaGenerationId) {
        return String.format(DELETE_META_REQUEST_FORMAT, bucketName, TrackingHttpRequestInitializer.urlEncode(object), metaGenerationId);
    }

    public static String batchRequestString() {
        return BATCH_REQUEST;
    }

    public static String composeRequestString(String bucketName, String object, Integer generationId) {
        return TrackingHttpRequestInitializer.composeRequestString(bucketName, object, generationId, true);
    }

    public static String composeRequestString(String bucketName, String object, Integer generationId, boolean replaceGenerationId) {
        String request = String.format(COMPOSE_REQUEST_FORMAT, bucketName, TrackingHttpRequestInitializer.urlEncode(object));
        return generationId == null ? request : String.format("%s?ifGenerationMatch=%s", request, replaceGenerationId ? "generationId_" + generationId : generationId);
    }

    public static String listBucketsRequestString(String projectId) {
        return String.format(LIST_BUCKETS_REQUEST_FORMAT, projectId);
    }

    public static String listRequestString(String bucket, String prefix, int maxResults) {
        return String.format(LIST_SIMPLE_REQUEST_FORMAT, bucket, maxResults, prefix);
    }

    public static String listRequestString(String bucket, String prefix, int maxResults, String pageToken) {
        return TrackingHttpRequestInitializer.listRequestString(bucket, (Boolean)false, prefix, OBJECT_FIELDS, maxResults, pageToken);
    }

    public static String listRequestWithTrailingDelimiter(String bucket, String prefix, String pageToken) {
        return TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, OBJECT_FIELDS, 5000, pageToken);
    }

    public static String listRequestWithTrailingDelimiter(String bucket, String prefix, int maxResults, String pageToken) {
        return TrackingHttpRequestInitializer.listRequestWithTrailingDelimiter(bucket, prefix, OBJECT_FIELDS, maxResults, pageToken);
    }

    public static String listRequestWithTrailingDelimiter(String bucket, String prefix, String objectFields, String pageToken) {
        return TrackingHttpRequestInitializer.listRequestString(bucket, (Boolean)true, prefix, objectFields, 5000, pageToken);
    }

    public static String listRequestWithTrailingDelimiter(String bucket, String prefix, String objectFields, int maxResults, String pageToken) {
        return TrackingHttpRequestInitializer.listRequestString(bucket, (Boolean)true, prefix, objectFields, maxResults, pageToken);
    }

    public static String listRequestString(String bucket, Boolean includeTrailingDelimiter, String prefix, int maxResults, String pageToken) {
        return TrackingHttpRequestInitializer.listRequestString(bucket, includeTrailingDelimiter, prefix, OBJECT_FIELDS, maxResults, pageToken);
    }

    public static String listRequestString(String bucket, Boolean includeTrailingDelimiter, String prefix, String objectFields, int maxResults, String pageToken) {
        return TrackingHttpRequestInitializer.listRequestString(bucket, false, includeTrailingDelimiter, prefix, objectFields, maxResults, pageToken);
    }

    public static String listRequestString(String bucket, boolean flatList, Boolean includeTrailingDelimiter, String prefix, String objectFields, String pageToken) {
        return TrackingHttpRequestInitializer.listRequestString(bucket, flatList, includeTrailingDelimiter, prefix, objectFields, 5000, pageToken);
    }

    public static String listRequestString(String bucket, boolean flatList, Boolean includeTrailingDelimiter, String prefix, String objectFields, int maxResults, String pageToken) {
        String extraParams = pageToken == null ? "" : "&pageToken=" + pageToken;
        extraParams = extraParams + (prefix == null ? "" : "&prefix=" + prefix);
        return String.format(LIST_REQUEST_FORMAT, bucket, flatList ? "" : "delimiter=/&", objectFields, includeTrailingDelimiter == null ? "" : "&includeTrailingDelimiter=" + includeTrailingDelimiter, maxResults, extraParams);
    }

    public static String createBucketRequestString(String projectId) {
        return String.format(CREATE_BUCKET_REQUEST_FORMAT, projectId);
    }

    private static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to url encode string: " + string, e);
        }
    }
}

