/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.integration;

import com.google.cloud.hadoop.gcsio.AssertingLogHandler;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientGrpcTracingInterceptor;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTracingFields;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.truth.Truth;
import com.google.gson.Gson;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.google.storage.v2.BucketName;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GoogleCloudStorageClientInterceptorIntegrationTest {
    private static final GoogleCloudStorageOptions GCS_TRACE_OPTIONS = GoogleCloudStorageTestHelper.getStandardOptionBuilder().setTraceLogEnabled(Boolean.valueOf(true)).build();
    private static final Logger LOGGER = Logger.getLogger(GoogleCloudStorageClientGrpcTracingInterceptor.class.getName());
    private static final GoogleCloudStorageTestHelper.TestBucketHelper BUCKET_HELPER = new GoogleCloudStorageTestHelper.TestBucketHelper("dataproc-grpc-interceptor");
    private static final String TEST_BUCKET = BUCKET_HELPER.getUniqueBucketPrefix();
    private static GoogleCloudStorage helperGcs = GoogleCloudStorageTestHelper.createGcsClientImpl();
    private AssertingLogHandler assertingHandler;
    private final Gson gson = new Gson();
    @Rule
    public TestName name = new TestName(){

        public String getMethodName() {
            return super.getMethodName();
        }
    };

    @BeforeClass
    public static void setup() throws IOException {
        helperGcs.createBucket(TEST_BUCKET);
    }

    @AfterClass
    public static void after() throws IOException {
        try {
            BUCKET_HELPER.cleanup(helperGcs);
        }
        finally {
            helperGcs.close();
        }
    }

    @Before
    public void setUpHandlers() throws IOException {
        this.assertingHandler = new AssertingLogHandler();
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(this.assertingHandler);
        LOGGER.setLevel(Level.INFO);
    }

    @After
    public void verifyAndRemoveAssertingHandler() {
        LOGGER.removeHandler(this.assertingHandler);
    }

    @Test
    public void testWriteLogs() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, this.name.getMethodName());
        int uploadChunkSize = 0x200000;
        GoogleCloudStorageOptions storageOption = GCS_TRACE_OPTIONS.toBuilder().setWriteChannelOptions(AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).build()).build();
        GoogleCloudStorage gcsImpl = GoogleCloudStorageClientInterceptorIntegrationTest.getGCSClientImpl(storageOption);
        int fileSize = uploadChunkSize - 1;
        GoogleCloudStorageTestHelper.writeObject(gcsImpl, resourceId, fileSize, 1);
        this.assertingHandler.assertLogCount(6);
        this.verifyChannelCreation(this.assertingHandler.getSubListOfRecords(0, 2), resourceId);
        Map<String, Object> writeObjectRequestRecord = this.assertingHandler.getLogRecordAtIndex(3);
        String writeObjectInvocationId = writeObjectRequestRecord.get(GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name).toString();
        Truth.assertThat((String)writeObjectInvocationId).isNotNull();
        WriteObjectRequest request = (WriteObjectRequest)this.fromProtoToMsg(writeObjectRequestRecord.get(GoogleCloudStorageTracingFields.REQUEST_MESSAGE_AS_STRING.name).toString(), (Message.Builder)WriteObjectRequest.newBuilder());
        Truth.assertThat((String)request.getUploadId()).isNotNull();
        Assert.assertTrue((boolean)request.getFinishWrite());
        Truth.assertThat((String)request.getChecksummedData().getContent().toStringUtf8()).isEqualTo((Object)String.format("<size (%d)>", fileSize));
        Map<String, Object> writeObjectResponseRecord = this.assertingHandler.getLogRecordAtIndex(4);
        WriteObjectResponse response = (WriteObjectResponse)this.fromProtoToMsg(writeObjectResponseRecord.get(GoogleCloudStorageTracingFields.RESPONSE_MESSAGE_AS_STRING.name).toString(), (Message.Builder)WriteObjectResponse.newBuilder());
        Truth.assertThat((String)response.getResource().getName()).isEqualTo((Object)resourceId.getObjectName());
        Truth.assertThat((Long)response.getResource().getSize()).isEqualTo((Object)fileSize);
        Map<String, Object> writeObjectCloseStatusRecord = this.assertingHandler.getLogRecordAtIndex(5);
        this.verifyCloseStatus(writeObjectCloseStatusRecord, "WriteObject", writeObjectInvocationId, Status.OK);
        gcsImpl.close();
    }

    @Test
    public void testReadLogs() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(TEST_BUCKET, this.name.getMethodName());
        int uploadChunkSize = 0x200000;
        GoogleCloudStorageOptions storageOption = GCS_TRACE_OPTIONS.toBuilder().setWriteChannelOptions(AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunkSize).build()).build();
        GoogleCloudStorage gcsImpl = GoogleCloudStorageClientInterceptorIntegrationTest.getGCSClientImpl(storageOption);
        int partitionsCount = 1;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject(gcsImpl, resourceId, 0x200000, partitionsCount);
        this.assertingHandler.assertLogCount(9);
        this.assertingHandler.flush();
        GoogleCloudStorageTestHelper.assertObjectContent(gcsImpl, resourceId, partition, partitionsCount);
        this.assertingHandler.assertLogCount(3);
        StorageResourceId derivedResourceId = this.derivedResourceId(resourceId);
        Map<String, Object> readObjectRequestRecord = this.assertingHandler.getLogRecordAtIndex(0);
        String streamInvocationId = readObjectRequestRecord.get(GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name).toString();
        Truth.assertThat((String)readObjectRequestRecord.get(GoogleCloudStorageTracingFields.RPC_METHOD.name).toString()).isEqualTo((Object)"ReadObject");
        ReadObjectRequest request = (ReadObjectRequest)this.fromProtoToMsg(readObjectRequestRecord.get(GoogleCloudStorageTracingFields.REQUEST_MESSAGE_AS_STRING.name).toString(), (Message.Builder)ReadObjectRequest.newBuilder());
        Truth.assertThat((String)request.getBucket()).isEqualTo((Object)derivedResourceId.getBucketName());
        Truth.assertThat((String)request.getObject()).isEqualTo((Object)derivedResourceId.getObjectName());
        Truth.assertThat((Long)request.getReadOffset()).isEqualTo((Object)0);
        Truth.assertThat((Long)request.getReadLimit()).isEqualTo((Object)partition.length);
        Map<String, Object> readObjectResponseRecord = this.assertingHandler.getLogRecordAtIndex(1);
        ReadObjectResponse response = (ReadObjectResponse)this.fromProtoToMsg(readObjectResponseRecord.get(GoogleCloudStorageTracingFields.RESPONSE_MESSAGE_AS_STRING.name).toString(), (Message.Builder)ReadObjectResponse.newBuilder());
        Truth.assertThat((String)response.getChecksummedData().getContent().toStringUtf8()).isEqualTo((Object)String.format("<size (%d)>", partition.length));
        Truth.assertThat((Object)readObjectResponseRecord.get(GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name)).isEqualTo((Object)streamInvocationId);
        Map<String, Object> readObjectCloseStatusRecord = this.assertingHandler.getLogRecordAtIndex(2);
        this.verifyCloseStatus(readObjectCloseStatusRecord, "ReadObject", streamInvocationId, Status.OK);
        gcsImpl.close();
    }

    public static GoogleCloudStorage getGCSClientImpl(GoogleCloudStorageOptions options) {
        try {
            return GoogleCloudStorageClientImpl.builder().setOptions(options).setCredentials(GoogleCloudStorageTestHelper.getCredentials()).setCredential(GoogleCloudStorageTestHelper.getCredential()).build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create GoogleCloudStorage instance", e);
        }
    }

    private void verifyCommonFields(Map<String, Object> logRecord, String rpcMethod) {
        Truth.assertThat((Object)logRecord.get(GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name)).isNotNull();
        Truth.assertThat((Object)logRecord.get(GoogleCloudStorageTracingFields.CURRENT_TIME.name)).isNotNull();
        Truth.assertThat((Object)logRecord.get(GoogleCloudStorageTracingFields.RPC_METHOD.name)).isEqualTo((Object)rpcMethod);
    }

    private void verifyCloseStatus(Map<String, Object> logRecord, String rpcMethod, String streamInvocationId, Status status) {
        this.verifyCommonFields(logRecord, rpcMethod);
        Truth.assertThat((String)logRecord.get(GoogleCloudStorageTracingFields.STATUS.name).toString()).contains((CharSequence)status.getCode().toString());
        Truth.assertThat((Object)logRecord.get(GoogleCloudStorageTracingFields.DURATION_MS.name)).isNotNull();
        Truth.assertThat((Object)logRecord.get(GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name)).isEqualTo((Object)streamInvocationId);
    }

    private StorageResourceId derivedResourceId(StorageResourceId resourceId) {
        String bucketName = BucketName.newBuilder().setBucket(resourceId.getBucketName()).setProject("_").build().toString();
        return new StorageResourceId(bucketName, resourceId.getObjectName(), resourceId.getGenerationId());
    }

    private void verifyChannelCreation(List<Map<String, Object>> logRecord, StorageResourceId resourceId) throws TextFormat.ParseException {
        Truth.assertThat((Integer)logRecord.size()).isEqualTo((Object)3);
        String rpcMethod = "StartResumableWrite";
        StorageResourceId derivedResourceId = this.derivedResourceId(resourceId);
        Map<String, Object> logRecordEntry = logRecord.get(0);
        this.verifyCommonFields(logRecord.get(0), rpcMethod);
        String streamInvocationId = logRecordEntry.get(GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name).toString();
        Truth.assertThat((String)streamInvocationId).isNotNull();
        StartResumableWriteRequest request = (StartResumableWriteRequest)this.fromProtoToMsg(logRecordEntry.get(GoogleCloudStorageTracingFields.REQUEST_MESSAGE_AS_STRING.name).toString(), (Message.Builder)StartResumableWriteRequest.newBuilder());
        Truth.assertThat((String)request.getWriteObjectSpec().getResource().getName()).isEqualTo((Object)derivedResourceId.getObjectName());
        Truth.assertThat((String)request.getWriteObjectSpec().getResource().getBucket()).isEqualTo((Object)derivedResourceId.getBucketName());
        Truth.assertThat((Object)logRecordEntry.get(GoogleCloudStorageTracingFields.REQUEST_COUNTER.name)).isEqualTo((Object)1);
        logRecordEntry = logRecord.get(1);
        this.verifyCommonFields(logRecordEntry, rpcMethod);
        StartResumableWriteResponse response = (StartResumableWriteResponse)this.fromProtoToMsg(logRecord.get(1).get(GoogleCloudStorageTracingFields.RESPONSE_MESSAGE_AS_STRING.name).toString(), (Message.Builder)StartResumableWriteResponse.newBuilder());
        Truth.assertThat((String)response.getUploadId()).isNotNull();
        Truth.assertThat((Object)logRecordEntry.get(GoogleCloudStorageTracingFields.RESPONSE_COUNTER.name)).isEqualTo((Object)1);
        Truth.assertThat((Object)logRecordEntry.get(GoogleCloudStorageTracingFields.IDEMPOTENCY_TOKEN.name)).isEqualTo((Object)streamInvocationId);
        this.verifyCloseStatus(logRecord.get(2), rpcMethod, streamInvocationId, Status.OK);
    }

    private Object fromProtoToMsg(String string, Message.Builder builder) throws TextFormat.ParseException {
        TextFormat.Parser.newBuilder().setAllowUnknownFields(true).build().merge((CharSequence)string, builder);
        return builder.build();
    }
}

