/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio.integration;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.AssertingLogHandler;
import com.google.cloud.hadoop.gcsio.CreateBucketOptions;
import com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.gcsio.EventLoggingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageClientImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.TrackingGrpcRequestInterceptor;
import com.google.cloud.hadoop.gcsio.TrackingHttpRequestInitializer;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GoogleCloudStorageImplTest {
    private GoogleCloudStorageTestHelper.TestBucketHelper bucketHelper;
    private String testBucket;
    private static final GoogleCloudStorageOptions GCS_OPTIONS = GoogleCloudStorageTestHelper.getStandardOptionBuilder().build();
    private static GoogleCloudStorage helperGcs;
    private final boolean testStorageClientImpl;
    @Rule
    public TestName name = new TestName(){

        public String getMethodName() {
            return super.getMethodName().replaceAll("[\\[,\\]]", "");
        }
    };

    public GoogleCloudStorageImplTest(boolean tesStorageClientImpl) {
        this.testStorageClientImpl = tesStorageClientImpl;
    }

    @Parameterized.Parameters
    public static Iterable<Boolean> javaClientEnabled() {
        return ImmutableList.of((Object)false, (Object)true);
    }

    @Before
    public void before() throws IOException {
        helperGcs = this.testStorageClientImpl ? GoogleCloudStorageTestHelper.createGcsClientImpl() : GoogleCloudStorageTestHelper.createGoogleCloudStorage();
        this.bucketHelper = new GoogleCloudStorageTestHelper.TestBucketHelper("dataproc-gcs-impl");
        this.testBucket = this.bucketHelper.getUniqueBucketPrefix();
        helperGcs.createBucket(this.testBucket);
    }

    @After
    public void after() throws IOException {
        try {
            this.bucketHelper.cleanup(helperGcs);
        }
        finally {
            helperGcs.close();
        }
    }

    @Test
    public void open_lazyInit_whenFastFailOnNotFound_isFalse() throws IOException {
        int expectedSize = 0x500000;
        StorageResourceId resourceId = new StorageResourceId(this.testBucket, this.name.getMethodName());
        GoogleCloudStorageTestHelper.writeObject(helperGcs, resourceId, expectedSize, 1);
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        GoogleCloudStorageReadOptions readOptions = GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(false).build();
        try (SeekableByteChannel readChannel = ((GoogleCloudStorage)trackingGcs.delegate).open(resourceId, readOptions);){
            Truth.assertThat((Long)readChannel.size()).isEqualTo((Object)expectedSize);
        }
        Truth.assertThat((Integer)trackingGcs.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs.requestsTracker.getAllRequests().size());
        String filelds = "contentEncoding,generation,size";
        if (this.testStorageClientImpl) {
            filelds = "bucket,name,timeCreated,updated,generation,metageneration,size,contentType,contentEncoding,md5Hash,crc32c,metadata";
        }
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getRequestString(resourceId.getBucketName(), resourceId.getObjectName(), filelds)});
        ((GoogleCloudStorage)trackingGcs.delegate).close();
    }

    @Test
    public void writeObject_withGrpcWriteDisabled() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(this.testBucket, this.name.getMethodName());
        int uploadChunkSize = 0x200000;
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GoogleCloudStorageImplTest.getOptionsWithUploadChunk(uploadChunkSize).toBuilder().setGrpcWriteEnabled(false).build());
        int partitionsCount = 1;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject((GoogleCloudStorage)trackingGcs.delegate, resourceId, uploadChunkSize, partitionsCount);
        GoogleCloudStorageTestHelper.assertObjectContent(helperGcs, resourceId, partition, partitionsCount);
        Truth.assertThat((Integer)trackingGcs.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs.requestsTracker.getAllRequests().size());
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactlyElementsIn(ImmutableList.builder().add((Object)TrackingHttpRequestInitializer.getRequestString(resourceId.getBucketName(), resourceId.getObjectName())).add((Object)TrackingHttpRequestInitializer.resumableUploadRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 1, true)).addAll((Iterable)ImmutableList.of((Object)TrackingHttpRequestInitializer.resumableUploadChunkRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 2, 1))).build().toArray()).inOrder();
        Truth.assertThat((Integer)trackingGcs.grpcRequestInterceptor.getAllRequestStrings().size()).isEqualTo((Object)0);
        ((GoogleCloudStorage)trackingGcs.delegate).close();
    }

    @Test
    public void writeLargeObject_withSmallUploadChunk() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(this.testBucket, this.name.getMethodName());
        int uploadChunkSize = 0x200000;
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GoogleCloudStorageImplTest.getOptionsWithUploadChunk(uploadChunkSize));
        int partitionsCount = 1;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject((GoogleCloudStorage)trackingGcs.delegate, resourceId, 0x500000, partitionsCount);
        GoogleCloudStorageTestHelper.assertObjectContent(helperGcs, resourceId, partition, partitionsCount);
        Truth.assertThat((Integer)trackingGcs.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs.requestsTracker.getAllRequests().size());
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactlyElementsIn(this.getExpectedRequestsForCreateObject(resourceId, uploadChunkSize, partitionsCount, partition)).inOrder();
        ((GoogleCloudStorage)trackingGcs.delegate).close();
    }

    @Test
    public void writeObject_withNonAlignedUploadChunk() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(this.testBucket, this.name.getMethodName());
        int uploadChunkSize = 0x200000;
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GoogleCloudStorageImplTest.getOptionsWithUploadChunk(uploadChunkSize));
        int partitionsCount = 17;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject((GoogleCloudStorage)trackingGcs.delegate, resourceId, 0x100000, partitionsCount);
        GoogleCloudStorageTestHelper.assertObjectContent(helperGcs, resourceId, partition, partitionsCount);
        Truth.assertThat((Integer)trackingGcs.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs.requestsTracker.getAllRequests().size());
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactlyElementsIn(this.getExpectedRequestsForCreateObject(resourceId, uploadChunkSize, partitionsCount, partition)).inOrder();
        ((GoogleCloudStorage)trackingGcs.delegate).close();
    }

    @Test
    public void conflictingWrites_noOverwrite_lastFails() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(this.testBucket, this.name.getMethodName());
        int uploadChunkSize = 0x200000;
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GoogleCloudStorageImplTest.getOptionsWithUploadChunk(uploadChunkSize));
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs2 = this.newTrackingGoogleCloudStorage(GoogleCloudStorageImplTest.getOptionsWithUploadChunk(uploadChunkSize));
        byte[] bytesToWrite = new byte[3 * uploadChunkSize];
        GoogleCloudStorageTestHelper.fillBytes(bytesToWrite);
        WritableByteChannel channel1 = ((GoogleCloudStorage)trackingGcs.delegate).create(resourceId, CreateObjectOptions.DEFAULT_NO_OVERWRITE);
        channel1.write(ByteBuffer.wrap(bytesToWrite));
        WritableByteChannel channel2 = ((GoogleCloudStorage)trackingGcs2.delegate).create(resourceId, CreateObjectOptions.DEFAULT_NO_OVERWRITE);
        channel1.close();
        Throwable thrown = Assert.assertThrows(Throwable.class, channel2::close);
        Truth.assertThat((Throwable)thrown).hasCauseThat().hasMessageThat().containsMatch(Pattern.compile("(412 Precondition Failed)|(FAILED_PRECONDITION)"));
        GoogleCloudStorageTestHelper.assertObjectContent(helperGcs, resourceId, bytesToWrite, 1);
        Truth.assertThat((Integer)trackingGcs.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs.requestsTracker.getAllRequests().size());
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactlyElementsIn(this.getExpectedRequestsForCreateObject(resourceId, uploadChunkSize, 1, bytesToWrite)).inOrder();
        Truth.assertThat((Integer)trackingGcs2.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs2.requestsTracker.getAllRequests().size());
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactlyElementsIn(this.getExpectedRequestsForCreateObject(resourceId, uploadChunkSize, 1, bytesToWrite)).inOrder();
        ((GoogleCloudStorage)trackingGcs.delegate).close();
        ((GoogleCloudStorage)trackingGcs2.delegate).close();
    }

    @Test
    public void create_doesNotRepairImplicitDirectories() throws IOException {
        String testDirectory = this.name.getMethodName();
        StorageResourceId resourceId = new StorageResourceId(this.testBucket, testDirectory + "/obj");
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        ((GoogleCloudStorage)trackingGcs.delegate).createEmptyObject(resourceId);
        GoogleCloudStorageItemInfo itemInfo = helperGcs.getItemInfo(new StorageResourceId(this.testBucket, testDirectory + "/"));
        Truth.assertThat((Boolean)itemInfo.exists()).isFalse();
        List listedItems = helperGcs.listObjectInfo(this.testBucket, testDirectory + "/");
        Truth.assertThat((Object[])listedItems.stream().map(GoogleCloudStorageItemInfo::getResourceId).toArray()).asList().containsExactly(new Object[]{resourceId});
        Truth.assertThat((Integer)trackingGcs.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs.requestsTracker.getAllRequests().size());
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.uploadRequestString(resourceId.getBucketName(), resourceId.getObjectName(), null)});
        ((GoogleCloudStorage)trackingGcs.delegate).close();
    }

    @Test
    public void create_correctlySetsContentType() throws IOException {
        StorageResourceId resourceId1 = new StorageResourceId(this.testBucket, this.name.getMethodName() + "_obj1");
        StorageResourceId resourceId2 = new StorageResourceId(this.testBucket, this.name.getMethodName() + "_obj2");
        StorageResourceId resourceId3 = new StorageResourceId(this.testBucket, this.name.getMethodName() + "obj3");
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        ((GoogleCloudStorage)trackingGcs.delegate).create(resourceId1, CreateObjectOptions.builder().setContentType("text/plain").build()).close();
        ((GoogleCloudStorage)trackingGcs.delegate).create(resourceId2, CreateObjectOptions.builder().setContentType("image/png").build()).close();
        ((GoogleCloudStorage)trackingGcs.delegate).create(resourceId3).close();
        Truth.assertThat((Object[])helperGcs.getItemInfos((List)ImmutableList.of((Object)resourceId1, (Object)resourceId2, (Object)resourceId3)).stream().map(GoogleCloudStorageItemInfo::getContentType).toArray()).asList().containsExactly(new Object[]{"text/plain", "image/png", "application/octet-stream"}).inOrder();
        Truth.assertThat((Integer)trackingGcs.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs.requestsTracker.getAllRequests().size());
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactly(ImmutableList.builder().add((Object)TrackingHttpRequestInitializer.getRequestString(resourceId1.getBucketName(), resourceId1.getObjectName())).add((Object)this.resumableUploadRequestString(resourceId1.getBucketName(), resourceId1.getObjectName(), 1, true)).addAll(this.resumableUploadChunkRequestString(resourceId1.getBucketName(), resourceId1.getObjectName(), 2, 1, 0, 0L, true)).add((Object)TrackingHttpRequestInitializer.getRequestString(resourceId2.getBucketName(), resourceId2.getObjectName())).add((Object)this.resumableUploadRequestString(resourceId2.getBucketName(), resourceId2.getObjectName(), 3, true)).addAll(this.resumableUploadChunkRequestString(resourceId2.getBucketName(), resourceId2.getObjectName(), 4, 2, 0, 0L, true)).add((Object)TrackingHttpRequestInitializer.getRequestString(resourceId3.getBucketName(), resourceId3.getObjectName())).add((Object)this.resumableUploadRequestString(resourceId3.getBucketName(), resourceId3.getObjectName(), 5, true)).addAll(this.resumableUploadChunkRequestString(resourceId3.getBucketName(), resourceId3.getObjectName(), 6, 3, 0, 0L, true)).build().toArray());
        ((GoogleCloudStorage)trackingGcs.delegate).close();
    }

    @Test
    public void copy_withRewrite_multipleRequests() throws IOException {
        int maxBytesRewrittenPerCall = 0x10000000;
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GoogleCloudStorageTestHelper.getStandardOptionBuilder().setCopyWithRewriteEnabled(true).setMaxBytesRewrittenPerCall((long)maxBytesRewrittenPerCall).build());
        String srcBucketName = this.testBucket;
        StorageResourceId resourceId = new StorageResourceId(srcBucketName, this.name.getMethodName() + "_src");
        String dstBucketName = this.bucketHelper.getUniqueBucketName(UUID.randomUUID().toString().replaceAll("-", "").substring(0, 10));
        helperGcs.createBucket(dstBucketName, CreateBucketOptions.builder().setStorageClass("nearline").build());
        StorageResourceId copiedResourceId = new StorageResourceId(dstBucketName, this.name.getMethodName() + "_dst");
        int partitionsCount = 10;
        byte[] partition = GoogleCloudStorageTestHelper.writeObject(helperGcs, resourceId, 0x4000000, partitionsCount);
        ((GoogleCloudStorage)trackingGcs.delegate).copy(srcBucketName, (List)ImmutableList.of((Object)resourceId.getObjectName()), dstBucketName, (List)ImmutableList.of((Object)copiedResourceId.getObjectName()));
        GoogleCloudStorageTestHelper.assertObjectContent(helperGcs, copiedResourceId, partition, partitionsCount);
        Truth.assertThat((Integer)trackingGcs.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs.requestsTracker.getAllRequests().size());
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactly(new Object[]{TrackingHttpRequestInitializer.getBucketRequestString(resourceId.getBucketName()), TrackingHttpRequestInitializer.getBucketRequestString(copiedResourceId.getBucketName()), TrackingHttpRequestInitializer.rewriteRequestString(resourceId.getBucketName(), resourceId.getObjectName(), copiedResourceId.getBucketName(), copiedResourceId.getObjectName(), maxBytesRewrittenPerCall, null), TrackingHttpRequestInitializer.rewriteRequestString(resourceId.getBucketName(), resourceId.getObjectName(), copiedResourceId.getBucketName(), copiedResourceId.getObjectName(), maxBytesRewrittenPerCall, 1), TrackingHttpRequestInitializer.rewriteRequestString(resourceId.getBucketName(), resourceId.getObjectName(), copiedResourceId.getBucketName(), copiedResourceId.getObjectName(), maxBytesRewrittenPerCall, 2)});
        ((GoogleCloudStorage)trackingGcs.delegate).close();
    }

    @Test
    public void create_gcsItemInfo_metadataEquals() throws IOException {
        StorageResourceId resourceId = new StorageResourceId(this.testBucket, this.name.getMethodName());
        GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GCS_OPTIONS);
        ImmutableMap expectedMetadata = ImmutableMap.of((Object)"key1", (Object)"value1".getBytes(StandardCharsets.UTF_8), (Object)"key2", (Object)"value2".getBytes(StandardCharsets.UTF_8));
        ImmutableMap wrongMetadata = ImmutableMap.of((Object)"key", (Object)"value1".getBytes(StandardCharsets.UTF_8), (Object)"key2", (Object)"value2".getBytes(StandardCharsets.UTF_8));
        ((GoogleCloudStorage)trackingGcs.delegate).create(resourceId, CreateObjectOptions.builder().setMetadata((Map)expectedMetadata).build()).close();
        GoogleCloudStorageItemInfo itemInfo = helperGcs.getItemInfo(resourceId);
        Truth.assertThat((Boolean)itemInfo.metadataEquals((Map)expectedMetadata)).isTrue();
        Truth.assertThat((Boolean)itemInfo.metadataEquals(itemInfo.getMetadata())).isTrue();
        Truth.assertThat((Boolean)itemInfo.metadataEquals((Map)wrongMetadata)).isFalse();
        Truth.assertThat((Integer)trackingGcs.requestsTracker.getAllRequestInvocationIds().size()).isEqualTo((Object)trackingGcs.requestsTracker.getAllRequests().size());
        Truth.assertThat((Iterable)trackingGcs.getAllRequestStrings()).containsExactly(ImmutableList.builder().add((Object)TrackingHttpRequestInitializer.getRequestString(resourceId.getBucketName(), resourceId.getObjectName())).add((Object)this.resumableUploadRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 1, true)).addAll(this.resumableUploadChunkRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 2, 1, 0, 0L, true)).build().toArray());
        ((GoogleCloudStorage)trackingGcs.delegate).close();
    }

    @Test
    public void tracelog_enabled() throws IOException {
        if (!this.testStorageClientImpl) {
            this.doTestTraceLog(true, 3, 5);
        }
    }

    @Test
    public void tracelog_disabled() throws IOException {
        this.doTestTraceLog(false, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestTraceLog(boolean traceLogEnabled, int expectedAfterWrite, int expectedAfterRead) throws IOException {
        AssertingLogHandler jsonLogHander = new AssertingLogHandler();
        Logger jsonTracingLogger = jsonLogHander.getLoggerForClass(EventLoggingHttpRequestInitializer.class.getName());
        try {
            GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> trackingGcs = this.newTrackingGoogleCloudStorage(GoogleCloudStorageTestHelper.getStandardOptionBuilder().setTraceLogEnabled(Boolean.valueOf(traceLogEnabled)).build());
            int expectedSize = 0x500000;
            StorageResourceId resourceId = new StorageResourceId(this.testBucket, this.name.getMethodName());
            byte[] writtenData = GoogleCloudStorageTestHelper.writeObject((GoogleCloudStorage)trackingGcs.delegate, resourceId, expectedSize, 1);
            jsonLogHander.assertLogCount(expectedAfterWrite);
            GoogleCloudStorageTestHelper.assertObjectContent((GoogleCloudStorage)trackingGcs.delegate, resourceId, writtenData);
            jsonLogHander.assertLogCount(expectedAfterRead);
            jsonLogHander.verifyJsonLogFields(this.testBucket, this.name.getMethodName());
            ((GoogleCloudStorage)trackingGcs.delegate).close();
        }
        finally {
            jsonTracingLogger.removeHandler(jsonLogHander);
        }
    }

    private GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage> newTrackingGoogleCloudStorage(GoogleCloudStorageOptions options) throws IOException {
        Credential credential = GoogleCloudStorageTestHelper.getCredential();
        Credentials credentials = GoogleCloudStorageTestHelper.getCredentials();
        return new GoogleCloudStorageTestHelper.TrackingStorageWrapper<GoogleCloudStorage>(options, (httpRequestInitializer, grpcRequestInterceptors) -> this.testStorageClientImpl ? GoogleCloudStorageClientImpl.builder().setOptions(options).setCredentials(credentials).setCredential(credential).setHttpRequestInitializer((HttpRequestInitializer)httpRequestInitializer).setGRPCInterceptors(grpcRequestInterceptors).build() : new GoogleCloudStorageImpl(options, (HttpRequestInitializer)httpRequestInitializer), credential);
    }

    private GoogleCloudStorage getStorageFromOptions(GoogleCloudStorageOptions storageOptions) throws IOException {
        Credential credential = GoogleCloudStorageTestHelper.getCredential();
        Credentials credentials = GoogleCloudStorageTestHelper.getCredentials();
        return this.testStorageClientImpl ? GoogleCloudStorageClientImpl.builder().setOptions(storageOptions).setCredentials(credentials).setCredential(credential).build() : new GoogleCloudStorageImpl(storageOptions, credential);
    }

    private static GoogleCloudStorageOptions getOptionsWithUploadChunk(int uploadChunk) {
        return GoogleCloudStorageTestHelper.getStandardOptionBuilder().setWriteChannelOptions(AsyncWriteChannelOptions.builder().setUploadChunkSize(uploadChunk).build()).build();
    }

    public List<String> getExpectedRequestsForCreateObject(StorageResourceId resourceId, int uploadChunkSize, int partitionsCount, byte[] partition) {
        double contentLength = (double)partition.length * (double)partitionsCount;
        int effectiveChunkSize = this.testStorageClientImpl ? Math.min(uploadChunkSize, 0x200000) : uploadChunkSize;
        int uploadChunkCount = (int)Math.max(1.0, Math.ceil((double)partition.length * (double)partitionsCount / (double)effectiveChunkSize));
        return ImmutableList.builder().add((Object)TrackingHttpRequestInitializer.getRequestString(resourceId.getBucketName(), resourceId.getObjectName())).add((Object)this.resumableUploadRequestString(resourceId.getBucketName(), resourceId.getObjectName(), 1, true)).addAll((Iterable)IntStream.rangeClosed(1, uploadChunkCount).mapToObj(i -> {
            int writeOffset = (int)Math.min((double)((i - 1) * effectiveChunkSize), contentLength);
            return this.resumableUploadChunkRequestString(resourceId.getBucketName(), resourceId.getObjectName(), i + 1, i, writeOffset, (int)Math.min(contentLength - (double)writeOffset, (double)effectiveChunkSize), i == uploadChunkCount);
        }).collect(Collectors.toList()).stream().flatMap(Collection::stream).collect(Collectors.toList())).build();
    }

    private String resumableUploadRequestString(String bucketName, String objectName, Integer generationId, boolean replaceGenrationId) {
        if (this.testStorageClientImpl) {
            return TrackingGrpcRequestInterceptor.resumableUploadRequestString(bucketName, objectName, generationId);
        }
        return TrackingHttpRequestInitializer.resumableUploadRequestString(bucketName, objectName, generationId, replaceGenrationId);
    }

    private ImmutableList<String> resumableUploadChunkRequestString(String bucketName, String objectName, Integer generationId, Integer uploadId, int writeOffset, long length, boolean finishWrite) {
        if (this.testStorageClientImpl) {
            ArrayList<String> requestsList = new ArrayList<String>();
            if (!finishWrite) {
                requestsList.add(TrackingGrpcRequestInterceptor.resumableUploadChunkRequestString(generationId, uploadId, length, writeOffset, false));
            } else if (length == 0L) {
                requestsList.add(TrackingGrpcRequestInterceptor.resumableUploadChunkRequestString(generationId, uploadId, 0L, writeOffset, true));
            } else {
                requestsList.add(TrackingGrpcRequestInterceptor.resumableUploadChunkRequestString(generationId, uploadId, length, writeOffset, false));
                requestsList.add(TrackingGrpcRequestInterceptor.resumableUploadChunkRequestString(generationId + 1, uploadId + 1, 0L, (long)writeOffset + length, true));
            }
            return ImmutableList.copyOf(requestsList);
        }
        return ImmutableList.of((Object)TrackingHttpRequestInitializer.resumableUploadChunkRequestString(bucketName, objectName, generationId, uploadId));
    }
}

