package com.google.cloud.hadoop.gcsio;

import java.util.regex.Pattern;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageFileSystemOptions extends GoogleCloudStorageFileSystemOptions {

  private final boolean performanceCacheEnabled;

  private final PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions;

  private final GoogleCloudStorageOptions cloudStorageOptions;

  private final boolean bucketDeleteEnabled;

  private final Pattern markerFilePattern;

  private final boolean statusParallelEnabled;

  private final boolean cooperativeLockingEnabled;

  private final boolean ensureNoConflictingItems;

  private AutoValue_GoogleCloudStorageFileSystemOptions(
      boolean performanceCacheEnabled,
      PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions,
      GoogleCloudStorageOptions cloudStorageOptions,
      boolean bucketDeleteEnabled,
      @Nullable Pattern markerFilePattern,
      boolean statusParallelEnabled,
      boolean cooperativeLockingEnabled,
      boolean ensureNoConflictingItems) {
    this.performanceCacheEnabled = performanceCacheEnabled;
    this.performanceCacheOptions = performanceCacheOptions;
    this.cloudStorageOptions = cloudStorageOptions;
    this.bucketDeleteEnabled = bucketDeleteEnabled;
    this.markerFilePattern = markerFilePattern;
    this.statusParallelEnabled = statusParallelEnabled;
    this.cooperativeLockingEnabled = cooperativeLockingEnabled;
    this.ensureNoConflictingItems = ensureNoConflictingItems;
  }

  @Override
  public boolean isPerformanceCacheEnabled() {
    return performanceCacheEnabled;
  }

  @Override
  public PerformanceCachingGoogleCloudStorageOptions getPerformanceCacheOptions() {
    return performanceCacheOptions;
  }

  @Override
  public GoogleCloudStorageOptions getCloudStorageOptions() {
    return cloudStorageOptions;
  }

  @Override
  public boolean isBucketDeleteEnabled() {
    return bucketDeleteEnabled;
  }

  @Nullable
  @Override
  public Pattern getMarkerFilePattern() {
    return markerFilePattern;
  }

  @Override
  public boolean isStatusParallelEnabled() {
    return statusParallelEnabled;
  }

  @Override
  public boolean isCooperativeLockingEnabled() {
    return cooperativeLockingEnabled;
  }

  @Override
  public boolean isEnsureNoConflictingItems() {
    return ensureNoConflictingItems;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageFileSystemOptions{"
        + "performanceCacheEnabled=" + performanceCacheEnabled + ", "
        + "performanceCacheOptions=" + performanceCacheOptions + ", "
        + "cloudStorageOptions=" + cloudStorageOptions + ", "
        + "bucketDeleteEnabled=" + bucketDeleteEnabled + ", "
        + "markerFilePattern=" + markerFilePattern + ", "
        + "statusParallelEnabled=" + statusParallelEnabled + ", "
        + "cooperativeLockingEnabled=" + cooperativeLockingEnabled + ", "
        + "ensureNoConflictingItems=" + ensureNoConflictingItems
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageFileSystemOptions) {
      GoogleCloudStorageFileSystemOptions that = (GoogleCloudStorageFileSystemOptions) o;
      return this.performanceCacheEnabled == that.isPerformanceCacheEnabled()
          && this.performanceCacheOptions.equals(that.getPerformanceCacheOptions())
          && this.cloudStorageOptions.equals(that.getCloudStorageOptions())
          && this.bucketDeleteEnabled == that.isBucketDeleteEnabled()
          && (this.markerFilePattern == null ? that.getMarkerFilePattern() == null : this.markerFilePattern.equals(that.getMarkerFilePattern()))
          && this.statusParallelEnabled == that.isStatusParallelEnabled()
          && this.cooperativeLockingEnabled == that.isCooperativeLockingEnabled()
          && this.ensureNoConflictingItems == that.isEnsureNoConflictingItems();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= performanceCacheEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= performanceCacheOptions.hashCode();
    h$ *= 1000003;
    h$ ^= cloudStorageOptions.hashCode();
    h$ *= 1000003;
    h$ ^= bucketDeleteEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (markerFilePattern == null) ? 0 : markerFilePattern.hashCode();
    h$ *= 1000003;
    h$ ^= statusParallelEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= cooperativeLockingEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= ensureNoConflictingItems ? 1231 : 1237;
    return h$;
  }

  @Override
  public GoogleCloudStorageFileSystemOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageFileSystemOptions.Builder {
    private Boolean performanceCacheEnabled;
    private PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions;
    private GoogleCloudStorageOptions cloudStorageOptions;
    private Boolean bucketDeleteEnabled;
    private Pattern markerFilePattern;
    private Boolean statusParallelEnabled;
    private Boolean cooperativeLockingEnabled;
    private Boolean ensureNoConflictingItems;
    Builder() {
    }
    private Builder(GoogleCloudStorageFileSystemOptions source) {
      this.performanceCacheEnabled = source.isPerformanceCacheEnabled();
      this.performanceCacheOptions = source.getPerformanceCacheOptions();
      this.cloudStorageOptions = source.getCloudStorageOptions();
      this.bucketDeleteEnabled = source.isBucketDeleteEnabled();
      this.markerFilePattern = source.getMarkerFilePattern();
      this.statusParallelEnabled = source.isStatusParallelEnabled();
      this.cooperativeLockingEnabled = source.isCooperativeLockingEnabled();
      this.ensureNoConflictingItems = source.isEnsureNoConflictingItems();
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setPerformanceCacheEnabled(boolean performanceCacheEnabled) {
      this.performanceCacheEnabled = performanceCacheEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setPerformanceCacheOptions(PerformanceCachingGoogleCloudStorageOptions performanceCacheOptions) {
      if (performanceCacheOptions == null) {
        throw new NullPointerException("Null performanceCacheOptions");
      }
      this.performanceCacheOptions = performanceCacheOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setCloudStorageOptions(GoogleCloudStorageOptions cloudStorageOptions) {
      if (cloudStorageOptions == null) {
        throw new NullPointerException("Null cloudStorageOptions");
      }
      this.cloudStorageOptions = cloudStorageOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setBucketDeleteEnabled(boolean bucketDeleteEnabled) {
      this.bucketDeleteEnabled = bucketDeleteEnabled;
      return this;
    }
    @Override
    GoogleCloudStorageFileSystemOptions.Builder setMarkerFilePattern(Pattern markerFilePattern) {
      this.markerFilePattern = markerFilePattern;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setStatusParallelEnabled(boolean statusParallelEnabled) {
      this.statusParallelEnabled = statusParallelEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setCooperativeLockingEnabled(boolean cooperativeLockingEnabled) {
      this.cooperativeLockingEnabled = cooperativeLockingEnabled;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions.Builder setEnsureNoConflictingItems(boolean ensureNoConflictingItems) {
      this.ensureNoConflictingItems = ensureNoConflictingItems;
      return this;
    }
    @Override
    public GoogleCloudStorageFileSystemOptions build() {
      if (this.performanceCacheEnabled == null
          || this.performanceCacheOptions == null
          || this.cloudStorageOptions == null
          || this.bucketDeleteEnabled == null
          || this.statusParallelEnabled == null
          || this.cooperativeLockingEnabled == null
          || this.ensureNoConflictingItems == null) {
        StringBuilder missing = new StringBuilder();
        if (this.performanceCacheEnabled == null) {
          missing.append(" performanceCacheEnabled");
        }
        if (this.performanceCacheOptions == null) {
          missing.append(" performanceCacheOptions");
        }
        if (this.cloudStorageOptions == null) {
          missing.append(" cloudStorageOptions");
        }
        if (this.bucketDeleteEnabled == null) {
          missing.append(" bucketDeleteEnabled");
        }
        if (this.statusParallelEnabled == null) {
          missing.append(" statusParallelEnabled");
        }
        if (this.cooperativeLockingEnabled == null) {
          missing.append(" cooperativeLockingEnabled");
        }
        if (this.ensureNoConflictingItems == null) {
          missing.append(" ensureNoConflictingItems");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageFileSystemOptions(
          this.performanceCacheEnabled,
          this.performanceCacheOptions,
          this.cloudStorageOptions,
          this.bucketDeleteEnabled,
          this.markerFilePattern,
          this.statusParallelEnabled,
          this.cooperativeLockingEnabled,
          this.ensureNoConflictingItems);
    }
  }

}
