package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageOptions extends GoogleCloudStorageOptions {

  private final boolean grpcEnabled;

  private final String grpcServerAddress;

  private final boolean trafficDirectorEnabled;

  private final boolean directPathPreferred;

  private final String storageRootUrl;

  private final String storageServicePath;

  private final String projectId;

  private final String appName;

  private final boolean autoRepairImplicitDirectoriesEnabled;

  private final Duration maxWaitTimeForEmptyObjectCreation;

  private final int maxListItemsPerCall;

  private final int maxRequestsPerBatch;

  private final int batchThreads;

  private final int maxHttpRequestRetries;

  private final Duration httpRequestConnectTimeout;

  private final Duration httpRequestReadTimeout;

  private final String proxyAddress;

  private final RedactedString proxyUsername;

  private final RedactedString proxyPassword;

  private final boolean copyWithRewriteEnabled;

  private final long maxRewriteChunkSize;

  private final GoogleCloudStorageReadOptions readChannelOptions;

  private final AsyncWriteChannelOptions writeChannelOptions;

  private final RequesterPaysOptions requesterPaysOptions;

  private final ImmutableMap<String, String> httpRequestHeaders;

  private final String encryptionAlgorithm;

  private final RedactedString encryptionKey;

  private final RedactedString encryptionKeyHash;

  private final Duration grpcMessageTimeoutCheckInterval;

  private final GoogleCloudStorageOptions.MetricsSink metricsSink;

  private final boolean traceLogEnabled;

  private AutoValue_GoogleCloudStorageOptions(
      boolean grpcEnabled,
      String grpcServerAddress,
      boolean trafficDirectorEnabled,
      boolean directPathPreferred,
      String storageRootUrl,
      String storageServicePath,
      @Nullable String projectId,
      @Nullable String appName,
      boolean autoRepairImplicitDirectoriesEnabled,
      Duration maxWaitTimeForEmptyObjectCreation,
      int maxListItemsPerCall,
      int maxRequestsPerBatch,
      int batchThreads,
      int maxHttpRequestRetries,
      Duration httpRequestConnectTimeout,
      Duration httpRequestReadTimeout,
      @Nullable String proxyAddress,
      @Nullable RedactedString proxyUsername,
      @Nullable RedactedString proxyPassword,
      boolean copyWithRewriteEnabled,
      long maxRewriteChunkSize,
      GoogleCloudStorageReadOptions readChannelOptions,
      AsyncWriteChannelOptions writeChannelOptions,
      RequesterPaysOptions requesterPaysOptions,
      ImmutableMap<String, String> httpRequestHeaders,
      @Nullable String encryptionAlgorithm,
      @Nullable RedactedString encryptionKey,
      @Nullable RedactedString encryptionKeyHash,
      Duration grpcMessageTimeoutCheckInterval,
      GoogleCloudStorageOptions.MetricsSink metricsSink,
      boolean traceLogEnabled) {
    this.grpcEnabled = grpcEnabled;
    this.grpcServerAddress = grpcServerAddress;
    this.trafficDirectorEnabled = trafficDirectorEnabled;
    this.directPathPreferred = directPathPreferred;
    this.storageRootUrl = storageRootUrl;
    this.storageServicePath = storageServicePath;
    this.projectId = projectId;
    this.appName = appName;
    this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
    this.maxWaitTimeForEmptyObjectCreation = maxWaitTimeForEmptyObjectCreation;
    this.maxListItemsPerCall = maxListItemsPerCall;
    this.maxRequestsPerBatch = maxRequestsPerBatch;
    this.batchThreads = batchThreads;
    this.maxHttpRequestRetries = maxHttpRequestRetries;
    this.httpRequestConnectTimeout = httpRequestConnectTimeout;
    this.httpRequestReadTimeout = httpRequestReadTimeout;
    this.proxyAddress = proxyAddress;
    this.proxyUsername = proxyUsername;
    this.proxyPassword = proxyPassword;
    this.copyWithRewriteEnabled = copyWithRewriteEnabled;
    this.maxRewriteChunkSize = maxRewriteChunkSize;
    this.readChannelOptions = readChannelOptions;
    this.writeChannelOptions = writeChannelOptions;
    this.requesterPaysOptions = requesterPaysOptions;
    this.httpRequestHeaders = httpRequestHeaders;
    this.encryptionAlgorithm = encryptionAlgorithm;
    this.encryptionKey = encryptionKey;
    this.encryptionKeyHash = encryptionKeyHash;
    this.grpcMessageTimeoutCheckInterval = grpcMessageTimeoutCheckInterval;
    this.metricsSink = metricsSink;
    this.traceLogEnabled = traceLogEnabled;
  }

  @Override
  public boolean isGrpcEnabled() {
    return grpcEnabled;
  }

  @Override
  public String getGrpcServerAddress() {
    return grpcServerAddress;
  }

  @Override
  public boolean isTrafficDirectorEnabled() {
    return trafficDirectorEnabled;
  }

  @Override
  public boolean isDirectPathPreferred() {
    return directPathPreferred;
  }

  @Override
  public String getStorageRootUrl() {
    return storageRootUrl;
  }

  @Override
  public String getStorageServicePath() {
    return storageServicePath;
  }

  @Nullable
  @Override
  public String getProjectId() {
    return projectId;
  }

  @Nullable
  @Override
  public String getAppName() {
    return appName;
  }

  @Override
  public boolean isAutoRepairImplicitDirectoriesEnabled() {
    return autoRepairImplicitDirectoriesEnabled;
  }

  @Override
  public Duration getMaxWaitTimeForEmptyObjectCreation() {
    return maxWaitTimeForEmptyObjectCreation;
  }

  @Override
  public int getMaxListItemsPerCall() {
    return maxListItemsPerCall;
  }

  @Override
  public int getMaxRequestsPerBatch() {
    return maxRequestsPerBatch;
  }

  @Override
  public int getBatchThreads() {
    return batchThreads;
  }

  @Override
  public int getMaxHttpRequestRetries() {
    return maxHttpRequestRetries;
  }

  @Override
  public Duration getHttpRequestConnectTimeout() {
    return httpRequestConnectTimeout;
  }

  @Override
  public Duration getHttpRequestReadTimeout() {
    return httpRequestReadTimeout;
  }

  @Nullable
  @Override
  public String getProxyAddress() {
    return proxyAddress;
  }

  @Nullable
  @Override
  public RedactedString getProxyUsername() {
    return proxyUsername;
  }

  @Nullable
  @Override
  public RedactedString getProxyPassword() {
    return proxyPassword;
  }

  @Override
  public boolean isCopyWithRewriteEnabled() {
    return copyWithRewriteEnabled;
  }

  @Override
  public long getMaxRewriteChunkSize() {
    return maxRewriteChunkSize;
  }

  @Override
  public GoogleCloudStorageReadOptions getReadChannelOptions() {
    return readChannelOptions;
  }

  @Override
  public AsyncWriteChannelOptions getWriteChannelOptions() {
    return writeChannelOptions;
  }

  @Override
  public RequesterPaysOptions getRequesterPaysOptions() {
    return requesterPaysOptions;
  }

  @Override
  public ImmutableMap<String, String> getHttpRequestHeaders() {
    return httpRequestHeaders;
  }

  @Nullable
  @Override
  public String getEncryptionAlgorithm() {
    return encryptionAlgorithm;
  }

  @Nullable
  @Override
  public RedactedString getEncryptionKey() {
    return encryptionKey;
  }

  @Nullable
  @Override
  public RedactedString getEncryptionKeyHash() {
    return encryptionKeyHash;
  }

  @Override
  public Duration getGrpcMessageTimeoutCheckInterval() {
    return grpcMessageTimeoutCheckInterval;
  }

  @Override
  public GoogleCloudStorageOptions.MetricsSink getMetricsSink() {
    return metricsSink;
  }

  @Override
  public boolean isTraceLogEnabled() {
    return traceLogEnabled;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageOptions{"
        + "grpcEnabled=" + grpcEnabled + ", "
        + "grpcServerAddress=" + grpcServerAddress + ", "
        + "trafficDirectorEnabled=" + trafficDirectorEnabled + ", "
        + "directPathPreferred=" + directPathPreferred + ", "
        + "storageRootUrl=" + storageRootUrl + ", "
        + "storageServicePath=" + storageServicePath + ", "
        + "projectId=" + projectId + ", "
        + "appName=" + appName + ", "
        + "autoRepairImplicitDirectoriesEnabled=" + autoRepairImplicitDirectoriesEnabled + ", "
        + "maxWaitTimeForEmptyObjectCreation=" + maxWaitTimeForEmptyObjectCreation + ", "
        + "maxListItemsPerCall=" + maxListItemsPerCall + ", "
        + "maxRequestsPerBatch=" + maxRequestsPerBatch + ", "
        + "batchThreads=" + batchThreads + ", "
        + "maxHttpRequestRetries=" + maxHttpRequestRetries + ", "
        + "httpRequestConnectTimeout=" + httpRequestConnectTimeout + ", "
        + "httpRequestReadTimeout=" + httpRequestReadTimeout + ", "
        + "proxyAddress=" + proxyAddress + ", "
        + "proxyUsername=" + proxyUsername + ", "
        + "proxyPassword=" + proxyPassword + ", "
        + "copyWithRewriteEnabled=" + copyWithRewriteEnabled + ", "
        + "maxRewriteChunkSize=" + maxRewriteChunkSize + ", "
        + "readChannelOptions=" + readChannelOptions + ", "
        + "writeChannelOptions=" + writeChannelOptions + ", "
        + "requesterPaysOptions=" + requesterPaysOptions + ", "
        + "httpRequestHeaders=" + httpRequestHeaders + ", "
        + "encryptionAlgorithm=" + encryptionAlgorithm + ", "
        + "encryptionKey=" + encryptionKey + ", "
        + "encryptionKeyHash=" + encryptionKeyHash + ", "
        + "grpcMessageTimeoutCheckInterval=" + grpcMessageTimeoutCheckInterval + ", "
        + "metricsSink=" + metricsSink + ", "
        + "traceLogEnabled=" + traceLogEnabled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageOptions) {
      GoogleCloudStorageOptions that = (GoogleCloudStorageOptions) o;
      return this.grpcEnabled == that.isGrpcEnabled()
          && this.grpcServerAddress.equals(that.getGrpcServerAddress())
          && this.trafficDirectorEnabled == that.isTrafficDirectorEnabled()
          && this.directPathPreferred == that.isDirectPathPreferred()
          && this.storageRootUrl.equals(that.getStorageRootUrl())
          && this.storageServicePath.equals(that.getStorageServicePath())
          && (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId()))
          && (this.appName == null ? that.getAppName() == null : this.appName.equals(that.getAppName()))
          && this.autoRepairImplicitDirectoriesEnabled == that.isAutoRepairImplicitDirectoriesEnabled()
          && this.maxWaitTimeForEmptyObjectCreation.equals(that.getMaxWaitTimeForEmptyObjectCreation())
          && this.maxListItemsPerCall == that.getMaxListItemsPerCall()
          && this.maxRequestsPerBatch == that.getMaxRequestsPerBatch()
          && this.batchThreads == that.getBatchThreads()
          && this.maxHttpRequestRetries == that.getMaxHttpRequestRetries()
          && this.httpRequestConnectTimeout.equals(that.getHttpRequestConnectTimeout())
          && this.httpRequestReadTimeout.equals(that.getHttpRequestReadTimeout())
          && (this.proxyAddress == null ? that.getProxyAddress() == null : this.proxyAddress.equals(that.getProxyAddress()))
          && (this.proxyUsername == null ? that.getProxyUsername() == null : this.proxyUsername.equals(that.getProxyUsername()))
          && (this.proxyPassword == null ? that.getProxyPassword() == null : this.proxyPassword.equals(that.getProxyPassword()))
          && this.copyWithRewriteEnabled == that.isCopyWithRewriteEnabled()
          && this.maxRewriteChunkSize == that.getMaxRewriteChunkSize()
          && this.readChannelOptions.equals(that.getReadChannelOptions())
          && this.writeChannelOptions.equals(that.getWriteChannelOptions())
          && this.requesterPaysOptions.equals(that.getRequesterPaysOptions())
          && this.httpRequestHeaders.equals(that.getHttpRequestHeaders())
          && (this.encryptionAlgorithm == null ? that.getEncryptionAlgorithm() == null : this.encryptionAlgorithm.equals(that.getEncryptionAlgorithm()))
          && (this.encryptionKey == null ? that.getEncryptionKey() == null : this.encryptionKey.equals(that.getEncryptionKey()))
          && (this.encryptionKeyHash == null ? that.getEncryptionKeyHash() == null : this.encryptionKeyHash.equals(that.getEncryptionKeyHash()))
          && this.grpcMessageTimeoutCheckInterval.equals(that.getGrpcMessageTimeoutCheckInterval())
          && this.metricsSink.equals(that.getMetricsSink())
          && this.traceLogEnabled == that.isTraceLogEnabled();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= grpcEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= grpcServerAddress.hashCode();
    h$ *= 1000003;
    h$ ^= trafficDirectorEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= directPathPreferred ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= storageRootUrl.hashCode();
    h$ *= 1000003;
    h$ ^= storageServicePath.hashCode();
    h$ *= 1000003;
    h$ ^= (projectId == null) ? 0 : projectId.hashCode();
    h$ *= 1000003;
    h$ ^= (appName == null) ? 0 : appName.hashCode();
    h$ *= 1000003;
    h$ ^= autoRepairImplicitDirectoriesEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= maxWaitTimeForEmptyObjectCreation.hashCode();
    h$ *= 1000003;
    h$ ^= maxListItemsPerCall;
    h$ *= 1000003;
    h$ ^= maxRequestsPerBatch;
    h$ *= 1000003;
    h$ ^= batchThreads;
    h$ *= 1000003;
    h$ ^= maxHttpRequestRetries;
    h$ *= 1000003;
    h$ ^= httpRequestConnectTimeout.hashCode();
    h$ *= 1000003;
    h$ ^= httpRequestReadTimeout.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyAddress == null) ? 0 : proxyAddress.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyUsername == null) ? 0 : proxyUsername.hashCode();
    h$ *= 1000003;
    h$ ^= (proxyPassword == null) ? 0 : proxyPassword.hashCode();
    h$ *= 1000003;
    h$ ^= copyWithRewriteEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((maxRewriteChunkSize >>> 32) ^ maxRewriteChunkSize);
    h$ *= 1000003;
    h$ ^= readChannelOptions.hashCode();
    h$ *= 1000003;
    h$ ^= writeChannelOptions.hashCode();
    h$ *= 1000003;
    h$ ^= requesterPaysOptions.hashCode();
    h$ *= 1000003;
    h$ ^= httpRequestHeaders.hashCode();
    h$ *= 1000003;
    h$ ^= (encryptionAlgorithm == null) ? 0 : encryptionAlgorithm.hashCode();
    h$ *= 1000003;
    h$ ^= (encryptionKey == null) ? 0 : encryptionKey.hashCode();
    h$ *= 1000003;
    h$ ^= (encryptionKeyHash == null) ? 0 : encryptionKeyHash.hashCode();
    h$ *= 1000003;
    h$ ^= grpcMessageTimeoutCheckInterval.hashCode();
    h$ *= 1000003;
    h$ ^= metricsSink.hashCode();
    h$ *= 1000003;
    h$ ^= traceLogEnabled ? 1231 : 1237;
    return h$;
  }

  @Override
  public GoogleCloudStorageOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageOptions.Builder {
    private boolean grpcEnabled;
    private String grpcServerAddress;
    private boolean trafficDirectorEnabled;
    private boolean directPathPreferred;
    private String storageRootUrl;
    private String storageServicePath;
    private String projectId;
    private String appName;
    private boolean autoRepairImplicitDirectoriesEnabled;
    private Duration maxWaitTimeForEmptyObjectCreation;
    private int maxListItemsPerCall;
    private int maxRequestsPerBatch;
    private int batchThreads;
    private int maxHttpRequestRetries;
    private Duration httpRequestConnectTimeout;
    private Duration httpRequestReadTimeout;
    private String proxyAddress;
    private RedactedString proxyUsername;
    private RedactedString proxyPassword;
    private boolean copyWithRewriteEnabled;
    private long maxRewriteChunkSize;
    private GoogleCloudStorageReadOptions readChannelOptions;
    private AsyncWriteChannelOptions writeChannelOptions;
    private RequesterPaysOptions requesterPaysOptions;
    private ImmutableMap<String, String> httpRequestHeaders;
    private String encryptionAlgorithm;
    private RedactedString encryptionKey;
    private RedactedString encryptionKeyHash;
    private Duration grpcMessageTimeoutCheckInterval;
    private GoogleCloudStorageOptions.MetricsSink metricsSink;
    private boolean traceLogEnabled;
    private short set$0;
    Builder() {
    }
    private Builder(GoogleCloudStorageOptions source) {
      this.grpcEnabled = source.isGrpcEnabled();
      this.grpcServerAddress = source.getGrpcServerAddress();
      this.trafficDirectorEnabled = source.isTrafficDirectorEnabled();
      this.directPathPreferred = source.isDirectPathPreferred();
      this.storageRootUrl = source.getStorageRootUrl();
      this.storageServicePath = source.getStorageServicePath();
      this.projectId = source.getProjectId();
      this.appName = source.getAppName();
      this.autoRepairImplicitDirectoriesEnabled = source.isAutoRepairImplicitDirectoriesEnabled();
      this.maxWaitTimeForEmptyObjectCreation = source.getMaxWaitTimeForEmptyObjectCreation();
      this.maxListItemsPerCall = source.getMaxListItemsPerCall();
      this.maxRequestsPerBatch = source.getMaxRequestsPerBatch();
      this.batchThreads = source.getBatchThreads();
      this.maxHttpRequestRetries = source.getMaxHttpRequestRetries();
      this.httpRequestConnectTimeout = source.getHttpRequestConnectTimeout();
      this.httpRequestReadTimeout = source.getHttpRequestReadTimeout();
      this.proxyAddress = source.getProxyAddress();
      this.proxyUsername = source.getProxyUsername();
      this.proxyPassword = source.getProxyPassword();
      this.copyWithRewriteEnabled = source.isCopyWithRewriteEnabled();
      this.maxRewriteChunkSize = source.getMaxRewriteChunkSize();
      this.readChannelOptions = source.getReadChannelOptions();
      this.writeChannelOptions = source.getWriteChannelOptions();
      this.requesterPaysOptions = source.getRequesterPaysOptions();
      this.httpRequestHeaders = source.getHttpRequestHeaders();
      this.encryptionAlgorithm = source.getEncryptionAlgorithm();
      this.encryptionKey = source.getEncryptionKey();
      this.encryptionKeyHash = source.getEncryptionKeyHash();
      this.grpcMessageTimeoutCheckInterval = source.getGrpcMessageTimeoutCheckInterval();
      this.metricsSink = source.getMetricsSink();
      this.traceLogEnabled = source.isTraceLogEnabled();
      set$0 = (short) 0x7ff;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcEnabled(boolean grpcEnabled) {
      this.grpcEnabled = grpcEnabled;
      set$0 |= 1;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcServerAddress(String grpcServerAddress) {
      if (grpcServerAddress == null) {
        throw new NullPointerException("Null grpcServerAddress");
      }
      this.grpcServerAddress = grpcServerAddress;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTrafficDirectorEnabled(boolean trafficDirectorEnabled) {
      this.trafficDirectorEnabled = trafficDirectorEnabled;
      set$0 |= 2;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setDirectPathPreferred(boolean directPathPreferred) {
      this.directPathPreferred = directPathPreferred;
      set$0 |= 4;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setStorageRootUrl(String storageRootUrl) {
      if (storageRootUrl == null) {
        throw new NullPointerException("Null storageRootUrl");
      }
      this.storageRootUrl = storageRootUrl;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setStorageServicePath(String storageServicePath) {
      if (storageServicePath == null) {
        throw new NullPointerException("Null storageServicePath");
      }
      this.storageServicePath = storageServicePath;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProjectId(String projectId) {
      this.projectId = projectId;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAppName(String appName) {
      this.appName = appName;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setAutoRepairImplicitDirectoriesEnabled(boolean autoRepairImplicitDirectoriesEnabled) {
      this.autoRepairImplicitDirectoriesEnabled = autoRepairImplicitDirectoriesEnabled;
      set$0 |= 8;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxWaitTimeForEmptyObjectCreation(Duration maxWaitTimeForEmptyObjectCreation) {
      if (maxWaitTimeForEmptyObjectCreation == null) {
        throw new NullPointerException("Null maxWaitTimeForEmptyObjectCreation");
      }
      this.maxWaitTimeForEmptyObjectCreation = maxWaitTimeForEmptyObjectCreation;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxListItemsPerCall(int maxListItemsPerCall) {
      this.maxListItemsPerCall = maxListItemsPerCall;
      set$0 |= 0x10;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxRequestsPerBatch(int maxRequestsPerBatch) {
      this.maxRequestsPerBatch = maxRequestsPerBatch;
      set$0 |= 0x20;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setBatchThreads(int batchThreads) {
      this.batchThreads = batchThreads;
      set$0 |= 0x40;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxHttpRequestRetries(int maxHttpRequestRetries) {
      this.maxHttpRequestRetries = maxHttpRequestRetries;
      set$0 |= 0x80;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestConnectTimeout(Duration httpRequestConnectTimeout) {
      if (httpRequestConnectTimeout == null) {
        throw new NullPointerException("Null httpRequestConnectTimeout");
      }
      this.httpRequestConnectTimeout = httpRequestConnectTimeout;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestReadTimeout(Duration httpRequestReadTimeout) {
      if (httpRequestReadTimeout == null) {
        throw new NullPointerException("Null httpRequestReadTimeout");
      }
      this.httpRequestReadTimeout = httpRequestReadTimeout;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyAddress(String proxyAddress) {
      this.proxyAddress = proxyAddress;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyUsername(RedactedString proxyUsername) {
      this.proxyUsername = proxyUsername;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setProxyPassword(RedactedString proxyPassword) {
      this.proxyPassword = proxyPassword;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setCopyWithRewriteEnabled(boolean copyWithRewriteEnabled) {
      this.copyWithRewriteEnabled = copyWithRewriteEnabled;
      set$0 |= 0x100;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMaxRewriteChunkSize(long maxRewriteChunkSize) {
      this.maxRewriteChunkSize = maxRewriteChunkSize;
      set$0 |= 0x200;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setReadChannelOptions(GoogleCloudStorageReadOptions readChannelOptions) {
      if (readChannelOptions == null) {
        throw new NullPointerException("Null readChannelOptions");
      }
      this.readChannelOptions = readChannelOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setWriteChannelOptions(AsyncWriteChannelOptions writeChannelOptions) {
      if (writeChannelOptions == null) {
        throw new NullPointerException("Null writeChannelOptions");
      }
      this.writeChannelOptions = writeChannelOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setRequesterPaysOptions(RequesterPaysOptions requesterPaysOptions) {
      if (requesterPaysOptions == null) {
        throw new NullPointerException("Null requesterPaysOptions");
      }
      this.requesterPaysOptions = requesterPaysOptions;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setHttpRequestHeaders(Map<String, String> httpRequestHeaders) {
      this.httpRequestHeaders = ImmutableMap.copyOf(httpRequestHeaders);
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setEncryptionAlgorithm(String encryptionAlgorithm) {
      this.encryptionAlgorithm = encryptionAlgorithm;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setEncryptionKey(RedactedString encryptionKey) {
      this.encryptionKey = encryptionKey;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setEncryptionKeyHash(RedactedString encryptionKeyHash) {
      this.encryptionKeyHash = encryptionKeyHash;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setGrpcMessageTimeoutCheckInterval(Duration grpcMessageTimeoutCheckInterval) {
      if (grpcMessageTimeoutCheckInterval == null) {
        throw new NullPointerException("Null grpcMessageTimeoutCheckInterval");
      }
      this.grpcMessageTimeoutCheckInterval = grpcMessageTimeoutCheckInterval;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setMetricsSink(GoogleCloudStorageOptions.MetricsSink metricsSink) {
      if (metricsSink == null) {
        throw new NullPointerException("Null metricsSink");
      }
      this.metricsSink = metricsSink;
      return this;
    }
    @Override
    public GoogleCloudStorageOptions.Builder setTraceLogEnabled(Boolean traceLogEnabled) {
      if (traceLogEnabled == null) {
        throw new NullPointerException("Null traceLogEnabled");
      }
      this.traceLogEnabled = traceLogEnabled;
      set$0 |= 0x400;
      return this;
    }
    @Override
    GoogleCloudStorageOptions autoBuild() {
      if (set$0 != 0x7ff
          || this.grpcServerAddress == null
          || this.storageRootUrl == null
          || this.storageServicePath == null
          || this.maxWaitTimeForEmptyObjectCreation == null
          || this.httpRequestConnectTimeout == null
          || this.httpRequestReadTimeout == null
          || this.readChannelOptions == null
          || this.writeChannelOptions == null
          || this.requesterPaysOptions == null
          || this.httpRequestHeaders == null
          || this.grpcMessageTimeoutCheckInterval == null
          || this.metricsSink == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" grpcEnabled");
        }
        if (this.grpcServerAddress == null) {
          missing.append(" grpcServerAddress");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" trafficDirectorEnabled");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" directPathPreferred");
        }
        if (this.storageRootUrl == null) {
          missing.append(" storageRootUrl");
        }
        if (this.storageServicePath == null) {
          missing.append(" storageServicePath");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" autoRepairImplicitDirectoriesEnabled");
        }
        if (this.maxWaitTimeForEmptyObjectCreation == null) {
          missing.append(" maxWaitTimeForEmptyObjectCreation");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" maxListItemsPerCall");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" maxRequestsPerBatch");
        }
        if ((set$0 & 0x40) == 0) {
          missing.append(" batchThreads");
        }
        if ((set$0 & 0x80) == 0) {
          missing.append(" maxHttpRequestRetries");
        }
        if (this.httpRequestConnectTimeout == null) {
          missing.append(" httpRequestConnectTimeout");
        }
        if (this.httpRequestReadTimeout == null) {
          missing.append(" httpRequestReadTimeout");
        }
        if ((set$0 & 0x100) == 0) {
          missing.append(" copyWithRewriteEnabled");
        }
        if ((set$0 & 0x200) == 0) {
          missing.append(" maxRewriteChunkSize");
        }
        if (this.readChannelOptions == null) {
          missing.append(" readChannelOptions");
        }
        if (this.writeChannelOptions == null) {
          missing.append(" writeChannelOptions");
        }
        if (this.requesterPaysOptions == null) {
          missing.append(" requesterPaysOptions");
        }
        if (this.httpRequestHeaders == null) {
          missing.append(" httpRequestHeaders");
        }
        if (this.grpcMessageTimeoutCheckInterval == null) {
          missing.append(" grpcMessageTimeoutCheckInterval");
        }
        if (this.metricsSink == null) {
          missing.append(" metricsSink");
        }
        if ((set$0 & 0x400) == 0) {
          missing.append(" traceLogEnabled");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageOptions(
          this.grpcEnabled,
          this.grpcServerAddress,
          this.trafficDirectorEnabled,
          this.directPathPreferred,
          this.storageRootUrl,
          this.storageServicePath,
          this.projectId,
          this.appName,
          this.autoRepairImplicitDirectoriesEnabled,
          this.maxWaitTimeForEmptyObjectCreation,
          this.maxListItemsPerCall,
          this.maxRequestsPerBatch,
          this.batchThreads,
          this.maxHttpRequestRetries,
          this.httpRequestConnectTimeout,
          this.httpRequestReadTimeout,
          this.proxyAddress,
          this.proxyUsername,
          this.proxyPassword,
          this.copyWithRewriteEnabled,
          this.maxRewriteChunkSize,
          this.readChannelOptions,
          this.writeChannelOptions,
          this.requesterPaysOptions,
          this.httpRequestHeaders,
          this.encryptionAlgorithm,
          this.encryptionKey,
          this.encryptionKeyHash,
          this.grpcMessageTimeoutCheckInterval,
          this.metricsSink,
          this.traceLogEnabled);
    }
  }

}
