/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.gcsio.AutoValue_GoogleCloudStorageReadOptions;
import com.google.common.base.Preconditions;
import java.time.Duration;

@AutoValue
public abstract class GoogleCloudStorageReadOptions {
    public static final GoogleCloudStorageReadOptions DEFAULT = GoogleCloudStorageReadOptions.builder().build();

    public static Builder builder() {
        return new AutoValue_GoogleCloudStorageReadOptions.Builder().setBackoffInitialInterval(Duration.ofMillis(200L)).setBackoffMaxElapsedTime(Duration.ofMinutes(2L)).setBackoffMaxInterval(Duration.ofSeconds(10L)).setBackoffMultiplier(1.5).setBackoffRandomizationFactor(0.5).setFadvise(Fadvise.AUTO).setFastFailOnNotFoundEnabled(true).setGrpcChecksumsEnabled(false).setGrpcReadMessageTimeout(Duration.ofSeconds(3L)).setGrpcReadTimeout(Duration.ofHours(1L)).setGrpcReadZeroCopyEnabled(true).setGzipEncodingSupportEnabled(false).setInplaceSeekLimit(0x800000L).setMinRangeRequestSize(0x200000L);
    }

    public abstract Builder toBuilder();

    public abstract Duration getBackoffInitialInterval();

    public abstract double getBackoffRandomizationFactor();

    public abstract double getBackoffMultiplier();

    public abstract Duration getBackoffMaxInterval();

    public abstract Duration getBackoffMaxElapsedTime();

    public abstract boolean isFastFailOnNotFoundEnabled();

    public abstract boolean isGzipEncodingSupportEnabled();

    public abstract long getInplaceSeekLimit();

    public abstract Fadvise getFadvise();

    public abstract long getMinRangeRequestSize();

    public abstract boolean isGrpcChecksumsEnabled();

    public abstract Duration getGrpcReadTimeout();

    public abstract boolean isGrpcReadZeroCopyEnabled();

    public abstract Duration getGrpcReadMessageTimeout();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBackoffInitialInterval(Duration var1);

        public abstract Builder setBackoffRandomizationFactor(double var1);

        public abstract Builder setBackoffMultiplier(double var1);

        public abstract Builder setBackoffMaxInterval(Duration var1);

        public abstract Builder setBackoffMaxElapsedTime(Duration var1);

        public abstract Builder setFastFailOnNotFoundEnabled(boolean var1);

        public abstract Builder setGzipEncodingSupportEnabled(boolean var1);

        public abstract Builder setInplaceSeekLimit(long var1);

        public abstract Builder setFadvise(Fadvise var1);

        public abstract Builder setMinRangeRequestSize(long var1);

        public abstract Builder setGrpcChecksumsEnabled(boolean var1);

        public abstract Builder setGrpcReadTimeout(Duration var1);

        public abstract Builder setGrpcReadZeroCopyEnabled(boolean var1);

        public abstract Builder setGrpcReadMessageTimeout(Duration var1);

        abstract GoogleCloudStorageReadOptions autoBuild();

        public GoogleCloudStorageReadOptions build() {
            GoogleCloudStorageReadOptions options = this.autoBuild();
            Preconditions.checkState((options.getInplaceSeekLimit() >= 0L ? 1 : 0) != 0, (String)"inplaceSeekLimit must be non-negative! Got %s", (long)options.getInplaceSeekLimit());
            return options;
        }
    }

    public static enum Fadvise {
        AUTO,
        RANDOM,
        SEQUENTIAL;

    }
}

