/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

class StatisticsTrackingHttpRequestInitializer
implements HttpRequestInitializer {
    private final ConcurrentMap<String, AtomicLong> statistics = new ConcurrentHashMap<String, AtomicLong>();

    StatisticsTrackingHttpRequestInitializer() {
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setResponseInterceptor(httpResponse -> {
            String requestMethod = Ascii.toLowerCase((String)httpResponse.getRequest().getRequestMethod());
            String statKey = String.format("http_%s_%d", requestMethod, httpResponse.getStatusCode());
            this.statistics.computeIfAbsent(statKey, k -> new AtomicLong()).incrementAndGet();
        });
    }

    public ImmutableMap<String, Long> getStatistics() {
        return (ImmutableMap)this.statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((AtomicLong)e.getValue()).get()));
    }
}

