/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageRequest;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.ComposeRequest;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.gcsio.StorageRequestFactory;
import com.google.cloud.hadoop.util.AccessBoundary;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.List;

class StorageRequestToAccessBoundaryConverter {
    StorageRequestToAccessBoundaryConverter() {
    }

    public static <RequestT extends StorageRequest<?>> List<AccessBoundary> fromStorageObjectRequest(RequestT request) {
        if (request instanceof Storage.Objects.List) {
            return StorageRequestToAccessBoundaryConverter.translateObjectListRequest((Storage.Objects.List)request);
        }
        if (request instanceof Storage.Objects.Insert) {
            return StorageRequestToAccessBoundaryConverter.translateObjectInsertRequest((Storage.Objects.Insert)request);
        }
        if (request instanceof Storage.Objects.Compose) {
            return StorageRequestToAccessBoundaryConverter.translateObjectComposeRequest((Storage.Objects.Compose)request);
        }
        if (request instanceof StorageRequestFactory.ObjectsGetMetadata) {
            return StorageRequestToAccessBoundaryConverter.translateObjectGetMetadataRequest((StorageRequestFactory.ObjectsGetMetadata)request);
        }
        if (request instanceof StorageRequestFactory.ObjectsGetData) {
            return StorageRequestToAccessBoundaryConverter.translateObjectGetDataRequest((StorageRequestFactory.ObjectsGetData)request);
        }
        if (request instanceof Storage.Objects.Delete) {
            return StorageRequestToAccessBoundaryConverter.translateObjectDeleteRequest((Storage.Objects.Delete)request);
        }
        if (request instanceof Storage.Objects.Rewrite) {
            return StorageRequestToAccessBoundaryConverter.translateObjectRewriteRequest((Storage.Objects.Rewrite)request);
        }
        if (request instanceof Storage.Objects.Copy) {
            return StorageRequestToAccessBoundaryConverter.translateObjectCopyRequest((Storage.Objects.Copy)request);
        }
        if (request instanceof Storage.Objects.Patch) {
            return StorageRequestToAccessBoundaryConverter.translateObjectPatchRequest((Storage.Objects.Patch)request);
        }
        if (request instanceof Storage.Buckets.Get) {
            return StorageRequestToAccessBoundaryConverter.translateBucketGetRequest((Storage.Buckets.Get)request);
        }
        if (request instanceof Storage.Buckets.Insert) {
            return StorageRequestToAccessBoundaryConverter.translateBucketInsertRequest((Storage.Buckets.Insert)request);
        }
        if (request instanceof Storage.Buckets.Delete) {
            return StorageRequestToAccessBoundaryConverter.translateBucketDeleteRequest((Storage.Buckets.Delete)request);
        }
        if (request instanceof Storage.Buckets.List) {
            return StorageRequestToAccessBoundaryConverter.translateBucketListRequest();
        }
        throw new InvalidParameterException("StorageRequest not used by the connector: " + request.getClass().getCanonicalName());
    }

    private static List<AccessBoundary> translateObjectListRequest(Storage.Objects.List request) {
        String prefix = request.getPrefix();
        if (Strings.isNullOrEmpty((String)prefix)) {
            prefix = "/";
        }
        return Collections.singletonList(AccessBoundary.create((String)request.getBucket(), (String)prefix, (AccessBoundary.Action)AccessBoundary.Action.LIST_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectInsertRequest(Storage.Objects.Insert request) {
        String path = ((StorageObject)StorageRequestToAccessBoundaryConverter.getData(request)).getName();
        return Collections.singletonList(AccessBoundary.create((String)request.getBucket(), (String)path, (AccessBoundary.Action)AccessBoundary.Action.WRITE_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectComposeRequest(Storage.Objects.Compose request) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ((ComposeRequest)StorageRequestToAccessBoundaryConverter.getData(request)).getSourceObjects().forEach(source -> listBuilder.add((Object)AccessBoundary.create((String)request.getDestinationBucket(), (String)source.getName(), (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS)));
        listBuilder.add((Object)AccessBoundary.create((String)request.getDestinationBucket(), (String)request.getDestinationObject(), (AccessBoundary.Action)AccessBoundary.Action.WRITE_OBJECTS));
        return listBuilder.build();
    }

    private static List<AccessBoundary> translateObjectGetDataRequest(StorageRequestFactory.ObjectsGetData request) {
        return ImmutableList.of((Object)AccessBoundary.create((String)request.getBucket(), (String)request.getObject(), (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectGetMetadataRequest(StorageRequestFactory.ObjectsGetMetadata request) {
        return ImmutableList.of((Object)AccessBoundary.create((String)request.getBucket(), (String)request.getObject(), (AccessBoundary.Action)AccessBoundary.Action.GET_METADATA_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectDeleteRequest(Storage.Objects.Delete request) {
        return Collections.singletonList(AccessBoundary.create((String)request.getBucket(), (String)request.getObject(), (AccessBoundary.Action)AccessBoundary.Action.DELETE_OBJECTS));
    }

    private static List<AccessBoundary> translateObjectRewriteRequest(Storage.Objects.Rewrite request) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)AccessBoundary.create((String)request.getSourceBucket(), (String)request.getSourceObject(), (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS));
        listBuilder.add((Object)AccessBoundary.create((String)request.getDestinationBucket(), (String)request.getDestinationObject(), (AccessBoundary.Action)AccessBoundary.Action.WRITE_OBJECTS));
        return listBuilder.build();
    }

    private static List<AccessBoundary> translateObjectCopyRequest(Storage.Objects.Copy request) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)AccessBoundary.create((String)request.getSourceBucket(), (String)request.getSourceObject(), (AccessBoundary.Action)AccessBoundary.Action.READ_OBJECTS));
        listBuilder.add((Object)AccessBoundary.create((String)request.getDestinationBucket(), (String)request.getDestinationObject(), (AccessBoundary.Action)AccessBoundary.Action.WRITE_OBJECTS));
        return listBuilder.build();
    }

    private static List<AccessBoundary> translateObjectPatchRequest(Storage.Objects.Patch request) {
        return Collections.singletonList(AccessBoundary.create((String)request.getBucket(), (String)request.getObject(), (AccessBoundary.Action)AccessBoundary.Action.EDIT_OBJECTS));
    }

    private static List<AccessBoundary> translateBucketGetRequest(Storage.Buckets.Get request) {
        return Collections.singletonList(AccessBoundary.create((String)request.getBucket(), (String)"/", (AccessBoundary.Action)AccessBoundary.Action.GET_BUCKETS));
    }

    private static List<AccessBoundary> translateBucketInsertRequest(Storage.Buckets.Insert request) {
        String bucketName = ((Bucket)StorageRequestToAccessBoundaryConverter.getData(request)).getName();
        return Collections.singletonList(AccessBoundary.create((String)bucketName, (String)"/", (AccessBoundary.Action)AccessBoundary.Action.CREATE_BUCKETS));
    }

    private static List<AccessBoundary> translateBucketDeleteRequest(Storage.Buckets.Delete request) {
        return Collections.singletonList(AccessBoundary.create((String)request.getBucket(), (String)"/", (AccessBoundary.Action)AccessBoundary.Action.DELETE_BUCKETS));
    }

    private static List<AccessBoundary> translateBucketListRequest() {
        return Collections.singletonList(AccessBoundary.create((String)"", (String)"", (AccessBoundary.Action)AccessBoundary.Action.LIST_BUCKETS));
    }

    private static Object getData(StorageRequest<?> request) {
        return ((JsonHttpContent)request.getHttpContent()).getData();
    }
}

