package com.google.cloud.hadoop.gcsio;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_CreateObjectOptions extends CreateObjectOptions {

  @Nullable
  private final String contentEncoding;

  @Nullable
  private final String contentType;

  private final boolean ensureEmptyObjectsMetadataMatch;

  @Nullable
  private final String kmsKeyName;

  private final ImmutableMap<String, byte[]> metadata;

  private final boolean overwriteExisting;

  private AutoValue_CreateObjectOptions(
      @Nullable String contentEncoding,
      @Nullable String contentType,
      boolean ensureEmptyObjectsMetadataMatch,
      @Nullable String kmsKeyName,
      ImmutableMap<String, byte[]> metadata,
      boolean overwriteExisting) {
    this.contentEncoding = contentEncoding;
    this.contentType = contentType;
    this.ensureEmptyObjectsMetadataMatch = ensureEmptyObjectsMetadataMatch;
    this.kmsKeyName = kmsKeyName;
    this.metadata = metadata;
    this.overwriteExisting = overwriteExisting;
  }

  @Nullable
  @Override
  public String getContentEncoding() {
    return contentEncoding;
  }

  @Nullable
  @Override
  public String getContentType() {
    return contentType;
  }

  @Override
  public boolean isEnsureEmptyObjectsMetadataMatch() {
    return ensureEmptyObjectsMetadataMatch;
  }

  @Nullable
  @Override
  public String getKmsKeyName() {
    return kmsKeyName;
  }

  @Override
  public ImmutableMap<String, byte[]> getMetadata() {
    return metadata;
  }

  @Override
  public boolean isOverwriteExisting() {
    return overwriteExisting;
  }

  @Override
  public String toString() {
    return "CreateObjectOptions{"
        + "contentEncoding=" + contentEncoding + ", "
        + "contentType=" + contentType + ", "
        + "ensureEmptyObjectsMetadataMatch=" + ensureEmptyObjectsMetadataMatch + ", "
        + "kmsKeyName=" + kmsKeyName + ", "
        + "metadata=" + metadata + ", "
        + "overwriteExisting=" + overwriteExisting
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CreateObjectOptions) {
      CreateObjectOptions that = (CreateObjectOptions) o;
      return (this.contentEncoding == null ? that.getContentEncoding() == null : this.contentEncoding.equals(that.getContentEncoding()))
          && (this.contentType == null ? that.getContentType() == null : this.contentType.equals(that.getContentType()))
          && this.ensureEmptyObjectsMetadataMatch == that.isEnsureEmptyObjectsMetadataMatch()
          && (this.kmsKeyName == null ? that.getKmsKeyName() == null : this.kmsKeyName.equals(that.getKmsKeyName()))
          && this.metadata.equals(that.getMetadata())
          && this.overwriteExisting == that.isOverwriteExisting();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (contentEncoding == null) ? 0 : contentEncoding.hashCode();
    h$ *= 1000003;
    h$ ^= (contentType == null) ? 0 : contentType.hashCode();
    h$ *= 1000003;
    h$ ^= ensureEmptyObjectsMetadataMatch ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (kmsKeyName == null) ? 0 : kmsKeyName.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= overwriteExisting ? 1231 : 1237;
    return h$;
  }

  @Override
  public CreateObjectOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends CreateObjectOptions.Builder {
    private String contentEncoding;
    private String contentType;
    private boolean ensureEmptyObjectsMetadataMatch;
    private String kmsKeyName;
    private ImmutableMap<String, byte[]> metadata;
    private boolean overwriteExisting;
    private byte set$0;
    Builder() {
    }
    private Builder(CreateObjectOptions source) {
      this.contentEncoding = source.getContentEncoding();
      this.contentType = source.getContentType();
      this.ensureEmptyObjectsMetadataMatch = source.isEnsureEmptyObjectsMetadataMatch();
      this.kmsKeyName = source.getKmsKeyName();
      this.metadata = source.getMetadata();
      this.overwriteExisting = source.isOverwriteExisting();
      set$0 = (byte) 3;
    }
    @Override
    public CreateObjectOptions.Builder setContentEncoding(String contentEncoding) {
      this.contentEncoding = contentEncoding;
      return this;
    }
    @Override
    public CreateObjectOptions.Builder setContentType(String contentType) {
      this.contentType = contentType;
      return this;
    }
    @Override
    public CreateObjectOptions.Builder setEnsureEmptyObjectsMetadataMatch(boolean ensureEmptyObjectsMetadataMatch) {
      this.ensureEmptyObjectsMetadataMatch = ensureEmptyObjectsMetadataMatch;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public CreateObjectOptions.Builder setKmsKeyName(String kmsKeyName) {
      this.kmsKeyName = kmsKeyName;
      return this;
    }
    @Override
    public CreateObjectOptions.Builder setMetadata(Map<String, byte[]> metadata) {
      this.metadata = ImmutableMap.copyOf(metadata);
      return this;
    }
    @Override
    public CreateObjectOptions.Builder setOverwriteExisting(boolean overwriteExisting) {
      this.overwriteExisting = overwriteExisting;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    protected CreateObjectOptions autoBuild() {
      if (set$0 != 3
          || this.metadata == null) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" ensureEmptyObjectsMetadataMatch");
        }
        if (this.metadata == null) {
          missing.append(" metadata");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" overwriteExisting");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CreateObjectOptions(
          this.contentEncoding,
          this.contentType,
          this.ensureEmptyObjectsMetadataMatch,
          this.kmsKeyName,
          this.metadata,
          this.overwriteExisting);
    }
  }

}
