/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import java.time.Duration;

final class AutoValue_GoogleCloudStorageReadOptions
extends GoogleCloudStorageReadOptions {
    private final Duration backoffInitialInterval;
    private final double backoffRandomizationFactor;
    private final double backoffMultiplier;
    private final Duration backoffMaxInterval;
    private final Duration backoffMaxElapsedTime;
    private final boolean fastFailOnNotFoundEnabled;
    private final boolean gzipEncodingSupportEnabled;
    private final long inplaceSeekLimit;
    private final GoogleCloudStorageReadOptions.Fadvise fadvise;
    private final long minRangeRequestSize;
    private final boolean grpcChecksumsEnabled;
    private final Duration grpcReadTimeout;
    private final boolean grpcReadZeroCopyEnabled;
    private final Duration grpcReadMessageTimeout;

    private AutoValue_GoogleCloudStorageReadOptions(Duration backoffInitialInterval, double backoffRandomizationFactor, double backoffMultiplier, Duration backoffMaxInterval, Duration backoffMaxElapsedTime, boolean fastFailOnNotFoundEnabled, boolean gzipEncodingSupportEnabled, long inplaceSeekLimit, GoogleCloudStorageReadOptions.Fadvise fadvise, long minRangeRequestSize, boolean grpcChecksumsEnabled, Duration grpcReadTimeout, boolean grpcReadZeroCopyEnabled, Duration grpcReadMessageTimeout) {
        this.backoffInitialInterval = backoffInitialInterval;
        this.backoffRandomizationFactor = backoffRandomizationFactor;
        this.backoffMultiplier = backoffMultiplier;
        this.backoffMaxInterval = backoffMaxInterval;
        this.backoffMaxElapsedTime = backoffMaxElapsedTime;
        this.fastFailOnNotFoundEnabled = fastFailOnNotFoundEnabled;
        this.gzipEncodingSupportEnabled = gzipEncodingSupportEnabled;
        this.inplaceSeekLimit = inplaceSeekLimit;
        this.fadvise = fadvise;
        this.minRangeRequestSize = minRangeRequestSize;
        this.grpcChecksumsEnabled = grpcChecksumsEnabled;
        this.grpcReadTimeout = grpcReadTimeout;
        this.grpcReadZeroCopyEnabled = grpcReadZeroCopyEnabled;
        this.grpcReadMessageTimeout = grpcReadMessageTimeout;
    }

    @Override
    public Duration getBackoffInitialInterval() {
        return this.backoffInitialInterval;
    }

    @Override
    public double getBackoffRandomizationFactor() {
        return this.backoffRandomizationFactor;
    }

    @Override
    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    @Override
    public Duration getBackoffMaxInterval() {
        return this.backoffMaxInterval;
    }

    @Override
    public Duration getBackoffMaxElapsedTime() {
        return this.backoffMaxElapsedTime;
    }

    @Override
    public boolean isFastFailOnNotFoundEnabled() {
        return this.fastFailOnNotFoundEnabled;
    }

    @Override
    public boolean isGzipEncodingSupportEnabled() {
        return this.gzipEncodingSupportEnabled;
    }

    @Override
    public long getInplaceSeekLimit() {
        return this.inplaceSeekLimit;
    }

    @Override
    public GoogleCloudStorageReadOptions.Fadvise getFadvise() {
        return this.fadvise;
    }

    @Override
    public long getMinRangeRequestSize() {
        return this.minRangeRequestSize;
    }

    @Override
    public boolean isGrpcChecksumsEnabled() {
        return this.grpcChecksumsEnabled;
    }

    @Override
    public Duration getGrpcReadTimeout() {
        return this.grpcReadTimeout;
    }

    @Override
    public boolean isGrpcReadZeroCopyEnabled() {
        return this.grpcReadZeroCopyEnabled;
    }

    @Override
    public Duration getGrpcReadMessageTimeout() {
        return this.grpcReadMessageTimeout;
    }

    public String toString() {
        return "GoogleCloudStorageReadOptions{backoffInitialInterval=" + this.backoffInitialInterval + ", backoffRandomizationFactor=" + this.backoffRandomizationFactor + ", backoffMultiplier=" + this.backoffMultiplier + ", backoffMaxInterval=" + this.backoffMaxInterval + ", backoffMaxElapsedTime=" + this.backoffMaxElapsedTime + ", fastFailOnNotFoundEnabled=" + this.fastFailOnNotFoundEnabled + ", gzipEncodingSupportEnabled=" + this.gzipEncodingSupportEnabled + ", inplaceSeekLimit=" + this.inplaceSeekLimit + ", fadvise=" + this.fadvise + ", minRangeRequestSize=" + this.minRangeRequestSize + ", grpcChecksumsEnabled=" + this.grpcChecksumsEnabled + ", grpcReadTimeout=" + this.grpcReadTimeout + ", grpcReadZeroCopyEnabled=" + this.grpcReadZeroCopyEnabled + ", grpcReadMessageTimeout=" + this.grpcReadMessageTimeout + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GoogleCloudStorageReadOptions) {
            GoogleCloudStorageReadOptions that = (GoogleCloudStorageReadOptions)o;
            return this.backoffInitialInterval.equals(that.getBackoffInitialInterval()) && Double.doubleToLongBits(this.backoffRandomizationFactor) == Double.doubleToLongBits(that.getBackoffRandomizationFactor()) && Double.doubleToLongBits(this.backoffMultiplier) == Double.doubleToLongBits(that.getBackoffMultiplier()) && this.backoffMaxInterval.equals(that.getBackoffMaxInterval()) && this.backoffMaxElapsedTime.equals(that.getBackoffMaxElapsedTime()) && this.fastFailOnNotFoundEnabled == that.isFastFailOnNotFoundEnabled() && this.gzipEncodingSupportEnabled == that.isGzipEncodingSupportEnabled() && this.inplaceSeekLimit == that.getInplaceSeekLimit() && this.fadvise.equals((Object)that.getFadvise()) && this.minRangeRequestSize == that.getMinRangeRequestSize() && this.grpcChecksumsEnabled == that.isGrpcChecksumsEnabled() && this.grpcReadTimeout.equals(that.getGrpcReadTimeout()) && this.grpcReadZeroCopyEnabled == that.isGrpcReadZeroCopyEnabled() && this.grpcReadMessageTimeout.equals(that.getGrpcReadMessageTimeout());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.backoffInitialInterval.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.backoffRandomizationFactor) >>> 32 ^ Double.doubleToLongBits(this.backoffRandomizationFactor));
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.backoffMultiplier) >>> 32 ^ Double.doubleToLongBits(this.backoffMultiplier));
        h$ *= 1000003;
        h$ ^= this.backoffMaxInterval.hashCode();
        h$ *= 1000003;
        h$ ^= this.backoffMaxElapsedTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.fastFailOnNotFoundEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.gzipEncodingSupportEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= (int)(this.inplaceSeekLimit >>> 32 ^ this.inplaceSeekLimit);
        h$ *= 1000003;
        h$ ^= this.fadvise.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.minRangeRequestSize >>> 32 ^ this.minRangeRequestSize);
        h$ *= 1000003;
        h$ ^= this.grpcChecksumsEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.grpcReadTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.grpcReadZeroCopyEnabled ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.grpcReadMessageTimeout.hashCode();
    }

    @Override
    public GoogleCloudStorageReadOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends GoogleCloudStorageReadOptions.Builder {
        private Duration backoffInitialInterval;
        private double backoffRandomizationFactor;
        private double backoffMultiplier;
        private Duration backoffMaxInterval;
        private Duration backoffMaxElapsedTime;
        private boolean fastFailOnNotFoundEnabled;
        private boolean gzipEncodingSupportEnabled;
        private long inplaceSeekLimit;
        private GoogleCloudStorageReadOptions.Fadvise fadvise;
        private long minRangeRequestSize;
        private boolean grpcChecksumsEnabled;
        private Duration grpcReadTimeout;
        private boolean grpcReadZeroCopyEnabled;
        private Duration grpcReadMessageTimeout;
        private byte set$0;

        Builder() {
        }

        private Builder(GoogleCloudStorageReadOptions source) {
            this.backoffInitialInterval = source.getBackoffInitialInterval();
            this.backoffRandomizationFactor = source.getBackoffRandomizationFactor();
            this.backoffMultiplier = source.getBackoffMultiplier();
            this.backoffMaxInterval = source.getBackoffMaxInterval();
            this.backoffMaxElapsedTime = source.getBackoffMaxElapsedTime();
            this.fastFailOnNotFoundEnabled = source.isFastFailOnNotFoundEnabled();
            this.gzipEncodingSupportEnabled = source.isGzipEncodingSupportEnabled();
            this.inplaceSeekLimit = source.getInplaceSeekLimit();
            this.fadvise = source.getFadvise();
            this.minRangeRequestSize = source.getMinRangeRequestSize();
            this.grpcChecksumsEnabled = source.isGrpcChecksumsEnabled();
            this.grpcReadTimeout = source.getGrpcReadTimeout();
            this.grpcReadZeroCopyEnabled = source.isGrpcReadZeroCopyEnabled();
            this.grpcReadMessageTimeout = source.getGrpcReadMessageTimeout();
            this.set$0 = (byte)-1;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffInitialInterval(Duration backoffInitialInterval) {
            if (backoffInitialInterval == null) {
                throw new NullPointerException("Null backoffInitialInterval");
            }
            this.backoffInitialInterval = backoffInitialInterval;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffRandomizationFactor(double backoffRandomizationFactor) {
            this.backoffRandomizationFactor = backoffRandomizationFactor;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffMultiplier(double backoffMultiplier) {
            this.backoffMultiplier = backoffMultiplier;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffMaxInterval(Duration backoffMaxInterval) {
            if (backoffMaxInterval == null) {
                throw new NullPointerException("Null backoffMaxInterval");
            }
            this.backoffMaxInterval = backoffMaxInterval;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setBackoffMaxElapsedTime(Duration backoffMaxElapsedTime) {
            if (backoffMaxElapsedTime == null) {
                throw new NullPointerException("Null backoffMaxElapsedTime");
            }
            this.backoffMaxElapsedTime = backoffMaxElapsedTime;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setFastFailOnNotFoundEnabled(boolean fastFailOnNotFoundEnabled) {
            this.fastFailOnNotFoundEnabled = fastFailOnNotFoundEnabled;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setGzipEncodingSupportEnabled(boolean gzipEncodingSupportEnabled) {
            this.gzipEncodingSupportEnabled = gzipEncodingSupportEnabled;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setInplaceSeekLimit(long inplaceSeekLimit) {
            this.inplaceSeekLimit = inplaceSeekLimit;
            this.set$0 = (byte)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setFadvise(GoogleCloudStorageReadOptions.Fadvise fadvise) {
            if (fadvise == null) {
                throw new NullPointerException("Null fadvise");
            }
            this.fadvise = fadvise;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setMinRangeRequestSize(long minRangeRequestSize) {
            this.minRangeRequestSize = minRangeRequestSize;
            this.set$0 = (byte)(this.set$0 | 0x20);
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setGrpcChecksumsEnabled(boolean grpcChecksumsEnabled) {
            this.grpcChecksumsEnabled = grpcChecksumsEnabled;
            this.set$0 = (byte)(this.set$0 | 0x40);
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setGrpcReadTimeout(Duration grpcReadTimeout) {
            if (grpcReadTimeout == null) {
                throw new NullPointerException("Null grpcReadTimeout");
            }
            this.grpcReadTimeout = grpcReadTimeout;
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setGrpcReadZeroCopyEnabled(boolean grpcReadZeroCopyEnabled) {
            this.grpcReadZeroCopyEnabled = grpcReadZeroCopyEnabled;
            this.set$0 = (byte)(this.set$0 | 0xFFFFFF80);
            return this;
        }

        @Override
        public GoogleCloudStorageReadOptions.Builder setGrpcReadMessageTimeout(Duration grpcReadMessageTimeout) {
            if (grpcReadMessageTimeout == null) {
                throw new NullPointerException("Null grpcReadMessageTimeout");
            }
            this.grpcReadMessageTimeout = grpcReadMessageTimeout;
            return this;
        }

        @Override
        GoogleCloudStorageReadOptions autoBuild() {
            if (this.set$0 != -1 || this.backoffInitialInterval == null || this.backoffMaxInterval == null || this.backoffMaxElapsedTime == null || this.fadvise == null || this.grpcReadTimeout == null || this.grpcReadMessageTimeout == null) {
                StringBuilder missing = new StringBuilder();
                if (this.backoffInitialInterval == null) {
                    missing.append(" backoffInitialInterval");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" backoffRandomizationFactor");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" backoffMultiplier");
                }
                if (this.backoffMaxInterval == null) {
                    missing.append(" backoffMaxInterval");
                }
                if (this.backoffMaxElapsedTime == null) {
                    missing.append(" backoffMaxElapsedTime");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" fastFailOnNotFoundEnabled");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" gzipEncodingSupportEnabled");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" inplaceSeekLimit");
                }
                if (this.fadvise == null) {
                    missing.append(" fadvise");
                }
                if ((this.set$0 & 0x20) == 0) {
                    missing.append(" minRangeRequestSize");
                }
                if ((this.set$0 & 0x40) == 0) {
                    missing.append(" grpcChecksumsEnabled");
                }
                if (this.grpcReadTimeout == null) {
                    missing.append(" grpcReadTimeout");
                }
                if ((this.set$0 & 0x80) == 0) {
                    missing.append(" grpcReadZeroCopyEnabled");
                }
                if (this.grpcReadMessageTimeout == null) {
                    missing.append(" grpcReadMessageTimeout");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GoogleCloudStorageReadOptions(this.backoffInitialInterval, this.backoffRandomizationFactor, this.backoffMultiplier, this.backoffMaxInterval, this.backoffMaxElapsedTime, this.fastFailOnNotFoundEnabled, this.gzipEncodingSupportEnabled, this.inplaceSeekLimit, this.fadvise, this.minRangeRequestSize, this.grpcChecksumsEnabled, this.grpcReadTimeout, this.grpcReadZeroCopyEnabled, this.grpcReadMessageTimeout);
        }
    }
}

