/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.FolderInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemImpl;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.ListFileOptions;
import com.google.cloud.hadoop.gcsio.ListFolderOptions;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public interface GoogleCloudStorageFileSystem {
    public static final String SCHEME = "gs";
    public static final URI GCS_ROOT = URI.create("gs:/");

    default public WritableByteChannel create(URI path) throws IOException {
        return this.create(path, CreateFileOptions.builder().setWriteMode(CreateFileOptions.WriteMode.OVERWRITE).build());
    }

    public WritableByteChannel create(URI var1, CreateFileOptions var2) throws IOException;

    default public SeekableByteChannel open(URI path) throws IOException {
        return this.open(path, GoogleCloudStorageReadOptions.DEFAULT);
    }

    public SeekableByteChannel open(URI var1, GoogleCloudStorageReadOptions var2) throws IOException;

    public SeekableByteChannel open(FileInfo var1, GoogleCloudStorageReadOptions var2) throws IOException;

    public void delete(URI var1, boolean var2) throws IOException;

    public boolean exists(URI var1) throws IOException;

    public void mkdirs(URI var1) throws IOException;

    public void rename(URI var1, URI var2) throws IOException;

    public void compose(List<URI> var1, URI var2, String var3) throws IOException;

    default public List<FileInfo> listFileInfoForPrefix(URI prefix) throws IOException {
        return this.listFileInfoForPrefix(prefix, ListFileOptions.DEFAULT);
    }

    public List<FileInfo> listFileInfoForPrefix(URI var1, ListFileOptions var2) throws IOException;

    default public GoogleCloudStorage.ListPage<FileInfo> listFileInfoForPrefixPage(URI prefix, String pageToken) throws IOException {
        return this.listFileInfoForPrefixPage(prefix, ListFileOptions.DEFAULT, pageToken);
    }

    public GoogleCloudStorage.ListPage<FileInfo> listFileInfoForPrefixPage(URI var1, ListFileOptions var2, String var3) throws IOException;

    default public List<FileInfo> listFileInfo(URI path) throws IOException {
        return this.listFileInfo(path, ListFileOptions.DEFAULT);
    }

    public List<FileInfo> listFileInfo(URI var1, ListFileOptions var2) throws IOException;

    public GoogleCloudStorage.ListPage<FolderInfo> listFoldersInfoForPrefixPage(URI var1, ListFolderOptions var2, String var3) throws IOException;

    public FileInfo getFileInfo(URI var1) throws IOException;

    public FileInfo getFileInfoWithHint(URI var1, GoogleCloudStorageFileSystemImpl.PathTypeHint var2) throws IOException;

    public FileInfo getFileInfoObject(URI var1) throws IOException;

    public List<FileInfo> getFileInfos(List<URI> var1) throws IOException;

    public void close();

    public void mkdir(URI var1) throws IOException;

    public GoogleCloudStorage getGcs();

    public GoogleCloudStorageFileSystemOptions getOptions();
}

