package com.google.cloud.hadoop.gcsio;

import java.time.Duration;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleCloudStorageReadOptions extends GoogleCloudStorageReadOptions {

  private final Duration backoffInitialInterval;

  private final double backoffRandomizationFactor;

  private final double backoffMultiplier;

  private final Duration backoffMaxInterval;

  private final Duration backoffMaxElapsedTime;

  private final boolean fastFailOnNotFoundEnabled;

  private final boolean gzipEncodingSupportEnabled;

  private final long inplaceSeekLimit;

  private final GoogleCloudStorageReadOptions.Fadvise fadvise;

  private final long minRangeRequestSize;

  private final boolean grpcChecksumsEnabled;

  private final boolean readExactRequestedBytesEnabled;

  private final Duration grpcReadTimeout;

  private final boolean grpcReadZeroCopyEnabled;

  private final Duration grpcReadMessageTimeout;

  private final long blockSize;

  private final int fadviseRequestTrackCount;

  private AutoValue_GoogleCloudStorageReadOptions(
      Duration backoffInitialInterval,
      double backoffRandomizationFactor,
      double backoffMultiplier,
      Duration backoffMaxInterval,
      Duration backoffMaxElapsedTime,
      boolean fastFailOnNotFoundEnabled,
      boolean gzipEncodingSupportEnabled,
      long inplaceSeekLimit,
      GoogleCloudStorageReadOptions.Fadvise fadvise,
      long minRangeRequestSize,
      boolean grpcChecksumsEnabled,
      boolean readExactRequestedBytesEnabled,
      Duration grpcReadTimeout,
      boolean grpcReadZeroCopyEnabled,
      Duration grpcReadMessageTimeout,
      long blockSize,
      int fadviseRequestTrackCount) {
    this.backoffInitialInterval = backoffInitialInterval;
    this.backoffRandomizationFactor = backoffRandomizationFactor;
    this.backoffMultiplier = backoffMultiplier;
    this.backoffMaxInterval = backoffMaxInterval;
    this.backoffMaxElapsedTime = backoffMaxElapsedTime;
    this.fastFailOnNotFoundEnabled = fastFailOnNotFoundEnabled;
    this.gzipEncodingSupportEnabled = gzipEncodingSupportEnabled;
    this.inplaceSeekLimit = inplaceSeekLimit;
    this.fadvise = fadvise;
    this.minRangeRequestSize = minRangeRequestSize;
    this.grpcChecksumsEnabled = grpcChecksumsEnabled;
    this.readExactRequestedBytesEnabled = readExactRequestedBytesEnabled;
    this.grpcReadTimeout = grpcReadTimeout;
    this.grpcReadZeroCopyEnabled = grpcReadZeroCopyEnabled;
    this.grpcReadMessageTimeout = grpcReadMessageTimeout;
    this.blockSize = blockSize;
    this.fadviseRequestTrackCount = fadviseRequestTrackCount;
  }

  @Override
  public Duration getBackoffInitialInterval() {
    return backoffInitialInterval;
  }

  @Override
  public double getBackoffRandomizationFactor() {
    return backoffRandomizationFactor;
  }

  @Override
  public double getBackoffMultiplier() {
    return backoffMultiplier;
  }

  @Override
  public Duration getBackoffMaxInterval() {
    return backoffMaxInterval;
  }

  @Override
  public Duration getBackoffMaxElapsedTime() {
    return backoffMaxElapsedTime;
  }

  @Override
  public boolean isFastFailOnNotFoundEnabled() {
    return fastFailOnNotFoundEnabled;
  }

  @Override
  public boolean isGzipEncodingSupportEnabled() {
    return gzipEncodingSupportEnabled;
  }

  @Override
  public long getInplaceSeekLimit() {
    return inplaceSeekLimit;
  }

  @Override
  public GoogleCloudStorageReadOptions.Fadvise getFadvise() {
    return fadvise;
  }

  @Override
  public long getMinRangeRequestSize() {
    return minRangeRequestSize;
  }

  @Override
  public boolean isGrpcChecksumsEnabled() {
    return grpcChecksumsEnabled;
  }

  @Override
  public boolean isReadExactRequestedBytesEnabled() {
    return readExactRequestedBytesEnabled;
  }

  @Override
  public Duration getGrpcReadTimeout() {
    return grpcReadTimeout;
  }

  @Override
  public boolean isGrpcReadZeroCopyEnabled() {
    return grpcReadZeroCopyEnabled;
  }

  @Override
  public Duration getGrpcReadMessageTimeout() {
    return grpcReadMessageTimeout;
  }

  @Override
  public long getBlockSize() {
    return blockSize;
  }

  @Override
  public int getFadviseRequestTrackCount() {
    return fadviseRequestTrackCount;
  }

  @Override
  public String toString() {
    return "GoogleCloudStorageReadOptions{"
        + "backoffInitialInterval=" + backoffInitialInterval + ", "
        + "backoffRandomizationFactor=" + backoffRandomizationFactor + ", "
        + "backoffMultiplier=" + backoffMultiplier + ", "
        + "backoffMaxInterval=" + backoffMaxInterval + ", "
        + "backoffMaxElapsedTime=" + backoffMaxElapsedTime + ", "
        + "fastFailOnNotFoundEnabled=" + fastFailOnNotFoundEnabled + ", "
        + "gzipEncodingSupportEnabled=" + gzipEncodingSupportEnabled + ", "
        + "inplaceSeekLimit=" + inplaceSeekLimit + ", "
        + "fadvise=" + fadvise + ", "
        + "minRangeRequestSize=" + minRangeRequestSize + ", "
        + "grpcChecksumsEnabled=" + grpcChecksumsEnabled + ", "
        + "readExactRequestedBytesEnabled=" + readExactRequestedBytesEnabled + ", "
        + "grpcReadTimeout=" + grpcReadTimeout + ", "
        + "grpcReadZeroCopyEnabled=" + grpcReadZeroCopyEnabled + ", "
        + "grpcReadMessageTimeout=" + grpcReadMessageTimeout + ", "
        + "blockSize=" + blockSize + ", "
        + "fadviseRequestTrackCount=" + fadviseRequestTrackCount
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleCloudStorageReadOptions) {
      GoogleCloudStorageReadOptions that = (GoogleCloudStorageReadOptions) o;
      return this.backoffInitialInterval.equals(that.getBackoffInitialInterval())
          && Double.doubleToLongBits(this.backoffRandomizationFactor) == Double.doubleToLongBits(that.getBackoffRandomizationFactor())
          && Double.doubleToLongBits(this.backoffMultiplier) == Double.doubleToLongBits(that.getBackoffMultiplier())
          && this.backoffMaxInterval.equals(that.getBackoffMaxInterval())
          && this.backoffMaxElapsedTime.equals(that.getBackoffMaxElapsedTime())
          && this.fastFailOnNotFoundEnabled == that.isFastFailOnNotFoundEnabled()
          && this.gzipEncodingSupportEnabled == that.isGzipEncodingSupportEnabled()
          && this.inplaceSeekLimit == that.getInplaceSeekLimit()
          && this.fadvise.equals(that.getFadvise())
          && this.minRangeRequestSize == that.getMinRangeRequestSize()
          && this.grpcChecksumsEnabled == that.isGrpcChecksumsEnabled()
          && this.readExactRequestedBytesEnabled == that.isReadExactRequestedBytesEnabled()
          && this.grpcReadTimeout.equals(that.getGrpcReadTimeout())
          && this.grpcReadZeroCopyEnabled == that.isGrpcReadZeroCopyEnabled()
          && this.grpcReadMessageTimeout.equals(that.getGrpcReadMessageTimeout())
          && this.blockSize == that.getBlockSize()
          && this.fadviseRequestTrackCount == that.getFadviseRequestTrackCount();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= backoffInitialInterval.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(backoffRandomizationFactor) >>> 32) ^ Double.doubleToLongBits(backoffRandomizationFactor));
    h$ *= 1000003;
    h$ ^= (int) ((Double.doubleToLongBits(backoffMultiplier) >>> 32) ^ Double.doubleToLongBits(backoffMultiplier));
    h$ *= 1000003;
    h$ ^= backoffMaxInterval.hashCode();
    h$ *= 1000003;
    h$ ^= backoffMaxElapsedTime.hashCode();
    h$ *= 1000003;
    h$ ^= fastFailOnNotFoundEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= gzipEncodingSupportEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (int) ((inplaceSeekLimit >>> 32) ^ inplaceSeekLimit);
    h$ *= 1000003;
    h$ ^= fadvise.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((minRangeRequestSize >>> 32) ^ minRangeRequestSize);
    h$ *= 1000003;
    h$ ^= grpcChecksumsEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= readExactRequestedBytesEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= grpcReadTimeout.hashCode();
    h$ *= 1000003;
    h$ ^= grpcReadZeroCopyEnabled ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= grpcReadMessageTimeout.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((blockSize >>> 32) ^ blockSize);
    h$ *= 1000003;
    h$ ^= fadviseRequestTrackCount;
    return h$;
  }

  @Override
  public GoogleCloudStorageReadOptions.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleCloudStorageReadOptions.Builder {
    private Duration backoffInitialInterval;
    private double backoffRandomizationFactor;
    private double backoffMultiplier;
    private Duration backoffMaxInterval;
    private Duration backoffMaxElapsedTime;
    private boolean fastFailOnNotFoundEnabled;
    private boolean gzipEncodingSupportEnabled;
    private long inplaceSeekLimit;
    private GoogleCloudStorageReadOptions.Fadvise fadvise;
    private long minRangeRequestSize;
    private boolean grpcChecksumsEnabled;
    private boolean readExactRequestedBytesEnabled;
    private Duration grpcReadTimeout;
    private boolean grpcReadZeroCopyEnabled;
    private Duration grpcReadMessageTimeout;
    private long blockSize;
    private int fadviseRequestTrackCount;
    private short set$0;
    Builder() {
    }
    private Builder(GoogleCloudStorageReadOptions source) {
      this.backoffInitialInterval = source.getBackoffInitialInterval();
      this.backoffRandomizationFactor = source.getBackoffRandomizationFactor();
      this.backoffMultiplier = source.getBackoffMultiplier();
      this.backoffMaxInterval = source.getBackoffMaxInterval();
      this.backoffMaxElapsedTime = source.getBackoffMaxElapsedTime();
      this.fastFailOnNotFoundEnabled = source.isFastFailOnNotFoundEnabled();
      this.gzipEncodingSupportEnabled = source.isGzipEncodingSupportEnabled();
      this.inplaceSeekLimit = source.getInplaceSeekLimit();
      this.fadvise = source.getFadvise();
      this.minRangeRequestSize = source.getMinRangeRequestSize();
      this.grpcChecksumsEnabled = source.isGrpcChecksumsEnabled();
      this.readExactRequestedBytesEnabled = source.isReadExactRequestedBytesEnabled();
      this.grpcReadTimeout = source.getGrpcReadTimeout();
      this.grpcReadZeroCopyEnabled = source.isGrpcReadZeroCopyEnabled();
      this.grpcReadMessageTimeout = source.getGrpcReadMessageTimeout();
      this.blockSize = source.getBlockSize();
      this.fadviseRequestTrackCount = source.getFadviseRequestTrackCount();
      set$0 = (short) 0x7ff;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffInitialInterval(Duration backoffInitialInterval) {
      if (backoffInitialInterval == null) {
        throw new NullPointerException("Null backoffInitialInterval");
      }
      this.backoffInitialInterval = backoffInitialInterval;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffRandomizationFactor(double backoffRandomizationFactor) {
      this.backoffRandomizationFactor = backoffRandomizationFactor;
      set$0 |= (short) 1;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffMultiplier(double backoffMultiplier) {
      this.backoffMultiplier = backoffMultiplier;
      set$0 |= (short) 2;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffMaxInterval(Duration backoffMaxInterval) {
      if (backoffMaxInterval == null) {
        throw new NullPointerException("Null backoffMaxInterval");
      }
      this.backoffMaxInterval = backoffMaxInterval;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBackoffMaxElapsedTime(Duration backoffMaxElapsedTime) {
      if (backoffMaxElapsedTime == null) {
        throw new NullPointerException("Null backoffMaxElapsedTime");
      }
      this.backoffMaxElapsedTime = backoffMaxElapsedTime;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setFastFailOnNotFoundEnabled(boolean fastFailOnNotFoundEnabled) {
      this.fastFailOnNotFoundEnabled = fastFailOnNotFoundEnabled;
      set$0 |= (short) 4;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGzipEncodingSupportEnabled(boolean gzipEncodingSupportEnabled) {
      this.gzipEncodingSupportEnabled = gzipEncodingSupportEnabled;
      set$0 |= (short) 8;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setInplaceSeekLimit(long inplaceSeekLimit) {
      this.inplaceSeekLimit = inplaceSeekLimit;
      set$0 |= (short) 0x10;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setFadvise(GoogleCloudStorageReadOptions.Fadvise fadvise) {
      if (fadvise == null) {
        throw new NullPointerException("Null fadvise");
      }
      this.fadvise = fadvise;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setMinRangeRequestSize(long minRangeRequestSize) {
      this.minRangeRequestSize = minRangeRequestSize;
      set$0 |= (short) 0x20;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGrpcChecksumsEnabled(boolean grpcChecksumsEnabled) {
      this.grpcChecksumsEnabled = grpcChecksumsEnabled;
      set$0 |= (short) 0x40;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setReadExactRequestedBytesEnabled(boolean readExactRequestedBytesEnabled) {
      this.readExactRequestedBytesEnabled = readExactRequestedBytesEnabled;
      set$0 |= (short) 0x80;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGrpcReadTimeout(Duration grpcReadTimeout) {
      if (grpcReadTimeout == null) {
        throw new NullPointerException("Null grpcReadTimeout");
      }
      this.grpcReadTimeout = grpcReadTimeout;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGrpcReadZeroCopyEnabled(boolean grpcReadZeroCopyEnabled) {
      this.grpcReadZeroCopyEnabled = grpcReadZeroCopyEnabled;
      set$0 |= (short) 0x100;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setGrpcReadMessageTimeout(Duration grpcReadMessageTimeout) {
      if (grpcReadMessageTimeout == null) {
        throw new NullPointerException("Null grpcReadMessageTimeout");
      }
      this.grpcReadMessageTimeout = grpcReadMessageTimeout;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setBlockSize(long blockSize) {
      this.blockSize = blockSize;
      set$0 |= (short) 0x200;
      return this;
    }
    @Override
    public GoogleCloudStorageReadOptions.Builder setFadviseRequestTrackCount(int fadviseRequestTrackCount) {
      this.fadviseRequestTrackCount = fadviseRequestTrackCount;
      set$0 |= (short) 0x400;
      return this;
    }
    @Override
    GoogleCloudStorageReadOptions autoBuild() {
      if (set$0 != 0x7ff
          || this.backoffInitialInterval == null
          || this.backoffMaxInterval == null
          || this.backoffMaxElapsedTime == null
          || this.fadvise == null
          || this.grpcReadTimeout == null
          || this.grpcReadMessageTimeout == null) {
        StringBuilder missing = new StringBuilder();
        if (this.backoffInitialInterval == null) {
          missing.append(" backoffInitialInterval");
        }
        if ((set$0 & 1) == 0) {
          missing.append(" backoffRandomizationFactor");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" backoffMultiplier");
        }
        if (this.backoffMaxInterval == null) {
          missing.append(" backoffMaxInterval");
        }
        if (this.backoffMaxElapsedTime == null) {
          missing.append(" backoffMaxElapsedTime");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" fastFailOnNotFoundEnabled");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" gzipEncodingSupportEnabled");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" inplaceSeekLimit");
        }
        if (this.fadvise == null) {
          missing.append(" fadvise");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" minRangeRequestSize");
        }
        if ((set$0 & 0x40) == 0) {
          missing.append(" grpcChecksumsEnabled");
        }
        if ((set$0 & 0x80) == 0) {
          missing.append(" readExactRequestedBytesEnabled");
        }
        if (this.grpcReadTimeout == null) {
          missing.append(" grpcReadTimeout");
        }
        if ((set$0 & 0x100) == 0) {
          missing.append(" grpcReadZeroCopyEnabled");
        }
        if (this.grpcReadMessageTimeout == null) {
          missing.append(" grpcReadMessageTimeout");
        }
        if ((set$0 & 0x200) == 0) {
          missing.append(" blockSize");
        }
        if ((set$0 & 0x400) == 0) {
          missing.append(" fadviseRequestTrackCount");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleCloudStorageReadOptions(
          this.backoffInitialInterval,
          this.backoffRandomizationFactor,
          this.backoffMultiplier,
          this.backoffMaxInterval,
          this.backoffMaxElapsedTime,
          this.fastFailOnNotFoundEnabled,
          this.gzipEncodingSupportEnabled,
          this.inplaceSeekLimit,
          this.fadvise,
          this.minRangeRequestSize,
          this.grpcChecksumsEnabled,
          this.readExactRequestedBytesEnabled,
          this.grpcReadTimeout,
          this.grpcReadZeroCopyEnabled,
          this.grpcReadMessageTimeout,
          this.blockSize,
          this.fadviseRequestTrackCount);
    }
  }

}
