/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class HadoopToStringUtil {
    public static String toString(InputSplit input) throws IOException, InterruptedException {
        if (input == null) {
            return "null";
        }
        String result = "InputSplit::";
        result = result + " length:" + input.getLength();
        result = result + " locations: " + Arrays.toString(input.getLocations());
        result = result + " toString(): " + input.toString();
        return result;
    }

    public static String toString(List<InputSplit> input) throws IOException, InterruptedException {
        if (input == null) {
            return "null";
        }
        String result = "List<InputSplit>::";
        result = result + " size:" + input.size() + " elements: [";
        for (InputSplit is : input) {
            result = result + HadoopToStringUtil.toString(is) + ", ";
        }
        result = result + "]";
        return result;
    }

    public static String toString(TaskAttemptContext input) {
        if (input == null) {
            return "null";
        }
        String result = "TaskAttemptContext::";
        result = result + " TaskAttemptID:" + input.getTaskAttemptID();
        result = result + " Status:" + input.getStatus();
        return result;
    }

    public static String toString(JobContext input) {
        if (input == null) {
            return "null";
        }
        String result = "JobContext::";
        result = result + " JobName:" + input.getJobName();
        result = result + " Jar:" + input.getJar();
        return result;
    }
}

