/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.common.base.Optional;
import org.apache.hadoop.util.VersionInfo;

public class HadoopVersionInfo {
    private static final HadoopVersionInfo INSTANCE = new HadoopVersionInfo();
    private Optional<Integer> majorVersion = Optional.absent();
    private Optional<Integer> minorVersion = Optional.absent();
    private Optional<Integer> patchLevel = Optional.absent();

    public static HadoopVersionInfo getInstance() {
        return INSTANCE;
    }

    public HadoopVersionInfo() {
        this(VersionInfo.getVersion());
    }

    public HadoopVersionInfo(String versionString) {
        this.parseVersionString(versionString);
    }

    protected boolean parseVersionString(String version) {
        ParseState state = new ParseState(version);
        this.majorVersion = this.parseNumberPiece(state);
        if (this.majorVersion.isPresent()) {
            this.discardSeparator(state);
            this.minorVersion = this.parseNumberPiece(state);
            if (this.minorVersion.isPresent()) {
                this.discardSeparator(state);
                this.patchLevel = this.parseNumberPiece(state);
            }
        }
        return this.majorVersion.isPresent();
    }

    protected Optional<Integer> parseNumberPiece(ParseState state) {
        StringBuilder builder = new StringBuilder(state.input.length());
        while (!state.isAtEndOfInput() && Character.isDigit(state.currentCharacter())) {
            builder.append(state.currentCharacter());
            state.advanceInput(1);
        }
        if (builder.length() > 0) {
            try {
                return Optional.of((Object)Integer.parseInt(builder.toString(), 10));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalStateException("Builder composed of digits could not be parsed as a number", nfe);
            }
        }
        return Optional.absent();
    }

    protected void discardSeparator(ParseState state) {
        while (!(state.isAtEndOfInput() || state.currentCharacter() != '.' && state.currentCharacter() != '-')) {
            state.advanceInput(1);
        }
    }

    public Optional<Integer> getMajorVersion() {
        return this.majorVersion;
    }

    public Optional<Integer> getMinorVersion() {
        return this.minorVersion;
    }

    public Optional<Integer> getPatchLevel() {
        return this.patchLevel;
    }

    public boolean isGreaterThan(int major, int minor) {
        return this.majorVersion.isPresent() && (Integer)this.majorVersion.get() > major || this.majorVersion.isPresent() && (Integer)this.majorVersion.get() == major && this.minorVersion.isPresent() && (Integer)this.minorVersion.get() > minor;
    }

    public boolean isLessThan(int major, int minor) {
        return this.majorVersion.isPresent() && (Integer)this.majorVersion.get() < major || this.majorVersion.isPresent() && (Integer)this.majorVersion.get() == major && this.minorVersion.isPresent() && (Integer)this.minorVersion.get() < minor;
    }

    public boolean isEqualTo(int major, int minor) {
        return this.majorVersion.isPresent() && (Integer)this.majorVersion.get() == major && this.minorVersion.isPresent() && (Integer)this.minorVersion.get() == minor;
    }

    protected static class ParseState {
        public final String input;
        public int currentIndex;

        ParseState(String input) {
            this.input = input;
            this.currentIndex = 0;
        }

        public void advanceInput(int characters) {
            this.currentIndex += characters;
        }

        public boolean isAtEndOfInput() {
            return this.currentIndex >= this.input.length();
        }

        public char currentCharacter() {
            return this.input.charAt(this.currentIndex);
        }
    }
}

