/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.hadoop.conf.Configuration;

public class HadoopConfigurationProperty<T> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private final String key;
    private final List<String> deprecatedKeys;
    private final T defaultValue;
    private List<String> keyPrefixes = ImmutableList.of((Object)"");

    public HadoopConfigurationProperty(String key) {
        this(key, null, new String[0]);
    }

    public HadoopConfigurationProperty(String key, T defaultValue, String ... deprecatedKeys) {
        this.key = key;
        this.deprecatedKeys = deprecatedKeys == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])deprecatedKeys);
        this.defaultValue = defaultValue;
    }

    public HadoopConfigurationProperty<T> withPrefixes(List<String> keyPrefixes) {
        this.keyPrefixes = ImmutableList.copyOf(keyPrefixes);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public List<String> getDeprecatedKeys() {
        return this.deprecatedKeys;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public T get(Configuration config, BiFunction<String, T, T> getterFn) {
        String lookupKey = this.getLookupKey(config, this.key, this.deprecatedKeys, (c, k) -> c.get(k) != null);
        return HadoopConfigurationProperty.logProperty(lookupKey, getterFn.apply(lookupKey, (String)this.defaultValue));
    }

    public String getPassword(Configuration config) {
        char[] value;
        Preconditions.checkState((this.defaultValue == null || this.defaultValue instanceof String ? 1 : 0) != 0, (Object)"Not a string property");
        String lookupKey = this.getLookupKey(config, this.key, this.deprecatedKeys, (c, k) -> c.get(k) != null);
        try {
            value = config.getPassword(lookupKey);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return HadoopConfigurationProperty.logProperty(lookupKey, value == null ? (String)this.defaultValue : String.valueOf(value));
    }

    public Collection<String> getStringCollection(Configuration config) {
        Preconditions.checkState((this.defaultValue == null || this.defaultValue instanceof Collection ? 1 : 0) != 0, (Object)"Not a collection property");
        String lookupKey = this.getLookupKey(config, this.key, this.deprecatedKeys, (c, k) -> c.get(k) != null);
        String valueString = config.get(lookupKey, this.defaultValue == null ? null : COMMA_JOINER.join((Iterable)((Collection)this.defaultValue)));
        List value = COMMA_SPLITTER.splitToList((CharSequence)Strings.nullToEmpty((String)valueString));
        return HadoopConfigurationProperty.logProperty(lookupKey, value);
    }

    public Map<String, String> getPropsWithPrefix(Configuration config) {
        Preconditions.checkState((boolean)(this.defaultValue instanceof Map), (Object)"Not a map property");
        String lookupKey = this.getLookupKey(config, this.key, this.deprecatedKeys, (c, k) -> !c.getPropsWithPrefix(k).isEmpty());
        Map propsWithPrefix = config.getPropsWithPrefix(lookupKey);
        return HadoopConfigurationProperty.logProperty(lookupKey, propsWithPrefix.isEmpty() ? (Map)this.defaultValue : propsWithPrefix);
    }

    private String getLookupKey(Configuration config, String key, List<String> deprecatedKeys, BiFunction<Configuration, String, Boolean> checkFn) {
        for (String prefix : this.keyPrefixes) {
            String prefixedKey = prefix + key;
            if (checkFn.apply(config, prefixedKey).booleanValue()) {
                return prefixedKey;
            }
            for (String deprecatedKey : deprecatedKeys) {
                String prefixedDeprecatedKey = prefix + deprecatedKey;
                if (!checkFn.apply(config, prefixedDeprecatedKey).booleanValue()) continue;
                ((GoogleLogger.Api)logger.atWarning()).log("Using deprecated key '%s', use '%s' key instead.", (Object)prefixedDeprecatedKey, (Object)prefixedKey);
                return prefixedDeprecatedKey;
            }
        }
        return this.keyPrefixes.get(0) + key;
    }

    private static <S> S logProperty(String key, S value) {
        ((GoogleLogger.Api)logger.atFine()).log("%s = %s", (Object)key, value);
        return value;
    }
}

