/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.http.HttpHost;

public class HttpTransportFactory {
    public static final HttpTransportType DEFAULT_TRANSPORT_TYPE = HttpTransportType.JAVA_NET;

    public static HttpTransportType getTransportTypeOf(@Nullable String typeName) {
        HttpTransportType type = DEFAULT_TRANSPORT_TYPE;
        if (!Strings.isNullOrEmpty((String)typeName)) {
            try {
                type = HttpTransportType.valueOf(typeName);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid HttpTransport type '%s'. Must be one of %s.", typeName, Arrays.toString((Object[])HttpTransportType.values())), e);
            }
        }
        return type;
    }

    public static HttpTransport createHttpTransport(HttpTransportType type, @Nullable String proxyAddress) throws IOException {
        try {
            URI proxyUri = HttpTransportFactory.parseProxyAddress(proxyAddress);
            switch (type) {
                case APACHE: {
                    HttpHost proxyHost = null;
                    if (proxyUri != null) {
                        proxyHost = new HttpHost(proxyUri.getHost(), proxyUri.getPort());
                    }
                    return HttpTransportFactory.createApacheHttpTransport(proxyHost);
                }
                case JAVA_NET: {
                    Proxy proxy = null;
                    if (proxyUri != null) {
                        proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort()));
                    }
                    return HttpTransportFactory.createNetHttpTransport(proxy);
                }
            }
            throw new IllegalArgumentException(String.format("Invalid HttpTransport type '%s'", type.name()));
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static ApacheHttpTransport createApacheHttpTransport(@Nullable HttpHost proxy) throws IOException, GeneralSecurityException {
        ApacheHttpTransport.Builder builder = new ApacheHttpTransport.Builder();
        builder.trustCertificates(GoogleUtils.getCertificateTrustStore());
        builder.setProxy(proxy);
        return builder.build();
    }

    public static NetHttpTransport createNetHttpTransport(@Nullable Proxy proxy) throws IOException, GeneralSecurityException {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        builder.trustCertificates(GoogleUtils.getCertificateTrustStore());
        builder.setProxy(proxy);
        return builder.build();
    }

    @VisibleForTesting
    static URI parseProxyAddress(@Nullable String proxyAddress) {
        if (Strings.isNullOrEmpty((String)proxyAddress)) {
            return null;
        }
        String uriString = proxyAddress;
        if (!uriString.contains("//")) {
            String string = String.valueOf(uriString);
            uriString = string.length() != 0 ? "//".concat(string) : new String("//");
        }
        try {
            URI uri = new URI(uriString);
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            if (!Strings.isNullOrEmpty((String)scheme) && !scheme.matches("https?")) {
                throw new IllegalArgumentException(String.format("HTTP proxy address '%s' has invalid scheme '%s'.", proxyAddress, scheme));
            }
            if (Strings.isNullOrEmpty((String)host)) {
                throw new IllegalArgumentException(String.format("Proxy address '%s' has no host.", proxyAddress));
            }
            if (port == -1) {
                throw new IllegalArgumentException(String.format("Proxy address '%s' has no port.", proxyAddress));
            }
            if (!uri.equals(new URI(scheme, null, host, port, null, null, null))) {
                throw new IllegalArgumentException(String.format("Invalid proxy address '%s'.", proxyAddress));
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid proxy address '%s'.", proxyAddress), e);
        }
    }

    public static enum HttpTransportType {
        APACHE,
        JAVA_NET;

    }
}

